using System.Web.Configuration;

public class ApplicationBasePage : MicroFour.StrataFrame.UI.Web.BasePage, MicroFour.StrataFrame.Tools.ITypeResolver
{

#region Business Object Definitions

	//-- Business Objects defined within this class will be available in the control builders as bindable business objects.
	//   They will also be persisted within session variables and retrieved each time the page loads.
	//   If the business object is defined WithEvents, events can be handled without the need for AddHandler calls.
        
#endregion

#region ITypeResolver Implementation Methods

    /// <summary>
    /// Must be used by the StrataFrame Application Framework to resolve a type within this ASP.NET project
    /// due to the fact that the Entry Assembly cannot be evaluated in an ASP.NET application
    /// </summary>
    /// <param name="TypeName"></param>
    /// <returns></returns>
    /// <remarks></remarks>
    public System.Type ResolveType(string TypeName)
    {    
        //-- Return the gettype for the given TypeName
        return System.Type.GetType(TypeName, false, true);
    }
    
    /// <summary>
    /// Required by the base class to allow the StrataFrame Application Framework to access the assemblies
    /// referenced by this project.
    /// </summary>
    /// <returns></returns>
    /// <remarks></remarks>
    public CompilationSection GetCompilationSection()
    {
		return (CompilationSection) WebConfigurationManager.GetSection("system.web/compilation");
    }
    
#endregion

}