Imports System.Collections.Generic

''' <summary>
''' This module provides static functions that are used to convert
''' name=value pair text into a dictionary and to convert a dictionary
''' into name=value pair strings.
''' </summary>
''' <remarks>
''' </remarks>
Public NotInheritable Class DictionaryToTextConverter

#Region " Constructors "

  ''' <summary>
  ''' Prevent instantiation of instances.
  ''' </summary>
  ''' <remarks></remarks>
  Private Sub New()
  End Sub

#End Region

#Region " Public Shared (static) Methods "

  ''' <summary>
  ''' This returns a dictionary object from a string of name=value pairs.
  ''' This also supports including just the key, with no value. The 
  ''' format of each pair is either 'name=value' or 'name'. Each pair 
  ''' is separated by a semi-colon.
  ''' </summary>
  ''' <param name="text"></param>
  ''' <returns>
  ''' Dictionary of name/value pairs
  ''' </returns>
  ''' <remarks>
  ''' You can use the format of only providing a key if the all you
  ''' intend to do is check that the key exists.  The value will
  ''' be an empty string.
  ''' </remarks>
  Public Shared Function GetDictionaryFromText(ByVal text As String) As Dictionary(Of String, String)
    Dim retDictionary As Dictionary(Of String, String)
    Dim key As String
    Dim value As String
    Dim pair As String
    Dim nameValuePairs() As String = Split(text, ";")

    ' For each name/value pair, create a dictionary entry
    retDictionary = New Dictionary(Of String, String)
    For Each pair In nameValuePairs
      If InStr(pair, "=") > 0 Then
        key = Split(pair, "=")(0)
        value = Split(pair, "=")(1)
      Else
        ' Add item with name and an empty string
        key = pair
        value = String.Empty
      End If
      retDictionary.Add(key, value)
    Next
    Return retDictionary
  End Function

  ''' <summary>
  ''' This takes a string dictionary (keys and values are strings) and
  ''' converts it into a text string.
  ''' </summary>
  ''' <param name="anyDictionary">A Dictionary object, keys are string, values are string</param>
  ''' <returns>
  ''' text with name=value pairs delimited by semi-colon
  ''' </returns>
  ''' <remarks>
  ''' This likely needs to become a wrapper around the dictionary object, which would load 
  ''' and generate the text automatically.
  ''' 
  ''' It might also be nice to make this more generic. Though if the key/value are not either
  ''' string or scalar, then things get interesting.  The types would need to be serialized
  ''' into text of some sort.
  ''' </remarks>
  Public Shared Function GetTextFromDictionary(ByVal anyDictionary As Dictionary(Of String, String)) As String
    Dim retText As String = String.Empty

    ' For each dictionary value, build the name=value pair
    For Each kvp As KeyValuePair(Of String, String) In anyDictionary
      ' handle the case of just a key
      If kvp.Value.Length = 0 Then
        retText = retText & ";" & kvp.Key
      Else
        retText = retText & ";" & kvp.Key & "=" & kvp.Value
      End If
    Next
    If Len(retText) > 0 Then
      retText = Mid(retText, 2)
    End If
    Return retText
  End Function

#End Region

End Class
