﻿Public Class ESInfoForm


  Public ReadOnly Property Host() As String
    Get
      Return Me.txtHost.Text
    End Get
  End Property

  Public ReadOnly Property Port() As Integer
    Get
      Dim loPort As Integer
      If Not String.IsNullOrEmpty(Me.txtPort.Text) Then
        loPort = CInt(Me.txtPort.Text)
      End If
      Return loPort
    End Get
  End Property

  Public ReadOnly Property RemoteKey() As String
    Get
      Return Me.txtRemoteKey.Text
    End Get
  End Property

  Public ReadOnly Property UseCompression() As Boolean
    Get
      Return Me.chkCompression.Checked
    End Get
  End Property

  Public ReadOnly Property UseEncryption() As Boolean
    Get
      Return Me.chkEncryption.Checked
    End Get
  End Property

  Public ReadOnly Property EncryptionKey() As Byte()
    Get
      '-- Provide default, blank key
      Dim encryptKey As Byte() = New Byte() {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}

      '-- If we are using encryption and if a key is provided, parse it into an array.
      If Me.UseEncryption AndAlso Not String.IsNullOrEmpty(Me.txtEncryptionKey.Text) Then
        encryptKey = Me.ConvertStringToByteArray(Me.txtEncryptionKey.Text)
      End If

      '-- Return the key
      Return encryptKey
    End Get
  End Property

  Public ReadOnly Property EncryptionVector() As Byte()
    Get
      '-- Provide default, blank key
      Dim encryptVector As Byte() = New Byte() {0, 0, 0, 0, 0, 0, 0, 0}

      '-- If we are using encryption and if a vector is provided, parse it into an array.
      If Me.UseEncryption AndAlso Not String.IsNullOrEmpty(Me.txtEncryptionVector.Text) Then
        encryptVector = Me.ConvertStringToByteArray(Me.txtEncryptionVector.Text)
      End If

      '-- Return the vector
      Return encryptVector
    End Get
  End Property

  ''' <summary>
  ''' Configure other encryption controls so they are only 
  ''' available if the encryption checkbox is checked.
  ''' </summary>
  ''' <param name="sender"></param>
  ''' <param name="e"></param>
  ''' <remarks></remarks>
  Private Sub chkEncryption_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles chkEncryption.CheckedChanged
    Dim usingEncryption As Boolean = Me.chkEncryption.Checked
    Me.txtEncryptionKey.Enabled = usingEncryption
    Me.txtEncryptionVector.Enabled = usingEncryption
  End Sub

  ''' <summary>
  ''' Convert a comma delimited string into a byte array.
  ''' </summary>
  ''' <param name="arrayText"></param>
  ''' <returns></returns>
  ''' <remarks></remarks>
  Private Function ConvertStringToByteArray(ByVal arrayText As String) As Byte()
    '-- Break text into string array, then add each item to byte array.
    Dim keyStrings As String() = arrayText.Split(","c)
    Dim keys As New System.Collections.Generic.List(Of Byte)()
    For Each item As String In keyStrings
      keys.Add(CByte(item.Trim()))
    Next
    Return keys.ToArray()
  End Function

  Private Sub btnOK_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnOK.Click
    Me.DialogResult = Windows.Forms.DialogResult.OK
  End Sub

  Private Sub btnCancel_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnCancel.Click
    Me.DialogResult = Windows.Forms.DialogResult.Cancel
  End Sub

End Class
