﻿Imports MicroFour.StrataFrame.Data
Imports MicroFour.StrataFrame.UI
Imports System.Data
Imports System.Collections.Specialized
Imports System.Collections.Generic

Public Class MainForm

  Private Sub MainForm_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
    '-- Set connection info.
    Me.lblCurrentConnection.Text = Me.BuildConnectionInfo()
  End Sub

  ''' <summary>
  ''' Set direct connection to an arbitrary database.
  ''' </summary>
  ''' <param name="sender"></param>
  ''' <param name="e"></param>
  ''' <remarks></remarks>
  Private Sub btnSetConnection_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnSetConnection.Click
    DataLayer.DataSources.Clear()
    DataLayer.DataSources.Add(New SqlDataSourceItem(""))
    If ConnectionManager.ShowAvailableConnectionStrings() Then
      ConnectionManager.SetConnections()
      Me.lblCurrentConnection.Text = Me.BuildConnectionInfo()
    End If
  End Sub

  ''' <summary>
  ''' Set the application to use an enterprise connection.
  ''' </summary>
  ''' <param name="sender"></param>
  ''' <param name="e"></param>
  ''' <remarks></remarks>
  Private Sub btnSetESConn_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnSetESConn.Click
    Me.SetEnterpriseConnection()
  End Sub

  ''' <summary>
  ''' Execute the entered SQL and load the results into the results
  ''' listview.
  ''' </summary>
  ''' <param name="sender"></param>
  ''' <param name="e"></param>
  ''' <remarks></remarks>
  Private Sub btnExecuteSql_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnExecuteSql.Click
    Me.ExecuteSql()
  End Sub

  ''' <summary>
  ''' Set parameters needed to load the results.
  ''' </summary>
  ''' <param name="e"></param>
  ''' <remarks></remarks>
  Private Sub lvwResults_ListPopulating(ByVal e As MicroFour.StrataFrame.UI.ListPopulatingEventArgs) Handles lvwResults.ListPopulating
    e.Parameters(0).Value = Me.GenericBO1
    e.Parameters(1).Value = MicroFour.StrataFrame.Business.BusinessCloneDataType.ClearAndFillFromCompleteTable
  End Sub

  ''' <summary>
  ''' Add execution shortcut, F5.
  ''' </summary>
  ''' <param name="msg"></param>
  ''' <param name="keyData"></param>
  ''' <returns></returns>
  ''' <remarks></remarks>
  Protected Overrides Function ProcessCmdKey(ByRef msg As System.Windows.Forms.Message, ByVal keyData As System.Windows.Forms.Keys) As Boolean
    Select Case keyData
      Case Keys.F5
        Me.ExecuteSql()
        Return True
      Case Else
        Return MyBase.ProcessCmdKey(msg, keyData)
    End Select
  End Function

  ''' <summary>
  ''' Execute provided SQL and load listview with the results.
  ''' </summary>
  ''' <remarks></remarks>
  Private Sub ExecuteSql()
    '-- Exit if no sql
    If String.IsNullOrEmpty(Me.syeSql.Text) Then Return

    '-- Get SQL.
    Dim sql As String = Me.syeSql.Text

    '-- Load BO using this SQL.
    Me.GenericBO1.FillDataTable(sql)

    '-- Clear current data and columns from results.
    Me.lvwResults.Clear()

    '-- Add columns from data table to listview, create list of items
    '   for list population and the format list. Also, we'll assume 
    '   the first field is the PK field.
    Dim fieldNames As New StringCollection()
    Dim formatColumns As New List(Of ListViewPopulationColumn)
    Dim pkField As String = String.Empty
    For Each col As DataColumn In Me.GenericBO1.CurrentDataTable.Columns
      '-- Set PK field, the first field listed
      If String.IsNullOrEmpty(pkField) Then
        pkField = col.ColumnName
      End If

      '-- Add column to listview, using provided alias or column name
      '   (the caption will correclty return the correct one).
      lvwResults.Columns.Add(col.Caption)

      '-- Set field names used to load data from underlying datatable
      fieldNames.Add(col.ColumnName)

      '-- Setup format column for this column
      Dim formatCol As New ListViewPopulationColumn()
      formatCol.FormatString = "{" & col.Ordinal & "}"
      formatCol.PopulationType = ListViewColumnPopulationType.FormattedString
      formatColumns.Add(formatCol)
    Next

    '-- Ensure that the listview has population settings.
    Me.lvwResults.PopulationDataSourceSettings = New ListViewPopulationSettings()

    '-- Setup listview to get data.
    With Me.lvwResults.PopulationDataSourceSettings
      .BusinessObjectType = Me.GenericBO1.GetType().FullName
      .DisplayFieldNames = fieldNames
      .FormatColumns.AddRange(formatColumns.ToArray())
      .MethodToExecute = "CopyDataFrom;MicroFour.StrataFrame.Business.BusinessLayerBase,MicroFour.StrataFrame.Business.BusinessCloneDataType"
      .ValueMember = pkField
      .FormatString = "{0}"
    End With

    '-- Load results, pass in BO and clone data type
    Me.lvwResults.Requery()
  End Sub

  ''' <summary>
  ''' Set the application connection to use an ES connection. This 
  ''' will prompt the user for the details related to that 
  ''' connection.
  ''' </summary>
  ''' <remarks></remarks>
  Private Sub SetEnterpriseConnection()
    '-- Establish locals for the data needed to setup the ES data source.
    Dim hostName As String = String.Empty
    Dim port As Integer
    Dim remoteKey As String = String.Empty
    Dim useCompression As Boolean
    Dim useEncryption As Boolean
    Dim cryptoKey As Byte()
    Dim cryptoVector As Byte()

    '-- Gather information required to create enterprise data source.
    Using infoForm As New ESInfoForm()
      If infoForm.ShowDialog(Me) = System.Windows.Forms.DialogResult.OK Then
        hostName = infoForm.Host
        port = infoForm.Port
        remoteKey = infoForm.RemoteKey
        useCompression = infoForm.UseCompression
        useEncryption = infoForm.UseEncryption
        cryptoKey = infoForm.EncryptionKey
        cryptoVector = infoForm.EncryptionVector
      Else
        Return
      End If
    End Using

    '-- Create the enterprise datasource item.
    Dim enterpriseDataSource As New Enterprise.EnterpriseDataSourceItem("", hostName, port, remoteKey, New SqlDataSourceItem(""))
    enterpriseDataSource.IsCompressed = useCompression
    enterpriseDataSource.IsEncrypted = useEncryption
    If useEncryption Then
      enterpriseDataSource.EncryptionKey = cryptoKey
      enterpriseDataSource.EncryptionVector = cryptoVector
    End If

    '-- Clear previous data sources.
    DataLayer.DataSources.Clear()

    '-- Add the data source.
    DataLayer.DataSources.Add(enterpriseDataSource)

    '-- Update the connection info.
    Me.lblCurrentConnection.Text = String.Format("Host={0}; Port={1}; RemoteKey={2}", hostName, port, remoteKey)
  End Sub

  Private Function BuildConnectionInfo() As String
    '-- Establish return var
    Dim info As String = String.Empty

    '-- Get connection string.
    Dim connString As String = DataLayer.DataSources(0).ConnectionString

    '-- We just want the database and initial catalog. Use a dictionary to figure this out.
    Dim connSettings As Dictionary(Of String, String) = DictionaryToTextConverter.GetDictionaryFromText(connString)
    info = String.Format("Server={0}; Database={1}", connSettings("Data Source"), connSettings("Initial Catalog"))

    '-- Return the connection info.
    Return info
  End Function
End Class
