﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace ProcessWinformUI
{

  /// <summary>
  /// Run a sample process and display results.
  /// </summary>
  public partial class MainForm : Form
  {
    public MainForm()
    {
      InitializeComponent();

      //-- Set initial steps to 10.
      this.txtSteps.Text = "10";
    }

    /// <summary>
    /// Run the process.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    private void btnRun_Click( object sender, EventArgs e )
    {
      //-- Get the number of steps the user entered.
      string stepsRaw = this.txtSteps.Text;

      //-- Initialize process manager class.
      SampleProcess.ProcessManager mng = new SampleProcess.ProcessManager();

      //-- Validate steps entered correctly (throws if not valid).
      mng.ValidateArgs( stepsRaw );

      //-- Add steps to process manager.
      mng.TotalSteps = int.Parse( stepsRaw );

      //-- Add event handler to the process manager to manage
      //   messages.
      mng.ProcessStepCompleted += ProcessManager_ProcessStepCompleted;

      //-- Clear previous messages
      this.txtMessages.Text = "";

      //-- Run process
      mng.Run();
    }

    /// <summary>
    /// Handle setting up and posting message.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    private void ProcessManager_ProcessStepCompleted( object sender, SampleProcess.ProcessStepCompletedEventArgs e )
    {
      //-- Just add the message.
      this.AddMessage( e.Message );
    }


    private void AddMessage( string message )
    {
      //-- Add message to form, on a new line. The \r\n adds a new
      //   line to a text box.
      this.txtMessages.Text += string.Format( "{0}\r\n", message );

      //-- Scroll to end of file so user can see messages
      //   if there are more than is displayed. Since we are putting
      //   two characters at the end of the message to add a new line,
      //   we want to upt caret at end of message, not after those two
      //   characters.
      this.txtMessages.SelectionStart = this.txtMessages.Text.Length - 2;
      this.txtMessages.ScrollToCaret();

      //-- This makes sure the form is updated. If you
      //   don't do this you get funky display issues.
      Application.DoEvents();
    }
  }
}
