﻿using System;
using System.Collections.Generic;
using System.Reflection;
using System.Text;

namespace ProcessConsoleUI
{
  class Program
  {
    static void Main( string[] args )
    {
      //-- We must have one and only one argument, otherwise
      //   show usage.
      if (args.Length != 1)
      {
        Console.Write( Properties.Resources.usage );
        return;
      }

      //-- Initialize process manager.
      SampleProcess.ProcessManager mng = new SampleProcess.ProcessManager();

      //-- Validate user input then run process, output any exceptions.
      try
      {
        //-- Validate total steps.
        mng.ValidateArgs( args[0] );

        //-- Set total steps.
        mng.TotalSteps = int.Parse( args[0] );

        //-- Setup handler to write messages to console.
        mng.ProcessStepCompleted += ProcessManager_ProcessStepCompleted;

        //-- Run process.
        mng.Run();
      }
      catch (Exception e)
      {
        Console.WriteLine( e.Message );
      }
    }

    private static void ProcessManager_ProcessStepCompleted( object sender, SampleProcess.ProcessStepCompletedEventArgs e )
    {
      //-- Just ouput message to standard out.
      Console.WriteLine( e.Message );
    }
  }
}
