﻿using System;

namespace SampleProcess
{
  public class ProcessStepCompletedEventArgs
    : EventArgs
  {

    /// <summary>
    /// Initialize args with message and step number.
    /// </summary>
    public ProcessStepCompletedEventArgs( int step, string message )
    {
      this.Message = message;
      this.StepNumber = step;
    }

    /// <summary>
    /// Message provided by process.
    /// </summary>
    public string Message { get; set; }

    /// <summary>
    /// The number of the step just completed.
    /// </summary>
    public int StepNumber { get; set; }
  }
}
