﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace UnattendedModeSample
{

  /// <summary>
  /// Display progress of a process.
  /// </summary>
  public partial class ProgressForm : Form
  {

    /// <summary>
    /// Display progress of a long running/multi-step task.
    /// </summary>
    public ProgressForm()
    {
      InitializeComponent();
    }

    /// <summary>
    /// Add a message to the progress indicator.
    /// </summary>
    /// <param name="message"></param>
    public void addMessage( string message )
    {
      //-- Add message to form, on a new line. The \r\n adds a new
      //   line to a text box.
      this.txtMessages.Text += string.Format( "{0}\r\n", message );

      //-- Scroll to end of file so user can see messages
      //   if there are more than is displayed. Since we are putting
      //   two characters at the end of the message to add a new line,
      //   we want to upt caret at end of message, not after those two
      //   characters.
      this.txtMessages.SelectionStart = this.txtMessages.Text.Length - 2;
      this.txtMessages.ScrollToCaret();

      //-- This makes sure the form is updated. If you
      //   don't do this you get funky display issues.
      Application.DoEvents();
    }

    public void setCompleted()
    {
      this.btnClose.Enabled = true;
    }

    /// <summary>
    /// Close the form.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    private void btnClose_Click( object sender, EventArgs e )
    {
      this.Close();
    }
  }
}
