﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Windows.Forms;

namespace UnattendedModeSample
{
  static class Program
  {
    /// <summary>
    /// The main entry point for the application.
    /// </summary>
    [STAThread]
    static void Main(string[] args)
    {
      Application.EnableVisualStyles();
      Application.SetCompatibleTextRenderingDefault( false );

      //-- If there are no arguments, run UI.
      if (args.Length == 0)
      {
        Application.Run( new MainForm() );
      }
      else
      {
        //-- Process arguments. We accept a number of steps.
        if (args.Length == 0)
        {
          throw new ArgumentNullException( "Number of Steps", "You must provide the number of steps as the first argument for the command." );
        }

        //-- Run process, validating arguments.
        ProcessManager mng = new ProcessManager();
        mng.ValidateArgs( args[0] );
        int numberOfSteps = int.Parse( args[0] );
        mng.Run( numberOfSteps );

        //-- The problem with this is that when the 
        //   process finishes, the progress form 
        //   disappears, as the entire app is complete.
      }
    }
  }
}
