using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using CrystalDecisions.Shared;
using CrystalDecisions.CrystalReports.Engine;
using System.Threading;
using Csla.Security;
using CustSvc.Library.Security;
using System.Configuration;

namespace CustSvc.App   
{
    public partial class FormReportViewer : Form
    {
        //CrystalDecisions.CrystalReports.Engine.ReportClass rc = null;
        CrystalDecisions.CrystalReports.Engine.ReportDocument ro = null;
        int newRow;
        Label l;
        Button b;
        public FormReportViewer()
        {
            InitializeComponent();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            try
            {
                //Dim crParameterFields As ParameterFields
                //Dim crParameterField As ParameterField
                //Dim crParameterDiscreteValue As New ParameterDiscreteValue()
                //Dim crParameterValue As ParameterValue

                //crParameterFields = CrystalReportViewer1.ParameterFieldInfo
                //crParameterField = crParameterFields(0)
                //crParameterDiscreteValue.Value = "Canada"
                //crParameterField.CurrentValues.Add(crParameterDiscreteValue)
                //CrystalReportViewer1.ParameterFieldInfo = crParameterFields
                //CrystalReportViewer1.Reportsource = EnterpriseReport1
                for (int i = Parameters.Controls.Count - 1; i >= 0; i--)
                {
                    Parameters.Controls.RemoveAt(i);
                }
                Console.WriteLine(Parameters.Controls.Count.ToString());
                Parameters.RowCount = 1;
                //rc = new CrystalDecisions.CrystalReports.Engine.ReportClass();
                ro = new CrystalDecisions.CrystalReports.Engine.ReportDocument();
                this.openFileDialog1.DefaultExt = "rpt";
                openFileDialog1.AddExtension = true;
                openFileDialog1.Filter = "Crystal Report Files (*.rpt)|*.rpt";
                openFileDialog1.FileName = "";
                string reportPath = ConfigurationManager.ConnectionStrings["Reports"].ConnectionString;
                openFileDialog1.InitialDirectory = reportPath;
                DialogResult dr = openFileDialog1.ShowDialog();
                if (dr != DialogResult.OK || openFileDialog1.FileName == "") return;
                this.textBox1.Text = openFileDialog1.FileName;
                if (ro == null) return;
                ro.Load(openFileDialog1.FileName);
                System.Security.Principal.IPrincipal p = Csla.ApplicationContext.User;
                PTIdentity identity = (PTIdentity)p.Identity;
                string u = ((PTIdentity)identity).LogonId;
                string pw = ((PTIdentity)identity).Password;
                ro.SetDatabaseLogon(u, pw);
                //MessageBox.Show(ro.ParameterFields[0].Name);
                foreach (ParameterField pf in ro.ParameterFields)
                {
                    newRow = Parameters.RowCount++;
                    l = new Label();
                    l.Text = pf.Name.Substring(1);
                    Parameters.Controls.Add(l);
                    l.TextAlign = ContentAlignment.BottomLeft;
                    Parameters.SetRow(l, newRow);
                    newRow = Parameters.RowCount++;
                    Control c = null;
                    if (pf.ParameterValueType.ToString() == "DateTimeParameter")
                    {
                        c = new DateTimePicker();
                    }
                    else if (pf.ParameterValueType.ToString() == "StringParameter")
                    {
                        c = new TextBox();
                        c.Width = Parameters.Width;
                    }
                    else if (pf.ParameterValueType.ToString() == "NumberParameter" && pf.Name.Substring(1, 1).ToUpper() == "I")
                    {
                        c = new TextBox();
                    }
                    else if (pf.ParameterValueType.ToString() == "NumberParameter" && pf.Name.Substring(1, 1).ToUpper() == "F")
                    {
                        c = new TextBox();
                    }
                    else if (pf.ParameterValueType.ToString() == "NumberParameter")
                    {
                        c = new TextBox();
                    }
                    if (c != null)
                    {
                        Parameters.Controls.Add(c);
                        Parameters.SetRow(c, newRow);
                    }
                    Console.WriteLine(pf.Name + ", " + pf.ParameterValueType.ToString());
                }
                newRow = Parameters.RowCount++;
                b = new Button();
                b.Text = "Run Report";
                b.Click += new EventHandler(RunReport);
                Parameters.Controls.Add(b);
                Parameters.Visible = true;
                //ro.SetParameterValue(0, DateTime.Parse("10/1/2005"));
                //ro.SetParameterValue(1, DateTime.Parse("10/31/2005"));
                //this.crystalReportViewer.ReportSource = openFileDialog1.FileName;
                //crystalReportViewer1.Refresh();
            }
            catch (Exception ex)
            {
                ((MainForm)MdiParent).StatusMessage = ex.Message;
            }
        }

        private void RunReport(object sender, EventArgs e)
        {
            try
            {
                int rowPointer = 1;
                int paramPointer = 0;
                foreach (ParameterField pf in ro.ParameterFields)
                {
                    if (pf.ParameterValueType.ToString() == "DateTimeParameter")
                    {
                        DateTimePicker d = (DateTimePicker)Parameters.Controls[rowPointer];
                        ro.SetParameterValue(paramPointer, TruncateDateTime(d.Value));
                    }
                    else if (pf.ParameterValueType.ToString() == "StringParameter")
                    {
                        TextBox t = (TextBox)Parameters.Controls[rowPointer];
                        ro.SetParameterValue(paramPointer, t.Text);
                    }
                    else if (pf.ParameterValueType.ToString() == "NumberParameter" && pf.Name.Substring(1, 1).ToUpper() == "I")
                    {
                        TextBox t = (TextBox)Parameters.Controls[rowPointer];
                        ro.SetParameterValue(paramPointer, int.Parse(t.Text));
                    }
                    else if (pf.ParameterValueType.ToString() == "NumberParameter" && pf.Name.Substring(1, 1).ToUpper() == "F")
                    {
                        TextBox t = (TextBox)Parameters.Controls[rowPointer];
                        ro.SetParameterValue(paramPointer, double.Parse(t.Text));
                    }
                    else if (pf.ParameterValueType.ToString() == "NumberParameter")
                    {
                        TextBox t = (TextBox)Parameters.Controls[rowPointer];
                        ro.SetParameterValue(paramPointer, double.Parse(t.Text));
                    }
                    rowPointer += 2;
                    paramPointer++;
                }
                this.crystalReportViewer.ReportSource = ro;
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }

        private DateTime TruncateDateTime(DateTime d)
        {
            string dateString = d.ToShortDateString();
            return DateTime.Parse(dateString);
        }
    }
}