﻿using System;
using System.Collections.Generic;
using System.Windows.Forms;

namespace LaunchDlgPropertyProvider
{

  /// <summary>
  /// Static class providing dialog launching methods.
  /// </summary>
  public static class Launcher
  {

    /// <summary>
    /// Define the MDI form used by launcher.
    /// </summary>
    public static Form MdiForm { get; set; }

    private static AddFormHandlers _addFormHandlersMethod;

    /// <summary>
    /// Define the delegate that is used to add handlers to form.
    /// Use the += and -= operators to add/remove multiple handlers.
    /// </summary>
    public static AddFormHandlers AddFormHandlersMethod 
    {
      get
      {
        return _addFormHandlersMethod;
      }
      set
      {
        _addFormHandlersMethod = value;
      }
    }

    /// <summary>
    /// Launch the form of the indicated type.
    /// </summary>
    /// <param name="dialogType"></param>
    /// <param name="args"></param>
    public static void LaunchDialog( Type dialogType, params object[] args )
    {
      //-- Check that MDI Form has been set.
      if (Launcher.MdiForm == null)
      {
        throw new InvalidOperationException( "A MDI form must be set before the LaunchDialog method can be used." );
      }

      //-- Establish Locals
      Form f = (Form)(Activator.CreateInstance( dialogType, args ));

      //-- Add the handlers to the form, if a delegate was provided.
      if (Launcher.AddFormHandlersMethod != null)
      {
        Launcher.AddFormHandlersMethod( f );
      }     

      //-- Set the parent MDI
      f.MdiParent = Launcher.MdiForm;

      //-- Show the dialog
      f.Show();
    }
  }
}
