﻿using System;
using System.Collections;
using System.Text;

namespace LaunchDlgPropertyProvider
{
  
  /// <summary>
  /// Provides a set of utility methods that are used when
  /// implementing an extender provider.
  /// </summary>
  public static class ExtenderProvider
  {

    #region   Static Methods

    /// <summary>
    /// Get the value for the extended control from the extended
    /// property hash table.
    /// </summary>
    /// <typeparam name="T">property System.Type</typeparam>
    /// <param name="extendee">extended control</param>
    /// <param name="hash">hash table with the desired
    /// properties within it</param>
    /// <param name="defaultValue">default value to return if
    /// the property isn't set for the extendee</param>
    /// <returns>the value (of type T)</returns>
    public static T GetProperty<T>(Object extendee, Hashtable hash, T defaultValue)
    {
      //-- Establish a return value
      T value = defaultValue;

      //-- If the hash contains the extendee, return 
      //   the associated value
      if (hash.Contains(extendee))
      {
        value = (T)hash[extendee];
      }

      //-- Return value of property
      return value;
    }

    /// <summary>
    /// Generic method to set the value of an extended property.
    /// </summary>
    /// <typeparam name="T">property System.Type</typeparam>
    /// <param name="extendee">extended control</param>
    /// <param name="value">value being set for the extended
    /// control</param>
    /// <param name="hash">hashtable used to store this extended
    /// properties values</param>
    public static void SetProperty<T>(Object extendee, Hashtable hash, Object value)
    {
      //-- If the value is null, remove the property
      if (value == null)
      {
        hash.Remove(extendee);
        return;
      }

      //-- If the value already exists, update, otherwise add it.
      if (hash.Contains(extendee))
      {
        hash[extendee] = (T)value;
      }
      else
      {
        hash.Add(extendee, (T)value);
      }
    }

    #endregion   Static Methods

  }
}
