﻿using System;
using System.Collections.Generic;
using System.Reflection;

namespace ProfilerExample
{

  /// <summary>
  /// Log profiler messages to a dialog.
  /// </summary>
  public class DialogProfileLogger
    : IProfileLogger
  {

    public DialogProfileLogger() { }

    static DialogProfileLogger()
    {
      //-- Create an instance of the profile message dialog.
      Dialog = new ProfilerMessageDialog();
    }

    static ProfilerMessageDialog Dialog { get; set; }

    #region [ IProfileLogger Members ]

    public MethodBase Method { get; set; }

    public string CodeBlockName { get; set; }

    public void EnterMethod()
    {
      //-- If the dialog is showing, show it now.
      if (!DialogProfileLogger.Dialog.Visible)
      {
        DialogProfileLogger.Dialog.Show();
      }

      //-- Format a message.
      string message = string.Format( "IN: {0}.{1}", this.Method.DeclaringType.FullName, this.Method.Name );

      //-- Add to log
      DialogProfileLogger.Dialog.AddMessage( message );
    }

    public void ExitMethod( TimeSpan elapsedTime )
    {
      //-- Format a message.
      string message = string.Format( "OUT: {0}.{1} [{2} seconds]", this.Method.DeclaringType.FullName, this.Method.Name, elapsedTime.TotalSeconds );

      //-- Add to log, then add a blank line
      DialogProfileLogger.Dialog.AddMessage( message );
      DialogProfileLogger.Dialog.AddMessage( "" );
    }

    public void Mark( string markName, TimeSpan elapsedTime )
    {
      //-- Format a message.
      string message = string.Format( "    {3}: {0}.{1} [{2} seconds]", this.Method.DeclaringType.FullName, this.Method.Name, elapsedTime.TotalSeconds, markName );

      //-- Add to log
      DialogProfileLogger.Dialog.AddMessage( message );
    }

    #endregion [ IProfileLogger Members ]

  }
}
