﻿using System;
using System.Collections.Generic;
using System.Text;

namespace ProfilerExample
{

  /// <summary>
  /// 
  /// </summary>
  public class ListviewProfileLogger
    : IProfileLogger
  {

    public ListviewProfileLogger() { }

    static ListviewProfileLogger()
    {
      //-- Create an instance of the profile message dialog.
      Dialog = new ListProfileDialog();
    }

    static ListProfileDialog Dialog { get; set; }

    #region [ IProfileLogger Members ]

    public System.Reflection.MethodBase Method { get; set; }

    public string CodeBlockName { get; set; }

    public void EnterMethod()
    {
      //-- If the dialog is showing, show it now.
      if (!ListviewProfileLogger.Dialog.Visible)
      {
        ListviewProfileLogger.Dialog.Show();
      }

      ListviewProfileLogger.Dialog.AddEnterMessage( this.Method, this.CodeBlockName );
    }

    public void ExitMethod( TimeSpan elapsedTime )
    {
      ListviewProfileLogger.Dialog.AddExitMessage( this.Method, this.CodeBlockName, elapsedTime );
    }

    public void Mark( string markName, TimeSpan elapsedTime )
    {
      ListviewProfileLogger.Dialog.AddMarkMessage( this.Method, this.CodeBlockName, elapsedTime, markName );
    }

    #endregion [ IProfileLogger Members ]
  }
}
