﻿using System;
using System.Collections.Generic;
using System.Threading;

namespace ProfilerExample
{
  /// <summary>
  /// This class is simply used to test profiling.
  /// </summary>
  public class ExampleProfiledClass
  {

    public void Main()
    {
      using (Profiler profile = new Profiler( System.Reflection.MethodBase.GetCurrentMethod() ))
      {
        //-- Run a process.
        SubOne();
        SubTwo();
        ComplexSub();
      }
    }

    public void Primary()
    {
      using (Profiler profile = new Profiler( System.Reflection.MethodBase.GetCurrentMethod() ))
      {
        Thread.Sleep( 876 );
        SubTwo();
        using (Profiler loopProfile = new Profiler( System.Reflection.MethodBase.GetCurrentMethod(), "Loop Profile" ))
        {
          for (int i = 0 ; i < 20 ; i++)
          {
            SubOne();
          }
        }
      }
    }

    private void SubOne()
    {
      using (Profiler profile = new Profiler( System.Reflection.MethodBase.GetCurrentMethod() ))
      {
        Thread.Sleep( 234 );
      }
    }

    private void SubTwo()
    {
      using (Profiler profile = new Profiler( System.Reflection.MethodBase.GetCurrentMethod() ))
      {
        Thread.Sleep( 13456 );
      }
    }

    private void ComplexSub()
    {
      using (Profiler profile = new Profiler( System.Reflection.MethodBase.GetCurrentMethod() ))
      {
        //-- Do some stuff
        Thread.Sleep( 45 );

        //-- Mark
        profile.AddMark( "Starting long process" );

        //-- Do a long running process
        Thread.Sleep( 4355 );
      }
    }
  }
}
