﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace ProfilerExample
{
  public partial class ListProfileDialog : MicroFour.StrataFrame.UI.Windows.Forms.StandardForm
  {
    public ListProfileDialog()
    {
      InitializeComponent();
    }

    private int LogOrdinal { get; set; }

    private string OrdinalDisplay
    {
      get
      {
        string displayText = this.LogOrdinal.ToString();

        //-- Padd number on left so it is of uniform length.
        int length = displayText.Length;
        string zeroPadding = new string( '0', 5 - length );
        displayText = zeroPadding + displayText;

        return displayText;
      }
    }

    public void AddEnterMessage( System.Reflection.MethodBase method, string blockName )
    {
      this.AddMessage( "ENTER", method, blockName, new TimeSpan(), string.Empty );
    }

    public void AddExitMessage( System.Reflection.MethodBase method, string blockName, TimeSpan elapsedTime )
    {
      this.AddMessage( "LEAVE", method, blockName, elapsedTime, string.Empty );
    }

    public void AddMarkMessage( System.Reflection.MethodBase method, string blockName, TimeSpan elapsedTime, string markName )
    {
      this.AddMessage( "MARK", method, blockName, elapsedTime, markName );
    }

    private void AddMessage( string action
                          , System.Reflection.MethodBase method
                          , string blockName
                          , TimeSpan elapsedTime
                          , string markName )
    {
      //-- Increment the log ordinal.
      this.LogOrdinal++;

      //-- Handle there being no elapsed time
      string timeDisplay = string.Empty;
      if (elapsedTime.TotalSeconds != 0)
      {
        timeDisplay = elapsedTime.TotalSeconds.ToString();
      }

      //-- Build array for message.
      string[] items = { this.OrdinalDisplay, action, blockName, timeDisplay, string.Format( "{0}.{1}", method.DeclaringType.FullName, method.Name ) };
      ListViewItem messageItem = new ListViewItem( items );

      this.lvwMessages.Items.Add( messageItem );
    }

    private void tsbClear_Click( object sender, EventArgs e )
    {
      this.lvwMessages.Items.Clear();
      this.LogOrdinal = 0;
    }
  }
}