using MicroFour.StrataFrame.Business;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Runtime.Serialization;
using System.Text;
using MicroFour.StrataFrame.Data;

namespace ConcurrencySample
{
  [Serializable()]
  public partial class CustomerBaseBO : MicroFour.StrataFrame.Business.BusinessLayer
  {

    #region Constructors

    /// <summary>
    /// Initializes a new instance of the BusinessObject1 class.
    /// </summary>
    public CustomerBaseBO()
      : base()
    {
      InitializeComponent();
    }

    /// <summary>
    /// Initializes a new instance of the BusinessObject1 class.
    /// </summary>
    /// <param name="container">The IContainer to which this business object will be added.</param>
    public CustomerBaseBO( IContainer container )
      : base()
    {
      container.Add( this );

      InitializeComponent();
    }

    /// <summary>
    /// Initializes a new instance of the BusinessObject1 class.
    /// </summary>
    /// <param name="info">The SerializationInfo for the object to create.</param>
    /// <param name="context">The StreamingContext for the source stream.</param>
    protected CustomerBaseBO( SerializationInfo info, StreamingContext context )
      : base( info, context )
    {
      InitializeComponent();
    }

    #endregion

    #region Data Retrieval Methods

    /// <summary>
    /// Fill the BO with the indicated number of customers.
    /// </summary>
    /// <param name="numberToFill"></param>
    public void FillTopN( int numberToFill )
    {
      this.FillDataTable( string.Format( "Select top {0} * From {1}", numberToFill, this.TableName ) );

    }

    #endregion

    /// <summary>
    /// Extract and return a collection of system collisions. These 
    /// are collisions that the user should never see and that we can
    /// figure out what do with without any intervention.
    /// </summary>
    /// <param name="originalCollisions"></param>
    /// <returns></returns>
    public FieldCollisionCollection GetSystemCollisions( RowCollision originalCollisions )
    {
      //-- Establish a return var.
      FieldCollisionCollection sysCollisions = new FieldCollisionCollection();

      //-- Loop through the field collisions and if any are system
      //   fields, add them to our collection of system collisions.
      foreach (FieldCollision collision in originalCollisions.FieldCollisions)
      {
        switch (collision.FieldName)
        {
          case "cust_Version":
            //-- Always accept server value.
            collision.AcceptServerData = true;

            //-- Add to system collisions
            sysCollisions.Add( collision );
            break;

          case "cust_Created":
            //-- Always accept server date. 
            collision.AcceptServerData = true;

            //-- Add to system collisions
            sysCollisions.Add( collision );
            break;
        }
      }

      //-- Return the system collisions.
      return sysCollisions;
    }

    /// <summary>
    /// Extract and return a collection of user collisions. These 
    /// are collisions that the user should must handle.
    /// </summary>
    /// <param name="originalCollisions"></param>
    /// <returns></returns>
    public FieldCollisionCollection GetUserCollisions( RowCollision originalCollisions )
    {
      //-- Establish a return var.
      FieldCollisionCollection userCollisions = new FieldCollisionCollection();

      //-- Loop through the field collisions and if they aren't system 
      //   columns, add them to collection of user collisions.
      foreach (FieldCollision collision in originalCollisions.FieldCollisions)
      {
        switch (collision.FieldName)
        {
          case "cust_Version":
          case "cust_Created":
            break;
          default:
            userCollisions.Add( collision );
            break;
        }
      }

      //-- Return the system collisions.
      return userCollisions;
    }
    

    #region Event Handlers

    /// <summary>
    /// Checks the business rules on the current row
    /// </summary>
    /// <param name="e"></param>
    /// <remarks></remarks>
    private void CustomerBaseBO_CheckRulesOnCurrentRow( CheckRulesEventArgs e )
    {

    }

    /// <summary>
    /// Sets the default values for a new row
    /// </summary>
    /// <remarks></remarks>
    private void CustomerBaseBO_SetDefaultValues()
    {

    }

    #endregion

  }
}
