using Microsoft.VisualBasic;
using System;
using MicroFour.StrataFrame.Tools;

namespace StrataFlix.Business
{
    /// <summary>
    /// Movie cast types
    /// </summary>
    /// <remarks></remarks>
	public enum MovieCastType
	{
		Actor = 0,
		Director = 1,
		Crew = 2,
		Producer = 3
	}
	
	/// <summary>
	/// Movie item record type indicator
	/// </summary>
	/// <remarks></remarks>
	public enum MovieItemType
	{
		[EnumDisplayValue("Genre")]Genre = 0,
		
		[EnumDisplayValue("Media Format")]Format = 1
	}
	
	/// <summary>
	/// Avalabile DVD movie status
	/// </summary>
	/// <remarks></remarks>
	public enum MovieDVDStatus
	{
		[EnumDisplayValue("Out")]Out = 0,
		
		[EnumDisplayValue("Discontinued")]Discontinued = 1,
		
		[EnumDisplayValue("Cancelled")]Cancelled = 2,
		
		[EnumDisplayValue("Pending")]Pending = 3,
		
		[EnumDisplayValue("Recalled")]Recalled = 4,
		
		[EnumDisplayValue("Postponed")]Postponed = 5
	}
	
	/// <summary>
	/// Movie Genres
	/// </summary>
	/// <remarks></remarks>
	public enum MovieGenre
	{
		[EnumDisplayValue("Action")]Action = 0,
		
		[EnumDisplayValue("Adventure")]Adventure = 1,
		
		[EnumDisplayValue("Animation")]Animation = 2,
		
		[EnumDisplayValue("Anime")]Anime = 3,
		
		[EnumDisplayValue("Ballet")]Ballet = 4,
		
		[EnumDisplayValue("Comedy")]Comedy = 5,
		
		[EnumDisplayValue("Dance")]Dance = 6,
		
		[EnumDisplayValue("Documentary")]Documentary = 7,
		
		[EnumDisplayValue("Drama")]Drama = 8,
		
		[EnumDisplayValue("Exercise")]Exercise = 9,
		
		[EnumDisplayValue("Family")]Family = 10,
		
		[EnumDisplayValue("Fantasy")]Fantasy = 11,
		
		[EnumDisplayValue("Foreign")]Foreign = 12,
		
		[EnumDisplayValue("Games")]Games = 13,
		
		[EnumDisplayValue("Horror")]Horror = 14,
		
		[EnumDisplayValue("Karaoke")]Karaoke = 15,
		
		[EnumDisplayValue("Late Night")]LateNight = 16,
		
		[EnumDisplayValue("Music")]Music = 17,
		
		[EnumDisplayValue("Musical")]Musical = 18,
		
		[EnumDisplayValue("Mystery")]Mystery = 19,
		
		[EnumDisplayValue("Opera")]Opera = 20,
		
		[EnumDisplayValue("Satire")]Satire = 21,
		
		[EnumDisplayValue("Sci-Fi")]SciFi = 22,
		
		[EnumDisplayValue("Silent")]Silent = 23,
		
		[EnumDisplayValue("Software")]Software = 24,
		
		[EnumDisplayValue("Special Interest")]SpecialInterest = 25,
		
		[EnumDisplayValue("Sports")]Sports = 26,
		
		[EnumDisplayValue("Suspense")]Suspense = 27,
		
		[EnumDisplayValue("Thriller")]Thriller = 28,
		
		[EnumDisplayValue("TV Classics")]TVClassics = 29,
		
		[EnumDisplayValue("VAR")]VAR = 30,
		
		[EnumDisplayValue("War")]War = 31,
		
		[EnumDisplayValue("Western")]Western = 32,
		
		[EnumDisplayValue("Unknown")]Unknown = 33
	}
	
	/// <summary>
	/// Movie MPAA ratings
	/// </summary>
	/// <remarks></remarks>
	public enum MovieRating
	{
		[EnumDisplayValue("G")]G = 0,
		
		[EnumDisplayValue("PG")]PG = 1,
		
		[EnumDisplayValue("PG-13")]PG13 = 2,
		
		[EnumDisplayValue("R")]R = 3,
		
		[EnumDisplayValue("NC-17")]NC17 = 4,
		
		[EnumDisplayValue("Not Rated")]NR = 5,
		
		//<EnumDisplayValue("R/UR")> _
		//RUR = 6
		
		[EnumDisplayValue("MA-13")]MA13 = 7,
		
		[EnumDisplayValue("Unrated")]UR = 9,
		
		[EnumDisplayValue("MA-15")]MA15 = 11,
		
		[EnumDisplayValue("GA")]GA = 0,
		
		[EnumDisplayValue("TV-MA")]TVMA = 14
		
	}
	
	/// <summary>
	/// Movie media formats
	/// </summary>
	/// <remarks></remarks>
	public enum MovieMediaFormats
	{
		[EnumDisplayValue("4:3 - Fullscreen")]Fullscreen = 0,
		
		[EnumDisplayValue("16:9 - Widescreen")]Widescreen = 1,
		
		[EnumDisplayValue("LBX - Letterbox")]Letterbox = 2,
		
		[EnumDisplayValue("Dual-Disc")]DualDisc = 3,
		
		[EnumDisplayValue("Pan and Scan")]PanAndScan = 4,
		
		[EnumDisplayValue("Blu-ray")]Bluray = 5,
		
		[EnumDisplayValue("HD-DVD")]HDDVD = 6,
		
		[EnumDisplayValue("Universal Media Disc")]UMD = 7,
		
		[EnumDisplayValue("Mini-DVD")]MiniDVD = 8,
		
		[EnumDisplayValue("Play Station 2")]PS2 = 9,
		
		[EnumDisplayValue("Xbox")]Xbox = 10,
		
		[EnumDisplayValue("Windows Media Video HD")]WMVHD = 11,
		
		[EnumDisplayValue("Unknown")]Unknown = 12
		
	}
	
	/// <summary>
	/// Type of phone indicator
	/// </summary>
	/// <remarks></remarks>
	public enum PhoneType
	{
		Home = 0,
		Business = 1,
		Mobile = 2,
		Pager = 3
	}
	
	
}
