using Microsoft.VisualBasic;
using System;
using Microsoft.Reporting.WinForms;


namespace StrataFlix.Reporting
{
	public partial class ReportViewerDialog
	{
		public ReportViewerDialog()
		{
			InitializeComponent();
		}
		
		#region " Public Methods "
		
		/// <summary>
		/// Runs the report
		/// </summary>
		/// <remarks></remarks>
		public void RunReport(LocalReport report)
		{
			//-- Set the local report on the viewer
			rptViewer.LocalReport.DataSources.Clear();
			
			//-- Add all of the report data sources
			foreach (ReportDataSource ds in report.DataSources)
			{
				rptViewer.LocalReport.DataSources.Add(ds);
			}
			
			//-- Set the additional properties
			rptViewer.LocalReport.DisplayName = report.DisplayName;
			rptViewer.LocalReport.ReportEmbeddedResource = report.ReportEmbeddedResource;
			
			
			//-- Refresh and run the report
			rptViewer.RefreshReport();
			
		}
		
		#endregion
		
		//Private Sub rptViewer_RenderingComplete(ByVal sender As Object, ByVal e As Microsoft.Reporting.WinForms.RenderingCompleteEventArgs) Handles rptViewer.RenderingComplete
		//    '-- Force the layout to print by default
		//    rptViewer.SetDisplayMode(DisplayMode.PrintLayout)
		//End Sub
	}
	
}
