using Microsoft.VisualBasic;
using System;
using MicroFour.StrataFrame.Business;
using Microsoft.Reporting.WinForms;


namespace StrataFlix.Reporting
{

    /// <summary>
    /// This class is used witin this application to create a reporting object which
    /// generates its own data sources and communicates with the proper RDLC file to
    /// produce a LocalReport object which can be used within a ReportViewer control.
    /// Additionally, this class also provides an implementation to populate the data source
    /// and display and dialogs to gather data prior to showing the report.
    /// </summary>
    /// <typeparam name="TSource"></typeparam>
    /// <remarks></remarks>
	public abstract class ReportDataSource<TSource> : IReportDataSource where TSource : BusinessBindingSource, new()
	{		
		
		#region " Private Fields "
		
		private TSource _DataSource = new TSource();
		private LocalReport _LocalReport = new LocalReport();
		
		#endregion
		
		#region " Public Methods "
		
		/// <summary>
		/// Method that is called to populate the binding source data
		/// </summary>
		/// <remarks></remarks>
		public abstract bool PopulateDataSource();
		
		#endregion
		
		#region " Public Properties "
		
		/// <summary>
		/// Returns the instance of the binding source that needs to be populated and that
		/// will be used on the report itself.  This is the object that should be populated
		/// with data.
		/// </summary>
		/// <value></value>
		/// <returns></returns>
		/// <remarks></remarks>
		public TSource DataSource
		{
			get
			{
				return _DataSource;
			}
		}
		
		/// <summary>
		/// The LocalReport object that for this report.  This is the exposed property that can be passed
		/// into any ReportViewer.  Additionally, this is the object that should be used to set the data
		/// sources, names, etc. specific to the report.
		/// </summary>
		public LocalReport LocalReport
		{
			get
			{
				return this._LocalReport;
			}
		}
		
		#endregion
		
	}
	
}
