using Microsoft.VisualBasic;
using System;
using MicroFour.StrataFrame.Business;
using Microsoft.Reporting.WinForms;


namespace StrataFlix.Reporting
{
    /// <summary>
    /// The reporting engine that is the funnel through which all reports
    /// are generated and run.
    /// </summary>
    /// <remarks></remarks>
	public sealed class ReportEngine
	{
		
		#region " Private Methods "
		
		/// <summary>
		/// Returns the reporting data source for the specified report
		/// </summary>
		/// <param name="report"></param>
		/// <returns></returns>
		/// <remarks></remarks>
		private static IReportDataSource GetReportDataSource(StrataFlixReports report)
		{
			//-- Establish Locals
			IReportDataSource r = null;
			
			switch (report)
			{
				case StrataFlixReports.MovieListing:
					r = new Reports.MovieListing.MovieListingDataSource();
					break;
					
				case StrataFlixReports.MovieProfile:
					r = new Reports.MovieProfile.MovieProfileDataSource();
					break;
					
				case StrataFlixReports.PeopleProfile:
					r = new Reports.PeopleProfileReport.PeopleProfileDataSource();
					break;
			}
			
			//-- Return the results
			return r;
		}
		
		#endregion
		
		#region " Public Methods "
		
		/// <summary>
		/// Runs the specified report
		/// </summary>
		/// <param name="report"></param>
		/// <remarks></remarks>
		public static void RunReport(StrataFlixReports report)
		{
			//-- Establish Locals
			ReportViewerDialog f = new ReportViewerDialog();
			IReportDataSource rpt;
			
			//-- Get the data source for the report
			rpt = GetReportDataSource(report);
			
			//-- Populate the data source
			if (rpt.PopulateDataSource())
			{
				//-- Run the report
				f.RunReport(rpt.LocalReport);
				f.ShowDialog();
			}
			
		}
		
		/// <summary>
		/// Runs the specified report
		/// </summary>
		/// <remarks></remarks>
		public static void RunReport(IReportDataSource dataSource)
		{
			//-- Establish Locals
			ReportViewerDialog f = new ReportViewerDialog();
			
			//-- Run the report since the data source has already been supplied
			f.RunReport(dataSource.LocalReport);
			f.ShowDialog();
		}
		
		#endregion
		
	}
	
}
