using System.Windows.Forms;
using Microsoft.VisualBasic;
using System;
using StrataFlix.UI.Windows.Forms;
using System.Collections.Generic;
using System.Drawing;


namespace StrataFlix
{
	public partial class FlixMain
	{
		public FlixMain()
		{
			InitializeComponent();
		}
		
		#region " Handled Events "
		
		private void mi_Movie_People_Click(System.Object sender, System.EventArgs e)
		{
			LaunchDialog(typeof(PeopleMaintenance));
		}
		
		private void tlmActions_ItemClicked(System.Object sender, MicroFour.StrataFrame.UI.Windows.Forms.ThemedLinkMenuClickEventArgs e)
		{
			//-- Since we have inherited from the ThemedLinkMenuItem, the delegates have been combined which will
			//   invoke the click within the ActionLinkMenuitem.  So to force this, call the OnClick to raise that event.
			((ActionLinkMenuItem) e.Item).OnClick();
		}
		
		private void mi_Movie_DVDMaintenance_Click(object sender, System.EventArgs e)
		{
			LaunchDialog(typeof(MovieMaintenance));
		}
		
		private void tlmMenu_ItemClicked(System.Object sender, MicroFour.StrataFrame.UI.Windows.Forms.ThemedLinkMenuClickEventArgs e)
		{
			if (e.Item.Key.Equals("MovieDatabase", StringComparison.OrdinalIgnoreCase))
			{
				cmMovieDatabase.Show(e.Item.Parent.PointToScreen(new Point(e.Item.Bounds.Right + 2, e.Item.Bounds.Top)));
			}
			else if (e.Item.Key.Equals("Setup", StringComparison.OrdinalIgnoreCase))
			{
				cmSetupAndOptions.Show(e.Item.Parent.PointToScreen(new Point(e.Item.Bounds.Right + 2, e.Item.Bounds.Top)));
			}
		}
		
		private void mi_Setup_DatabaseConnection_Click(System.Object sender, System.EventArgs e)
		{
			SetDatabaseConnection();
		}
		
		#endregion
		
		#region " Private Fields "
		
		private MdiClient _MDIClient = new MdiClient();
		
		#endregion
		
		#region " Private Methods "
		
		/// <summary>
		/// Adds handlers to a form so that the actions can be properly managed
		/// </summary>
		/// <param name="form"></param>
		/// <remarks></remarks>
		private void AddFormHandlers(Form form)
		{
			form.Activated += new System.EventHandler(HandleFormActivated);
			form.FormClosed += new System.Windows.Forms.FormClosedEventHandler(HandleFormClosed);
		}
		
		/// <summary>
		/// Clears the actions from the list
		/// </summary>
		/// <remarks></remarks>
		private void ClearActions()
		{
			//-- Clear the items from the list
			tlmActions.ItemCollection.Clear();
			
			//-- Force the menu to re-render regardless of circumstances
			tlmActions.Invalidate();
		}
		
		/// <summary>
		/// Manages the form activation and adds or removes the respective actions
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		/// <remarks></remarks>
		private void HandleFormActivated(object sender, EventArgs e)
		{
			//-- Establish Locals
			object f = sender as ApplicationBaseForm;
			
			//-- Set the action items if the specifies dialog can be cast as a base form
			if (f != null)
			{
				SetActionItems((ApplicationBaseForm) f);
			}
			else
			{
				tlmActions.ItemCollection.Clear();
			}
		}
		
		/// <summary>
		/// When a form closes, it should clear out the actions
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		/// <remarks></remarks>
		private void HandleFormClosed(object sender, FormClosedEventArgs e)
		{
			ClearActions();
			RemoveFormHandlers((Form) sender);
		}
		
		/// <summary>
		/// Launches a dialog and adds it to the MDI
		/// </summary>
		/// <param name="dialogType"></param>
		/// <remarks></remarks>
		private void LaunchDialog(System.Type dialogType)
		{
			//-- Establish Locals
			Form f = (Form) (Activator.CreateInstance(dialogType));
			
			//-- Add the handlers to the form
			AddFormHandlers(f);
			
			//-- Set the parent MDI
			f.MdiParent = this;
			
			//-- Show the dialog
			f.Show();
		}
		
		/// <summary>
		/// Removes the handlers from a form
		/// </summary>
		/// <param name="form"></param>
		/// <remarks></remarks>
		private void RemoveFormHandlers(Form form)
		{
			form.Activated -= new System.EventHandler(HandleFormActivated);
			form.FormClosed -= new System.Windows.Forms.FormClosedEventHandler(HandleFormClosed);
		}
		
		/// <summary>
		/// Updates the action menu with the items within the active dialog
		/// </summary>
		/// <param name="form"></param>
		/// <remarks></remarks>
		private void SetActionItems(ApplicationBaseForm form)
		{
			//-- Clear the items currently in the list
			tlmActions.BeginUpdate();
			tlmActions.ItemCollection.Clear();
			
			//-- Add the actions into the ThemedLinkMenu
			foreach (ActionLinkMenuItem item in form.ActionItems)
			{
				tlmActions.ItemCollection.Add(item);
			}
			
			//-- Restore rendering
			tlmActions.EndUpdate();
		}
		
		/// <summary>
		/// Sets the database connection
		/// </summary>
		/// <remarks></remarks>
		private void SetDatabaseConnection()
		{
			//-- Show the connection dialog and allow a connection to be selected
			if (MicroFour.StrataFrame.Data.ConnectionManager.ShowAvailableConnectionStrings())
			{
				//-- Since a connection was selected, then all of the existing dialogs need to be closed
				//   since their connection is established to the original source.
				foreach (Form loForm in this.MdiChildren)
				{
					loForm.Close();
					loForm.Dispose();
				}
				
				//-- Force the connections to be reset
				MicroFour.StrataFrame.Data.ConnectionManager.SetConnections();
			}
		}
		
		#endregion
		
		#region " Protected Methods "
		
		/// <summary>
		/// Provide additional load logic
		/// </summary>
		/// <param name="e"></param>
		/// <remarks></remarks>
		protected override void OnLoad(System.EventArgs e)
		{
			base.OnLoad(e);
			
			//-- Set the MDI backcolor to white
			_MDIClient.BackColor = System.Drawing.Color.White;
			
			//-- Add the MDI
			this.Controls.Add(_MDIClient);
		}
		
		#endregion
		
	}
	
}
