using Microsoft.VisualBasic;
using System;
using System.Data;
using System.Drawing;

namespace StrataFlix
{
    /// <summary>
    /// Contains a collection of methods and properties that are used throughout the application.
    /// </summary>
    /// <remarks></remarks>
	public sealed class Basics
	{
		
		
		#region " Constructors "
		
		/// <summary>
		/// Seal the class so an instance cannot be created.
		/// </summary>
		/// <remarks></remarks>
		private Basics()
		{
			
		}
		
		#endregion
		
		#region " Public Methods "
		
		/// <summary>
		/// Ensures that the column specified exists within the table.
		/// </summary>
		/// <param name="table"></param>
		/// <param name="columnName"></param>
		/// <param name="columnType"></param>
		/// <param name="defaultValue"></param>
		/// <remarks></remarks>
		public static void EnsureColumnExists(DataTable table, string columnName, System.Type columnType, object defaultValue)
		{
			//-- Establish Locals
			DataColumn col;
			bool columnFound = false;
			
			//-- Cycle through all of the columns so we can test on a case-insensitive basis
			foreach (DataColumn tempLoopVar_col in table.Columns)
			{
				col = tempLoopVar_col;
				//-- Check to see if the column name matches
				columnFound = col.ColumnName.Equals(columnName, StringComparison.OrdinalIgnoreCase);
				
				//-- If the column was found, exit
				if (columnFound)
				{
					break;
				}
			}
			
			//-- See if there is any reason to continue
			if (columnFound)
			{
				return;
			}
			
			//-- If we make it to this point, then we have a hit
			col = new DataColumn(columnName, columnType);
			col.DefaultValue = defaultValue;
			
			//-- Add the column to the table
			table.Columns.Add(col);
		}
        
        /// <summary>
        /// Ensures that the specified image does not exceed the width or height specified.  If so, it reduces the image
        /// size to the specified dimensions.
        /// </summary>
        /// <param name="imgSource"></param>
        /// <param name="width"></param>
        /// <param name="height"></param>
        /// <returns></returns>
        public static Image ReduceImageSize(Image imgSource, int width, int height)
        {
            //-- Establish Locals
            Bitmap r = (Bitmap)imgSource;
            Graphics dc;

            //-- See if there is anything that needs to be done to the image size
            if ((r.Width > width) || (r.Height > height))
            {
                //-- Create the new image
                r = new Bitmap(width, height);

                //-- Create a drawing device context
                dc = Graphics.FromImage(r);

                //-- Now scale down the image
                dc.DrawImage(imgSource, new Rectangle(0,0,width, height), new Rectangle(0,0,imgSource.Width, imgSource.Height), GraphicsUnit.Pixel);

                //-- Clean Up
                dc.Dispose();

            }

            //-- Return the results
            return r;
        }
		
		
		#endregion
		
		#region " Public Properties "
		
		/// <summary>
		/// Exposes the user primary key of the current user
		/// </summary>
		/// <value></value>
		/// <returns></returns>
		/// <remarks></remarks>
		public int UserPk
		{
			get
			{
				return MicroFour.StrataFrame.Security.SecurityBasics.CurrentUser.UserPK;
			}
		}
		
		#endregion
		
	}
	
}
