using System.Windows.Forms;
using Microsoft.VisualBasic;
using System;
using MicroFour.StrataFrame.Application;
using MicroFour.StrataFrame.Data;
using MicroFour.StrataFrame.Security;
using MicroFour.StrataFrame.Security.BusinessObjects;
using Microsoft.VisualBasic.CompilerServices;


namespace StrataFlix
{
	public sealed class program
	{
		
		
		[STAThread()]public static void Main()
		{
			//-- Enable the visual styles
			System.Windows.Forms.Application.EnableVisualStyles();
			
			//-- Add the handlers for the application events
			StrataFrameApplication.ShowGateway += new MicroFour.StrataFrame.Application.StrataFrameApplication.ShowGatewayEventHandler(ShowGateway);
			StrataFrameApplication.InitializingApplication += new MicroFour.StrataFrame.Application.StrataFrameApplication.InitializingApplicationEventHandler(InitApplication);
			StrataFrameApplication.SetDataSources += new MicroFour.StrataFrame.Application.StrataFrameApplication.SetDataSourcesEventHandler(SetDataSources);
			StrataFrameApplication.UnhandledExceptionFound += new MicroFour.StrataFrame.Application.StrataFrameApplication.UnhandledExceptionFoundEventHandler(UnhandledExceptionFound);
			StrataFrameApplication.ShowLoginAndInitializeForm += new MicroFour.StrataFrame.Application.StrataFrameApplication.ShowLoginAndInitializeFormEventHandler(ShowLoginAndInitMainForm);
			
			//-- Run the application
			StrataFrameApplication.RunApplication();
			
			//-- Forcibly close the application to stop message pumps from looping and preventing the application
			//   from closing
			ProjectData.EndApp();
		}
		
		/// <summary>
		/// Gets the connection string if the application will use a custom method to aquire the connection
		/// string rather than the StrataFrame Connection String Manager (optional)
		/// </summary>
		/// <remarks></remarks>
		private static void SetDataSources()
		{
			
			//------------------------------------
			//  Using the Connection Manager
			//------------------------------------
			
			//-- Set the information specific to this application and the data sources
			//       The application key:
			ConnectionManager.ApplicationKey = "StrataFlix";
			ConnectionManager.ApplicationDefaultTitle = "StrataFlix Connection";
			ConnectionManager.ApplicationDefaultDescription = "This application connection is used by StrataFlix";
			
			//-- Set the required data source information so that the ConnectionManager can gather it
			//      SQL Connection
			ConnectionManager.AddRequiredDataSourceItem("", "SQL Connection", DataSourceTypeOptions.SqlServer, "StrataFlix", "This connection is used by StrataFlix.");
			
			//-- Make the call to SetConnections which will gather the connection information, show the connection wizard
			//   if needed and set the DataSources collection on the DataLayer class.
			ConnectionManager.SetConnections();
			
			//ConnectionManager.ShowAvailableConnectionStrings()
			
			//-- Use the default connection for security since the security tables for this applicaiton
			//   reside in the same database
			SecurityBasics.SecurityDataSourceKey = "";
		}
		
		/// <summary>
		/// Shows the "Gateway" form (a custom form that gives the user a choice to launch different components
		/// within the application) (optional)
		/// </summary>
		/// <param name="e"></param>
		/// <remarks></remarks>
		private static void ShowGateway(ShowGatewayEventArgs e)
		{
			//-- Inform the application to not show the "Gateway" form again after the main form has closed
			e.ShowGatewayAfterMainFormClose = false;
		}
		
		/// <summary>
		/// Shows a login form before a main form is shown and allows security to be checked before the application
		/// launches the main form (optional)
		/// </summary>
		/// <param name="e"></param>
		/// <remarks></remarks>
		private static void ShowLoginAndInitMainForm(ShowLoginAndInitFormEventArgs e)
		{
			//-- Set the login form to your custom login form (optional)
			Login.LoginFormType = typeof(StrataFlix.StrataFlixLogin);
			
			//-- Show the login form and authenticate the user
			e.ShowMainForm = Login.ShowLoginAndAuthUser(true);
		}
		
		/// <summary>
		/// Provides a centralized location to add any initialization parameters that need to be set before
		/// the application is loaded and defines the form types used as main forms by the application
		/// </summary>
		/// <param name="e"></param>
		/// <remarks></remarks>
		private static void InitApplication(InitializingApplicationEventArgs e)
		{
			//-- Add the main form type
			//-- If more than one form is added to the collection, they can be chosen by showing a "Gateway" form
			//   and supplying the index of the form to show (At least 1 form type must be added to the collection
			e.Forms.Add(typeof(StrataFlix.FlixMain));
			
			//-- ToDo:  Add any extra application initialization
			MicroFour.StrataFrame.UI.Localization.MessageKeyType = MicroFour.StrataFrame.Messaging.MessageKeyDataType.XML;
			MicroFour.StrataFrame.UI.Localization.MessageLocaleID = MicroFour.StrataFrame.UI.Localization.GetActiveLanguage("StrataFlix");
			
			//-- Retrieve the global preferences
			SFSPreferencesBO.RetrieveSecurityPreferences();
			
			//-- Set the encryption key and vector for the user data
			SecurityBasics.SetSecurityKeyAndVectorForUserAuthentication("StrataFlixSample");
			
			//-- Start the session locking monitor & set the quick key to lock the application
			SessionLock.StartSessionMonitoring();
			SessionLock.SessionLockKey = Keys.F11;
			
			//-- Set the administrative and security maintenance usernames and passwords
			SecurityBasics.AdministratorUserName = "Administrator";
			SecurityBasics.AdministratorPassword = "sample";
			SecurityBasics.AdministratorUserPk = - 1;
			
			//-- Set the default actions for security enabled objects within the application
			SecurityBasics.DefaultPermissionInfo = new PermissionInfo(PermissionAction.Deny, "Access Denied.", DeniedActions.Message);
			SecurityBasics.DefaultPermissionAction = PermissionAction.Deny;
			SecurityBasics.DefaultBlockedMsg = "Access Denied.";
			//SecurityBasics.DefaultBlockedMsgKey = "AccessDeniedKey"
			SecurityBasics.BlockedReplacementCharacter = '*';
			SecurityBasics.BlockedReplacementRegex = "[A-Za-z0-9@]";
			
			//-- Determine whether to allow Windows authentication
			SecurityBasics.AllowWindowsAuth = false;
		}
		
		/// <summary>
		/// Catches any unhandled exception within the application and provides a place to log the information
		/// </summary>
		/// <param name="e"></param>
		/// <remarks></remarks>
		private static void UnhandledExceptionFound(UnhandledExceptionFoundEventArgs e)
		{
			MicroFour.StrataFrame.Application.StrataFrameApplication.ShowRedExceptionDialog(e.UnhandledException);
		}
		
	}
}
