using MicroFour.StrataFrame.Business;
using MicroFour.StrataFrame.Security;
using MicroFour.StrataFrame.UI.Windows.Forms;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.IO;

namespace DM.Library
{
    public partial class Entity : MicroFour.StrataFrame.Business.BusinessLayer
    {

        #region Component Implementation

        /// <summary>
        /// Required designer variable.
        /// </summary>
        private System.ComponentModel.IContainer components = null;

        /// <summary> 
        /// Clean up any resources being used.
        /// </summary>
        /// <param name="disposing">true if managed resources should be disposed; otherwise, false.</param>
        protected override void Dispose(bool disposing)
        {
            if (disposing && (components != null))
            {
                components.Dispose();
            }
            base.Dispose(disposing);
        }

        /// <summary>
        /// Required method for Designer support - do not modify
        /// the contents of this method with the code editor.
        /// </summary>
        private void InitializeComponent()
        {
            components = new System.ComponentModel.Container();

            this.CheckRulesOnCurrentRow += new CheckRulesOnCurrentRowEventHandler(BusinessObject1_CheckRulesOnCurrentRow);
            this.SetDefaultValues += new SetDefaultValuesEventHandler(BusinessObject1_SetDefaultValues);
        }

        #endregion


        #region BusinessLayer Overriden Methods & Properties

        /// <summary>
        /// The collection of required fields for the business object.
        /// </summary>
        /// <remarks></remarks>
        [Browsable(false), DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public override RequiredFieldsCollection RequiredFields
        {
            get
            {
                return base.RequiredFields;
            }
            set
            {
                base.RequiredFields = value;
            }
        }

        /// <summary>
        /// Defines the constraint that defines the parent-child relationship between this business object type and another business object type.
        /// </summary>
        /// <remarks></remarks>
        [Browsable(false), DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public override IBusinessParentRelationship ParentRelationship
        {
            get
            {
                return base.ParentRelationship;
            }
            set
            {
                base.ParentRelationship = value;
            }
        }

        /// <summary>
        /// Returns all of the field names in a single string in the form of [field1],[field2],...  This must be used in the place of '*' in select statements if Query Notifications are to be registered.
        /// </summary>
        /// <remarks></remarks>
        protected override String AllFieldNames
        {
            get
            {
                return "[MRN],[FIRSTNAME],[LASTNAME],[MIDDLENAME],[BIRTHDATE],[GENDER],[ETHNICITY],[SSN],[ADDR1],[ADDR2],[CITY],[STATE],[ZIP],[HOMEPHONE],[MOTHERMAIDENNAME],[COUNTY],[LANGUAGE],[MARITALSTATUS],[RELIGION],[WORKPHONE]";
            }
        }

        /// <summary>
        /// The name of the database that contains the table to which this business object is mapped.
        /// </summary>
        /// <remarks></remarks>
        public override String Database
        {
            get
            {
                return "CRM";
            }
        }

        private static string[] _PrimaryKeyFields = new string[] { };
        /// <summary>
        /// Gets the field or fields that comprise the primary key for the business object.
        /// </summary>
        /// <remarks></remarks>
        public override string[] PrimaryKeyFields
        {
            get
            {
                return _PrimaryKeyFields;
            }
        }

        /// <summary>
        /// The name of the table in the database to which this business object is mapped.
        /// </summary>
        /// <remarks></remarks>
        public override String TableName
        {
            get
            {
                return "Entity";
            }
        }

        /// <summary>
        /// The schema of the table in the database to which this business object is mapped.
        /// </summary>
        /// <remarks></remarks>
        public override String TableSchema
        {
            get
            {
                return "dbo";
            }
        }

        /// <summary>
        /// Creates and returns an array of DataColumns that contains the schema for the table.  This is used to prevent a round trip to the server to aquire the initial schema for the internal DataTable.
        /// </summary>
        /// <remarks></remarks>
        protected override DataColumn[] CreateTableSchema()
        {
            return new DataColumn[] {
new DataColumn("MRN", typeof(System.String)),
new DataColumn("FIRSTNAME", typeof(System.String)),
new DataColumn("LASTNAME", typeof(System.String)),
new DataColumn("MIDDLENAME", typeof(System.String)),
new DataColumn("BIRTHDATE", typeof(System.DateTime)),
new DataColumn("GENDER", typeof(System.String)),
new DataColumn("ETHNICITY", typeof(System.String)),
new DataColumn("SSN", typeof(System.String)),
new DataColumn("ADDR1", typeof(System.String)),
new DataColumn("ADDR2", typeof(System.String)),
new DataColumn("CITY", typeof(System.String)),
new DataColumn("STATE", typeof(System.String)),
new DataColumn("ZIP", typeof(System.String)),
new DataColumn("HOMEPHONE", typeof(System.String)),
new DataColumn("MOTHERMAIDENNAME", typeof(System.String)),
new DataColumn("COUNTY", typeof(System.String)),
new DataColumn("LANGUAGE", typeof(System.String)),
new DataColumn("MARITALSTATUS", typeof(System.String)),
new DataColumn("RELIGION", typeof(System.String)),
new DataColumn("WORKPHONE", typeof(System.String))};
        }

        /// <summary>
        /// Adds a broken rule to the business object's collection
        /// </summary>
        /// <remarks></remarks>
        protected void AddBrokenRule(EntityFieldNames Field, string ErrorMessage)
        {
            base.AddBrokenRule(Field, ErrorMessage);
        }

        /// <summary>
        /// Adds a broken rule to the business object's collection
        /// </summary>
        /// <remarks></remarks>
        protected new void AddBrokenRule(string FieldName, string ErrorMessage)
        {
            base.AddBrokenRule(FieldName, ErrorMessage);
        }

        /// <summary>
        /// Adds a broken rules to the business object's collection using the given message key to pull the error message from the localization database
        /// </summary>
        /// <remarks></remarks>
        protected void AddBrokenRuleByKey(EntityFieldNames Field, string ErrorMessageKey)
        {
            base.AddBrokenRuleByKey(Field, ErrorMessageKey);
        }

        /// <summary>
        /// Adds a broken rules to the business object's collection using the given message key to pull the error message from the localization database
        /// </summary>
        /// <remarks></remarks>
        protected new void AddBrokenRuleByKey(string FieldName, string ErrorMessageKey)
        {
            base.AddBrokenRuleByKey(FieldName, ErrorMessageKey);
        }

        /// <summary>
        /// Gets a collection of the names for all fields that belong to this business object and map to the database.
        /// </summary>
        /// <remarks></remarks>
        public override List<string> AllFieldsList
        {
            get
            {
                return _AllFieldsList;
            }
        }

        /// <summary>
        /// Gets a dictionary of the DbTypes for all fields that belong to this business object and map to the database.
        /// </summary>
        /// <remarks></remarks>
        public override Dictionary<string, DbType> FieldDbTypes
        {
            get
            {
                return _FieldDbTypes;
            }
        }

        /// <summary>
        /// Gets a dictionary of all fields within this business object that map to the FieldNames enumeration for this business object.
        /// </summary>
        /// <remarks></remarks>
        public override BusinessLayerFieldEnumDictionary FieldEnums
        {
            get
            {
                return _FieldEnums;
            }
        }

        /// <summary>
        /// Gets a dictionary of all of the lengths for all fields within this business object that map to a field in the database.
        /// </summary>
        /// <remarks></remarks>
        public override Dictionary<string, int> FieldLengths
        {
            get
            {
                return _FieldLengths;
            }
        }

        /// <summary>
        /// Gets a dictionary of the native DbType (SqlDbType, OracleType, OleDbType, etc.) for all fields within this buisness object that map to a field in the database.
        /// </summary>
        /// <remarks></remarks>
        public override Dictionary<string, int> FieldNativeDbTypes
        {
            get
            {
                return _FieldNativeDbTypes;
            }
        }

        /// <summary>
        /// Gets a dictionary of the security permission keys for each field in the business object.
        /// </summary>
        /// <remarks></remarks>
        public override Dictionary<string, string> FieldPermissionKeys
        {
            get
            {
                return _FieldPermissionKeys;
            }
        }

        #endregion

        #region Field Properties

        /// <summary>
        /// MRN
        /// </summary>
        /// <remarks></remarks>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("MRN"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.String MRN
        {
            get
            {
                return (System.String)this.CurrentRow["MRN"];
            }
            set
            {
                this.CurrentRow["MRN"] = value;
            }
        }

        /// <summary>
        /// FIRSTNAME
        /// </summary>
        /// <remarks></remarks>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("FIRSTNAME"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.String FIRSTNAME
        {
            get
            {
                return (System.String)this.CurrentRow["FIRSTNAME"];
            }
            set
            {
                this.CurrentRow["FIRSTNAME"] = value;
            }
        }

        /// <summary>
        /// LASTNAME
        /// </summary>
        /// <remarks></remarks>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("LASTNAME"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.String LASTNAME
        {
            get
            {
                return (System.String)this.CurrentRow["LASTNAME"];
            }
            set
            {
                this.CurrentRow["LASTNAME"] = value;
            }
        }

        /// <summary>
        /// MIDDLENAME
        /// </summary>
        /// <remarks></remarks>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("MIDDLENAME"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.String MIDDLENAME
        {
            get
            {
                return (System.String)this.CurrentRow["MIDDLENAME"];
            }
            set
            {
                this.CurrentRow["MIDDLENAME"] = value;
            }
        }

        /// <summary>
        /// BIRTHDATE
        /// </summary>
        /// <remarks></remarks>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("BIRTHDATE"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.DateTime BIRTHDATE
        {
            get
            {
                return (System.DateTime)this.CurrentRow["BIRTHDATE"];
            }
            set
            {
                this.CurrentRow["BIRTHDATE"] = value;
            }
        }

        /// <summary>
        /// GENDER
        /// </summary>
        /// <remarks></remarks>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("GENDER"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.String GENDER
        {
            get
            {
                return (System.String)this.CurrentRow["GENDER"];
            }
            set
            {
                this.CurrentRow["GENDER"] = value;
            }
        }

        /// <summary>
        /// ETHNICITY
        /// </summary>
        /// <remarks></remarks>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("ETHNICITY"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.String ETHNICITY
        {
            get
            {
                return (System.String)this.CurrentRow["ETHNICITY"];
            }
            set
            {
                this.CurrentRow["ETHNICITY"] = value;
            }
        }

        /// <summary>
        /// SSN
        /// </summary>
        /// <remarks></remarks>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("SSN"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.String SSN
        {
            get
            {
                return (System.String)this.CurrentRow["SSN"];
            }
            set
            {
                this.CurrentRow["SSN"] = value;
            }
        }

        /// <summary>
        /// ADDR1
        /// </summary>
        /// <remarks></remarks>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("ADDR1"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.String ADDR1
        {
            get
            {
                return (System.String)this.CurrentRow["ADDR1"];
            }
            set
            {
                this.CurrentRow["ADDR1"] = value;
            }
        }

        /// <summary>
        /// ADDR2
        /// </summary>
        /// <remarks></remarks>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("ADDR2"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.String ADDR2
        {
            get
            {
                return (System.String)this.CurrentRow["ADDR2"];
            }
            set
            {
                this.CurrentRow["ADDR2"] = value;
            }
        }

        /// <summary>
        /// CITY
        /// </summary>
        /// <remarks></remarks>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("CITY"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.String CITY
        {
            get
            {
                return (System.String)this.CurrentRow["CITY"];
            }
            set
            {
                this.CurrentRow["CITY"] = value;
            }
        }

        /// <summary>
        /// STATE
        /// </summary>
        /// <remarks></remarks>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("STATE"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.String STATE
        {
            get
            {
                return (System.String)this.CurrentRow["STATE"];
            }
            set
            {
                this.CurrentRow["STATE"] = value;
            }
        }

        /// <summary>
        /// ZIP
        /// </summary>
        /// <remarks></remarks>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("ZIP"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.String ZIP
        {
            get
            {
                return (System.String)this.CurrentRow["ZIP"];
            }
            set
            {
                this.CurrentRow["ZIP"] = value;
            }
        }

        /// <summary>
        /// HOMEPHONE
        /// </summary>
        /// <remarks></remarks>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("HOMEPHONE"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.String HOMEPHONE
        {
            get
            {
                return (System.String)this.CurrentRow["HOMEPHONE"];
            }
            set
            {
                this.CurrentRow["HOMEPHONE"] = value;
            }
        }

        /// <summary>
        /// MOTHERMAIDENNAME
        /// </summary>
        /// <remarks></remarks>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("MOTHERMAIDENNAME"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.String MOTHERMAIDENNAME
        {
            get
            {
                return (System.String)this.CurrentRow["MOTHERMAIDENNAME"];
            }
            set
            {
                this.CurrentRow["MOTHERMAIDENNAME"] = value;
            }
        }

        /// <summary>
        /// COUNTY
        /// </summary>
        /// <remarks></remarks>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("COUNTY"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.String COUNTY
        {
            get
            {
                return (System.String)this.CurrentRow["COUNTY"];
            }
            set
            {
                this.CurrentRow["COUNTY"] = value;
            }
        }

        /// <summary>
        /// LANGUAGE
        /// </summary>
        /// <remarks></remarks>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("LANGUAGE"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.String LANGUAGE
        {
            get
            {
                return (System.String)this.CurrentRow["LANGUAGE"];
            }
            set
            {
                this.CurrentRow["LANGUAGE"] = value;
            }
        }

        /// <summary>
        /// MARITALSTATUS
        /// </summary>
        /// <remarks></remarks>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("MARITALSTATUS"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.String MARITALSTATUS
        {
            get
            {
                return (System.String)this.CurrentRow["MARITALSTATUS"];
            }
            set
            {
                this.CurrentRow["MARITALSTATUS"] = value;
            }
        }

        /// <summary>
        /// RELIGION
        /// </summary>
        /// <remarks></remarks>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("RELIGION"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.String RELIGION
        {
            get
            {
                return (System.String)this.CurrentRow["RELIGION"];
            }
            set
            {
                this.CurrentRow["RELIGION"] = value;
            }
        }

        /// <summary>
        /// WORKPHONE
        /// </summary>
        /// <remarks></remarks>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("WORKPHONE"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.String WORKPHONE
        {
            get
            {
                return (System.String)this.CurrentRow["WORKPHONE"];
            }
            set
            {
                this.CurrentRow["WORKPHONE"] = value;
            }
        }

        #endregion

        #region Field Property Events

        #endregion

        #region Nested Types & Field Security

        /// <summary>
        /// Contains all of the field names that belong to the business object.
        /// </summary>
        /// <remarks></remarks>
        public enum EntityFieldNames
        {
            MRN,
            FIRSTNAME,
            LASTNAME,
            MIDDLENAME,
            BIRTHDATE,
            GENDER,
            ETHNICITY,
            SSN,
            ADDR1,
            ADDR2,
            CITY,
            STATE,
            ZIP,
            HOMEPHONE,
            MOTHERMAIDENNAME,
            COUNTY,
            LANGUAGE,
            MARITALSTATUS,
            RELIGION,
            WORKPHONE,
            CUSTOM_FIELD
        }

        /// <summary>
        /// Gets the System.Type of the enumeration that contains the field names for the business object.
        /// </summary>
        /// <remarks></remarks>
        public override System.Type GetFieldEnumType()
        {
            return typeof(EntityFieldNames);
        }

        /// <summary>
        /// Creates a new CheckFieldSecurityEventArgs object that can be used with this business object type.
        /// </summary>
        /// <remarks></remarks>
        protected override CheckFieldSecurityEventArgsBase CreateNewFieldSecurityEventArgs(System.Enum Field, string CustomField, Permission Perm)
        {
            return new CheckFieldSecurityEventArgs<EntityFieldNames>(Field, CustomField, Perm);
        }

        /// <summary>
        /// Describes a method that will handle the CheckFieldScurity event.
        /// </summary>
        /// <remarks></remarks>
        public delegate void CheckFieldSecurityEventHandler(object sender, CheckFieldSecurityEventArgs<EntityFieldNames> e);

        /// <summary>
        /// Occurs when the business objects needs to check the security on a field.
        /// </summary>
        /// <remarks></remarks>
        public event CheckFieldSecurityEventHandler CheckFieldSecurity;

        /// <summary>
        /// Raises the CheckFieldSecurity event.
        /// </summary>
        /// <remarks></remarks>
        protected override void OnCheckFieldSecurity(CheckFieldSecurityEventArgsBase e)
        {
            if (this.CheckFieldSecurity != null)
            {
                this.CheckFieldSecurity(this, (CheckFieldSecurityEventArgs<EntityFieldNames>)e);
            }
        }

        #endregion

        #region Item Property Implementation


        private static List<string> _AllFieldsList;
        private static Dictionary<string, DbType> _FieldDbTypes;
        private static BusinessLayerFieldEnumDictionary _FieldEnums;
        private static Dictionary<string, int> _FieldLengths;
        private static Dictionary<string, int> _FieldNativeDbTypes;
        private static Dictionary<string, string> _FieldPermissionKeys;

        /// <summary>
        /// Initializes the static members of the Entity class.
        /// </summary>
        /// <remarks></remarks>
        static Entity()
        {
            //-- Create the new shared dictionary and populate it with an 
            //   instance of each property descriptor
            _PropertyDescriptors = new PropertyDescriptorDictionary(25);
            _PropertyDescriptors.Add("MRN", new Field_MRN_Descriptor());
            _PropertyDescriptors.Add("FIRSTNAME", new Field_FIRSTNAME_Descriptor());
            _PropertyDescriptors.Add("LASTNAME", new Field_LASTNAME_Descriptor());
            _PropertyDescriptors.Add("MIDDLENAME", new Field_MIDDLENAME_Descriptor());
            _PropertyDescriptors.Add("BIRTHDATE", new Field_BIRTHDATE_Descriptor());
            _PropertyDescriptors.Add("GENDER", new Field_GENDER_Descriptor());
            _PropertyDescriptors.Add("ETHNICITY", new Field_ETHNICITY_Descriptor());
            _PropertyDescriptors.Add("SSN", new Field_SSN_Descriptor());
            _PropertyDescriptors.Add("ADDR1", new Field_ADDR1_Descriptor());
            _PropertyDescriptors.Add("ADDR2", new Field_ADDR2_Descriptor());
            _PropertyDescriptors.Add("CITY", new Field_CITY_Descriptor());
            _PropertyDescriptors.Add("STATE", new Field_STATE_Descriptor());
            _PropertyDescriptors.Add("ZIP", new Field_ZIP_Descriptor());
            _PropertyDescriptors.Add("HOMEPHONE", new Field_HOMEPHONE_Descriptor());
            _PropertyDescriptors.Add("MOTHERMAIDENNAME", new Field_MOTHERMAIDENNAME_Descriptor());
            _PropertyDescriptors.Add("COUNTY", new Field_COUNTY_Descriptor());
            _PropertyDescriptors.Add("LANGUAGE", new Field_LANGUAGE_Descriptor());
            _PropertyDescriptors.Add("MARITALSTATUS", new Field_MARITALSTATUS_Descriptor());
            _PropertyDescriptors.Add("RELIGION", new Field_RELIGION_Descriptor());
            _PropertyDescriptors.Add("WORKPHONE", new Field_WORKPHONE_Descriptor());

            _AllFieldsList = new List<string>(20);
            _AllFieldsList.Add("MRN");
            _AllFieldsList.Add("FIRSTNAME");
            _AllFieldsList.Add("LASTNAME");
            _AllFieldsList.Add("MIDDLENAME");
            _AllFieldsList.Add("BIRTHDATE");
            _AllFieldsList.Add("GENDER");
            _AllFieldsList.Add("ETHNICITY");
            _AllFieldsList.Add("SSN");
            _AllFieldsList.Add("ADDR1");
            _AllFieldsList.Add("ADDR2");
            _AllFieldsList.Add("CITY");
            _AllFieldsList.Add("STATE");
            _AllFieldsList.Add("ZIP");
            _AllFieldsList.Add("HOMEPHONE");
            _AllFieldsList.Add("MOTHERMAIDENNAME");
            _AllFieldsList.Add("COUNTY");
            _AllFieldsList.Add("LANGUAGE");
            _AllFieldsList.Add("MARITALSTATUS");
            _AllFieldsList.Add("RELIGION");
            _AllFieldsList.Add("WORKPHONE");

            _FieldDbTypes = new Dictionary<string, DbType>(20);
            _FieldDbTypes.Add("MRN", DbType.AnsiString);
            _FieldDbTypes.Add("FIRSTNAME", DbType.AnsiString);
            _FieldDbTypes.Add("LASTNAME", DbType.AnsiString);
            _FieldDbTypes.Add("MIDDLENAME", DbType.AnsiString);
            _FieldDbTypes.Add("BIRTHDATE", DbType.DateTime);
            _FieldDbTypes.Add("GENDER", DbType.AnsiString);
            _FieldDbTypes.Add("ETHNICITY", DbType.AnsiString);
            _FieldDbTypes.Add("SSN", DbType.AnsiString);
            _FieldDbTypes.Add("ADDR1", DbType.AnsiString);
            _FieldDbTypes.Add("ADDR2", DbType.AnsiString);
            _FieldDbTypes.Add("CITY", DbType.AnsiString);
            _FieldDbTypes.Add("STATE", DbType.AnsiString);
            _FieldDbTypes.Add("ZIP", DbType.AnsiString);
            _FieldDbTypes.Add("HOMEPHONE", DbType.AnsiString);
            _FieldDbTypes.Add("MOTHERMAIDENNAME", DbType.AnsiString);
            _FieldDbTypes.Add("COUNTY", DbType.AnsiString);
            _FieldDbTypes.Add("LANGUAGE", DbType.AnsiString);
            _FieldDbTypes.Add("MARITALSTATUS", DbType.AnsiString);
            _FieldDbTypes.Add("RELIGION", DbType.AnsiString);
            _FieldDbTypes.Add("WORKPHONE", DbType.AnsiString);

            _FieldEnums = new BusinessLayerFieldEnumDictionary(21);
            _FieldEnums.Add("MRN", EntityFieldNames.MRN);
            _FieldEnums.Add("FIRSTNAME", EntityFieldNames.FIRSTNAME);
            _FieldEnums.Add("LASTNAME", EntityFieldNames.LASTNAME);
            _FieldEnums.Add("MIDDLENAME", EntityFieldNames.MIDDLENAME);
            _FieldEnums.Add("BIRTHDATE", EntityFieldNames.BIRTHDATE);
            _FieldEnums.Add("GENDER", EntityFieldNames.GENDER);
            _FieldEnums.Add("ETHNICITY", EntityFieldNames.ETHNICITY);
            _FieldEnums.Add("SSN", EntityFieldNames.SSN);
            _FieldEnums.Add("ADDR1", EntityFieldNames.ADDR1);
            _FieldEnums.Add("ADDR2", EntityFieldNames.ADDR2);
            _FieldEnums.Add("CITY", EntityFieldNames.CITY);
            _FieldEnums.Add("STATE", EntityFieldNames.STATE);
            _FieldEnums.Add("ZIP", EntityFieldNames.ZIP);
            _FieldEnums.Add("HOMEPHONE", EntityFieldNames.HOMEPHONE);
            _FieldEnums.Add("MOTHERMAIDENNAME", EntityFieldNames.MOTHERMAIDENNAME);
            _FieldEnums.Add("COUNTY", EntityFieldNames.COUNTY);
            _FieldEnums.Add("LANGUAGE", EntityFieldNames.LANGUAGE);
            _FieldEnums.Add("MARITALSTATUS", EntityFieldNames.MARITALSTATUS);
            _FieldEnums.Add("RELIGION", EntityFieldNames.RELIGION);
            _FieldEnums.Add("WORKPHONE", EntityFieldNames.WORKPHONE);
            _FieldEnums.Add("CUSTOM_FIELD", EntityFieldNames.CUSTOM_FIELD);

            _FieldLengths = new Dictionary<string, int>(20);
            _FieldLengths.Add("MRN", 36);
            _FieldLengths.Add("FIRSTNAME", 50);
            _FieldLengths.Add("LASTNAME", 50);
            _FieldLengths.Add("MIDDLENAME", 50);
            _FieldLengths.Add("BIRTHDATE", 0);
            _FieldLengths.Add("GENDER", 1);
            _FieldLengths.Add("ETHNICITY", 18);
            _FieldLengths.Add("SSN", 50);
            _FieldLengths.Add("ADDR1", 60);
            _FieldLengths.Add("ADDR2", 60);
            _FieldLengths.Add("CITY", 30);
            _FieldLengths.Add("STATE", 2);
            _FieldLengths.Add("ZIP", 10);
            _FieldLengths.Add("HOMEPHONE", 50);
            _FieldLengths.Add("MOTHERMAIDENNAME", 50);
            _FieldLengths.Add("COUNTY", 5);
            _FieldLengths.Add("LANGUAGE", 25);
            _FieldLengths.Add("MARITALSTATUS", 1);
            _FieldLengths.Add("RELIGION", 3);
            _FieldLengths.Add("WORKPHONE", 50);

            _FieldNativeDbTypes = new Dictionary<string, int>(20);
            _FieldNativeDbTypes.Add("MRN", (int)System.Data.SqlDbType.VarChar);
            _FieldNativeDbTypes.Add("FIRSTNAME", (int)System.Data.SqlDbType.VarChar);
            _FieldNativeDbTypes.Add("LASTNAME", (int)System.Data.SqlDbType.VarChar);
            _FieldNativeDbTypes.Add("MIDDLENAME", (int)System.Data.SqlDbType.VarChar);
            _FieldNativeDbTypes.Add("BIRTHDATE", (int)System.Data.SqlDbType.DateTime);
            _FieldNativeDbTypes.Add("GENDER", (int)System.Data.SqlDbType.VarChar);
            _FieldNativeDbTypes.Add("ETHNICITY", (int)System.Data.SqlDbType.VarChar);
            _FieldNativeDbTypes.Add("SSN", (int)System.Data.SqlDbType.VarChar);
            _FieldNativeDbTypes.Add("ADDR1", (int)System.Data.SqlDbType.VarChar);
            _FieldNativeDbTypes.Add("ADDR2", (int)System.Data.SqlDbType.VarChar);
            _FieldNativeDbTypes.Add("CITY", (int)System.Data.SqlDbType.VarChar);
            _FieldNativeDbTypes.Add("STATE", (int)System.Data.SqlDbType.VarChar);
            _FieldNativeDbTypes.Add("ZIP", (int)System.Data.SqlDbType.VarChar);
            _FieldNativeDbTypes.Add("HOMEPHONE", (int)System.Data.SqlDbType.VarChar);
            _FieldNativeDbTypes.Add("MOTHERMAIDENNAME", (int)System.Data.SqlDbType.VarChar);
            _FieldNativeDbTypes.Add("COUNTY", (int)System.Data.SqlDbType.VarChar);
            _FieldNativeDbTypes.Add("LANGUAGE", (int)System.Data.SqlDbType.VarChar);
            _FieldNativeDbTypes.Add("MARITALSTATUS", (int)System.Data.SqlDbType.VarChar);
            _FieldNativeDbTypes.Add("RELIGION", (int)System.Data.SqlDbType.VarChar);
            _FieldNativeDbTypes.Add("WORKPHONE", (int)System.Data.SqlDbType.VarChar);

            _FieldPermissionKeys = new Dictionary<string, string>(20);
            _FieldPermissionKeys.Add("MRN", string.Empty);
            _FieldPermissionKeys.Add("FIRSTNAME", string.Empty);
            _FieldPermissionKeys.Add("LASTNAME", string.Empty);
            _FieldPermissionKeys.Add("MIDDLENAME", string.Empty);
            _FieldPermissionKeys.Add("BIRTHDATE", string.Empty);
            _FieldPermissionKeys.Add("GENDER", string.Empty);
            _FieldPermissionKeys.Add("ETHNICITY", string.Empty);
            _FieldPermissionKeys.Add("SSN", string.Empty);
            _FieldPermissionKeys.Add("ADDR1", string.Empty);
            _FieldPermissionKeys.Add("ADDR2", string.Empty);
            _FieldPermissionKeys.Add("CITY", string.Empty);
            _FieldPermissionKeys.Add("STATE", string.Empty);
            _FieldPermissionKeys.Add("ZIP", string.Empty);
            _FieldPermissionKeys.Add("HOMEPHONE", string.Empty);
            _FieldPermissionKeys.Add("MOTHERMAIDENNAME", string.Empty);
            _FieldPermissionKeys.Add("COUNTY", string.Empty);
            _FieldPermissionKeys.Add("LANGUAGE", string.Empty);
            _FieldPermissionKeys.Add("MARITALSTATUS", string.Empty);
            _FieldPermissionKeys.Add("RELIGION", string.Empty);
            _FieldPermissionKeys.Add("WORKPHONE", string.Empty);

        }

        private static bool _AreCustomDescriptorsEvaluated = false;
        protected override bool AreCustomDescriptorsEvaluated
        {
            get
            {
                bool llReturn = _AreCustomDescriptorsEvaluated;
                _AreCustomDescriptorsEvaluated = true;
                return llReturn;
            }
        }

        private static PropertyDescriptorDictionary _PropertyDescriptors;
        protected override PropertyDescriptorDictionary PropertyDescriptors
        {
            get
            {
                return _PropertyDescriptors;
            }
        }

        /// <summary>
        /// A private field used to store the System.Type of this business object for use by the FieldPropertyDescriptor classes.
        /// </summary>
        /// <remarks></remarks>

        private static System.Type _ComponentType = typeof(Entity);

        /// <summary>
        /// A PropertyDescriptor class used to Get and Set the value of the MRN property.
        /// </summary>
        /// <remarks></remarks>
        private class Field_MRN_Descriptor : MicroFour.StrataFrame.Business.FieldPropertyDescriptor
        {
            public Field_MRN_Descriptor() : base("MRN") { }
            private System.Type _PropertyType = typeof(System.String);
            public override object GetValue(Object component)
            {
                return ((Entity)component).MRN;
            }
            public override void SetValue(Object component, object Value)
            {
                ((Entity)component).MRN = (System.String)Value;
            }
            public override System.Type PropertyType
            {
                get
                {
                    return this._PropertyType;
                }
            }
            public override System.Type ComponentType
            {
                get
                {
                    return _ComponentType;
                }
            }
        }

        /// <summary>
        /// A PropertyDescriptor class used to Get and Set the value of the FIRSTNAME property.
        /// </summary>
        /// <remarks></remarks>
        private class Field_FIRSTNAME_Descriptor : MicroFour.StrataFrame.Business.FieldPropertyDescriptor
        {
            public Field_FIRSTNAME_Descriptor() : base("FIRSTNAME") { }
            private System.Type _PropertyType = typeof(System.String);
            public override object GetValue(Object component)
            {
                return ((Entity)component).FIRSTNAME;
            }
            public override void SetValue(Object component, object Value)
            {
                ((Entity)component).FIRSTNAME = (System.String)Value;
            }
            public override System.Type PropertyType
            {
                get
                {
                    return this._PropertyType;
                }
            }
            public override System.Type ComponentType
            {
                get
                {
                    return _ComponentType;
                }
            }
        }

        /// <summary>
        /// A PropertyDescriptor class used to Get and Set the value of the LASTNAME property.
        /// </summary>
        /// <remarks></remarks>
        private class Field_LASTNAME_Descriptor : MicroFour.StrataFrame.Business.FieldPropertyDescriptor
        {
            public Field_LASTNAME_Descriptor() : base("LASTNAME") { }
            private System.Type _PropertyType = typeof(System.String);
            public override object GetValue(Object component)
            {
                return ((Entity)component).LASTNAME;
            }
            public override void SetValue(Object component, object Value)
            {
                ((Entity)component).LASTNAME = (System.String)Value;
            }
            public override System.Type PropertyType
            {
                get
                {
                    return this._PropertyType;
                }
            }
            public override System.Type ComponentType
            {
                get
                {
                    return _ComponentType;
                }
            }
        }

        /// <summary>
        /// A PropertyDescriptor class used to Get and Set the value of the MIDDLENAME property.
        /// </summary>
        /// <remarks></remarks>
        private class Field_MIDDLENAME_Descriptor : MicroFour.StrataFrame.Business.FieldPropertyDescriptor
        {
            public Field_MIDDLENAME_Descriptor() : base("MIDDLENAME") { }
            private System.Type _PropertyType = typeof(System.String);
            public override object GetValue(Object component)
            {
                return ((Entity)component).MIDDLENAME;
            }
            public override void SetValue(Object component, object Value)
            {
                ((Entity)component).MIDDLENAME = (System.String)Value;
            }
            public override System.Type PropertyType
            {
                get
                {
                    return this._PropertyType;
                }
            }
            public override System.Type ComponentType
            {
                get
                {
                    return _ComponentType;
                }
            }
        }

        /// <summary>
        /// A PropertyDescriptor class used to Get and Set the value of the BIRTHDATE property.
        /// </summary>
        /// <remarks></remarks>
        private class Field_BIRTHDATE_Descriptor : MicroFour.StrataFrame.Business.FieldPropertyDescriptor
        {
            public Field_BIRTHDATE_Descriptor() : base("BIRTHDATE") { }
            private System.Type _PropertyType = typeof(System.DateTime);
            public override object GetValue(Object component)
            {
                return ((Entity)component).BIRTHDATE;
            }
            public override void SetValue(Object component, object Value)
            {
                ((Entity)component).BIRTHDATE = (System.DateTime)Value;
            }
            public override System.Type PropertyType
            {
                get
                {
                    return this._PropertyType;
                }
            }
            public override System.Type ComponentType
            {
                get
                {
                    return _ComponentType;
                }
            }
        }

        /// <summary>
        /// A PropertyDescriptor class used to Get and Set the value of the GENDER property.
        /// </summary>
        /// <remarks></remarks>
        private class Field_GENDER_Descriptor : MicroFour.StrataFrame.Business.FieldPropertyDescriptor
        {
            public Field_GENDER_Descriptor() : base("GENDER") { }
            private System.Type _PropertyType = typeof(System.String);
            public override object GetValue(Object component)
            {
                return ((Entity)component).GENDER;
            }
            public override void SetValue(Object component, object Value)
            {
                ((Entity)component).GENDER = (System.String)Value;
            }
            public override System.Type PropertyType
            {
                get
                {
                    return this._PropertyType;
                }
            }
            public override System.Type ComponentType
            {
                get
                {
                    return _ComponentType;
                }
            }
        }

        /// <summary>
        /// A PropertyDescriptor class used to Get and Set the value of the ETHNICITY property.
        /// </summary>
        /// <remarks></remarks>
        private class Field_ETHNICITY_Descriptor : MicroFour.StrataFrame.Business.FieldPropertyDescriptor
        {
            public Field_ETHNICITY_Descriptor() : base("ETHNICITY") { }
            private System.Type _PropertyType = typeof(System.String);
            public override object GetValue(Object component)
            {
                return ((Entity)component).ETHNICITY;
            }
            public override void SetValue(Object component, object Value)
            {
                ((Entity)component).ETHNICITY = (System.String)Value;
            }
            public override System.Type PropertyType
            {
                get
                {
                    return this._PropertyType;
                }
            }
            public override System.Type ComponentType
            {
                get
                {
                    return _ComponentType;
                }
            }
        }

        /// <summary>
        /// A PropertyDescriptor class used to Get and Set the value of the SSN property.
        /// </summary>
        /// <remarks></remarks>
        private class Field_SSN_Descriptor : MicroFour.StrataFrame.Business.FieldPropertyDescriptor
        {
            public Field_SSN_Descriptor() : base("SSN") { }
            private System.Type _PropertyType = typeof(System.String);
            public override object GetValue(Object component)
            {
                return ((Entity)component).SSN;
            }
            public override void SetValue(Object component, object Value)
            {
                ((Entity)component).SSN = (System.String)Value;
            }
            public override System.Type PropertyType
            {
                get
                {
                    return this._PropertyType;
                }
            }
            public override System.Type ComponentType
            {
                get
                {
                    return _ComponentType;
                }
            }
        }

        /// <summary>
        /// A PropertyDescriptor class used to Get and Set the value of the ADDR1 property.
        /// </summary>
        /// <remarks></remarks>
        private class Field_ADDR1_Descriptor : MicroFour.StrataFrame.Business.FieldPropertyDescriptor
        {
            public Field_ADDR1_Descriptor() : base("ADDR1") { }
            private System.Type _PropertyType = typeof(System.String);
            public override object GetValue(Object component)
            {
                return ((Entity)component).ADDR1;
            }
            public override void SetValue(Object component, object Value)
            {
                ((Entity)component).ADDR1 = (System.String)Value;
            }
            public override System.Type PropertyType
            {
                get
                {
                    return this._PropertyType;
                }
            }
            public override System.Type ComponentType
            {
                get
                {
                    return _ComponentType;
                }
            }
        }

        /// <summary>
        /// A PropertyDescriptor class used to Get and Set the value of the ADDR2 property.
        /// </summary>
        /// <remarks></remarks>
        private class Field_ADDR2_Descriptor : MicroFour.StrataFrame.Business.FieldPropertyDescriptor
        {
            public Field_ADDR2_Descriptor() : base("ADDR2") { }
            private System.Type _PropertyType = typeof(System.String);
            public override object GetValue(Object component)
            {
                return ((Entity)component).ADDR2;
            }
            public override void SetValue(Object component, object Value)
            {
                ((Entity)component).ADDR2 = (System.String)Value;
            }
            public override System.Type PropertyType
            {
                get
                {
                    return this._PropertyType;
                }
            }
            public override System.Type ComponentType
            {
                get
                {
                    return _ComponentType;
                }
            }
        }

        /// <summary>
        /// A PropertyDescriptor class used to Get and Set the value of the CITY property.
        /// </summary>
        /// <remarks></remarks>
        private class Field_CITY_Descriptor : MicroFour.StrataFrame.Business.FieldPropertyDescriptor
        {
            public Field_CITY_Descriptor() : base("CITY") { }
            private System.Type _PropertyType = typeof(System.String);
            public override object GetValue(Object component)
            {
                return ((Entity)component).CITY;
            }
            public override void SetValue(Object component, object Value)
            {
                ((Entity)component).CITY = (System.String)Value;
            }
            public override System.Type PropertyType
            {
                get
                {
                    return this._PropertyType;
                }
            }
            public override System.Type ComponentType
            {
                get
                {
                    return _ComponentType;
                }
            }
        }

        /// <summary>
        /// A PropertyDescriptor class used to Get and Set the value of the STATE property.
        /// </summary>
        /// <remarks></remarks>
        private class Field_STATE_Descriptor : MicroFour.StrataFrame.Business.FieldPropertyDescriptor
        {
            public Field_STATE_Descriptor() : base("STATE") { }
            private System.Type _PropertyType = typeof(System.String);
            public override object GetValue(Object component)
            {
                return ((Entity)component).STATE;
            }
            public override void SetValue(Object component, object Value)
            {
                ((Entity)component).STATE = (System.String)Value;
            }
            public override System.Type PropertyType
            {
                get
                {
                    return this._PropertyType;
                }
            }
            public override System.Type ComponentType
            {
                get
                {
                    return _ComponentType;
                }
            }
        }

        /// <summary>
        /// A PropertyDescriptor class used to Get and Set the value of the ZIP property.
        /// </summary>
        /// <remarks></remarks>
        private class Field_ZIP_Descriptor : MicroFour.StrataFrame.Business.FieldPropertyDescriptor
        {
            public Field_ZIP_Descriptor() : base("ZIP") { }
            private System.Type _PropertyType = typeof(System.String);
            public override object GetValue(Object component)
            {
                return ((Entity)component).ZIP;
            }
            public override void SetValue(Object component, object Value)
            {
                ((Entity)component).ZIP = (System.String)Value;
            }
            public override System.Type PropertyType
            {
                get
                {
                    return this._PropertyType;
                }
            }
            public override System.Type ComponentType
            {
                get
                {
                    return _ComponentType;
                }
            }
        }

        /// <summary>
        /// A PropertyDescriptor class used to Get and Set the value of the HOMEPHONE property.
        /// </summary>
        /// <remarks></remarks>
        private class Field_HOMEPHONE_Descriptor : MicroFour.StrataFrame.Business.FieldPropertyDescriptor
        {
            public Field_HOMEPHONE_Descriptor() : base("HOMEPHONE") { }
            private System.Type _PropertyType = typeof(System.String);
            public override object GetValue(Object component)
            {
                return ((Entity)component).HOMEPHONE;
            }
            public override void SetValue(Object component, object Value)
            {
                ((Entity)component).HOMEPHONE = (System.String)Value;
            }
            public override System.Type PropertyType
            {
                get
                {
                    return this._PropertyType;
                }
            }
            public override System.Type ComponentType
            {
                get
                {
                    return _ComponentType;
                }
            }
        }

        /// <summary>
        /// A PropertyDescriptor class used to Get and Set the value of the MOTHERMAIDENNAME property.
        /// </summary>
        /// <remarks></remarks>
        private class Field_MOTHERMAIDENNAME_Descriptor : MicroFour.StrataFrame.Business.FieldPropertyDescriptor
        {
            public Field_MOTHERMAIDENNAME_Descriptor() : base("MOTHERMAIDENNAME") { }
            private System.Type _PropertyType = typeof(System.String);
            public override object GetValue(Object component)
            {
                return ((Entity)component).MOTHERMAIDENNAME;
            }
            public override void SetValue(Object component, object Value)
            {
                ((Entity)component).MOTHERMAIDENNAME = (System.String)Value;
            }
            public override System.Type PropertyType
            {
                get
                {
                    return this._PropertyType;
                }
            }
            public override System.Type ComponentType
            {
                get
                {
                    return _ComponentType;
                }
            }
        }

        /// <summary>
        /// A PropertyDescriptor class used to Get and Set the value of the COUNTY property.
        /// </summary>
        /// <remarks></remarks>
        private class Field_COUNTY_Descriptor : MicroFour.StrataFrame.Business.FieldPropertyDescriptor
        {
            public Field_COUNTY_Descriptor() : base("COUNTY") { }
            private System.Type _PropertyType = typeof(System.String);
            public override object GetValue(Object component)
            {
                return ((Entity)component).COUNTY;
            }
            public override void SetValue(Object component, object Value)
            {
                ((Entity)component).COUNTY = (System.String)Value;
            }
            public override System.Type PropertyType
            {
                get
                {
                    return this._PropertyType;
                }
            }
            public override System.Type ComponentType
            {
                get
                {
                    return _ComponentType;
                }
            }
        }

        /// <summary>
        /// A PropertyDescriptor class used to Get and Set the value of the LANGUAGE property.
        /// </summary>
        /// <remarks></remarks>
        private class Field_LANGUAGE_Descriptor : MicroFour.StrataFrame.Business.FieldPropertyDescriptor
        {
            public Field_LANGUAGE_Descriptor() : base("LANGUAGE") { }
            private System.Type _PropertyType = typeof(System.String);
            public override object GetValue(Object component)
            {
                return ((Entity)component).LANGUAGE;
            }
            public override void SetValue(Object component, object Value)
            {
                ((Entity)component).LANGUAGE = (System.String)Value;
            }
            public override System.Type PropertyType
            {
                get
                {
                    return this._PropertyType;
                }
            }
            public override System.Type ComponentType
            {
                get
                {
                    return _ComponentType;
                }
            }
        }

        /// <summary>
        /// A PropertyDescriptor class used to Get and Set the value of the MARITALSTATUS property.
        /// </summary>
        /// <remarks></remarks>
        private class Field_MARITALSTATUS_Descriptor : MicroFour.StrataFrame.Business.FieldPropertyDescriptor
        {
            public Field_MARITALSTATUS_Descriptor() : base("MARITALSTATUS") { }
            private System.Type _PropertyType = typeof(System.String);
            public override object GetValue(Object component)
            {
                return ((Entity)component).MARITALSTATUS;
            }
            public override void SetValue(Object component, object Value)
            {
                ((Entity)component).MARITALSTATUS = (System.String)Value;
            }
            public override System.Type PropertyType
            {
                get
                {
                    return this._PropertyType;
                }
            }
            public override System.Type ComponentType
            {
                get
                {
                    return _ComponentType;
                }
            }
        }

        /// <summary>
        /// A PropertyDescriptor class used to Get and Set the value of the RELIGION property.
        /// </summary>
        /// <remarks></remarks>
        private class Field_RELIGION_Descriptor : MicroFour.StrataFrame.Business.FieldPropertyDescriptor
        {
            public Field_RELIGION_Descriptor() : base("RELIGION") { }
            private System.Type _PropertyType = typeof(System.String);
            public override object GetValue(Object component)
            {
                return ((Entity)component).RELIGION;
            }
            public override void SetValue(Object component, object Value)
            {
                ((Entity)component).RELIGION = (System.String)Value;
            }
            public override System.Type PropertyType
            {
                get
                {
                    return this._PropertyType;
                }
            }
            public override System.Type ComponentType
            {
                get
                {
                    return _ComponentType;
                }
            }
        }

        /// <summary>
        /// A PropertyDescriptor class used to Get and Set the value of the WORKPHONE property.
        /// </summary>
        /// <remarks></remarks>
        private class Field_WORKPHONE_Descriptor : MicroFour.StrataFrame.Business.FieldPropertyDescriptor
        {
            public Field_WORKPHONE_Descriptor() : base("WORKPHONE") { }
            private System.Type _PropertyType = typeof(System.String);
            public override object GetValue(Object component)
            {
                return ((Entity)component).WORKPHONE;
            }
            public override void SetValue(Object component, object Value)
            {
                ((Entity)component).WORKPHONE = (System.String)Value;
            }
            public override System.Type PropertyType
            {
                get
                {
                    return this._PropertyType;
                }
            }
            public override System.Type ComponentType
            {
                get
                {
                    return _ComponentType;
                }
            }
        }

        #endregion

    }

}
