using MicroFour.StrataFrame.Business;
using MicroFour.StrataFrame.Security;
using MicroFour.StrataFrame.UI.Windows.Forms;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.IO;

namespace DM.Library
{
    public partial class Users : MicroFour.StrataFrame.Business.BusinessLayer
    {

        #region Component Implementation

        /// <summary>
        /// Required designer variable.
        /// </summary>
        private System.ComponentModel.IContainer components = null;

        /// <summary> 
        /// Clean up any resources being used.
        /// </summary>
        /// <param name="disposing">true if managed resources should be disposed; otherwise, false.</param>
        protected override void Dispose(bool disposing)
        {
            if (disposing && (components != null))
            {
                components.Dispose();
            }
            base.Dispose(disposing);
        }

        /// <summary>
        /// Required method for Designer support - do not modify
        /// the contents of this method with the code editor.
        /// </summary>
        private void InitializeComponent()
        {
            components = new System.ComponentModel.Container();

            this.CheckRulesOnCurrentRow += new CheckRulesOnCurrentRowEventHandler(Users_CheckRulesOnCurrentRow);
            this.SetDefaultValues += new SetDefaultValuesEventHandler(Users_SetDefaultValues);
        }

        #endregion


        #region BusinessLayer Overriden Methods & Properties

        /// <summary>
        /// The collection of required fields for the business object.
        /// </summary>
        /// <remarks></remarks>
        [Browsable(false), DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public override RequiredFieldsCollection RequiredFields
        {
            get
            {
                return base.RequiredFields;
            }
            set
            {
                base.RequiredFields = value;
            }
        }

        /// <summary>
        /// Defines the constraint that defines the parent-child relationship between this business object type and another business object type.
        /// </summary>
        /// <remarks></remarks>
        [Browsable(false), DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public override IBusinessParentRelationship ParentRelationship
        {
            get
            {
                return base.ParentRelationship;
            }
            set
            {
                base.ParentRelationship = value;
            }
        }

        /// <summary>
        /// Returns all of the field names in a single string in the form of [field1],[field2],...  This must be used in the place of '*' in select statements if Query Notifications are to be registered.
        /// </summary>
        /// <remarks></remarks>
        protected override String AllFieldNames
        {
            get
            {
                return "[LogonName],[FullName],[Permission]";
            }
        }

        /// <summary>
        /// The name of the database that contains the table to which this business object is mapped.
        /// </summary>
        /// <remarks></remarks>
        public override String Database
        {
            get
            {
                return "CRM";
            }
        }

        private static string[] _PrimaryKeyFields = new string[] { "LogonName" };
        /// <summary>
        /// Gets the field or fields that comprise the primary key for the business object.
        /// </summary>
        /// <remarks></remarks>
        public override string[] PrimaryKeyFields
        {
            get
            {
                return _PrimaryKeyFields;
            }
        }

        /// <summary>
        /// The name of the table in the database to which this business object is mapped.
        /// </summary>
        /// <remarks></remarks>
        public override String TableName
        {
            get
            {
                return "Users";
            }
        }

        /// <summary>
        /// The schema of the table in the database to which this business object is mapped.
        /// </summary>
        /// <remarks></remarks>
        public override String TableSchema
        {
            get
            {
                return "dbo";
            }
        }

        /// <summary>
        /// Creates and returns an array of DataColumns that contains the schema for the table.  This is used to prevent a round trip to the server to aquire the initial schema for the internal DataTable.
        /// </summary>
        /// <remarks></remarks>
        protected override DataColumn[] CreateTableSchema()
        {
            return new DataColumn[] {
new DataColumn("LogonName", typeof(System.String)),
new DataColumn("FullName", typeof(System.String)),
new DataColumn("Permission", typeof(System.String))};
        }

        /// <summary>
        /// Adds a broken rule to the business object's collection
        /// </summary>
        /// <remarks></remarks>
        protected void AddBrokenRule(UsersFieldNames Field, string ErrorMessage)
        {
            base.AddBrokenRule(Field, ErrorMessage);
        }

        /// <summary>
        /// Adds a broken rule to the business object's collection
        /// </summary>
        /// <remarks></remarks>
        protected new void AddBrokenRule(string FieldName, string ErrorMessage)
        {
            base.AddBrokenRule(FieldName, ErrorMessage);
        }

        /// <summary>
        /// Adds a broken rules to the business object's collection using the given message key to pull the error message from the localization database
        /// </summary>
        /// <remarks></remarks>
        protected void AddBrokenRuleByKey(UsersFieldNames Field, string ErrorMessageKey)
        {
            base.AddBrokenRuleByKey(Field, ErrorMessageKey);
        }

        /// <summary>
        /// Adds a broken rules to the business object's collection using the given message key to pull the error message from the localization database
        /// </summary>
        /// <remarks></remarks>
        protected new void AddBrokenRuleByKey(string FieldName, string ErrorMessageKey)
        {
            base.AddBrokenRuleByKey(FieldName, ErrorMessageKey);
        }

        /// <summary>
        /// Gets a collection of the names for all fields that belong to this business object and map to the database.
        /// </summary>
        /// <remarks></remarks>
        public override List<string> AllFieldsList
        {
            get
            {
                return _AllFieldsList;
            }
        }

        /// <summary>
        /// Gets a dictionary of the DbTypes for all fields that belong to this business object and map to the database.
        /// </summary>
        /// <remarks></remarks>
        public override Dictionary<string, DbType> FieldDbTypes
        {
            get
            {
                return _FieldDbTypes;
            }
        }

        /// <summary>
        /// Gets a dictionary of all fields within this business object that map to the FieldNames enumeration for this business object.
        /// </summary>
        /// <remarks></remarks>
        public override BusinessLayerFieldEnumDictionary FieldEnums
        {
            get
            {
                return _FieldEnums;
            }
        }

        /// <summary>
        /// Gets a dictionary of all of the lengths for all fields within this business object that map to a field in the database.
        /// </summary>
        /// <remarks></remarks>
        public override Dictionary<string, int> FieldLengths
        {
            get
            {
                return _FieldLengths;
            }
        }

        /// <summary>
        /// Gets a dictionary of the native DbType (SqlDbType, OracleType, OleDbType, etc.) for all fields within this buisness object that map to a field in the database.
        /// </summary>
        /// <remarks></remarks>
        public override Dictionary<string, int> FieldNativeDbTypes
        {
            get
            {
                return _FieldNativeDbTypes;
            }
        }

        /// <summary>
        /// Gets a dictionary of the security permission keys for each field in the business object.
        /// </summary>
        /// <remarks></remarks>
        public override Dictionary<string, string> FieldPermissionKeys
        {
            get
            {
                return _FieldPermissionKeys;
            }
        }

        #endregion

        #region Field Properties

        /// <summary>
        /// LogonName
        /// </summary>
        /// <remarks></remarks>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("LogonName"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.String LogonName
        {
            get
            {
                return (System.String)this.CurrentRow["LogonName"];
            }
            set
            {
                this.CurrentRow["LogonName"] = value;
            }
        }

        /// <summary>
        /// FullName
        /// </summary>
        /// <remarks></remarks>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("FullName"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.String FullName
        {
            get
            {
                return (System.String)this.CurrentRow["FullName"];
            }
            set
            {
                this.CurrentRow["FullName"] = value;
            }
        }

        /// <summary>
        /// Permission
        /// </summary>
        /// <remarks></remarks>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("Permission"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.String Permission
        {
            get
            {
                return (System.String)this.CurrentRow["Permission"];
            }
            set
            {
                this.CurrentRow["Permission"] = value;
            }
        }

        #endregion

        #region Field Property Events

        #endregion

        #region Nested Types & Field Security

        /// <summary>
        /// Contains all of the field names that belong to the business object.
        /// </summary>
        /// <remarks></remarks>
        public enum UsersFieldNames
        {
            LogonName,
            FullName,
            Permission,
            CUSTOM_FIELD
        }

        /// <summary>
        /// Gets the System.Type of the enumeration that contains the field names for the business object.
        /// </summary>
        /// <remarks></remarks>
        public override System.Type GetFieldEnumType()
        {
            return typeof(UsersFieldNames);
        }

        /// <summary>
        /// Creates a new CheckFieldSecurityEventArgs object that can be used with this business object type.
        /// </summary>
        /// <remarks></remarks>
        protected override CheckFieldSecurityEventArgsBase CreateNewFieldSecurityEventArgs(System.Enum Field, string CustomField, Permission Perm)
        {
            return new CheckFieldSecurityEventArgs<UsersFieldNames>(Field, CustomField, Perm);
        }

        /// <summary>
        /// Describes a method that will handle the CheckFieldScurity event.
        /// </summary>
        /// <remarks></remarks>
        public delegate void CheckFieldSecurityEventHandler(object sender, CheckFieldSecurityEventArgs<UsersFieldNames> e);

        /// <summary>
        /// Occurs when the business objects needs to check the security on a field.
        /// </summary>
        /// <remarks></remarks>
        public event CheckFieldSecurityEventHandler CheckFieldSecurity;

        /// <summary>
        /// Raises the CheckFieldSecurity event.
        /// </summary>
        /// <remarks></remarks>
        protected override void OnCheckFieldSecurity(CheckFieldSecurityEventArgsBase e)
        {
            if (this.CheckFieldSecurity != null)
            {
                this.CheckFieldSecurity(this, (CheckFieldSecurityEventArgs<UsersFieldNames>)e);
            }
        }

        #endregion

        #region Item Property Implementation


        private static List<string> _AllFieldsList;
        private static Dictionary<string, DbType> _FieldDbTypes;
        private static BusinessLayerFieldEnumDictionary _FieldEnums;
        private static Dictionary<string, int> _FieldLengths;
        private static Dictionary<string, int> _FieldNativeDbTypes;
        private static Dictionary<string, string> _FieldPermissionKeys;

        /// <summary>
        /// Initializes the static members of the Users class.
        /// </summary>
        /// <remarks></remarks>
        static Users()
        {
            //-- Create the new shared dictionary and populate it with an 
            //   instance of each property descriptor
            _PropertyDescriptors = new PropertyDescriptorDictionary(8);
            _PropertyDescriptors.Add("LogonName", new Field_LogonName_Descriptor());
            _PropertyDescriptors.Add("FullName", new Field_FullName_Descriptor());
            _PropertyDescriptors.Add("Permission", new Field_Permission_Descriptor());

            _AllFieldsList = new List<string>(3);
            _AllFieldsList.Add("LogonName");
            _AllFieldsList.Add("FullName");
            _AllFieldsList.Add("Permission");

            _FieldDbTypes = new Dictionary<string, DbType>(3);
            _FieldDbTypes.Add("LogonName", DbType.AnsiString);
            _FieldDbTypes.Add("FullName", DbType.AnsiString);
            _FieldDbTypes.Add("Permission", DbType.AnsiString);

            _FieldEnums = new BusinessLayerFieldEnumDictionary(4);
            _FieldEnums.Add("LogonName", UsersFieldNames.LogonName);
            _FieldEnums.Add("FullName", UsersFieldNames.FullName);
            _FieldEnums.Add("Permission", UsersFieldNames.Permission);
            _FieldEnums.Add("CUSTOM_FIELD", UsersFieldNames.CUSTOM_FIELD);

            _FieldLengths = new Dictionary<string, int>(3);
            _FieldLengths.Add("LogonName", 50);
            _FieldLengths.Add("FullName", 50);
            _FieldLengths.Add("Permission", 10);

            _FieldNativeDbTypes = new Dictionary<string, int>(3);
            _FieldNativeDbTypes.Add("LogonName", (int)System.Data.SqlDbType.VarChar);
            _FieldNativeDbTypes.Add("FullName", (int)System.Data.SqlDbType.VarChar);
            _FieldNativeDbTypes.Add("Permission", (int)System.Data.SqlDbType.VarChar);

            _FieldPermissionKeys = new Dictionary<string, string>(3);
            _FieldPermissionKeys.Add("LogonName", string.Empty);
            _FieldPermissionKeys.Add("FullName", string.Empty);
            _FieldPermissionKeys.Add("Permission", string.Empty);

        }

        private static bool _AreCustomDescriptorsEvaluated = false;
        protected override bool AreCustomDescriptorsEvaluated
        {
            get
            {
                bool llReturn = _AreCustomDescriptorsEvaluated;
                _AreCustomDescriptorsEvaluated = true;
                return llReturn;
            }
        }

        private static PropertyDescriptorDictionary _PropertyDescriptors;
        protected override PropertyDescriptorDictionary PropertyDescriptors
        {
            get
            {
                return _PropertyDescriptors;
            }
        }

        /// <summary>
        /// A private field used to store the System.Type of this business object for use by the FieldPropertyDescriptor classes.
        /// </summary>
        /// <remarks></remarks>

        private static System.Type _ComponentType = typeof(Users);

        /// <summary>
        /// A PropertyDescriptor class used to Get and Set the value of the LogonName property.
        /// </summary>
        /// <remarks></remarks>
        private class Field_LogonName_Descriptor : MicroFour.StrataFrame.Business.FieldPropertyDescriptor
        {
            public Field_LogonName_Descriptor() : base("LogonName") { }
            private System.Type _PropertyType = typeof(System.String);
            public override object GetValue(Object component)
            {
                return ((Users)component).LogonName;
            }
            public override void SetValue(Object component, object Value)
            {
                ((Users)component).LogonName = (System.String)Value;
            }
            public override System.Type PropertyType
            {
                get
                {
                    return this._PropertyType;
                }
            }
            public override System.Type ComponentType
            {
                get
                {
                    return _ComponentType;
                }
            }
        }

        /// <summary>
        /// A PropertyDescriptor class used to Get and Set the value of the FullName property.
        /// </summary>
        /// <remarks></remarks>
        private class Field_FullName_Descriptor : MicroFour.StrataFrame.Business.FieldPropertyDescriptor
        {
            public Field_FullName_Descriptor() : base("FullName") { }
            private System.Type _PropertyType = typeof(System.String);
            public override object GetValue(Object component)
            {
                return ((Users)component).FullName;
            }
            public override void SetValue(Object component, object Value)
            {
                ((Users)component).FullName = (System.String)Value;
            }
            public override System.Type PropertyType
            {
                get
                {
                    return this._PropertyType;
                }
            }
            public override System.Type ComponentType
            {
                get
                {
                    return _ComponentType;
                }
            }
        }

        /// <summary>
        /// A PropertyDescriptor class used to Get and Set the value of the Permission property.
        /// </summary>
        /// <remarks></remarks>
        private class Field_Permission_Descriptor : MicroFour.StrataFrame.Business.FieldPropertyDescriptor
        {
            public Field_Permission_Descriptor() : base("Permission") { }
            private System.Type _PropertyType = typeof(System.String);
            public override object GetValue(Object component)
            {
                return ((Users)component).Permission;
            }
            public override void SetValue(Object component, object Value)
            {
                ((Users)component).Permission = (System.String)Value;
            }
            public override System.Type PropertyType
            {
                get
                {
                    return this._PropertyType;
                }
            }
            public override System.Type ComponentType
            {
                get
                {
                    return _ComponentType;
                }
            }
        }

        #endregion

    }

}
