using MicroFour.StrataFrame.Business;
using MicroFour.StrataFrame.Security;
using MicroFour.StrataFrame.UI.Windows.Forms;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.IO;

namespace DM.Library
{
    public partial class VisitsForEntity : MicroFour.StrataFrame.Business.BusinessLayer
    {

        #region Component Implementation

        /// <summary>
        /// Required designer variable.
        /// </summary>
        private System.ComponentModel.IContainer components = null;

        /// <summary> 
        /// Clean up any resources being used.
        /// </summary>
        /// <param name="disposing">true if managed resources should be disposed; otherwise, false.</param>
        protected override void Dispose(bool disposing)
        {
            if (disposing && (components != null))
            {
                components.Dispose();
            }
            base.Dispose(disposing);
        }

        /// <summary>
        /// Required method for Designer support - do not modify
        /// the contents of this method with the code editor.
        /// </summary>
        private void InitializeComponent()
        {
            components = new System.ComponentModel.Container();

            this.CheckRulesOnCurrentRow += new CheckRulesOnCurrentRowEventHandler(VisitsForEntity_CheckRulesOnCurrentRow);
            this.SetDefaultValues += new SetDefaultValuesEventHandler(VisitsForEntity_SetDefaultValues);
        }

        #endregion


        #region BusinessLayer Overriden Methods & Properties

        /// <summary>
        /// The collection of required fields for the business object.
        /// </summary>
        /// <remarks></remarks>
        [Browsable(false), DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public override RequiredFieldsCollection RequiredFields
        {
            get
            {
                return base.RequiredFields;
            }
            set
            {
                base.RequiredFields = value;
            }
        }

        /// <summary>
        /// Defines the constraint that defines the parent-child relationship between this business object type and another business object type.
        /// </summary>
        /// <remarks></remarks>
        [Browsable(false), DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public override IBusinessParentRelationship ParentRelationship
        {
            get
            {
                return base.ParentRelationship;
            }
            set
            {
                base.ParentRelationship = value;
            }
        }

        /// <summary>
        /// Returns all of the field names in a single string in the form of [field1],[field2],...  This must be used in the place of '*' in select statements if Query Notifications are to be registered.
        /// </summary>
        /// <remarks></remarks>
        protected override String AllFieldNames
        {
            get
            {
                return "[VisitID],[MRN],[PatientClass],[AdmissionType],[AdmitDate],[Service],[Clinic],[PatientType],[FinancialClass],[CurrLocation]";
            }
        }

        /// <summary>
        /// The name of the database that contains the table to which this business object is mapped.
        /// </summary>
        /// <remarks></remarks>
        public override String Database
        {
            get
            {
                return "CRM";
            }
        }

        private static string[] _PrimaryKeyFields = new string[] { };
        /// <summary>
        /// Gets the field or fields that comprise the primary key for the business object.
        /// </summary>
        /// <remarks></remarks>
        public override string[] PrimaryKeyFields
        {
            get
            {
                return _PrimaryKeyFields;
            }
        }

        /// <summary>
        /// The name of the table in the database to which this business object is mapped.
        /// </summary>
        /// <remarks></remarks>
        public override String TableName
        {
            get
            {
                return "Visits";
            }
        }

        /// <summary>
        /// The schema of the table in the database to which this business object is mapped.
        /// </summary>
        /// <remarks></remarks>
        public override String TableSchema
        {
            get
            {
                return "dbo";
            }
        }

        /// <summary>
        /// Creates and returns an array of DataColumns that contains the schema for the table.  This is used to prevent a round trip to the server to aquire the initial schema for the internal DataTable.
        /// </summary>
        /// <remarks></remarks>
        protected override DataColumn[] CreateTableSchema()
        {
            return new DataColumn[] {
new DataColumn("VisitID", typeof(System.String)),
new DataColumn("MRN", typeof(System.String)),
new DataColumn("PatientClass", typeof(System.String)),
new DataColumn("AdmissionType", typeof(System.String)),
new DataColumn("AdmitDate", typeof(System.DateTime)),
new DataColumn("Service", typeof(System.String)),
new DataColumn("Clinic", typeof(System.String)),
new DataColumn("PatientType", typeof(System.String)),
new DataColumn("FinancialClass", typeof(System.String)),
new DataColumn("CurrLocation", typeof(System.String))};
        }

        /// <summary>
        /// Adds a broken rule to the business object's collection
        /// </summary>
        /// <remarks></remarks>
        protected void AddBrokenRule(VisitsForEntityFieldNames Field, string ErrorMessage)
        {
            base.AddBrokenRule(Field, ErrorMessage);
        }

        /// <summary>
        /// Adds a broken rule to the business object's collection
        /// </summary>
        /// <remarks></remarks>
        protected new void AddBrokenRule(string FieldName, string ErrorMessage)
        {
            base.AddBrokenRule(FieldName, ErrorMessage);
        }

        /// <summary>
        /// Adds a broken rules to the business object's collection using the given message key to pull the error message from the localization database
        /// </summary>
        /// <remarks></remarks>
        protected void AddBrokenRuleByKey(VisitsForEntityFieldNames Field, string ErrorMessageKey)
        {
            base.AddBrokenRuleByKey(Field, ErrorMessageKey);
        }

        /// <summary>
        /// Adds a broken rules to the business object's collection using the given message key to pull the error message from the localization database
        /// </summary>
        /// <remarks></remarks>
        protected new void AddBrokenRuleByKey(string FieldName, string ErrorMessageKey)
        {
            base.AddBrokenRuleByKey(FieldName, ErrorMessageKey);
        }

        /// <summary>
        /// Gets a collection of the names for all fields that belong to this business object and map to the database.
        /// </summary>
        /// <remarks></remarks>
        public override List<string> AllFieldsList
        {
            get
            {
                return _AllFieldsList;
            }
        }

        /// <summary>
        /// Gets a dictionary of the DbTypes for all fields that belong to this business object and map to the database.
        /// </summary>
        /// <remarks></remarks>
        public override Dictionary<string, DbType> FieldDbTypes
        {
            get
            {
                return _FieldDbTypes;
            }
        }

        /// <summary>
        /// Gets a dictionary of all fields within this business object that map to the FieldNames enumeration for this business object.
        /// </summary>
        /// <remarks></remarks>
        public override BusinessLayerFieldEnumDictionary FieldEnums
        {
            get
            {
                return _FieldEnums;
            }
        }

        /// <summary>
        /// Gets a dictionary of all of the lengths for all fields within this business object that map to a field in the database.
        /// </summary>
        /// <remarks></remarks>
        public override Dictionary<string, int> FieldLengths
        {
            get
            {
                return _FieldLengths;
            }
        }

        /// <summary>
        /// Gets a dictionary of the native DbType (SqlDbType, OracleType, OleDbType, etc.) for all fields within this buisness object that map to a field in the database.
        /// </summary>
        /// <remarks></remarks>
        public override Dictionary<string, int> FieldNativeDbTypes
        {
            get
            {
                return _FieldNativeDbTypes;
            }
        }

        /// <summary>
        /// Gets a dictionary of the security permission keys for each field in the business object.
        /// </summary>
        /// <remarks></remarks>
        public override Dictionary<string, string> FieldPermissionKeys
        {
            get
            {
                return _FieldPermissionKeys;
            }
        }

        #endregion

        #region Field Properties

        /// <summary>
        /// VisitID
        /// </summary>
        /// <remarks></remarks>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("VisitID"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.String VisitID
        {
            get
            {
                return (System.String)this.CurrentRow["VisitID"];
            }
            set
            {
                this.CurrentRow["VisitID"] = value;
            }
        }

        /// <summary>
        /// MRN
        /// </summary>
        /// <remarks></remarks>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("MRN"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.String MRN
        {
            get
            {
                return (System.String)this.CurrentRow["MRN"];
            }
            set
            {
                this.CurrentRow["MRN"] = value;
            }
        }

        /// <summary>
        /// PatientClass
        /// </summary>
        /// <remarks></remarks>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("PatientClass"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.String PatientClass
        {
            get
            {
                return (System.String)this.CurrentRow["PatientClass"];
            }
            set
            {
                this.CurrentRow["PatientClass"] = value;
            }
        }

        /// <summary>
        /// AdmissionType
        /// </summary>
        /// <remarks></remarks>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("AdmissionType"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.String AdmissionType
        {
            get
            {
                return (System.String)this.CurrentRow["AdmissionType"];
            }
            set
            {
                this.CurrentRow["AdmissionType"] = value;
            }
        }

        /// <summary>
        /// AdmitDate
        /// </summary>
        /// <remarks></remarks>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("AdmitDate"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.DateTime AdmitDate
        {
            get
            {
                return (System.DateTime)this.CurrentRow["AdmitDate"];
            }
            set
            {
                this.CurrentRow["AdmitDate"] = value;
            }
        }

        /// <summary>
        /// Service
        /// </summary>
        /// <remarks></remarks>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("Service"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.String Service
        {
            get
            {
                return (System.String)this.CurrentRow["Service"];
            }
            set
            {
                this.CurrentRow["Service"] = value;
            }
        }

        /// <summary>
        /// Clinic
        /// </summary>
        /// <remarks></remarks>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("Clinic"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.String Clinic
        {
            get
            {
                return (System.String)this.CurrentRow["Clinic"];
            }
            set
            {
                this.CurrentRow["Clinic"] = value;
            }
        }

        /// <summary>
        /// PatientType
        /// </summary>
        /// <remarks></remarks>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("PatientType"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.String PatientType
        {
            get
            {
                return (System.String)this.CurrentRow["PatientType"];
            }
            set
            {
                this.CurrentRow["PatientType"] = value;
            }
        }

        /// <summary>
        /// FinancialClass
        /// </summary>
        /// <remarks></remarks>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("FinancialClass"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.String FinancialClass
        {
            get
            {
                return (System.String)this.CurrentRow["FinancialClass"];
            }
            set
            {
                this.CurrentRow["FinancialClass"] = value;
            }
        }

        /// <summary>
        /// CurrLocation
        /// </summary>
        /// <remarks></remarks>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("CurrLocation"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.String CurrLocation
        {
            get
            {
                return (System.String)this.CurrentRow["CurrLocation"];
            }
            set
            {
                this.CurrentRow["CurrLocation"] = value;
            }
        }

        #endregion

        #region Field Property Events

        #endregion

        #region Nested Types & Field Security

        /// <summary>
        /// Contains all of the field names that belong to the business object.
        /// </summary>
        /// <remarks></remarks>
        public enum VisitsForEntityFieldNames
        {
            VisitID,
            MRN,
            PatientClass,
            AdmissionType,
            AdmitDate,
            Service,
            Clinic,
            PatientType,
            FinancialClass,
            CurrLocation,
            CUSTOM_FIELD
        }

        /// <summary>
        /// Gets the System.Type of the enumeration that contains the field names for the business object.
        /// </summary>
        /// <remarks></remarks>
        public override System.Type GetFieldEnumType()
        {
            return typeof(VisitsForEntityFieldNames);
        }

        /// <summary>
        /// Creates a new CheckFieldSecurityEventArgs object that can be used with this business object type.
        /// </summary>
        /// <remarks></remarks>
        protected override CheckFieldSecurityEventArgsBase CreateNewFieldSecurityEventArgs(System.Enum Field, string CustomField, Permission Perm)
        {
            return new CheckFieldSecurityEventArgs<VisitsForEntityFieldNames>(Field, CustomField, Perm);
        }

        /// <summary>
        /// Describes a method that will handle the CheckFieldScurity event.
        /// </summary>
        /// <remarks></remarks>
        public delegate void CheckFieldSecurityEventHandler(object sender, CheckFieldSecurityEventArgs<VisitsForEntityFieldNames> e);

        /// <summary>
        /// Occurs when the business objects needs to check the security on a field.
        /// </summary>
        /// <remarks></remarks>
        public event CheckFieldSecurityEventHandler CheckFieldSecurity;

        /// <summary>
        /// Raises the CheckFieldSecurity event.
        /// </summary>
        /// <remarks></remarks>
        protected override void OnCheckFieldSecurity(CheckFieldSecurityEventArgsBase e)
        {
            if (this.CheckFieldSecurity != null)
            {
                this.CheckFieldSecurity(this, (CheckFieldSecurityEventArgs<VisitsForEntityFieldNames>)e);
            }
        }

        #endregion

        #region Item Property Implementation


        private static List<string> _AllFieldsList;
        private static Dictionary<string, DbType> _FieldDbTypes;
        private static BusinessLayerFieldEnumDictionary _FieldEnums;
        private static Dictionary<string, int> _FieldLengths;
        private static Dictionary<string, int> _FieldNativeDbTypes;
        private static Dictionary<string, string> _FieldPermissionKeys;

        /// <summary>
        /// Initializes the static members of the VisitsForEntity class.
        /// </summary>
        /// <remarks></remarks>
        static VisitsForEntity()
        {
            //-- Create the new shared dictionary and populate it with an 
            //   instance of each property descriptor
            _PropertyDescriptors = new PropertyDescriptorDictionary(15);
            _PropertyDescriptors.Add("VisitID", new Field_VisitID_Descriptor());
            _PropertyDescriptors.Add("MRN", new Field_MRN_Descriptor());
            _PropertyDescriptors.Add("PatientClass", new Field_PatientClass_Descriptor());
            _PropertyDescriptors.Add("AdmissionType", new Field_AdmissionType_Descriptor());
            _PropertyDescriptors.Add("AdmitDate", new Field_AdmitDate_Descriptor());
            _PropertyDescriptors.Add("Service", new Field_Service_Descriptor());
            _PropertyDescriptors.Add("Clinic", new Field_Clinic_Descriptor());
            _PropertyDescriptors.Add("PatientType", new Field_PatientType_Descriptor());
            _PropertyDescriptors.Add("FinancialClass", new Field_FinancialClass_Descriptor());
            _PropertyDescriptors.Add("CurrLocation", new Field_CurrLocation_Descriptor());

            _AllFieldsList = new List<string>(10);
            _AllFieldsList.Add("VisitID");
            _AllFieldsList.Add("MRN");
            _AllFieldsList.Add("PatientClass");
            _AllFieldsList.Add("AdmissionType");
            _AllFieldsList.Add("AdmitDate");
            _AllFieldsList.Add("Service");
            _AllFieldsList.Add("Clinic");
            _AllFieldsList.Add("PatientType");
            _AllFieldsList.Add("FinancialClass");
            _AllFieldsList.Add("CurrLocation");

            _FieldDbTypes = new Dictionary<string, DbType>(10);
            _FieldDbTypes.Add("VisitID", DbType.AnsiStringFixedLength);
            _FieldDbTypes.Add("MRN", DbType.AnsiString);
            _FieldDbTypes.Add("PatientClass", DbType.AnsiStringFixedLength);
            _FieldDbTypes.Add("AdmissionType", DbType.AnsiStringFixedLength);
            _FieldDbTypes.Add("AdmitDate", DbType.DateTime);
            _FieldDbTypes.Add("Service", DbType.AnsiString);
            _FieldDbTypes.Add("Clinic", DbType.AnsiString);
            _FieldDbTypes.Add("PatientType", DbType.AnsiString);
            _FieldDbTypes.Add("FinancialClass", DbType.AnsiString);
            _FieldDbTypes.Add("CurrLocation", DbType.AnsiString);

            _FieldEnums = new BusinessLayerFieldEnumDictionary(11);
            _FieldEnums.Add("VisitID", VisitsForEntityFieldNames.VisitID);
            _FieldEnums.Add("MRN", VisitsForEntityFieldNames.MRN);
            _FieldEnums.Add("PatientClass", VisitsForEntityFieldNames.PatientClass);
            _FieldEnums.Add("AdmissionType", VisitsForEntityFieldNames.AdmissionType);
            _FieldEnums.Add("AdmitDate", VisitsForEntityFieldNames.AdmitDate);
            _FieldEnums.Add("Service", VisitsForEntityFieldNames.Service);
            _FieldEnums.Add("Clinic", VisitsForEntityFieldNames.Clinic);
            _FieldEnums.Add("PatientType", VisitsForEntityFieldNames.PatientType);
            _FieldEnums.Add("FinancialClass", VisitsForEntityFieldNames.FinancialClass);
            _FieldEnums.Add("CurrLocation", VisitsForEntityFieldNames.CurrLocation);
            _FieldEnums.Add("CUSTOM_FIELD", VisitsForEntityFieldNames.CUSTOM_FIELD);

            _FieldLengths = new Dictionary<string, int>(10);
            _FieldLengths.Add("VisitID", 15);
            _FieldLengths.Add("MRN", 36);
            _FieldLengths.Add("PatientClass", 1);
            _FieldLengths.Add("AdmissionType", 2);
            _FieldLengths.Add("AdmitDate", 0);
            _FieldLengths.Add("Service", 10);
            _FieldLengths.Add("Clinic", 50);
            _FieldLengths.Add("PatientType", 6);
            _FieldLengths.Add("FinancialClass", 50);
            _FieldLengths.Add("CurrLocation", 12);

            _FieldNativeDbTypes = new Dictionary<string, int>(10);
            _FieldNativeDbTypes.Add("VisitID", (int)System.Data.SqlDbType.Char);
            _FieldNativeDbTypes.Add("MRN", (int)System.Data.SqlDbType.VarChar);
            _FieldNativeDbTypes.Add("PatientClass", (int)System.Data.SqlDbType.Char);
            _FieldNativeDbTypes.Add("AdmissionType", (int)System.Data.SqlDbType.Char);
            _FieldNativeDbTypes.Add("AdmitDate", (int)System.Data.SqlDbType.DateTime);
            _FieldNativeDbTypes.Add("Service", (int)System.Data.SqlDbType.VarChar);
            _FieldNativeDbTypes.Add("Clinic", (int)System.Data.SqlDbType.VarChar);
            _FieldNativeDbTypes.Add("PatientType", (int)System.Data.SqlDbType.VarChar);
            _FieldNativeDbTypes.Add("FinancialClass", (int)System.Data.SqlDbType.VarChar);
            _FieldNativeDbTypes.Add("CurrLocation", (int)System.Data.SqlDbType.VarChar);

            _FieldPermissionKeys = new Dictionary<string, string>(10);
            _FieldPermissionKeys.Add("VisitID", string.Empty);
            _FieldPermissionKeys.Add("MRN", string.Empty);
            _FieldPermissionKeys.Add("PatientClass", string.Empty);
            _FieldPermissionKeys.Add("AdmissionType", string.Empty);
            _FieldPermissionKeys.Add("AdmitDate", string.Empty);
            _FieldPermissionKeys.Add("Service", string.Empty);
            _FieldPermissionKeys.Add("Clinic", string.Empty);
            _FieldPermissionKeys.Add("PatientType", string.Empty);
            _FieldPermissionKeys.Add("FinancialClass", string.Empty);
            _FieldPermissionKeys.Add("CurrLocation", string.Empty);

        }

        private static bool _AreCustomDescriptorsEvaluated = false;
        protected override bool AreCustomDescriptorsEvaluated
        {
            get
            {
                bool llReturn = _AreCustomDescriptorsEvaluated;
                _AreCustomDescriptorsEvaluated = true;
                return llReturn;
            }
        }

        private static PropertyDescriptorDictionary _PropertyDescriptors;
        protected override PropertyDescriptorDictionary PropertyDescriptors
        {
            get
            {
                return _PropertyDescriptors;
            }
        }

        /// <summary>
        /// A private field used to store the System.Type of this business object for use by the FieldPropertyDescriptor classes.
        /// </summary>
        /// <remarks></remarks>

        private static System.Type _ComponentType = typeof(VisitsForEntity);

        /// <summary>
        /// A PropertyDescriptor class used to Get and Set the value of the VisitID property.
        /// </summary>
        /// <remarks></remarks>
        private class Field_VisitID_Descriptor : MicroFour.StrataFrame.Business.FieldPropertyDescriptor
        {
            public Field_VisitID_Descriptor() : base("VisitID") { }
            private System.Type _PropertyType = typeof(System.String);
            public override object GetValue(Object component)
            {
                return ((VisitsForEntity)component).VisitID;
            }
            public override void SetValue(Object component, object Value)
            {
                ((VisitsForEntity)component).VisitID = (System.String)Value;
            }
            public override System.Type PropertyType
            {
                get
                {
                    return this._PropertyType;
                }
            }
            public override System.Type ComponentType
            {
                get
                {
                    return _ComponentType;
                }
            }
        }

        /// <summary>
        /// A PropertyDescriptor class used to Get and Set the value of the MRN property.
        /// </summary>
        /// <remarks></remarks>
        private class Field_MRN_Descriptor : MicroFour.StrataFrame.Business.FieldPropertyDescriptor
        {
            public Field_MRN_Descriptor() : base("MRN") { }
            private System.Type _PropertyType = typeof(System.String);
            public override object GetValue(Object component)
            {
                return ((VisitsForEntity)component).MRN;
            }
            public override void SetValue(Object component, object Value)
            {
                ((VisitsForEntity)component).MRN = (System.String)Value;
            }
            public override System.Type PropertyType
            {
                get
                {
                    return this._PropertyType;
                }
            }
            public override System.Type ComponentType
            {
                get
                {
                    return _ComponentType;
                }
            }
        }

        /// <summary>
        /// A PropertyDescriptor class used to Get and Set the value of the PatientClass property.
        /// </summary>
        /// <remarks></remarks>
        private class Field_PatientClass_Descriptor : MicroFour.StrataFrame.Business.FieldPropertyDescriptor
        {
            public Field_PatientClass_Descriptor() : base("PatientClass") { }
            private System.Type _PropertyType = typeof(System.String);
            public override object GetValue(Object component)
            {
                return ((VisitsForEntity)component).PatientClass;
            }
            public override void SetValue(Object component, object Value)
            {
                ((VisitsForEntity)component).PatientClass = (System.String)Value;
            }
            public override System.Type PropertyType
            {
                get
                {
                    return this._PropertyType;
                }
            }
            public override System.Type ComponentType
            {
                get
                {
                    return _ComponentType;
                }
            }
        }

        /// <summary>
        /// A PropertyDescriptor class used to Get and Set the value of the AdmissionType property.
        /// </summary>
        /// <remarks></remarks>
        private class Field_AdmissionType_Descriptor : MicroFour.StrataFrame.Business.FieldPropertyDescriptor
        {
            public Field_AdmissionType_Descriptor() : base("AdmissionType") { }
            private System.Type _PropertyType = typeof(System.String);
            public override object GetValue(Object component)
            {
                return ((VisitsForEntity)component).AdmissionType;
            }
            public override void SetValue(Object component, object Value)
            {
                ((VisitsForEntity)component).AdmissionType = (System.String)Value;
            }
            public override System.Type PropertyType
            {
                get
                {
                    return this._PropertyType;
                }
            }
            public override System.Type ComponentType
            {
                get
                {
                    return _ComponentType;
                }
            }
        }

        /// <summary>
        /// A PropertyDescriptor class used to Get and Set the value of the AdmitDate property.
        /// </summary>
        /// <remarks></remarks>
        private class Field_AdmitDate_Descriptor : MicroFour.StrataFrame.Business.FieldPropertyDescriptor
        {
            public Field_AdmitDate_Descriptor() : base("AdmitDate") { }
            private System.Type _PropertyType = typeof(System.DateTime);
            public override object GetValue(Object component)
            {
                return ((VisitsForEntity)component).AdmitDate;
            }
            public override void SetValue(Object component, object Value)
            {
                ((VisitsForEntity)component).AdmitDate = (System.DateTime)Value;
            }
            public override System.Type PropertyType
            {
                get
                {
                    return this._PropertyType;
                }
            }
            public override System.Type ComponentType
            {
                get
                {
                    return _ComponentType;
                }
            }
        }

        /// <summary>
        /// A PropertyDescriptor class used to Get and Set the value of the Service property.
        /// </summary>
        /// <remarks></remarks>
        private class Field_Service_Descriptor : MicroFour.StrataFrame.Business.FieldPropertyDescriptor
        {
            public Field_Service_Descriptor() : base("Service") { }
            private System.Type _PropertyType = typeof(System.String);
            public override object GetValue(Object component)
            {
                return ((VisitsForEntity)component).Service;
            }
            public override void SetValue(Object component, object Value)
            {
                ((VisitsForEntity)component).Service = (System.String)Value;
            }
            public override System.Type PropertyType
            {
                get
                {
                    return this._PropertyType;
                }
            }
            public override System.Type ComponentType
            {
                get
                {
                    return _ComponentType;
                }
            }
        }

        /// <summary>
        /// A PropertyDescriptor class used to Get and Set the value of the Clinic property.
        /// </summary>
        /// <remarks></remarks>
        private class Field_Clinic_Descriptor : MicroFour.StrataFrame.Business.FieldPropertyDescriptor
        {
            public Field_Clinic_Descriptor() : base("Clinic") { }
            private System.Type _PropertyType = typeof(System.String);
            public override object GetValue(Object component)
            {
                return ((VisitsForEntity)component).Clinic;
            }
            public override void SetValue(Object component, object Value)
            {
                ((VisitsForEntity)component).Clinic = (System.String)Value;
            }
            public override System.Type PropertyType
            {
                get
                {
                    return this._PropertyType;
                }
            }
            public override System.Type ComponentType
            {
                get
                {
                    return _ComponentType;
                }
            }
        }

        /// <summary>
        /// A PropertyDescriptor class used to Get and Set the value of the PatientType property.
        /// </summary>
        /// <remarks></remarks>
        private class Field_PatientType_Descriptor : MicroFour.StrataFrame.Business.FieldPropertyDescriptor
        {
            public Field_PatientType_Descriptor() : base("PatientType") { }
            private System.Type _PropertyType = typeof(System.String);
            public override object GetValue(Object component)
            {
                return ((VisitsForEntity)component).PatientType;
            }
            public override void SetValue(Object component, object Value)
            {
                ((VisitsForEntity)component).PatientType = (System.String)Value;
            }
            public override System.Type PropertyType
            {
                get
                {
                    return this._PropertyType;
                }
            }
            public override System.Type ComponentType
            {
                get
                {
                    return _ComponentType;
                }
            }
        }

        /// <summary>
        /// A PropertyDescriptor class used to Get and Set the value of the FinancialClass property.
        /// </summary>
        /// <remarks></remarks>
        private class Field_FinancialClass_Descriptor : MicroFour.StrataFrame.Business.FieldPropertyDescriptor
        {
            public Field_FinancialClass_Descriptor() : base("FinancialClass") { }
            private System.Type _PropertyType = typeof(System.String);
            public override object GetValue(Object component)
            {
                return ((VisitsForEntity)component).FinancialClass;
            }
            public override void SetValue(Object component, object Value)
            {
                ((VisitsForEntity)component).FinancialClass = (System.String)Value;
            }
            public override System.Type PropertyType
            {
                get
                {
                    return this._PropertyType;
                }
            }
            public override System.Type ComponentType
            {
                get
                {
                    return _ComponentType;
                }
            }
        }

        /// <summary>
        /// A PropertyDescriptor class used to Get and Set the value of the CurrLocation property.
        /// </summary>
        /// <remarks></remarks>
        private class Field_CurrLocation_Descriptor : MicroFour.StrataFrame.Business.FieldPropertyDescriptor
        {
            public Field_CurrLocation_Descriptor() : base("CurrLocation") { }
            private System.Type _PropertyType = typeof(System.String);
            public override object GetValue(Object component)
            {
                return ((VisitsForEntity)component).CurrLocation;
            }
            public override void SetValue(Object component, object Value)
            {
                ((VisitsForEntity)component).CurrLocation = (System.String)Value;
            }
            public override System.Type PropertyType
            {
                get
                {
                    return this._PropertyType;
                }
            }
            public override System.Type ComponentType
            {
                get
                {
                    return _ComponentType;
                }
            }
        }

        #endregion

    }

}
