using MicroFour.StrataFrame.Business;
using MicroFour.StrataFrame.Security;
using MicroFour.StrataFrame.UI.Windows.Forms;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.IO;

namespace DM.Library
{
    public partial class Programs : MicroFour.StrataFrame.Business.BusinessLayer
    {

        #region Component Implementation

        /// <summary>
        /// Required designer variable.
        /// </summary>
        private System.ComponentModel.IContainer components = null;

        /// <summary> 
        /// Clean up any resources being used.
        /// </summary>
        /// <param name="disposing">true if managed resources should be disposed; otherwise, false.</param>
        protected override void Dispose(bool disposing)
        {
            if (disposing && (components != null))
            {
                components.Dispose();
            }
            base.Dispose(disposing);
        }

        /// <summary>
        /// Required method for Designer support - do not modify
        /// the contents of this method with the code editor.
        /// </summary>
        private void InitializeComponent()
        {
            components = new System.ComponentModel.Container();

            this.CheckRulesOnCurrentRow += new CheckRulesOnCurrentRowEventHandler(Programs_CheckRulesOnCurrentRow);
            this.SetDefaultValues += new SetDefaultValuesEventHandler(Programs_SetDefaultValues);
        }

        #endregion


        #region BusinessLayer Overriden Methods & Properties

        /// <summary>
        /// The collection of required fields for the business object.
        /// </summary>
        /// <remarks></remarks>
        [Browsable(false), DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public override RequiredFieldsCollection RequiredFields
        {
            get
            {
                return base.RequiredFields;
            }
            set
            {
                base.RequiredFields = value;
            }
        }

        /// <summary>
        /// Defines the constraint that defines the parent-child relationship between this business object type and another business object type.
        /// </summary>
        /// <remarks></remarks>
        [Browsable(false), DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public override IBusinessParentRelationship ParentRelationship
        {
            get
            {
                return base.ParentRelationship;
            }
            set
            {
                base.ParentRelationship = value;
            }
        }

        /// <summary>
        /// Returns all of the field names in a single string in the form of [field1],[field2],...  This must be used in the place of '*' in select statements if Query Notifications are to be registered.
        /// </summary>
        /// <remarks></remarks>
        protected override String AllFieldNames
        {
            get
            {
                return "[ProgramName]";
            }
        }

        /// <summary>
        /// The name of the database that contains the table to which this business object is mapped.
        /// </summary>
        /// <remarks></remarks>
        public override String Database
        {
            get
            {
                return "CRM";
            }
        }

        private static string[] _PrimaryKeyFields = new string[] { "ProgramName" };
        /// <summary>
        /// Gets the field or fields that comprise the primary key for the business object.
        /// </summary>
        /// <remarks></remarks>
        public override string[] PrimaryKeyFields
        {
            get
            {
                return _PrimaryKeyFields;
            }
        }

        /// <summary>
        /// The name of the table in the database to which this business object is mapped.
        /// </summary>
        /// <remarks></remarks>
        public override String TableName
        {
            get
            {
                return "Programs";
            }
        }

        /// <summary>
        /// The schema of the table in the database to which this business object is mapped.
        /// </summary>
        /// <remarks></remarks>
        public override String TableSchema
        {
            get
            {
                return "dbo";
            }
        }

        /// <summary>
        /// Creates and returns an array of DataColumns that contains the schema for the table.  This is used to prevent a round trip to the server to aquire the initial schema for the internal DataTable.
        /// </summary>
        /// <remarks></remarks>
        protected override DataColumn[] CreateTableSchema()
        {
            return new DataColumn[] {
new DataColumn("ProgramName", typeof(System.String))};
        }

        /// <summary>
        /// Adds a broken rule to the business object's collection
        /// </summary>
        /// <remarks></remarks>
        protected void AddBrokenRule(ProgramsFieldNames Field, string ErrorMessage)
        {
            base.AddBrokenRule(Field, ErrorMessage);
        }

        /// <summary>
        /// Adds a broken rule to the business object's collection
        /// </summary>
        /// <remarks></remarks>
        protected new void AddBrokenRule(string FieldName, string ErrorMessage)
        {
            base.AddBrokenRule(FieldName, ErrorMessage);
        }

        /// <summary>
        /// Adds a broken rules to the business object's collection using the given message key to pull the error message from the localization database
        /// </summary>
        /// <remarks></remarks>
        protected void AddBrokenRuleByKey(ProgramsFieldNames Field, string ErrorMessageKey)
        {
            base.AddBrokenRuleByKey(Field, ErrorMessageKey);
        }

        /// <summary>
        /// Adds a broken rules to the business object's collection using the given message key to pull the error message from the localization database
        /// </summary>
        /// <remarks></remarks>
        protected new void AddBrokenRuleByKey(string FieldName, string ErrorMessageKey)
        {
            base.AddBrokenRuleByKey(FieldName, ErrorMessageKey);
        }

        /// <summary>
        /// Gets a collection of the names for all fields that belong to this business object and map to the database.
        /// </summary>
        /// <remarks></remarks>
        public override List<string> AllFieldsList
        {
            get
            {
                return _AllFieldsList;
            }
        }

        /// <summary>
        /// Gets a dictionary of the DbTypes for all fields that belong to this business object and map to the database.
        /// </summary>
        /// <remarks></remarks>
        public override Dictionary<string, DbType> FieldDbTypes
        {
            get
            {
                return _FieldDbTypes;
            }
        }

        /// <summary>
        /// Gets a dictionary of all fields within this business object that map to the FieldNames enumeration for this business object.
        /// </summary>
        /// <remarks></remarks>
        public override BusinessLayerFieldEnumDictionary FieldEnums
        {
            get
            {
                return _FieldEnums;
            }
        }

        /// <summary>
        /// Gets a dictionary of all of the lengths for all fields within this business object that map to a field in the database.
        /// </summary>
        /// <remarks></remarks>
        public override Dictionary<string, int> FieldLengths
        {
            get
            {
                return _FieldLengths;
            }
        }

        /// <summary>
        /// Gets a dictionary of the native DbType (SqlDbType, OracleType, OleDbType, etc.) for all fields within this buisness object that map to a field in the database.
        /// </summary>
        /// <remarks></remarks>
        public override Dictionary<string, int> FieldNativeDbTypes
        {
            get
            {
                return _FieldNativeDbTypes;
            }
        }

        /// <summary>
        /// Gets a dictionary of the security permission keys for each field in the business object.
        /// </summary>
        /// <remarks></remarks>
        public override Dictionary<string, string> FieldPermissionKeys
        {
            get
            {
                return _FieldPermissionKeys;
            }
        }

        #endregion

        #region Field Properties

        /// <summary>
        /// ProgramName
        /// </summary>
        /// <remarks></remarks>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("ProgramName"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.String ProgramName
        {
            get
            {
                return (System.String)this.CurrentRow["ProgramName"];
            }
            set
            {
                this.CurrentRow["ProgramName"] = value;
            }
        }

        #endregion

        #region Field Property Events

        #endregion

        #region Nested Types & Field Security

        /// <summary>
        /// Contains all of the field names that belong to the business object.
        /// </summary>
        /// <remarks></remarks>
        public enum ProgramsFieldNames
        {
            ProgramName,
            CUSTOM_FIELD
        }

        /// <summary>
        /// Gets the System.Type of the enumeration that contains the field names for the business object.
        /// </summary>
        /// <remarks></remarks>
        public override System.Type GetFieldEnumType()
        {
            return typeof(ProgramsFieldNames);
        }

        /// <summary>
        /// Creates a new CheckFieldSecurityEventArgs object that can be used with this business object type.
        /// </summary>
        /// <remarks></remarks>
        protected override CheckFieldSecurityEventArgsBase CreateNewFieldSecurityEventArgs(System.Enum Field, string CustomField, Permission Perm)
        {
            return new CheckFieldSecurityEventArgs<ProgramsFieldNames>(Field, CustomField, Perm);
        }

        /// <summary>
        /// Describes a method that will handle the CheckFieldScurity event.
        /// </summary>
        /// <remarks></remarks>
        public delegate void CheckFieldSecurityEventHandler(object sender, CheckFieldSecurityEventArgs<ProgramsFieldNames> e);

        /// <summary>
        /// Occurs when the business objects needs to check the security on a field.
        /// </summary>
        /// <remarks></remarks>
        public event CheckFieldSecurityEventHandler CheckFieldSecurity;

        /// <summary>
        /// Raises the CheckFieldSecurity event.
        /// </summary>
        /// <remarks></remarks>
        protected override void OnCheckFieldSecurity(CheckFieldSecurityEventArgsBase e)
        {
            if (this.CheckFieldSecurity != null)
            {
                this.CheckFieldSecurity(this, (CheckFieldSecurityEventArgs<ProgramsFieldNames>)e);
            }
        }

        #endregion

        #region Item Property Implementation


        private static List<string> _AllFieldsList;
        private static Dictionary<string, DbType> _FieldDbTypes;
        private static BusinessLayerFieldEnumDictionary _FieldEnums;
        private static Dictionary<string, int> _FieldLengths;
        private static Dictionary<string, int> _FieldNativeDbTypes;
        private static Dictionary<string, string> _FieldPermissionKeys;

        /// <summary>
        /// Initializes the static members of the Programs class.
        /// </summary>
        /// <remarks></remarks>
        static Programs()
        {
            //-- Create the new shared dictionary and populate it with an 
            //   instance of each property descriptor
            _PropertyDescriptors = new PropertyDescriptorDictionary(6);
            _PropertyDescriptors.Add("ProgramName", new Field_ProgramName_Descriptor());

            _AllFieldsList = new List<string>(1);
            _AllFieldsList.Add("ProgramName");

            _FieldDbTypes = new Dictionary<string, DbType>(1);
            _FieldDbTypes.Add("ProgramName", DbType.AnsiString);

            _FieldEnums = new BusinessLayerFieldEnumDictionary(2);
            _FieldEnums.Add("ProgramName", ProgramsFieldNames.ProgramName);
            _FieldEnums.Add("CUSTOM_FIELD", ProgramsFieldNames.CUSTOM_FIELD);

            _FieldLengths = new Dictionary<string, int>(1);
            _FieldLengths.Add("ProgramName", 50);

            _FieldNativeDbTypes = new Dictionary<string, int>(1);
            _FieldNativeDbTypes.Add("ProgramName", (int)System.Data.SqlDbType.VarChar);

            _FieldPermissionKeys = new Dictionary<string, string>(1);
            _FieldPermissionKeys.Add("ProgramName", string.Empty);

        }

        private static bool _AreCustomDescriptorsEvaluated = false;
        protected override bool AreCustomDescriptorsEvaluated
        {
            get
            {
                bool llReturn = _AreCustomDescriptorsEvaluated;
                _AreCustomDescriptorsEvaluated = true;
                return llReturn;
            }
        }

        private static PropertyDescriptorDictionary _PropertyDescriptors;
        protected override PropertyDescriptorDictionary PropertyDescriptors
        {
            get
            {
                return _PropertyDescriptors;
            }
        }

        /// <summary>
        /// A private field used to store the System.Type of this business object for use by the FieldPropertyDescriptor classes.
        /// </summary>
        /// <remarks></remarks>

        private static System.Type _ComponentType = typeof(Programs);

        /// <summary>
        /// A PropertyDescriptor class used to Get and Set the value of the ProgramName property.
        /// </summary>
        /// <remarks></remarks>
        private class Field_ProgramName_Descriptor : MicroFour.StrataFrame.Business.FieldPropertyDescriptor
        {
            public Field_ProgramName_Descriptor() : base("ProgramName") { }
            private System.Type _PropertyType = typeof(System.String);
            public override object GetValue(Object component)
            {
                return ((Programs)component).ProgramName;
            }
            public override void SetValue(Object component, object Value)
            {
                ((Programs)component).ProgramName = (System.String)Value;
            }
            public override System.Type PropertyType
            {
                get
                {
                    return this._PropertyType;
                }
            }
            public override System.Type ComponentType
            {
                get
                {
                    return _ComponentType;
                }
            }
        }

        #endregion

    }

}
