using MicroFour.StrataFrame.Business;
using MicroFour.StrataFrame.Security;
using MicroFour.StrataFrame.UI.Windows.Forms;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.IO;

namespace BrowseDialogIssue
{
    partial class OrderBO
    {

        #region Component Implementation

        /// <summary>
        /// Required designer variable.
        /// </summary>
        private System.ComponentModel.IContainer components = null;

        /// <summary> 
        /// Clean up any resources being used.
        /// </summary>
        /// <param name="disposing">true if managed resources should be disposed; otherwise, false.</param>
        protected override void Dispose(bool disposing)
        {
            if (disposing && (components != null))
            {
                components.Dispose();
            }
            base.Dispose(disposing);
        }

        /// <summary>
        /// Required method for Designer support - do not modify
        /// the contents of this method with the code editor.
        /// </summary>
        private void InitializeComponent()
        {
            components = new System.ComponentModel.Container();

            this.CheckRulesOnCurrentRow += new CheckRulesOnCurrentRowEventHandler(OrderBO_CheckRulesOnCurrentRow);
            this.SetDefaultValues += new SetDefaultValuesEventHandler(OrderBO_SetDefaultValues);
        }

        #endregion


        #region BusinessLayer Overriden Methods & Properties

        /// <summary>
        /// The collection of required fields for the business object.
        /// </summary>
        [Browsable(false), DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public override RequiredFieldsCollection RequiredFields
        {
            get
            {
                return base.RequiredFields;
            }
            set
            {
                base.RequiredFields = value;
            }
        }

        /// <summary>
        /// Defines the constraint that defines the parent-child relationship between this business object type and another business object type.
        /// </summary>
        [Browsable(false), DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public override IBusinessParentRelationship ParentRelationship
        {
            get
            {
                return base.ParentRelationship;
            }
            set
            {
                base.ParentRelationship = value;
            }
        }

        /// <summary>
        /// Returns all of the field names in a single string in the form of [field1],[field2],...  This must be used in the place of '*' in select statements if Query Notifications are to be registered.
        /// </summary>
        protected override String AllFieldNames
        {
            get
            {
                return "[or_pk],[or_cust_pk],[or_ponumber],[or_Created],[or_Version]";
            }
        }

        /// <summary>
        /// The name of the database that contains the table to which this business object is mapped.
        /// </summary>
        public override String Database
        {
            get
            {
                return "StrataFrameSample";
            }
        }

        private static string[] _PrimaryKeyFields = new string[] { "or_pk" };
        /// <summary>
        /// Gets the field or fields that comprise the primary key for the business object.
        /// </summary>
        public override string[] PrimaryKeyFields
        {
            get
            {
                return _PrimaryKeyFields;
            }
        }

        /// <summary>
        /// The name of the table in the database to which this business object is mapped.
        /// </summary>
        public override String TableName
        {
            get
            {
                return "Orders";
            }
        }

        /// <summary>
        /// The schema of the table in the database to which this business object is mapped.
        /// </summary>
        public override String TableSchema
        {
            get
            {
                return "dbo";
            }
        }

        /// <summary>
        /// Creates and returns an array of DataColumns that contains the schema for the table.  This is used to prevent a round trip to the server to aquire the initial schema for the internal DataTable.
        /// </summary>
        protected override DataColumn[] CreateTableSchema()
        {
            return new DataColumn[] {
new DataColumn("or_pk", typeof(System.Int32)),
new DataColumn("or_cust_pk", typeof(System.Int32)),
new DataColumn("or_ponumber", typeof(System.String)),
new DataColumn("or_Created", typeof(System.DateTime)),
new DataColumn("or_Version", typeof(System.Int32))};
        }

        /// <summary>
        /// Adds a broken rule to the business object's collection
        /// </summary>
        protected void AddBrokenRule(OrderBOFieldNames Field, string ErrorMessage)
        {
            base.AddBrokenRule(Field, ErrorMessage);
        }

        /// <summary>
        /// Adds a broken rule to the business object's collection
        /// </summary>
        protected new void AddBrokenRule(string FieldName, string ErrorMessage)
        {
            base.AddBrokenRule(FieldName, ErrorMessage);
        }

        /// <summary>
        /// Adds a broken rules to the business object's collection using the given message key to pull the error message from the localization database
        /// </summary>
        protected void AddBrokenRuleByKey(OrderBOFieldNames Field, string ErrorMessageKey)
        {
            base.AddBrokenRuleByKey(Field, ErrorMessageKey);
        }

        /// <summary>
        /// Adds a broken rules to the business object's collection using the given message key to pull the error message from the localization database
        /// </summary>
        protected new void AddBrokenRuleByKey(string FieldName, string ErrorMessageKey)
        {
            base.AddBrokenRuleByKey(FieldName, ErrorMessageKey);
        }

        /// <summary>
        /// Gets a collection of the names for all fields that belong to this business object and map to the database.
        /// </summary>
        public override List<string> AllFieldsList
        {
            get
            {
                return _AllFieldsList;
            }
        }

        /// <summary>
        /// Gets a dictionary of the DbTypes for all fields that belong to this business object and map to the database.
        /// </summary>
        public override Dictionary<string, DbType> FieldDbTypes
        {
            get
            {
                return _FieldDbTypes;
            }
        }

        /// <summary>
        /// Gets a dictionary of all fields within this business object that map to the FieldNames enumeration for this business object.
        /// </summary>
        public override BusinessLayerFieldEnumDictionary FieldEnums
        {
            get
            {
                return _FieldEnums;
            }
        }

        /// <summary>
        /// Gets a dictionary of all of the lengths for all fields within this business object that map to a field in the database.
        /// </summary>
        public override Dictionary<string, int> FieldLengths
        {
            get
            {
                return _FieldLengths;
            }
        }

        /// <summary>
        /// Gets a dictionary of the native DbType (SqlDbType, OracleType, OleDbType, etc.) for all fields within this buisness object that map to a field in the database.
        /// </summary>
        public override Dictionary<string, int> FieldNativeDbTypes
        {
            get
            {
                return _FieldNativeDbTypes;
            }
        }

        /// <summary>
        /// Gets a dictionary of the security permission keys for each field in the business object.
        /// </summary>
        public override Dictionary<string, string> FieldPermissionKeys
        {
            get
            {
                return _FieldPermissionKeys;
            }
        }

        #endregion

        #region Field Properties

        /// <summary>
        /// or_pk
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("or_pk"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.Int32 or_pk
        {
            get
            {
                return (System.Int32)this.CurrentRow["or_pk"];
            }
            set
            {
                this.CurrentRow["or_pk"] = value;
            }
        }

        /// <summary>
        /// or_cust_pk
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("or_cust_pk"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.Int32 or_cust_pk
        {
            get
            {
                return (System.Int32)this.CurrentRow["or_cust_pk"];
            }
            set
            {
                this.CurrentRow["or_cust_pk"] = value;
            }
        }

        /// <summary>
        /// or_ponumber
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("or_ponumber"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.String or_ponumber
        {
            get
            {
                return (System.String)this.CurrentRow["or_ponumber"];
            }
            set
            {
                this.CurrentRow["or_ponumber"] = value;
            }
        }

        /// <summary>
        /// or_Created
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("or_Created"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.DateTime or_Created
        {
            get
            {
                return (System.DateTime)this.CurrentRow["or_Created"];
            }
            set
            {
                this.CurrentRow["or_Created"] = value;
            }
        }

        /// <summary>
        /// or_Version
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("or_Version"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.Int32 or_Version
        {
            get
            {
                return (System.Int32)this.CurrentRow["or_Version"];
            }
            set
            {
                this.CurrentRow["or_Version"] = value;
            }
        }

        #endregion

        #region Field Property Events

        #endregion

        #region Nested Types & Field Security

        /// <summary>
        /// Contains all of the field names that belong to the business object.
        /// </summary>
        public enum OrderBOFieldNames
        {
            or_pk,
            or_cust_pk,
            or_ponumber,
            or_Created,
            or_Version,
            CUSTOM_FIELD
        }

        /// <summary>
        /// Gets the System.Type of the enumeration that contains the field names for the business object.
        /// </summary>
        public override System.Type GetFieldEnumType()
        {
            return typeof(OrderBOFieldNames);
        }

        /// <summary>
        /// Creates a new CheckFieldSecurityEventArgs object that can be used with this business object type.
        /// </summary>
        protected override CheckFieldSecurityEventArgsBase CreateNewFieldSecurityEventArgs(System.Enum Field, string CustomField, string PermissionKey, PermissionInfo Perm)
        {
            return new CheckFieldSecurityEventArgs<OrderBOFieldNames>(Field, CustomField, PermissionKey, Perm);
        }

        /// <summary>
        /// Describes a method that will handle the CheckFieldScurity event.
        /// </summary>
        public delegate void CheckFieldSecurityEventHandler(object sender, CheckFieldSecurityEventArgs<OrderBOFieldNames> e);

        /// <summary>
        /// Occurs when the business objects needs to check the security on a field.
        /// </summary>
        public event CheckFieldSecurityEventHandler CheckFieldSecurity;

        /// <summary>
        /// Raises the CheckFieldSecurity event.
        /// </summary>
        protected override void OnCheckFieldSecurity(CheckFieldSecurityEventArgsBase e)
        {
            if (this.CheckFieldSecurity != null)
            {
                this.CheckFieldSecurity(this, (CheckFieldSecurityEventArgs<OrderBOFieldNames>)e);
            }
        }

        #endregion

        #region Item Property Implementation


        private static List<string> _AllFieldsList;
        private static Dictionary<string, DbType> _FieldDbTypes;
        private static BusinessLayerFieldEnumDictionary _FieldEnums;
        private static Dictionary<string, int> _FieldLengths;
        private static Dictionary<string, int> _FieldNativeDbTypes;
        private static Dictionary<string, string> _FieldPermissionKeys;

        /// <summary>
        /// Initializes the static members of the OrderBO class.
        /// </summary>
        static OrderBO()
        {
            //-- Create the new shared dictionary and populate it with an 
            //   instance of each property descriptor
            _PropertyDescriptors = new PropertyDescriptorDictionary(10);
            _PropertyDescriptors.Add("or_pk", new FieldDescriptor(OrderBOFieldNames.or_pk, typeof(System.Int32)));
            _PropertyDescriptors.Add("or_cust_pk", new FieldDescriptor(OrderBOFieldNames.or_cust_pk, typeof(System.Int32)));
            _PropertyDescriptors.Add("or_ponumber", new FieldDescriptor(OrderBOFieldNames.or_ponumber, typeof(System.String)));
            _PropertyDescriptors.Add("or_Created", new FieldDescriptor(OrderBOFieldNames.or_Created, typeof(System.DateTime)));
            _PropertyDescriptors.Add("or_Version", new FieldDescriptor(OrderBOFieldNames.or_Version, typeof(System.Int32)));

            _AllFieldsList = new List<string>(5);
            _AllFieldsList.Add("or_pk");
            _AllFieldsList.Add("or_cust_pk");
            _AllFieldsList.Add("or_ponumber");
            _AllFieldsList.Add("or_Created");
            _AllFieldsList.Add("or_Version");

            _FieldDbTypes = new Dictionary<string, DbType>(5);
            _FieldDbTypes.Add("or_pk", DbType.Int32);
            _FieldDbTypes.Add("or_cust_pk", DbType.Int32);
            _FieldDbTypes.Add("or_ponumber", DbType.String);
            _FieldDbTypes.Add("or_Created", DbType.DateTime);
            _FieldDbTypes.Add("or_Version", DbType.Int32);

            _FieldEnums = new BusinessLayerFieldEnumDictionary(6);
            _FieldEnums.Add("or_pk", OrderBOFieldNames.or_pk);
            _FieldEnums.Add("or_cust_pk", OrderBOFieldNames.or_cust_pk);
            _FieldEnums.Add("or_ponumber", OrderBOFieldNames.or_ponumber);
            _FieldEnums.Add("or_Created", OrderBOFieldNames.or_Created);
            _FieldEnums.Add("or_Version", OrderBOFieldNames.or_Version);
            _FieldEnums.Add("CUSTOM_FIELD", OrderBOFieldNames.CUSTOM_FIELD);

            _FieldLengths = new Dictionary<string, int>(5);
            _FieldLengths.Add("or_pk", 0);
            _FieldLengths.Add("or_cust_pk", 0);
            _FieldLengths.Add("or_ponumber", 25);
            _FieldLengths.Add("or_Created", 0);
            _FieldLengths.Add("or_Version", 0);

            _FieldNativeDbTypes = new Dictionary<string, int>(5);
            _FieldNativeDbTypes.Add("or_pk", (int)System.Data.SqlDbType.Int);
            _FieldNativeDbTypes.Add("or_cust_pk", (int)System.Data.SqlDbType.Int);
            _FieldNativeDbTypes.Add("or_ponumber", (int)System.Data.SqlDbType.NVarChar);
            _FieldNativeDbTypes.Add("or_Created", (int)System.Data.SqlDbType.DateTime);
            _FieldNativeDbTypes.Add("or_Version", (int)System.Data.SqlDbType.Int);

            _FieldPermissionKeys = new Dictionary<string, string>(5);

        }

        private static bool _AreCustomDescriptorsEvaluated = false;
        protected override bool AreCustomDescriptorsEvaluated
        {
            get
            {
                bool llReturn = _AreCustomDescriptorsEvaluated;
                _AreCustomDescriptorsEvaluated = true;
                return llReturn;
            }
        }

        private static PropertyDescriptorDictionary _PropertyDescriptors;
        protected override PropertyDescriptorDictionary PropertyDescriptors
        {
            get
            {
                return _PropertyDescriptors;
            }
        }

        /// <summary>
        /// A PropertyDescriptor class used to Get and Set the value of fields within the OrderBO business object.
        /// </summary>
        private class FieldDescriptor :
        MicroFour.StrataFrame.Business.FieldPropertyDescriptor<OrderBOFieldNames>
        {
            public FieldDescriptor(OrderBOFieldNames field, Type fieldType) :
                base(field, fieldType) { }
            private static Type _ComponentType = typeof(OrderBO);
            public override object GetValue(object component)
            {
                switch (this.Field)
                {
                    case OrderBOFieldNames.or_pk:
                        return ((OrderBO)component).or_pk;
                    case OrderBOFieldNames.or_cust_pk:
                        return ((OrderBO)component).or_cust_pk;
                    case OrderBOFieldNames.or_ponumber:
                        return ((OrderBO)component).or_ponumber;
                    case OrderBOFieldNames.or_Created:
                        return ((OrderBO)component).or_Created;
                    case OrderBOFieldNames.or_Version:
                        return ((OrderBO)component).or_Version;
                    default:
                        throw new BusinessLayerException("Field not supported.");
                }
            }
            public override void SetValue(object component, object value)
            {
                switch (this.Field)
                {
                    case OrderBOFieldNames.or_pk:
                        ((OrderBO)component).or_pk = (System.Int32)value;
                        break;
                    case OrderBOFieldNames.or_cust_pk:
                        ((OrderBO)component).or_cust_pk = (System.Int32)value;
                        break;
                    case OrderBOFieldNames.or_ponumber:
                        ((OrderBO)component).or_ponumber = (System.String)value;
                        break;
                    case OrderBOFieldNames.or_Created:
                        ((OrderBO)component).or_Created = (System.DateTime)value;
                        break;
                    case OrderBOFieldNames.or_Version:
                        ((OrderBO)component).or_Version = (System.Int32)value;
                        break;
                    default:
                        throw new BusinessLayerException("Field not supported.");
                }
            }
            public override Type ComponentType
            {
                get
                {
                    return _ComponentType;
                }
            }
        }

        #endregion

    }

}
