using MicroFour.StrataFrame.Business;
using MicroFour.StrataFrame.Security;
using MicroFour.StrataFrame.UI.Windows.Forms;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.IO;

namespace TestBoundDDL
{
    partial class CustNoteBO
    {

        #region Component Implementation

        /// <summary>
        /// Required designer variable.
        /// </summary>
        private System.ComponentModel.IContainer components = null;

        /// <summary> 
        /// Clean up any resources being used.
        /// </summary>
        /// <param name="disposing">true if managed resources should be disposed; otherwise, false.</param>
        protected override void Dispose(bool disposing)
        {
            if (disposing && (components != null))
            {
                components.Dispose();
            }
            base.Dispose(disposing);
        }

        /// <summary>
        /// Required method for Designer support - do not modify
        /// the contents of this method with the code editor.
        /// </summary>
        private void InitializeComponent()
        {
            components = new System.ComponentModel.Container();

            this.CheckRulesOnCurrentRow += new CheckRulesOnCurrentRowEventHandler(CustNoteBO_CheckRulesOnCurrentRow);
            this.SetDefaultValues += new SetDefaultValuesEventHandler(CustNoteBO_SetDefaultValues);
        }

        #endregion


        #region BusinessLayer Overriden Methods & Properties

        /// <summary>
        /// The collection of required fields for the business object.
        /// </summary>
        [Browsable(false), DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public override RequiredFieldsCollection RequiredFields
        {
            get
            {
                return base.RequiredFields;
            }
            set
            {
                base.RequiredFields = value;
            }
        }

        /// <summary>
        /// Defines the constraint that defines the parent-child relationship between this business object type and another business object type.
        /// </summary>
        [Browsable(false), DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public override IBusinessParentRelationship ParentRelationship
        {
            get
            {
                return base.ParentRelationship;
            }
            set
            {
                base.ParentRelationship = value;
            }
        }

        /// <summary>
        /// Returns all of the field names in a single string in the form of [field1],[field2],...  This must be used in the place of '*' in select statements if Query Notifications are to be registered.
        /// </summary>
        protected override String AllFieldNames
        {
            get
            {
                return "[cn_pk],[cn_cust_pk],[cn_Subject],[cn_Note],[cn_Created],[cn_Version]";
            }
        }

        /// <summary>
        /// The name of the database that contains the table to which this business object is mapped.
        /// </summary>
        public override String Database
        {
            get
            {
                return "StrataFrameSample";
            }
        }

        private static string[] _PrimaryKeyFields = new string[] { "cn_pk" };
        /// <summary>
        /// Gets the field or fields that comprise the primary key for the business object.
        /// </summary>
        public override string[] PrimaryKeyFields
        {
            get
            {
                return _PrimaryKeyFields;
            }
        }

        /// <summary>
        /// The name of the table in the database to which this business object is mapped.
        /// </summary>
        public override String TableName
        {
            get
            {
                return "CustomerNotes";
            }
        }

        /// <summary>
        /// The schema of the table in the database to which this business object is mapped.
        /// </summary>
        public override String TableSchema
        {
            get
            {
                return "dbo";
            }
        }

        /// <summary>
        /// Creates and returns an array of DataColumns that contains the schema for the table.  This is used to prevent a round trip to the server to aquire the initial schema for the internal DataTable.
        /// </summary>
        protected override DataColumn[] CreateTableSchema()
        {
            return new DataColumn[] {
new DataColumn("cn_pk", typeof(System.Int32)),
new DataColumn("cn_cust_pk", typeof(System.Int32)),
new DataColumn("cn_Subject", typeof(System.String)),
new DataColumn("cn_Note", typeof(System.String)),
new DataColumn("cn_Created", typeof(System.DateTime)),
new DataColumn("cn_Version", typeof(System.Int32))};
        }

        /// <summary>
        /// Adds a broken rule to the business object's collection
        /// </summary>
        protected void AddBrokenRule(CustNoteBOFieldNames Field, string ErrorMessage)
        {
            base.AddBrokenRule(Field, ErrorMessage);
        }

        /// <summary>
        /// Adds a broken rule to the business object's collection
        /// </summary>
        protected new void AddBrokenRule(string FieldName, string ErrorMessage)
        {
            base.AddBrokenRule(FieldName, ErrorMessage);
        }

        /// <summary>
        /// Adds a broken rules to the business object's collection using the given message key to pull the error message from the localization database
        /// </summary>
        protected void AddBrokenRuleByKey(CustNoteBOFieldNames Field, string ErrorMessageKey)
        {
            base.AddBrokenRuleByKey(Field, ErrorMessageKey);
        }

        /// <summary>
        /// Adds a broken rules to the business object's collection using the given message key to pull the error message from the localization database
        /// </summary>
        protected new void AddBrokenRuleByKey(string FieldName, string ErrorMessageKey)
        {
            base.AddBrokenRuleByKey(FieldName, ErrorMessageKey);
        }

        /// <summary>
        /// Gets a collection of the names for all fields that belong to this business object and map to the database.
        /// </summary>
        public override List<string> AllFieldsList
        {
            get
            {
                return _AllFieldsList;
            }
        }

        /// <summary>
        /// Gets a dictionary of the DbTypes for all fields that belong to this business object and map to the database.
        /// </summary>
        public override Dictionary<string, DbType> FieldDbTypes
        {
            get
            {
                return _FieldDbTypes;
            }
        }

        /// <summary>
        /// Gets a dictionary of all fields within this business object that map to the FieldNames enumeration for this business object.
        /// </summary>
        public override BusinessLayerFieldEnumDictionary FieldEnums
        {
            get
            {
                return _FieldEnums;
            }
        }

        /// <summary>
        /// Gets a dictionary of all of the lengths for all fields within this business object that map to a field in the database.
        /// </summary>
        public override Dictionary<string, int> FieldLengths
        {
            get
            {
                return _FieldLengths;
            }
        }

        /// <summary>
        /// Gets a dictionary of the native DbType (SqlDbType, OracleType, OleDbType, etc.) for all fields within this buisness object that map to a field in the database.
        /// </summary>
        public override Dictionary<string, int> FieldNativeDbTypes
        {
            get
            {
                return _FieldNativeDbTypes;
            }
        }

        /// <summary>
        /// Gets a dictionary of the security permission keys for each field in the business object.
        /// </summary>
        public override Dictionary<string, string> FieldPermissionKeys
        {
            get
            {
                return _FieldPermissionKeys;
            }
        }

        #endregion

        #region Field Properties

        /// <summary>
        /// cn_pk
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("cn_pk"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.Int32 cn_pk
        {
            get
            {
                return (System.Int32)this.CurrentRow["cn_pk"];
            }
            set
            {
                this.CurrentRow["cn_pk"] = value;
            }
        }

        /// <summary>
        /// cn_cust_pk
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("cn_cust_pk"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.Int32 cn_cust_pk
        {
            get
            {
                return (System.Int32)this.CurrentRow["cn_cust_pk"];
            }
            set
            {
                this.CurrentRow["cn_cust_pk"] = value;
            }
        }

        /// <summary>
        /// cn_Subject
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("cn_Subject"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.String cn_Subject
        {
            get
            {
                return (System.String)this.CurrentRow["cn_Subject"];
            }
            set
            {
                this.CurrentRow["cn_Subject"] = value;
            }
        }

        /// <summary>
        /// cn_Note
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("cn_Note"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.String cn_Note
        {
            get
            {
                return (System.String)this.CurrentRow["cn_Note"];
            }
            set
            {
                this.CurrentRow["cn_Note"] = value;
            }
        }

        /// <summary>
        /// cn_Created
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("cn_Created"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.DateTime cn_Created
        {
            get
            {
                return (System.DateTime)this.CurrentRow["cn_Created"];
            }
            set
            {
                this.CurrentRow["cn_Created"] = value;
            }
        }

        /// <summary>
        /// cn_Version
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("cn_Version"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.Int32 cn_Version
        {
            get
            {
                return (System.Int32)this.CurrentRow["cn_Version"];
            }
            set
            {
                this.CurrentRow["cn_Version"] = value;
            }
        }

        #endregion

        #region Field Property Events

        #endregion

        #region Nested Types & Field Security

        /// <summary>
        /// Contains all of the field names that belong to the business object.
        /// </summary>
        public enum CustNoteBOFieldNames
        {
            cn_pk,
            cn_cust_pk,
            cn_Subject,
            cn_Note,
            cn_Created,
            cn_Version,
            CUSTOM_FIELD
        }

        /// <summary>
        /// Gets the System.Type of the enumeration that contains the field names for the business object.
        /// </summary>
        public override System.Type GetFieldEnumType()
        {
            return typeof(CustNoteBOFieldNames);
        }

        /// <summary>
        /// Creates a new CheckFieldSecurityEventArgs object that can be used with this business object type.
        /// </summary>
        protected override CheckFieldSecurityEventArgsBase CreateNewFieldSecurityEventArgs(System.Enum Field, string CustomField, string PermissionKey, PermissionInfo Perm)
        {
            return new CheckFieldSecurityEventArgs<CustNoteBOFieldNames>(Field, CustomField, PermissionKey, Perm);
        }

        /// <summary>
        /// Describes a method that will handle the CheckFieldScurity event.
        /// </summary>
        public delegate void CheckFieldSecurityEventHandler(object sender, CheckFieldSecurityEventArgs<CustNoteBOFieldNames> e);

        /// <summary>
        /// Occurs when the business objects needs to check the security on a field.
        /// </summary>
        public event CheckFieldSecurityEventHandler CheckFieldSecurity;

        /// <summary>
        /// Raises the CheckFieldSecurity event.
        /// </summary>
        protected override void OnCheckFieldSecurity(CheckFieldSecurityEventArgsBase e)
        {
            if (this.CheckFieldSecurity != null)
            {
                this.CheckFieldSecurity(this, (CheckFieldSecurityEventArgs<CustNoteBOFieldNames>)e);
            }
        }

        #endregion

        #region Item Property Implementation


        private static List<string> _AllFieldsList;
        private static Dictionary<string, DbType> _FieldDbTypes;
        private static BusinessLayerFieldEnumDictionary _FieldEnums;
        private static Dictionary<string, int> _FieldLengths;
        private static Dictionary<string, int> _FieldNativeDbTypes;
        private static Dictionary<string, string> _FieldPermissionKeys;

        /// <summary>
        /// Initializes the static members of the CustNoteBO class.
        /// </summary>
        static CustNoteBO()
        {
            //-- Create the new shared dictionary and populate it with an 
            //   instance of each property descriptor
            _PropertyDescriptors = new PropertyDescriptorDictionary(11);
            _PropertyDescriptors.Add("cn_pk", new FieldDescriptor(CustNoteBOFieldNames.cn_pk, typeof(System.Int32)));
            _PropertyDescriptors.Add("cn_cust_pk", new FieldDescriptor(CustNoteBOFieldNames.cn_cust_pk, typeof(System.Int32)));
            _PropertyDescriptors.Add("cn_Subject", new FieldDescriptor(CustNoteBOFieldNames.cn_Subject, typeof(System.String)));
            _PropertyDescriptors.Add("cn_Note", new FieldDescriptor(CustNoteBOFieldNames.cn_Note, typeof(System.String)));
            _PropertyDescriptors.Add("cn_Created", new FieldDescriptor(CustNoteBOFieldNames.cn_Created, typeof(System.DateTime)));
            _PropertyDescriptors.Add("cn_Version", new FieldDescriptor(CustNoteBOFieldNames.cn_Version, typeof(System.Int32)));

            _AllFieldsList = new List<string>(6);
            _AllFieldsList.Add("cn_pk");
            _AllFieldsList.Add("cn_cust_pk");
            _AllFieldsList.Add("cn_Subject");
            _AllFieldsList.Add("cn_Note");
            _AllFieldsList.Add("cn_Created");
            _AllFieldsList.Add("cn_Version");

            _FieldDbTypes = new Dictionary<string, DbType>(6);
            _FieldDbTypes.Add("cn_pk", DbType.Int32);
            _FieldDbTypes.Add("cn_cust_pk", DbType.Int32);
            _FieldDbTypes.Add("cn_Subject", DbType.AnsiString);
            _FieldDbTypes.Add("cn_Note", DbType.AnsiString);
            _FieldDbTypes.Add("cn_Created", DbType.DateTime);
            _FieldDbTypes.Add("cn_Version", DbType.Int32);

            _FieldEnums = new BusinessLayerFieldEnumDictionary(7);
            _FieldEnums.Add("cn_pk", CustNoteBOFieldNames.cn_pk);
            _FieldEnums.Add("cn_cust_pk", CustNoteBOFieldNames.cn_cust_pk);
            _FieldEnums.Add("cn_Subject", CustNoteBOFieldNames.cn_Subject);
            _FieldEnums.Add("cn_Note", CustNoteBOFieldNames.cn_Note);
            _FieldEnums.Add("cn_Created", CustNoteBOFieldNames.cn_Created);
            _FieldEnums.Add("cn_Version", CustNoteBOFieldNames.cn_Version);
            _FieldEnums.Add("CUSTOM_FIELD", CustNoteBOFieldNames.CUSTOM_FIELD);

            _FieldLengths = new Dictionary<string, int>(6);
            _FieldLengths.Add("cn_pk", 0);
            _FieldLengths.Add("cn_cust_pk", 0);
            _FieldLengths.Add("cn_Subject", 512);
            _FieldLengths.Add("cn_Note", -1);
            _FieldLengths.Add("cn_Created", 0);
            _FieldLengths.Add("cn_Version", 0);

            _FieldNativeDbTypes = new Dictionary<string, int>(6);
            _FieldNativeDbTypes.Add("cn_pk", (int)System.Data.SqlDbType.Int);
            _FieldNativeDbTypes.Add("cn_cust_pk", (int)System.Data.SqlDbType.Int);
            _FieldNativeDbTypes.Add("cn_Subject", (int)System.Data.SqlDbType.VarChar);
            _FieldNativeDbTypes.Add("cn_Note", (int)System.Data.SqlDbType.VarChar);
            _FieldNativeDbTypes.Add("cn_Created", (int)System.Data.SqlDbType.DateTime);
            _FieldNativeDbTypes.Add("cn_Version", (int)System.Data.SqlDbType.Int);

            _FieldPermissionKeys = new Dictionary<string, string>(6);

        }

        private static bool _AreCustomDescriptorsEvaluated = false;
        protected override bool AreCustomDescriptorsEvaluated
        {
            get
            {
                bool llReturn = _AreCustomDescriptorsEvaluated;
                _AreCustomDescriptorsEvaluated = true;
                return llReturn;
            }
        }

        private static PropertyDescriptorDictionary _PropertyDescriptors;
        protected override PropertyDescriptorDictionary PropertyDescriptors
        {
            get
            {
                return _PropertyDescriptors;
            }
        }

        /// <summary>
        /// A PropertyDescriptor class used to Get and Set the value of fields within the CustNoteBO business object.
        /// </summary>
        private class FieldDescriptor :
        MicroFour.StrataFrame.Business.FieldPropertyDescriptor<CustNoteBOFieldNames>
        {
            public FieldDescriptor(CustNoteBOFieldNames field, Type fieldType) :
                base(field, fieldType) { }
            private static Type _ComponentType = typeof(CustNoteBO);
            public override object GetValue(object component)
            {
                switch (this.Field)
                {
                    case CustNoteBOFieldNames.cn_pk:
                        return ((CustNoteBO)component).cn_pk;
                    case CustNoteBOFieldNames.cn_cust_pk:
                        return ((CustNoteBO)component).cn_cust_pk;
                    case CustNoteBOFieldNames.cn_Subject:
                        return ((CustNoteBO)component).cn_Subject;
                    case CustNoteBOFieldNames.cn_Note:
                        return ((CustNoteBO)component).cn_Note;
                    case CustNoteBOFieldNames.cn_Created:
                        return ((CustNoteBO)component).cn_Created;
                    case CustNoteBOFieldNames.cn_Version:
                        return ((CustNoteBO)component).cn_Version;
                    default:
                        throw new BusinessLayerException("Field not supported.");
                }
            }
            public override void SetValue(object component, object value)
            {
                switch (this.Field)
                {
                    case CustNoteBOFieldNames.cn_pk:
                        ((CustNoteBO)component).cn_pk = (System.Int32)value;
                        break;
                    case CustNoteBOFieldNames.cn_cust_pk:
                        ((CustNoteBO)component).cn_cust_pk = (System.Int32)value;
                        break;
                    case CustNoteBOFieldNames.cn_Subject:
                        ((CustNoteBO)component).cn_Subject = (System.String)value;
                        break;
                    case CustNoteBOFieldNames.cn_Note:
                        ((CustNoteBO)component).cn_Note = (System.String)value;
                        break;
                    case CustNoteBOFieldNames.cn_Created:
                        ((CustNoteBO)component).cn_Created = (System.DateTime)value;
                        break;
                    case CustNoteBOFieldNames.cn_Version:
                        ((CustNoteBO)component).cn_Version = (System.Int32)value;
                        break;
                    default:
                        throw new BusinessLayerException("Field not supported.");
                }
            }
            public override Type ComponentType
            {
                get
                {
                    return _ComponentType;
                }
            }
        }

        #endregion

    }

}
