﻿Option Strict On
Option Explicit On

Imports MicroFour.StrataFrame.Business
Imports MicroFour.StrataFrame.Security
Imports MicroFour.StrataFrame.UI.Windows.Forms
Imports System.Collections.Generic
Imports System.ComponentModel
Imports System.Data
Imports System.IO

Partial Public Class ProductsBO
    Inherits MicroFour.StrataFrame.Business.BusinessLayer

#Region " Component Implementation "

    <System.Diagnostics.DebuggerNonUserCodeAttribute()> _
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If (disposing _
           AndAlso (Not (Me.components) Is Nothing)) Then
            Me.components.Dispose()
        End If
        MyBase.Dispose(disposing)
    End Sub

    Private components As System.ComponentModel.IContainer

    'NOTE: The following procedure is required by the Component Designer
    'It can be modified using the Component Designer.
    'Do not modify it using the code editor.
    <System.Diagnostics.DebuggerNonUserCodeAttribute()> _
    Private Sub InitializeComponent()
        '
        'ProductsBO
        '
    End Sub

#End Region

#Region " BusinessLayer Overriden Methods & Properties "

    ''' <summary>
    ''' The collection of required fields for the business object.
    ''' </summary>
    ''' <remarks></remarks>
    <Browsable(False), DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)> _
    Public Overrides Property RequiredFields() As RequiredFieldsCollection
        Get
            Return MyBase.RequiredFields
        End Get
        Set(ByVal value As RequiredFieldsCollection)
            MyBase.RequiredFields = value
        End Set
    End Property

    ''' <summary>
    ''' Defines the constraint that defines the parent-child relationship between this business object type and another business object type.
    ''' </summary>
    ''' <remarks></remarks>
    <Browsable(False), DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)> _
    Public Overrides Property ParentRelationship() As IBusinessParentRelationship
        Get
            Return MyBase.ParentRelationship
        End Get
        Set(ByVal value As IBusinessParentRelationship)
            MyBase.ParentRelationship = value
        End Set
    End Property

    ''' <summary>
    ''' Returns all of the field names in a single string in the form of [field1],[field2],...  This must be used in the place of '*' in select statements if Query Notifications are to be registered.
    ''' </summary>
    ''' <remarks></remarks>
    Protected Overrides ReadOnly Property AllFieldNames() As String
        Get
            Return "[prod_pk],[prod_sku],[prod_name],[prod_desc],[prod_price],[prod_image],[prod_isactive],[prod_created]"
        End Get
    End Property

    ''' <summary>
    ''' The name of the database that contains the table to which this business object is mapped.
    ''' </summary>
    ''' <remarks></remarks>
    Public Overrides ReadOnly Property Database() As String
        Get
            Return "StrataFrameSample"
        End Get
    End Property

    Private Shared _PrimaryKeyFields As String() = New String() {"prod_pk"}
    ''' <summary>
    ''' Gets the field or fields that comprise the primary key for the business object.
    ''' </summary>
    ''' <remarks></remarks>
    Public Overrides ReadOnly Property PrimaryKeyFields() As String()
        Get
            Return _PrimaryKeyFields
        End Get
    End Property

    ''' <summary>
    ''' The name of the table in the database to which this business object is mapped.
    ''' </summary>
    ''' <remarks></remarks>
    Public Overrides ReadOnly Property TableName() As String
        Get
            Return "Products"
        End Get
    End Property

    ''' <summary>
    ''' The schema of the table in the database to which this business object is mapped.
    ''' </summary>
    ''' <remarks></remarks>
    Public Overrides ReadOnly Property TableSchema() As String
        Get
            Return "dbo"
        End Get
    End Property

    ''' <summary>
    ''' Creates and returns an array of DataColumns that contains the schema for the table.  This is used to prevent a round trip to the server to aquire the initial schema for the internal DataTable.
    ''' </summary>
    ''' <remarks></remarks>
    Protected Overrides Function CreateTableSchema() As DataColumn()
        Return New DataColumn() { _
        New DataColumn("prod_pk", GetType(System.Int32)), _
        New DataColumn("prod_sku", GetType(System.String)), _
        New DataColumn("prod_name", GetType(System.String)), _
        New DataColumn("prod_desc", GetType(System.String)), _
        New DataColumn("prod_price", GetType(System.Decimal)), _
        New DataColumn("prod_image", GetType(System.Byte())), _
        New DataColumn("prod_isactive", GetType(System.Boolean)), _
        New DataColumn("prod_created", GetType(System.DateTime))}
    End Function

    ''' <summary>
    ''' Adds a broken rule to the business object's collection
    ''' </summary>
    ''' <remarks></remarks>
    Protected Shadows Sub AddBrokenRule(ByVal Field As ProductsBOFieldNames, ByVal ErrorMessage As String)
        MyBase.AddBrokenRule(Field, ErrorMessage)
    End Sub

    ''' <summary>
    ''' Adds a broken rule to the business object's collection
    ''' </summary>
    ''' <remarks></remarks>
    Protected Shadows Sub AddBrokenRule(ByVal FieldName As String, ByVal ErrorMessage As String)
        MyBase.AddBrokenRule(FieldName, ErrorMessage)
    End Sub

    ''' <summary>
    ''' Adds a broken rules to the business object's collection using the given message key to pull the error message from the localization database
    ''' </summary>
    ''' <remarks></remarks>
    Protected Shadows Sub AddBrokenRuleByKey(ByVal Field As ProductsBOFieldNames, ByVal ErrorMessageKey As String)
        MyBase.AddBrokenRuleByKey(Field, ErrorMessageKey)
    End Sub

    ''' <summary>
    ''' Adds a broken rules to the business object's collection using the given message key to pull the error message from the localization database
    ''' </summary>
    ''' <remarks></remarks>
    Protected Shadows Sub AddBrokenRuleByKey(ByVal FieldName As String, ByVal ErrorMessageKey As String)
        MyBase.AddBrokenRuleByKey(FieldName, ErrorMessageKey)
    End Sub

    ''' <summary>
    ''' Gets a collection of the names for all fields that belong to this business object and map to the database.
    ''' </summary>
    ''' <remarks></remarks>
    Public Overrides ReadOnly Property AllFieldsList() As List(Of String)
        Get
            Return _AllFieldsList
        End Get
    End Property

    ''' <summary>
    ''' Gets a dictionary of the DbTypes for all fields that belong to this business object and map to the database.
    ''' </summary>
    ''' <remarks></remarks>
    Public Overrides ReadOnly Property FieldDbTypes() As Dictionary(Of String, DbType)
        Get
            Return _FieldDbTypes
        End Get
    End Property

    ''' <summary>
    ''' Gets a dictionary of all fields within this business object that map to the FieldNames enumeration for this business object.
    ''' </summary>
    ''' <remarks></remarks>
    Public Overrides ReadOnly Property FieldEnums() As BusinessLayerFieldEnumDictionary
        Get
            Return _FieldEnums
        End Get
    End Property

    ''' <summary>
    ''' Gets a dictionary of all of the lengths for all fields within this business object that map to a field in the database.
    ''' </summary>
    ''' <remarks></remarks>
    Public Overrides ReadOnly Property FieldLengths() As Dictionary(Of String, Integer)
        Get
            Return _FieldLengths
        End Get
    End Property

    ''' <summary>
    ''' Gets a dictionary of the native DbType (SqlDbType, OracleType, OleDbType, etc.) for all fields within this buisness object that map to a field in the database.
    ''' </summary>
    ''' <remarks></remarks>
    Public Overrides ReadOnly Property FieldNativeDbTypes() As Dictionary(Of String, Integer)
        Get
            Return _FieldNativeDbTypes
        End Get
    End Property

    ''' <summary>
    ''' Gets a dictionary of the security permission keys for each field in the business object.
    ''' </summary>
    ''' <remarks></remarks>
    Public Overrides ReadOnly Property FieldPermissionKeys() As Dictionary(Of String, String)
        Get
            Return _FieldPermissionKeys
        End Get
    End Property

#End Region

#Region " Field Properties "

    ''' <summary>
    ''' prod_pk
    ''' </summary>
    ''' <remarks></remarks>
    <Browsable(False), _
     BusinessFieldDisplayInEditor(), _
     Description("prod_pk"), _
     DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)> _
    Public Property [prod_pk]() As System.Int32
        Get
            Return CType(Me.CurrentRow.Item("prod_pk"), System.Int32)
        End Get
        Set(ByVal value As System.Int32)
            Me.CurrentRow.Item("prod_pk") = value
        End Set
    End Property

    ''' <summary>
    ''' prod_sku
    ''' </summary>
    ''' <remarks></remarks>
    <Browsable(False), _
     BusinessFieldDisplayInEditor(), _
     Description("prod_sku"), _
     DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)> _
    Public Property [prod_sku]() As System.String
        Get
            Return CType(Me.CurrentRow.Item("prod_sku"), System.String)
        End Get
        Set(ByVal value As System.String)
            Me.CurrentRow.Item("prod_sku") = value
        End Set
    End Property

    ''' <summary>
    ''' prod_name
    ''' </summary>
    ''' <remarks></remarks>
    <Browsable(False), _
     BusinessFieldDisplayInEditor(), _
     Description("prod_name"), _
     DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)> _
    Public Property [prod_name]() As System.String
        Get
            Return CType(Me.CurrentRow.Item("prod_name"), System.String)
        End Get
        Set(ByVal value As System.String)
            Me.CurrentRow.Item("prod_name") = value
        End Set
    End Property

    ''' <summary>
    ''' prod_desc
    ''' </summary>
    ''' <remarks></remarks>
    <Browsable(False), _
     BusinessFieldDisplayInEditor(), _
     Description("prod_desc"), _
     DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)> _
    Public Property [prod_desc]() As System.String
        Get
            Return CType(Me.CurrentRow.Item("prod_desc"), System.String)
        End Get
        Set(ByVal value As System.String)
            Me.CurrentRow.Item("prod_desc") = value
        End Set
    End Property

    ''' <summary>
    ''' prod_price
    ''' </summary>
    ''' <remarks></remarks>
    <Browsable(False), _
     BusinessFieldDisplayInEditor(), _
     Description("prod_price"), _
     DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)> _
    Public Property [prod_price]() As System.Decimal
        Get
            Return CType(Me.CurrentRow.Item("prod_price"), System.Decimal)
        End Get
        Set(ByVal value As System.Decimal)
            Me.CurrentRow.Item("prod_price") = value
        End Set
    End Property

    ''' <summary>
    ''' prod_image
    ''' </summary>
    ''' <remarks></remarks>
    <Browsable(False), _
     BusinessFieldDisplayInEditor(), _
     Description("prod_image"), _
     DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)> _
    Public Property [prod_image]() As System.Byte()
        Get
            Return CType(Me.CurrentRow.Item("prod_image"), System.Byte())
        End Get
        Set(ByVal value As System.Byte())
            Me.CurrentRow.Item("prod_image") = value
        End Set
    End Property

    ''' <summary>
    ''' prod_isactive
    ''' </summary>
    ''' <remarks></remarks>
    <Browsable(False), _
     BusinessFieldDisplayInEditor(), _
     Description("prod_isactive"), _
     DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)> _
    Public Property [prod_isactive]() As System.Boolean
        Get
            Return CType(Me.CurrentRow.Item("prod_isactive"), System.Boolean)
        End Get
        Set(ByVal value As System.Boolean)
            Me.CurrentRow.Item("prod_isactive") = value
        End Set
    End Property

    ''' <summary>
    ''' prod_created
    ''' </summary>
    ''' <remarks></remarks>
    <Browsable(False), _
     BusinessFieldDisplayInEditor(), _
     Description("prod_created"), _
     DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)> _
    Public Property [prod_created]() As System.DateTime
        Get
            Return CType(Me.CurrentRow.Item("prod_created"), System.DateTime)
        End Get
        Set(ByVal value As System.DateTime)
            Me.CurrentRow.Item("prod_created") = value
        End Set
    End Property

#End Region

#Region " Field Property Events  "

#End Region

#Region " Nested Types & Field Security "

    ''' <summary>
    ''' Contains all of the field names that belong to the business object.
    ''' </summary>
    ''' <remarks></remarks>
    Public Enum ProductsBOFieldNames As Integer
        [prod_pk]
        [prod_sku]
        [prod_name]
        [prod_desc]
        [prod_price]
        [prod_image]
        [prod_isactive]
        [prod_created]
        CUSTOM_FIELD
    End Enum

    ''' <summary>
    ''' Gets the System.Type of the enumeration that contains the field names for the business object.
    ''' </summary>
    ''' <remarks></remarks>
    Public Overrides Function GetFieldEnumType() As System.Type
        Return GetType(ProductsBOFieldNames)
    End Function

    ''' <summary>
    ''' Creates a new CheckFieldSecurityEventArgs object that can be used with this business object type.
    ''' </summary>
    ''' <remarks></remarks>
    Protected Overrides Function CreateNewFieldSecurityEventArgs(ByVal Field As System.Enum, ByVal CustomField As String, ByVal Perm As Permission) As CheckFieldSecurityEventArgsBase
        Return New CheckFieldSecurityEventArgs(Of ProductsBOFieldNames)(Field, CustomField, Perm)
    End Function

    ''' <summary>
    ''' Describes a method that will handle the CheckFieldScurity event.
    ''' </summary>
    ''' <remarks></remarks>
    Public Delegate Sub CheckFieldSecurityEventHandler(ByVal sender As Object, ByVal e As CheckFieldSecurityEventArgs(Of ProductsBOFieldNames))

    ''' <summary>
    ''' Occurs when the business objects needs to check the security on a field.
    ''' </summary>
    ''' <remarks></remarks>
    Public Event CheckFieldSecurity As CheckFieldSecurityEventHandler

    ''' <summary>
    ''' Raises the CheckFieldSecurity event.
    ''' </summary>
    ''' <remarks></remarks>
    Protected Overrides Sub OnCheckFieldSecurity(ByVal e As CheckFieldSecurityEventArgsBase)
        RaiseEvent CheckFieldSecurity(Me, CType(e, CheckFieldSecurityEventArgs(Of ProductsBOFieldNames)))
    End Sub

#End Region

#Region " Item Property Implementation "


    Private Shared _AllFieldsList As List(Of String)
    Private Shared _FieldDbTypes As Dictionary(Of String, DbType)
    Private Shared _FieldEnums As BusinessLayerFieldEnumDictionary
    Private Shared _FieldLengths As Dictionary(Of String, Integer)
    Private Shared _FieldNativeDbTypes As Dictionary(Of String, Integer)
    Private Shared _FieldPermissionKeys As Dictionary(Of String, String)

    ''' <summary>
    ''' Initializes the shared members of the ProductsBO class.
    ''' </summary>
    ''' <remarks></remarks>
    Shared Sub New()
        '-- Create the new shared dictionary and populate it with an 
        '   instance of each property descriptor
        _PropertyDescriptors = New PropertyDescriptorDictionary(13)
        _PropertyDescriptors.Add("prod_pk", New Field_prod_pk_Descriptor())
        _PropertyDescriptors.Add("prod_sku", New Field_prod_sku_Descriptor())
        _PropertyDescriptors.Add("prod_name", New Field_prod_name_Descriptor())
        _PropertyDescriptors.Add("prod_desc", New Field_prod_desc_Descriptor())
        _PropertyDescriptors.Add("prod_price", New Field_prod_price_Descriptor())
        _PropertyDescriptors.Add("prod_image", New Field_prod_image_Descriptor())
        _PropertyDescriptors.Add("prod_isactive", New Field_prod_isactive_Descriptor())
        _PropertyDescriptors.Add("prod_created", New Field_prod_created_Descriptor())

        _AllFieldsList = New List(Of String)(8)
        _AllFieldsList.Add("prod_pk")
        _AllFieldsList.Add("prod_sku")
        _AllFieldsList.Add("prod_name")
        _AllFieldsList.Add("prod_desc")
        _AllFieldsList.Add("prod_price")
        _AllFieldsList.Add("prod_image")
        _AllFieldsList.Add("prod_isactive")
        _AllFieldsList.Add("prod_created")

        _FieldDbTypes = New Dictionary(Of String, DbType)(8)
        _FieldDbTypes.Add("prod_pk", DbType.Int32)
        _FieldDbTypes.Add("prod_sku", DbType.AnsiString)
        _FieldDbTypes.Add("prod_name", DbType.String)
        _FieldDbTypes.Add("prod_desc", DbType.String)
        _FieldDbTypes.Add("prod_price", DbType.Currency)
        _FieldDbTypes.Add("prod_image", DbType.Binary)
        _FieldDbTypes.Add("prod_isactive", DbType.Boolean)
        _FieldDbTypes.Add("prod_created", DbType.DateTime)

        _FieldEnums = New BusinessLayerFieldEnumDictionary(9)
        _FieldEnums.Add("prod_pk", ProductsBOFieldNames.prod_pk)
        _FieldEnums.Add("prod_sku", ProductsBOFieldNames.prod_sku)
        _FieldEnums.Add("prod_name", ProductsBOFieldNames.prod_name)
        _FieldEnums.Add("prod_desc", ProductsBOFieldNames.prod_desc)
        _FieldEnums.Add("prod_price", ProductsBOFieldNames.prod_price)
        _FieldEnums.Add("prod_image", ProductsBOFieldNames.prod_image)
        _FieldEnums.Add("prod_isactive", ProductsBOFieldNames.prod_isactive)
        _FieldEnums.Add("prod_created", ProductsBOFieldNames.prod_created)
        _FieldEnums.Add("CUSTOM_FIELD", ProductsBOFieldNames.CUSTOM_FIELD)

        _FieldLengths = New Dictionary(Of String, Integer)(8)
        _FieldLengths.Add("prod_pk", 0)
        _FieldLengths.Add("prod_sku", 20)
        _FieldLengths.Add("prod_name", 200)
        _FieldLengths.Add("prod_desc", 2000)
        _FieldLengths.Add("prod_price", 0)
        _FieldLengths.Add("prod_image", -1)
        _FieldLengths.Add("prod_isactive", 0)
        _FieldLengths.Add("prod_created", 0)

        _FieldNativeDbTypes = New Dictionary(Of String, Integer)(8)
        _FieldNativeDbTypes.Add("prod_pk", System.Data.SqlDbType.Int)
        _FieldNativeDbTypes.Add("prod_sku", System.Data.SqlDbType.VarChar)
        _FieldNativeDbTypes.Add("prod_name", System.Data.SqlDbType.NVarChar)
        _FieldNativeDbTypes.Add("prod_desc", System.Data.SqlDbType.NVarChar)
        _FieldNativeDbTypes.Add("prod_price", System.Data.SqlDbType.Money)
        _FieldNativeDbTypes.Add("prod_image", System.Data.SqlDbType.VarBinary)
        _FieldNativeDbTypes.Add("prod_isactive", System.Data.SqlDbType.Bit)
        _FieldNativeDbTypes.Add("prod_created", System.Data.SqlDbType.DateTime)

        _FieldPermissionKeys = New Dictionary(Of String, String)(8)
        _FieldPermissionKeys.Add("prod_pk", String.Empty)
        _FieldPermissionKeys.Add("prod_sku", String.Empty)
        _FieldPermissionKeys.Add("prod_name", String.Empty)
        _FieldPermissionKeys.Add("prod_desc", String.Empty)
        _FieldPermissionKeys.Add("prod_price", String.Empty)
        _FieldPermissionKeys.Add("prod_image", String.Empty)
        _FieldPermissionKeys.Add("prod_isactive", String.Empty)
        _FieldPermissionKeys.Add("prod_created", String.Empty)

    End Sub

    Private Shared _AreCustomDescriptorsEvaluated As Boolean = False
    Protected Overrides ReadOnly Property AreCustomDescriptorsEvaluated() As Boolean
        Get
            Dim llReturn As Boolean = _AreCustomDescriptorsEvaluated
            _AreCustomDescriptorsEvaluated = True
            Return llReturn
        End Get
    End Property

    Private Shared _PropertyDescriptors As PropertyDescriptorDictionary
    Protected Overrides ReadOnly Property PropertyDescriptors() As PropertyDescriptorDictionary
        Get
            Return _PropertyDescriptors
        End Get
    End Property

    ''' <summary>
    ''' A private field used to store the System.Type of this business object for use by the FieldPropertyDescriptor classes.
    ''' </summary>
    ''' <remarks></remarks>

    Private Shared _ComponentType As System.Type = GetType(ProductsBO)

    ''' <summary>
    ''' A PropertyDescriptor class used to Get and Set the value of the prod_pk property.
    ''' </summary>
    ''' <remarks></remarks>
    Private Class Field_prod_pk_Descriptor
        Inherits MicroFour.StrataFrame.Business.FieldPropertyDescriptor
        Public Sub New()
            MyBase.New("prod_pk")
        End Sub
        Private _PropertyType As System.Type = GetType(System.Int32)
        Public Overrides Function GetValue(ByVal component As Object) As Object
            Return CType(component, ProductsBO).prod_pk
        End Function
        Public Overrides Sub SetValue(ByVal component As Object, ByVal Value As Object)
            CType(component, ProductsBO).prod_pk = CType(Value, System.Int32)
        End Sub
        Public Overrides ReadOnly Property PropertyType() As System.Type
            Get
                Return Me._PropertyType
            End Get
        End Property
        Public Overrides ReadOnly Property ComponentType() As System.Type
            Get
                Return _ComponentType
            End Get
        End Property
    End Class

    ''' <summary>
    ''' A PropertyDescriptor class used to Get and Set the value of the prod_sku property.
    ''' </summary>
    ''' <remarks></remarks>
    Private Class Field_prod_sku_Descriptor
        Inherits MicroFour.StrataFrame.Business.FieldPropertyDescriptor
        Public Sub New()
            MyBase.New("prod_sku")
        End Sub
        Private _PropertyType As System.Type = GetType(System.String)
        Public Overrides Function GetValue(ByVal component As Object) As Object
            Return CType(component, ProductsBO).prod_sku
        End Function
        Public Overrides Sub SetValue(ByVal component As Object, ByVal Value As Object)
            CType(component, ProductsBO).prod_sku = CType(Value, System.String)
        End Sub
        Public Overrides ReadOnly Property PropertyType() As System.Type
            Get
                Return Me._PropertyType
            End Get
        End Property
        Public Overrides ReadOnly Property ComponentType() As System.Type
            Get
                Return _ComponentType
            End Get
        End Property
    End Class

    ''' <summary>
    ''' A PropertyDescriptor class used to Get and Set the value of the prod_name property.
    ''' </summary>
    ''' <remarks></remarks>
    Private Class Field_prod_name_Descriptor
        Inherits MicroFour.StrataFrame.Business.FieldPropertyDescriptor
        Public Sub New()
            MyBase.New("prod_name")
        End Sub
        Private _PropertyType As System.Type = GetType(System.String)
        Public Overrides Function GetValue(ByVal component As Object) As Object
            Return CType(component, ProductsBO).prod_name
        End Function
        Public Overrides Sub SetValue(ByVal component As Object, ByVal Value As Object)
            CType(component, ProductsBO).prod_name = CType(Value, System.String)
        End Sub
        Public Overrides ReadOnly Property PropertyType() As System.Type
            Get
                Return Me._PropertyType
            End Get
        End Property
        Public Overrides ReadOnly Property ComponentType() As System.Type
            Get
                Return _ComponentType
            End Get
        End Property
    End Class

    ''' <summary>
    ''' A PropertyDescriptor class used to Get and Set the value of the prod_desc property.
    ''' </summary>
    ''' <remarks></remarks>
    Private Class Field_prod_desc_Descriptor
        Inherits MicroFour.StrataFrame.Business.FieldPropertyDescriptor
        Public Sub New()
            MyBase.New("prod_desc")
        End Sub
        Private _PropertyType As System.Type = GetType(System.String)
        Public Overrides Function GetValue(ByVal component As Object) As Object
            Return CType(component, ProductsBO).prod_desc
        End Function
        Public Overrides Sub SetValue(ByVal component As Object, ByVal Value As Object)
            CType(component, ProductsBO).prod_desc = CType(Value, System.String)
        End Sub
        Public Overrides ReadOnly Property PropertyType() As System.Type
            Get
                Return Me._PropertyType
            End Get
        End Property
        Public Overrides ReadOnly Property ComponentType() As System.Type
            Get
                Return _ComponentType
            End Get
        End Property
    End Class

    ''' <summary>
    ''' A PropertyDescriptor class used to Get and Set the value of the prod_price property.
    ''' </summary>
    ''' <remarks></remarks>
    Private Class Field_prod_price_Descriptor
        Inherits MicroFour.StrataFrame.Business.FieldPropertyDescriptor
        Public Sub New()
            MyBase.New("prod_price")
        End Sub
        Private _PropertyType As System.Type = GetType(System.Decimal)
        Public Overrides Function GetValue(ByVal component As Object) As Object
            Return CType(component, ProductsBO).prod_price
        End Function
        Public Overrides Sub SetValue(ByVal component As Object, ByVal Value As Object)
            CType(component, ProductsBO).prod_price = CType(Value, System.Decimal)
        End Sub
        Public Overrides ReadOnly Property PropertyType() As System.Type
            Get
                Return Me._PropertyType
            End Get
        End Property
        Public Overrides ReadOnly Property ComponentType() As System.Type
            Get
                Return _ComponentType
            End Get
        End Property
    End Class

    ''' <summary>
    ''' A PropertyDescriptor class used to Get and Set the value of the prod_image property.
    ''' </summary>
    ''' <remarks></remarks>
    Private Class Field_prod_image_Descriptor
        Inherits MicroFour.StrataFrame.Business.FieldPropertyDescriptor
        Public Sub New()
            MyBase.New("prod_image")
        End Sub
        Private _PropertyType As System.Type = GetType(System.Byte())
        Public Overrides Function GetValue(ByVal component As Object) As Object
            Return CType(component, ProductsBO).prod_image
        End Function
        Public Overrides Sub SetValue(ByVal component As Object, ByVal Value As Object)
            CType(component, ProductsBO).prod_image = CType(Value, System.Byte())
        End Sub
        Public Overrides ReadOnly Property PropertyType() As System.Type
            Get
                Return Me._PropertyType
            End Get
        End Property
        Public Overrides ReadOnly Property ComponentType() As System.Type
            Get
                Return _ComponentType
            End Get
        End Property
    End Class

    ''' <summary>
    ''' A PropertyDescriptor class used to Get and Set the value of the prod_isactive property.
    ''' </summary>
    ''' <remarks></remarks>
    Private Class Field_prod_isactive_Descriptor
        Inherits MicroFour.StrataFrame.Business.FieldPropertyDescriptor
        Public Sub New()
            MyBase.New("prod_isactive")
        End Sub
        Private _PropertyType As System.Type = GetType(System.Boolean)
        Public Overrides Function GetValue(ByVal component As Object) As Object
            Return CType(component, ProductsBO).prod_isactive
        End Function
        Public Overrides Sub SetValue(ByVal component As Object, ByVal Value As Object)
            CType(component, ProductsBO).prod_isactive = CType(Value, System.Boolean)
        End Sub
        Public Overrides ReadOnly Property PropertyType() As System.Type
            Get
                Return Me._PropertyType
            End Get
        End Property
        Public Overrides ReadOnly Property ComponentType() As System.Type
            Get
                Return _ComponentType
            End Get
        End Property
    End Class

    ''' <summary>
    ''' A PropertyDescriptor class used to Get and Set the value of the prod_created property.
    ''' </summary>
    ''' <remarks></remarks>
    Private Class Field_prod_created_Descriptor
        Inherits MicroFour.StrataFrame.Business.FieldPropertyDescriptor
        Public Sub New()
            MyBase.New("prod_created")
        End Sub
        Private _PropertyType As System.Type = GetType(System.DateTime)
        Public Overrides Function GetValue(ByVal component As Object) As Object
            Return CType(component, ProductsBO).prod_created
        End Function
        Public Overrides Sub SetValue(ByVal component As Object, ByVal Value As Object)
            CType(component, ProductsBO).prod_created = CType(Value, System.DateTime)
        End Sub
        Public Overrides ReadOnly Property PropertyType() As System.Type
            Get
                Return Me._PropertyType
            End Get
        End Property
        Public Overrides ReadOnly Property ComponentType() As System.Type
            Get
                Return _ComponentType
            End Get
        End Property
    End Class

#End Region

End Class

