﻿Option Strict On
Option Explicit On

Imports MicroFour.StrataFrame.Business
Imports MicroFour.StrataFrame.Security
Imports MicroFour.StrataFrame.UI.Windows.Forms
Imports System.Collections.Generic
Imports System.ComponentModel
Imports System.Data
Imports System.IO

Partial Public Class BusinessBO
    Inherits MicroFour.StrataFrame.Business.BusinessLayer

#Region " Component Implementation "

    <System.Diagnostics.DebuggerNonUserCodeAttribute()> _
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If (disposing _
           AndAlso (Not (Me.components) Is Nothing)) Then
            Me.components.Dispose()
        End If
        MyBase.Dispose(disposing)
    End Sub

    Private components As System.ComponentModel.IContainer

    'NOTE: The following procedure is required by the Component Designer
    'It can be modified using the Component Designer.
    'Do not modify it using the code editor.
    <System.Diagnostics.DebuggerNonUserCodeAttribute()> _
    Private Sub InitializeComponent()
        '
        'BusinessesBO
        '
    End Sub

#End Region

#Region " BusinessLayer Overriden Methods & Properties "

    ''' <summary>
    ''' The collection of required fields for the business object.
    ''' </summary>
    ''' <remarks></remarks>
    <Browsable(False), DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)> _
    Public Overrides Property RequiredFields() As RequiredFieldsCollection
        Get
            Return MyBase.RequiredFields
        End Get
        Set(ByVal value As RequiredFieldsCollection)
            MyBase.RequiredFields = value
        End Set
    End Property

    ''' <summary>
    ''' Defines the constraint that defines the parent-child relationship between this business object type and another business object type.
    ''' </summary>
    ''' <remarks></remarks>
    <Browsable(False), DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)> _
    Public Overrides Property ParentRelationship() As IBusinessParentRelationship
        Get
            Return MyBase.ParentRelationship
        End Get
        Set(ByVal value As IBusinessParentRelationship)
            MyBase.ParentRelationship = value
        End Set
    End Property

    ''' <summary>
    ''' Returns all of the field names in a single string in the form of [field1],[field2],...  This must be used in the place of '*' in select statements if Query Notifications are to be registered.
    ''' </summary>
    ''' <remarks></remarks>
    Protected Overrides ReadOnly Property AllFieldNames() As String
        Get
            Return "[BusinessId],[Name]"
        End Get
    End Property

    ''' <summary>
    ''' The name of the database that contains the table to which this business object is mapped.
    ''' </summary>
    ''' <remarks></remarks>
    Public Overrides ReadOnly Property Database() As String
        Get
            Return "Test2_VB"
        End Get
    End Property

    Private Shared _PrimaryKeyFields As String() = New String() {"BusinessId"}
    ''' <summary>
    ''' Gets the field or fields that comprise the primary key for the business object.
    ''' </summary>
    ''' <remarks></remarks>
    Public Overrides ReadOnly Property PrimaryKeyFields() As String()
        Get
            Return _PrimaryKeyFields
        End Get
    End Property

    ''' <summary>
    ''' The name of the table in the database to which this business object is mapped.
    ''' </summary>
    ''' <remarks></remarks>
    Public Overrides ReadOnly Property TableName() As String
        Get
            Return "Business"
        End Get
    End Property

    ''' <summary>
    ''' The schema of the table in the database to which this business object is mapped.
    ''' </summary>
    ''' <remarks></remarks>
    Public Overrides ReadOnly Property TableSchema() As String
        Get
            Return "dbo"
        End Get
    End Property

    ''' <summary>
    ''' Creates and returns an array of DataColumns that contains the schema for the table.  This is used to prevent a round trip to the server to aquire the initial schema for the internal DataTable.
    ''' </summary>
    ''' <remarks></remarks>
    Protected Overrides Function CreateTableSchema() As DataColumn()
        Return New DataColumn() { _
        New DataColumn("BusinessId", GetType(System.Int32)), _
        New DataColumn("Name", GetType(System.String))}
    End Function

    ''' <summary>
    ''' Adds a broken rule to the business object's collection
    ''' </summary>
    ''' <remarks></remarks>
    Protected Shadows Sub AddBrokenRule(ByVal Field As BusinessBOFieldNames, ByVal ErrorMessage As String)
        MyBase.AddBrokenRule(Field, ErrorMessage)
    End Sub

    ''' <summary>
    ''' Adds a broken rule to the business object's collection
    ''' </summary>
    ''' <remarks></remarks>
    Protected Shadows Sub AddBrokenRule(ByVal FieldName As String, ByVal ErrorMessage As String)
        MyBase.AddBrokenRule(FieldName, ErrorMessage)
    End Sub

    ''' <summary>
    ''' Adds a broken rules to the business object's collection using the given message key to pull the error message from the localization database
    ''' </summary>
    ''' <remarks></remarks>
    Protected Shadows Sub AddBrokenRuleByKey(ByVal Field As BusinessBOFieldNames, ByVal ErrorMessageKey As String)
        MyBase.AddBrokenRuleByKey(Field, ErrorMessageKey)
    End Sub

    ''' <summary>
    ''' Adds a broken rules to the business object's collection using the given message key to pull the error message from the localization database
    ''' </summary>
    ''' <remarks></remarks>
    Protected Shadows Sub AddBrokenRuleByKey(ByVal FieldName As String, ByVal ErrorMessageKey As String)
        MyBase.AddBrokenRuleByKey(FieldName, ErrorMessageKey)
    End Sub

    ''' <summary>
    ''' Gets a collection of the names for all fields that belong to this business object and map to the database.
    ''' </summary>
    ''' <remarks></remarks>
    Public Overrides ReadOnly Property AllFieldsList() As List(Of String)
        Get
            Return _AllFieldsList
        End Get
    End Property

    ''' <summary>
    ''' Gets a dictionary of the DbTypes for all fields that belong to this business object and map to the database.
    ''' </summary>
    ''' <remarks></remarks>
    Public Overrides ReadOnly Property FieldDbTypes() As Dictionary(Of String, DbType)
        Get
            Return _FieldDbTypes
        End Get
    End Property

    ''' <summary>
    ''' Gets a dictionary of all fields within this business object that map to the FieldNames enumeration for this business object.
    ''' </summary>
    ''' <remarks></remarks>
    Public Overrides ReadOnly Property FieldEnums() As BusinessLayerFieldEnumDictionary
        Get
            Return _FieldEnums
        End Get
    End Property

    ''' <summary>
    ''' Gets a dictionary of all of the lengths for all fields within this business object that map to a field in the database.
    ''' </summary>
    ''' <remarks></remarks>
    Public Overrides ReadOnly Property FieldLengths() As Dictionary(Of String, Integer)
        Get
            Return _FieldLengths
        End Get
    End Property

    ''' <summary>
    ''' Gets a dictionary of the native DbType (SqlDbType, OracleType, OleDbType, etc.) for all fields within this buisness object that map to a field in the database.
    ''' </summary>
    ''' <remarks></remarks>
    Public Overrides ReadOnly Property FieldNativeDbTypes() As Dictionary(Of String, Integer)
        Get
            Return _FieldNativeDbTypes
        End Get
    End Property

    ''' <summary>
    ''' Gets a dictionary of the security permission keys for each field in the business object.
    ''' </summary>
    ''' <remarks></remarks>
    Public Overrides ReadOnly Property FieldPermissionKeys() As Dictionary(Of String, String)
        Get
            Return _FieldPermissionKeys
        End Get
    End Property

#End Region

#Region " Field Properties "

    ''' <summary>
    ''' BusinessId
    ''' </summary>
    ''' <remarks></remarks>
    <Browsable(False), _
     BusinessFieldDisplayInEditor(), _
     Description("BusinessId"), _
     DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)> _
    Public Property [BusinessId]() As System.Int32
        Get
            Return CType(Me.CurrentRow.Item("BusinessId"), System.Int32)
        End Get
        Set(ByVal value As System.Int32)
            Me.CurrentRow.Item("BusinessId") = value
        End Set
    End Property

    ''' <summary>
    ''' Name
    ''' </summary>
    ''' <remarks></remarks>
    <Browsable(False), _
     BusinessFieldDisplayInEditor(), _
     Description("Name"), _
     DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)> _
    Public Property [Name]() As System.String
        Get
            Return CType(Me.CurrentRow.Item("Name"), System.String)
        End Get
        Set(ByVal value As System.String)
            Me.CurrentRow.Item("Name") = value
        End Set
    End Property

#End Region

#Region " Field Property Events  "

#End Region

#Region " Nested Types & Field Security "

    ''' <summary>
    ''' Contains all of the field names that belong to the business object.
    ''' </summary>
    ''' <remarks></remarks>
    Public Enum BusinessBOFieldNames As Integer
        [BusinessId]
        [Name]
        CUSTOM_FIELD
    End Enum

    ''' <summary>
    ''' Gets the System.Type of the enumeration that contains the field names for the business object.
    ''' </summary>
    ''' <remarks></remarks>
    Public Overrides Function GetFieldEnumType() As System.Type
        Return GetType(BusinessBOFieldNames)
    End Function

    ''' <summary>
    ''' Creates a new CheckFieldSecurityEventArgs object that can be used with this business object type.
    ''' </summary>
    ''' <remarks></remarks>
    Protected Overrides Function CreateNewFieldSecurityEventArgs(ByVal Field As System.Enum, ByVal CustomField As String, ByVal Perm As Permission) As CheckFieldSecurityEventArgsBase
        Return New CheckFieldSecurityEventArgs(Of BusinessBOFieldNames)(Field, CustomField, Perm)
    End Function

    ''' <summary>
    ''' Describes a method that will handle the CheckFieldScurity event.
    ''' </summary>
    ''' <remarks></remarks>
    Public Delegate Sub CheckFieldSecurityEventHandler(ByVal sender As Object, ByVal e As CheckFieldSecurityEventArgs(Of BusinessBOFieldNames))

    ''' <summary>
    ''' Occurs when the business objects needs to check the security on a field.
    ''' </summary>
    ''' <remarks></remarks>
    Public Event CheckFieldSecurity As CheckFieldSecurityEventHandler

    ''' <summary>
    ''' Raises the CheckFieldSecurity event.
    ''' </summary>
    ''' <remarks></remarks>
    Protected Overrides Sub OnCheckFieldSecurity(ByVal e As CheckFieldSecurityEventArgsBase)
        RaiseEvent CheckFieldSecurity(Me, CType(e, CheckFieldSecurityEventArgs(Of BusinessBOFieldNames)))
    End Sub

#End Region

#Region " Item Property Implementation "


    Private Shared _AllFieldsList As List(Of String)
    Private Shared _FieldDbTypes As Dictionary(Of String, DbType)
    Private Shared _FieldEnums As BusinessLayerFieldEnumDictionary
    Private Shared _FieldLengths As Dictionary(Of String, Integer)
    Private Shared _FieldNativeDbTypes As Dictionary(Of String, Integer)
    Private Shared _FieldPermissionKeys As Dictionary(Of String, String)

    ''' <summary>
    ''' Initializes the shared members of the BusinessBO class.
    ''' </summary>
    ''' <remarks></remarks>
    Shared Sub New()
        '-- Create the new shared dictionary and populate it with an 
        '   instance of each property descriptor
        _PropertyDescriptors = New PropertyDescriptorDictionary(7)
        _PropertyDescriptors.Add("BusinessId", New Field_BusinessId_Descriptor())
        _PropertyDescriptors.Add("Name", New Field_Name_Descriptor())

        _AllFieldsList = New List(Of String)(2)
        _AllFieldsList.Add("BusinessId")
        _AllFieldsList.Add("Name")

        _FieldDbTypes = New Dictionary(Of String, DbType)(2)
        _FieldDbTypes.Add("BusinessId", DbType.Int32)
        _FieldDbTypes.Add("Name", DbType.String)

        _FieldEnums = New BusinessLayerFieldEnumDictionary(3)
        _FieldEnums.Add("BusinessId", BusinessBOFieldNames.BusinessId)
        _FieldEnums.Add("Name", BusinessBOFieldNames.Name)
        _FieldEnums.Add("CUSTOM_FIELD", BusinessBOFieldNames.CUSTOM_FIELD)

        _FieldLengths = New Dictionary(Of String, Integer)(2)
        _FieldLengths.Add("BusinessId", 0)
        _FieldLengths.Add("Name", 200)

        _FieldNativeDbTypes = New Dictionary(Of String, Integer)(2)
        _FieldNativeDbTypes.Add("BusinessId", System.Data.SqlDbType.Int)
        _FieldNativeDbTypes.Add("Name", System.Data.SqlDbType.NVarChar)

        _FieldPermissionKeys = New Dictionary(Of String, String)(2)
        _FieldPermissionKeys.Add("BusinessId", String.Empty)
        _FieldPermissionKeys.Add("Name", String.Empty)

    End Sub

    Private Shared _AreCustomDescriptorsEvaluated As Boolean = False
    Protected Overrides ReadOnly Property AreCustomDescriptorsEvaluated() As Boolean
        Get
            Dim llReturn As Boolean = _AreCustomDescriptorsEvaluated
            _AreCustomDescriptorsEvaluated = True
            Return llReturn
        End Get
    End Property

    Private Shared _PropertyDescriptors As PropertyDescriptorDictionary
    Protected Overrides ReadOnly Property PropertyDescriptors() As PropertyDescriptorDictionary
        Get
            Return _PropertyDescriptors
        End Get
    End Property

    ''' <summary>
    ''' A private field used to store the System.Type of this business object for use by the FieldPropertyDescriptor classes.
    ''' </summary>
    ''' <remarks></remarks>

    Private Shared _ComponentType As System.Type = GetType(BusinessBO)

    ''' <summary>
    ''' A PropertyDescriptor class used to Get and Set the value of the BusinessId property.
    ''' </summary>
    ''' <remarks></remarks>
    Private Class Field_BusinessId_Descriptor
        Inherits MicroFour.StrataFrame.Business.FieldPropertyDescriptor
        Public Sub New()
            MyBase.New("BusinessId")
        End Sub
        Private _PropertyType As System.Type = GetType(System.Int32)
        Public Overrides Function GetValue(ByVal component As Object) As Object
            Return CType(component, BusinessBO).BusinessId
        End Function
        Public Overrides Sub SetValue(ByVal component As Object, ByVal Value As Object)
            CType(component, BusinessBO).BusinessId = CType(Value, System.Int32)
        End Sub
        Public Overrides ReadOnly Property PropertyType() As System.Type
            Get
                Return Me._PropertyType
            End Get
        End Property
        Public Overrides ReadOnly Property ComponentType() As System.Type
            Get
                Return _ComponentType
            End Get
        End Property
    End Class

    ''' <summary>
    ''' A PropertyDescriptor class used to Get and Set the value of the Name property.
    ''' </summary>
    ''' <remarks></remarks>
    Private Class Field_Name_Descriptor
        Inherits MicroFour.StrataFrame.Business.FieldPropertyDescriptor
        Public Sub New()
            MyBase.New("Name")
        End Sub
        Private _PropertyType As System.Type = GetType(System.String)
        Public Overrides Function GetValue(ByVal component As Object) As Object
            Return CType(component, BusinessBO).Name
        End Function
        Public Overrides Sub SetValue(ByVal component As Object, ByVal Value As Object)
            CType(component, BusinessBO).Name = CType(Value, System.String)
        End Sub
        Public Overrides ReadOnly Property PropertyType() As System.Type
            Get
                Return Me._PropertyType
            End Get
        End Property
        Public Overrides ReadOnly Property ComponentType() As System.Type
            Get
                Return _ComponentType
            End Get
        End Property
    End Class

#End Region

End Class

