﻿Imports MicroFour.StrataFrame.Application
Imports MicroFour.StrataFrame.Data
Imports MicroFour.StrataFrame.Security
Imports MicroFour.StrataFrame.Security.BusinessObjects

Public NotInheritable Class AppMain

  <STAThread()> _
  Public Shared Sub Main()
    '-- Enable the visual styles
    System.Windows.Forms.Application.EnableVisualStyles()

    '-- Add the handlers for the application events
    AddHandler StrataFrameApplication.ShowGateway, AddressOf ShowGateway
    AddHandler StrataFrameApplication.InitializingApplication, AddressOf InitApplication
    AddHandler StrataFrameApplication.SetDataSources, AddressOf SetDataSources
    AddHandler StrataFrameApplication.UnhandledExceptionFound, AddressOf UnhandledExceptionFound
    AddHandler StrataFrameApplication.ShowLoginAndInitializeForm, AddressOf ShowLoginAndInitMainForm

    '-- Run the application
    StrataFrameApplication.RunApplication()
    SessionLock.StopSessionMonitoring()

    '-- Forcibly close the application to stop message pumps from looping and preventing the application 
    '   from closing
    End
  End Sub

  ''' <summary>
  ''' Gets the connection string if the application will use a custom method to aquire the connection
  ''' string rather than the StrataFrame Connection String Manager (optional)
  ''' </summary>
  ''' <remarks></remarks>
  Private Shared Sub SetDataSources()

    ' ToDo:  1) Set the connection information below including the connection application settings and the
    '           required settings information and then call the ConnectionManager's SetConnections() method.
    '
    '          OR
    '
    '        2) Manually set the DataSourceItems on the DataSources collection below.

    '  -- You can set as many data sources as necessary.  The business objects use the data source specified
    '     by their DataSourceKey property (defaults to "").


    '------------------------------------
    '  Using the Connection Manager
    '------------------------------------

    '-- Set the information specific to this application and the data sources
    '       The application key:
    ConnectionManager.ApplicationKey = "SessionEventTest"
    ConnectionManager.ApplicationDefaultTitle = "SessionEventTest Connection"
    ConnectionManager.ApplicationDefaultDescription = "This application connection is used by SessionEventTest"

    '-- Set the required data source information so that the ConnectionManager can gather it
    '      SQL Connection
    ConnectionManager.AddRequiredDataSourceItem("", "SQL Connection", _
     DataSourceTypeOptions.SqlServer, "MyDatabase", "This connection isn't really used, select anything.")
    ConnectionManager.AddRequiredDataSourceItem("security" _
                                           , "SQL Connection" _
                                           , DataSourceTypeOptions.SqlServer _
                                           , "StrataFrame" _
                                           , "This connection is used to provide security credentials for FOX tools.")
    '      Oracle Connection
    'ConnectionManager.AddRequiredDataSourceItem("", "Oracle Connection", _
    '    DataSourceTypeOptions.Oracle, "", "This connection is used by WindowsApplication1.")
    '      Access Connection
    'ConnectionManager.AddRequiredDataSourceItem("", "Access Connection", _
    '    DataSourceTypeOptions.MicrosoftAccess, "", "This connection is used by WindowsApplication1.")
    '      FoxPro Connection
    'ConnectionManager.AddRequiredDataSourceItem("", "Visual Fox Pro Connection", _
    '    DataSourceTypeOptions.VisualFoxPro, "", "This connection is used by WindowsApplication1.")

    '-- Make the call to SetConnections which will gather the connection information, show the connection wizard
    '   if needed and set the DataSources collection on the DataLayer class.
    ConnectionManager.SetConnections()


    '------------------------------------
    '  Setting the data sources manually
    '------------------------------------
    '-- SQL Server
    'DataLayer.DataSources.Add(New SqlDataSourceItem("", "myconnectionstring"))

    '-- Oracle
    'DataLayer.DataSources.Add(New OracleDataSourceItem("", "myconnectionstring"))

    '-- Microsoft Access
    'DataLayer.DataSources.Add(New AccessDataSourceItem("", "myconnectionstring"))

    '-- Visual Fox Pro
    'DataLayer.DataSources.Add(New VfpDataSourceItem("", "myconnectionstring"))

    '-- ToDo:  Set the data source key for the security tables
    SecurityBasics.SecurityDataSourceKey = "security"
  End Sub

  ''' <summary>
  ''' Shows the "Gateway" form (a custom form that gives the user a choice to launch different components
  ''' within the application) (optional)
  ''' </summary>
  ''' <param name="e"></param>
  ''' <remarks></remarks>
  Private Shared Sub ShowGateway(ByVal e As ShowGatewayEventArgs)
    '-- Inform the application to not show the "Gateway" form again after the main form has closed
    e.ShowGatewayAfterMainFormClose = False
  End Sub

  ''' <summary>
  ''' Shows a login form before a main form is shown and allows security to be checked before the application
  ''' launches the main form (optional)
  ''' </summary>
  ''' <param name="e"></param>
  ''' <remarks></remarks>
  Private Shared Sub ShowLoginAndInitMainForm(ByVal e As ShowLoginAndInitFormEventArgs)
    '-- Set the login form to your custom login form (optional)
    'Login.LoginFormType = GetType(MyLoginForm)

    '-- Show the login form and authenticate the user
    e.ShowMainForm = Login.ShowLoginAndAuthUser(True)
  End Sub

  ''' <summary>
  ''' Provides a centralized location to add any initialization parameters that need to be set before
  ''' the application is loaded and defines the form types used as main forms by the application
  ''' </summary>
  ''' <param name="e"></param>
  ''' <remarks></remarks>
  Private Shared Sub InitApplication(ByVal e As InitializingApplicationEventArgs)
    '-- Add the main form type
    '-- If more than one form is added to the collection, they can be chosen by showing a "Gateway" form
    '   and supplying the index of the form to show (At least 1 form type must be added to the collection
    e.Forms.Add(GetType(SessionEventTest.Form1))

    '-- ToDo:  Add any extra application initialization
    MicroFour.StrataFrame.UI.Localization.MessageKeyType = MicroFour.StrataFrame.Messaging.MessageKeyDataType.XML
    MicroFour.StrataFrame.UI.Localization.MessageLocaleID = MicroFour.StrataFrame.UI.Localization.GetActiveLanguage("SessionEventTest")

    '-- ToDo:  Configure the security settings
    '--------------------------------------------
    '-- Retrieve the global preferences
    SFSPreferencesBO.RetrieveSecurityPreferences()

    '-- Set the encryption key and vector for the user data
    SecurityBasics.SetSecurityKeyAndVectorForUserAuthentication("MySecurityKey")

    '-- Start the session locking monitor & set the quick key to lock the application
    SessionLock.StartSessionMonitoring()
    SessionLock.SessionLockKey = Keys.F11

    '-- Set the administrative and security maintenance usernames and passwords
    SecurityBasics.AdministratorUserName = "admin"
    SecurityBasics.AdministratorPassword = "admin" '& DateTime.Now.Day.ToString() '-- set the admin password so that it changes from day to day
    SecurityBasics.AdministratorUserPk = -1

    SecurityBasics.SecurityMaintenanceUserName = "SecurityUser"
    SecurityBasics.SecurityMaintenancePassword = "mySecurityUserPass1"
    SecurityBasics.SecurityMaintenanceUserPk = -2

    '-- Set the default actions for security enabled objects within the application
    SecurityBasics.DefaultPermissionInfo = New PermissionInfo(PermissionAction.Deny, _
        "Access Denied.", DeniedActions.Message)
    SecurityBasics.DefaultPermissionAction = PermissionAction.Deny
    SecurityBasics.DefaultBlockedMsg = "Access Denied."
    'SecurityBasics.DefaultBlockedMsgKey = "AccessDeniedKey"
    SecurityBasics.BlockedReplacementCharacter = "*"c
    SecurityBasics.BlockedReplacementRegex = "[A-Za-z0-9@]"

    '-- Determine whether to allow Windows authentication
    SecurityBasics.AllowWindowsAuth = False

    '-- Add handlers for session locking events
    ' TEST CODE
    AddHandler SessionLock.AfterSessionLock, AddressOf SessionEventHandlers.AfterSessionLock
    AddHandler SessionLock.BeforeSessionLock, AddressOf SessionEventHandlers.BeforeSessionLock
  End Sub

  ''' <summary>
  ''' Catches any unhandled exception within the application and provides a place to log the information
  ''' </summary>
  ''' <param name="e"></param>
  ''' <remarks></remarks>
  Private Shared Sub UnhandledExceptionFound(ByVal e As UnhandledExceptionFoundEventArgs)
    '-- ToDo: add any error logging required.  To prevent the StrataFrame ApplicationErrorForm from showing,
    '   set:
    '   e.Handled = true
  End Sub

End Class