using MicroFour.StrataFrame.Business;
using MicroFour.StrataFrame.UI.Windows.Forms;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.IO;

namespace ComplexBOSample
{
    public partial class CompanyBO : MicroFour.StrataFrame.Business.BusinessLayer
    {

        #region Component Implementation

        /// <summary>
        /// Required designer variable.
        /// </summary>
        private System.ComponentModel.IContainer components = null;

        public CompanyBO()
        {
            InitializeComponent();
        }

        public CompanyBO(IContainer container)
        {
            container.Add(this);

            InitializeComponent();
        }

        /// <summary> 
        /// Clean up any resources being used.
        /// </summary>
        /// <param name="disposing">true if managed resources should be disposed; otherwise, false.</param>
        protected override void Dispose(bool disposing)
        {
            if (disposing && (components != null))
            {
                components.Dispose();
            }
            base.Dispose(disposing);
        }

        /// <summary>
        /// Required method for Designer support - do not modify
        /// the contents of this method with the code editor.
        /// </summary>
        private void InitializeComponent()
        {
            // 
            // CompanyBO
            // 
            this.ChildAutoFilterOption = MicroFour.StrataFrame.Business.AutoChildFilterOptions.MatchCurrentRow;
            this.Navigated += new MicroFour.StrataFrame.Business.BusinessLayer.NavigatedEventHandler(this.CompanyBO_Navigated);
            this.CurrentDataTableRefilled += new MicroFour.StrataFrame.Business.BusinessLayer.CurrentDataTableRefilledEventHandler(this.CompanyBO_CurrentDataTableRefilled);
            this.CheckRulesOnCurrentRow += new MicroFour.StrataFrame.Business.BusinessLayer.CheckRulesOnCurrentRowEventHandler(this.CompanyBO_CheckRulesOnCurrentRow);
            this.SetDefaultValues += new MicroFour.StrataFrame.Business.BusinessLayer.SetDefaultValuesEventHandler(this.CompanyBO_SetDefaultValues);

        }

        #endregion


        #region BusinessLayer Overriden Methods & Properties

        /// <summary>
        /// The collection of required fields for the business object.
        /// </summary>
        /// <remarks></remarks>
        [Browsable(false), DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public override RequiredFieldsCollection RequiredFields
        {
            get
            {
                return base.RequiredFields;
            }
            set
            {
                base.RequiredFields = value;
            }
        }

        /// <summary>
        /// Defines the constraint that defines the parent-child relationship between this business object type and another business object type.
        /// </summary>
        /// <remarks></remarks>
        [Browsable(false), DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public override IBusinessParentRelationship ParentRelationship
        {
            get
            {
                return base.ParentRelationship;
            }
            set
            {
                base.ParentRelationship = value;
            }
        }

        /// <summary>
        /// Returns all of the field names in a single string in the form of [field1],[field2],...  This must be used in the place of '*' in select statements if Query Notifications are to be registered.
        /// </summary>
        /// <remarks></remarks>
        protected override String AllFieldNames
        {
            get
            {
                return "[CompanyMasterID],[CompanyID],[CompanyName],[AddressLine1],[AddressLine2],[City],[State],[ZipCode]";
            }
        }

        /// <summary>
        /// The name of the database that contains the table to which this business object is mapped.
        /// </summary>
        /// <remarks></remarks>
        public override String Database
        {
            get
            {
                return "Sample";
            }
        }

        /// <summary>
        /// The name of the column that is the primary key of the table to which this business object is mapped.
        /// </summary>
        /// <remarks></remarks>
        public override String PrimaryKeyField
        {
            get
            {
                return "CompanyMasterID";
            }
        }

        /// <summary>
        /// The name of the table in the database to which this business object is mapped.
        /// </summary>
        /// <remarks></remarks>
        public override String TableName
        {
            get
            {
                return "Company";
            }
        }

        /// <summary>
        /// The schema of the table in the database to which this business object is mapped.
        /// </summary>
        /// <remarks></remarks>
        public override String TableSchema
        {
            get
            {
                return "dbo";
            }
        }

        /// <summary>
        /// Creates and returns an array of DataColumns that contains the schema for the table.  This is used to prevent a round trip to the server to aquire the initial schema for the internal DataTable.
        /// </summary>
        /// <remarks></remarks>
        protected override DataColumn[] CreateTableSchema()
        {
            return new DataColumn[] {
new DataColumn("CompanyMasterID", typeof(System.Int32)),
new DataColumn("CompanyID", typeof(System.String)),
new DataColumn("CompanyName", typeof(System.String)),
new DataColumn("AddressLine1", typeof(System.String)),
new DataColumn("AddressLine2", typeof(System.String)),
new DataColumn("City", typeof(System.String)),
new DataColumn("State", typeof(System.String)),
new DataColumn("ZipCode", typeof(System.String))};
        }

        protected override void InitFieldTypesAndLengths()
        {
            this.FieldDbTypes = new Dictionary<string, DbType>(8);
            this.FieldDbTypes.Add("CompanyMasterID", DbType.Int32);
            this.FieldDbTypes.Add("CompanyID", DbType.String);
            this.FieldDbTypes.Add("CompanyName", DbType.String);
            this.FieldDbTypes.Add("AddressLine1", DbType.AnsiString);
            this.FieldDbTypes.Add("AddressLine2", DbType.String);
            this.FieldDbTypes.Add("City", DbType.String);
            this.FieldDbTypes.Add("State", DbType.String);
            this.FieldDbTypes.Add("ZipCode", DbType.String);

            this.FieldLengths = new Dictionary<string, int>(8);
            this.FieldLengths.Add("CompanyMasterID", 4);
            this.FieldLengths.Add("CompanyID", 50);
            this.FieldLengths.Add("CompanyName", 50);
            this.FieldLengths.Add("AddressLine1", 10);
            this.FieldLengths.Add("AddressLine2", 50);
            this.FieldLengths.Add("City", 16);
            this.FieldLengths.Add("State", 50);
            this.FieldLengths.Add("ZipCode", 50);
        }

        /// <summary>
        /// Adds a broken rule to the business object's collection
        /// </summary>
        /// <remarks></remarks>
        protected void AddBrokenRule(CompanyBOFieldNames Field, string ErrorMessage)
        {
            base.AddBrokenRule(Field, ErrorMessage);
        }

        /// <summary>
        /// Adds a broken rule to the business object's collection
        /// </summary>
        /// <remarks></remarks>
        protected new void AddBrokenRule(string FieldName, string ErrorMessage)
        {
            base.AddBrokenRule(FieldName, ErrorMessage);
        }

        /// <summary>
        /// Adds a broken rules to the business object's collection using the given message key to pull the error message from the localization database
        /// </summary>
        /// <remarks></remarks>
        protected void AddBrokenRuleByKey(CompanyBOFieldNames Field, string ErrorMessageKey)
        {
            base.AddBrokenRuleByKey(Field, ErrorMessageKey);
        }

        /// <summary>
        /// Adds a broken rules to the business object's collection using the given message key to pull the error message from the localization database
        /// </summary>
        /// <remarks></remarks>
        protected new void AddBrokenRuleByKey(string FieldName, string ErrorMessageKey)
        {
            base.AddBrokenRuleByKey(FieldName, ErrorMessageKey);
        }

        #endregion

        #region Field Properties

        /// <summary>
        /// 
        /// </summary>
        /// <remarks></remarks>
        [Description(""),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden),
         Browsable(false), BusinessFieldDisplayInEditor()]
        public System.Int32 CompanyMasterID
        {
            get
            {
                if (CurrentRow.RowState == DataRowState.Deleted)
                {
                    return (System.Int32)CurrentRow["CompanyMasterID", DataRowVersion.Original];
                }
                else
                {
                    return (System.Int32)CurrentRow["CompanyMasterID"];
                }
            }
            set
            {
                CurrentRow["CompanyMasterID"] = value;
            }
        }

        /// <summary>
        /// 
        /// </summary>
        /// <remarks></remarks>
        [Description(""),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden),
         Browsable(false), BusinessFieldDisplayInEditor()]
        public System.String CompanyID
        {
            get
            {
                if (CurrentRow.RowState == DataRowState.Deleted)
                {
                    return (System.String)CurrentRow["CompanyID", DataRowVersion.Original];
                }
                else
                {
                    return (System.String)CurrentRow["CompanyID"];
                }
            }
            set
            {
                CurrentRow["CompanyID"] = value;
            }
        }

        /// <summary>
        /// 
        /// </summary>
        /// <remarks></remarks>
        [Description(""),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden),
         Browsable(false), BusinessFieldDisplayInEditor()]
        public System.String CompanyName
        {
            get
            {
                if (CurrentRow.RowState == DataRowState.Deleted)
                {
                    return (System.String)CurrentRow["CompanyName", DataRowVersion.Original];
                }
                else
                {
                    return (System.String)CurrentRow["CompanyName"];
                }
            }
            set
            {
                CurrentRow["CompanyName"] = value;
            }
        }

        /// <summary>
        /// 
        /// </summary>
        /// <remarks></remarks>
        [Description(""),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden),
         Browsable(false), BusinessFieldDisplayInEditor()]
        public System.String AddressLine1
        {
            get
            {
                if (CurrentRow.RowState == DataRowState.Deleted)
                {
                    return (System.String)CurrentRow["AddressLine1", DataRowVersion.Original];
                }
                else
                {
                    return (System.String)CurrentRow["AddressLine1"];
                }
            }
            set
            {
                CurrentRow["AddressLine1"] = value;
            }
        }

        /// <summary>
        /// 
        /// </summary>
        /// <remarks></remarks>
        [Description(""),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden),
         Browsable(false), BusinessFieldDisplayInEditor()]
        public System.String AddressLine2
        {
            get
            {
                if (CurrentRow.RowState == DataRowState.Deleted)
                {
                    return (System.String)CurrentRow["AddressLine2", DataRowVersion.Original];
                }
                else
                {
                    return (System.String)CurrentRow["AddressLine2"];
                }
            }
            set
            {
                CurrentRow["AddressLine2"] = value;
            }
        }

        /// <summary>
        /// 
        /// </summary>
        /// <remarks></remarks>
        [Description(""),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden),
         Browsable(false), BusinessFieldDisplayInEditor()]
        public System.String City
        {
            get
            {
                if (CurrentRow.RowState == DataRowState.Deleted)
                {
                    return (System.String)CurrentRow["City", DataRowVersion.Original];
                }
                else
                {
                    return (System.String)CurrentRow["City"];
                }
            }
            set
            {
                CurrentRow["City"] = value;
            }
        }

        public ComplexBOSample.StateBO State
        {
            get
            {
                return this._State;
            }
        }

        /// <summary>
        /// 
        /// </summary>
        /// <remarks></remarks>
        [Description(""),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden),
         Browsable(false), BusinessFieldDisplayInEditor()]
        public System.String ZipCode
        {
            get
            {
                if (CurrentRow.RowState == DataRowState.Deleted)
                {
                    return (System.String)CurrentRow["ZipCode", DataRowVersion.Original];
                }
                else
                {
                    return (System.String)CurrentRow["ZipCode"];
                }
            }
            set
            {
                CurrentRow["ZipCode"] = value;
            }
        }

        #endregion

        #region Nested Types & Field Security

        /// <summary>
        /// Contains all of the field names that belong to the business object.
        /// </summary>
        /// <remarks></remarks>
        public enum CompanyBOFieldNames
        {
            CompanyMasterID,
            CompanyID,
            CompanyName,
            AddressLine1,
            AddressLine2,
            City,
            State,
            ZipCode,
            CUSTOM_FIELD
        }

        /// <summary>
        /// Gets the System.Type of the enumeration that contains the field names for the business object.
        /// </summary>
        /// <remarks></remarks>
        public override System.Type GetFieldEnumType()
        {
            return typeof(CompanyBOFieldNames);
        }

        /// <summary>
        /// Gets the System.Type of the enumeration that contains the field names for the business object.
        /// </summary>
        /// <remarks></remarks>
        public override System.Type GetFieldSecurityEventArgsType()
        {
            return typeof(CheckCompanyBOFieldSecurityEventArgs);
        }

        /// <summary>
        /// A subclass of MicroFour.StrataFrame.Business.CheckFieldSecurityEventArgs that returns the field to check as a custom enumeration for this business object.
        /// </summary>
        /// <remarks></remarks>
        public class CheckCompanyBOFieldSecurityEventArgs : CheckFieldSecurityEventArgs
        {

            public CompanyBOFieldNames FieldToCheck
            {
                get
                {
                    return (CompanyBOFieldNames)base.Field;
                }
            }
        }

        public delegate void CheckFieldSecurityEventHandler(CheckCompanyBOFieldSecurityEventArgs e);

        /// <summary>
        /// Checks the security on an individual field level if CheckSecurityOnFields is set to true.
        /// </summary>
        /// <remarks></remarks>
        public event CheckFieldSecurityEventHandler CheckFieldSecurity;

        /// <summary>
        /// Called from within the framework to raise the actual event to check individual field security.
        /// </summary>
        /// <remarks></remarks>
        protected override void RaiseCheckFieldSecurityEvent(CheckFieldSecurityEventArgs e)
        {
            this.CheckFieldSecurity((CheckCompanyBOFieldSecurityEventArgs)e);
        }

        #endregion

        #region Item Property Implementation

        /// <summary>
        /// Initializes the static members of the CompanyBO class.
        /// </summary>
        /// <remarks></remarks>
        static CompanyBO()
        {
            //-- Create the new shared dictionary and populate it with an 
            //   instance of each property descriptor
            _PropertyDescriptors = new PropertyDescriptorDictionary(13);
            _PropertyDescriptors.Add("CompanyMasterID", new Field_CompanyMasterID_Descriptor());
            _PropertyDescriptors.Add("CompanyID", new Field_CompanyID_Descriptor());
            _PropertyDescriptors.Add("CompanyName", new Field_CompanyName_Descriptor());
            _PropertyDescriptors.Add("AddressLine1", new Field_AddressLine1_Descriptor());
            _PropertyDescriptors.Add("AddressLine2", new Field_AddressLine2_Descriptor());
            _PropertyDescriptors.Add("City", new Field_City_Descriptor());
            _PropertyDescriptors.Add("ZipCode", new Field_ZipCode_Descriptor());
        }

        private static bool _AreCustomDescriptorsEvaluated = false;
        protected override bool AreCustomDescriptorsEvaluated
        {
            get
            {
                bool llReturn = _AreCustomDescriptorsEvaluated;
                _AreCustomDescriptorsEvaluated = true;
                return llReturn;
            }
        }

        private static PropertyDescriptorDictionary _PropertyDescriptors;
        protected override PropertyDescriptorDictionary PropertyDescriptors
        {
            get
            {
                return _PropertyDescriptors;
            }
        }

        /// <summary>
        /// A private field used to store the System.Type of this business object for use by the FieldPropertyDescriptor classes.
        /// </summary>
        /// <remarks></remarks>

        private static System.Type _ComponentType = typeof(CompanyBO);

        /// <summary>
        /// A PropertyDescriptor class used to Get and Set the value of the CompanyMasterID property.
        /// </summary>
        /// <remarks></remarks>
        private class Field_CompanyMasterID_Descriptor : MicroFour.StrataFrame.Business.FieldPropertyDescriptor
        {
            public Field_CompanyMasterID_Descriptor() : base("CompanyMasterID") { }
            private System.Type _PropertyType = typeof(System.Int32);
            public override object GetValue(Object component)
            {
                return ((CompanyBO)component).CompanyMasterID;
            }
            public override void SetValue(Object component, object Value)
            {
                ((CompanyBO)component).CompanyMasterID = (System.Int32)Value;
            }
            public override System.Type PropertyType
            {
                get
                {
                    return this._PropertyType;
                }
            }
            public override System.Type ComponentType
            {
                get
                {
                    return _ComponentType;
                }
            }
        }

        /// <summary>
        /// A PropertyDescriptor class used to Get and Set the value of the CompanyID property.
        /// </summary>
        /// <remarks></remarks>
        private class Field_CompanyID_Descriptor : MicroFour.StrataFrame.Business.FieldPropertyDescriptor
        {
            public Field_CompanyID_Descriptor() : base("CompanyID") { }
            private System.Type _PropertyType = typeof(System.String);
            public override object GetValue(Object component)
            {
                return ((CompanyBO)component).CompanyID;
            }
            public override void SetValue(Object component, object Value)
            {
                ((CompanyBO)component).CompanyID = (System.String)Value;
            }
            public override System.Type PropertyType
            {
                get
                {
                    return this._PropertyType;
                }
            }
            public override System.Type ComponentType
            {
                get
                {
                    return _ComponentType;
                }
            }
        }

        /// <summary>
        /// A PropertyDescriptor class used to Get and Set the value of the CompanyName property.
        /// </summary>
        /// <remarks></remarks>
        private class Field_CompanyName_Descriptor : MicroFour.StrataFrame.Business.FieldPropertyDescriptor
        {
            public Field_CompanyName_Descriptor() : base("CompanyName") { }
            private System.Type _PropertyType = typeof(System.String);
            public override object GetValue(Object component)
            {
                return ((CompanyBO)component).CompanyName;
            }
            public override void SetValue(Object component, object Value)
            {
                ((CompanyBO)component).CompanyName = (System.String)Value;
            }
            public override System.Type PropertyType
            {
                get
                {
                    return this._PropertyType;
                }
            }
            public override System.Type ComponentType
            {
                get
                {
                    return _ComponentType;
                }
            }
        }

        /// <summary>
        /// A PropertyDescriptor class used to Get and Set the value of the AddressLine1 property.
        /// </summary>
        /// <remarks></remarks>
        private class Field_AddressLine1_Descriptor : MicroFour.StrataFrame.Business.FieldPropertyDescriptor
        {
            public Field_AddressLine1_Descriptor() : base("AddressLine1") { }
            private System.Type _PropertyType = typeof(System.String);
            public override object GetValue(Object component)
            {
                return ((CompanyBO)component).AddressLine1;
            }
            public override void SetValue(Object component, object Value)
            {
                ((CompanyBO)component).AddressLine1 = (System.String)Value;
            }
            public override System.Type PropertyType
            {
                get
                {
                    return this._PropertyType;
                }
            }
            public override System.Type ComponentType
            {
                get
                {
                    return _ComponentType;
                }
            }
        }

        /// <summary>
        /// A PropertyDescriptor class used to Get and Set the value of the AddressLine2 property.
        /// </summary>
        /// <remarks></remarks>
        private class Field_AddressLine2_Descriptor : MicroFour.StrataFrame.Business.FieldPropertyDescriptor
        {
            public Field_AddressLine2_Descriptor() : base("AddressLine2") { }
            private System.Type _PropertyType = typeof(System.String);
            public override object GetValue(Object component)
            {
                return ((CompanyBO)component).AddressLine2;
            }
            public override void SetValue(Object component, object Value)
            {
                ((CompanyBO)component).AddressLine2 = (System.String)Value;
            }
            public override System.Type PropertyType
            {
                get
                {
                    return this._PropertyType;
                }
            }
            public override System.Type ComponentType
            {
                get
                {
                    return _ComponentType;
                }
            }
        }

        /// <summary>
        /// A PropertyDescriptor class used to Get and Set the value of the City property.
        /// </summary>
        /// <remarks></remarks>
        private class Field_City_Descriptor : MicroFour.StrataFrame.Business.FieldPropertyDescriptor
        {
            public Field_City_Descriptor() : base("City") { }
            private System.Type _PropertyType = typeof(System.String);
            public override object GetValue(Object component)
            {
                return ((CompanyBO)component).City;
            }
            public override void SetValue(Object component, object Value)
            {
                ((CompanyBO)component).City = (System.String)Value;
            }
            public override System.Type PropertyType
            {
                get
                {
                    return this._PropertyType;
                }
            }
            public override System.Type ComponentType
            {
                get
                {
                    return _ComponentType;
                }
            }
        }

        /// <summary>
        /// A PropertyDescriptor class used to Get and Set the value of the ZipCode property.
        /// </summary>
        /// <remarks></remarks>
        private class Field_ZipCode_Descriptor : MicroFour.StrataFrame.Business.FieldPropertyDescriptor
        {
            public Field_ZipCode_Descriptor() : base("ZipCode") { }
            private System.Type _PropertyType = typeof(System.String);
            public override object GetValue(Object component)
            {
                return ((CompanyBO)component).ZipCode;
            }
            public override void SetValue(Object component, object Value)
            {
                ((CompanyBO)component).ZipCode = (System.String)Value;
            }
            public override System.Type PropertyType
            {
                get
                {
                    return this._PropertyType;
                }
            }
            public override System.Type ComponentType
            {
                get
                {
                    return _ComponentType;
                }
            }
        }

        #endregion

    }

}
