using MicroFour.StrataFrame.Application;
using MicroFour.StrataFrame.DBEngine.Data;
using System;
using System.Collections.Generic;
using System.Windows.Forms;

namespace ComplexBOSample
{
    static class Program
    {
        public const string APP_CONNECTION_KEY = "ComplexBOSample";
        public const string APP_CONNECTION_DATABASE = "ComplexBOSample";
        public const string APP_CONNECTION_TITLE = "ComplexBOSample";

        /// <summary>
        /// The main entry point for the application.
        /// </summary>
        [STAThread]
        static void Main()
        {
            //-- Enable visual styles on the application
            Application.EnableVisualStyles();

            //-- Add event handlers for the application events
            StrataFrameApplication.ShowGateway +=
                new StrataFrameApplication.ShowGatewayEventHandler(
                ShowGateway);
            StrataFrameApplication.InitializingApplication +=
                new StrataFrameApplication.InitializingApplicationEventHandler(
                InitApplication);
            StrataFrameApplication.GettingConnectionString +=
                new StrataFrameApplication.GettingConnectionStringEventHandler(
                GettingConnectionString);
            StrataFrameApplication.UnhandledExceptionFound +=
                new StrataFrameApplication.UnhandledExceptionFoundEventHandler(
                UnhandledExceptionFound);
            StrataFrameApplication.ShowLoginAndInitializeForm +=
                new StrataFrameApplication.ShowLoginAndInitializeFormEventHandler(
                ShowLoginAndInitMainForm);

            //-- Run the application
            StrataFrameApplication.RunApplication();
        }

        /// <summary>
        /// Gets the connection string if the application will use a custom method to aquire the connection
        /// string rather than the StrataFrame Connection String Manager (optional)
        /// </summary>
        /// <param name="e"></param>
        /// <remarks></remarks>
        private static void GettingConnectionString(GettingConnectionStringEventArgs e)
        {
            //-- ToDo:  Add any custom connection string initialization code
            //   e.ConnectionString = "mystring"
            e.ConnectionString = ConnectionStringLoader.GetConnectionString(APP_CONNECTION_KEY, APP_CONNECTION_DATABASE, APP_CONNECTION_TITLE);
        }

        /// <summary>
        /// Shows the "Gateway" form (a custom form that gives the user a choice to launch different components
        /// within the application) (optional)
        /// </summary>
        /// <param name="e"></param>
        /// <remarks></remarks>
        private static void ShowGateway(ShowGatewayEventArgs e)
        {
            //-- Inform the application to not show the "Gateway" form again after the main form has closed
            e.ShowGatewayAfterMainFormClose = false;
        }

        /// <summary>
        /// Shows a login form before a main form is shown and allows security to be checked before the application
        /// launches the main form (optional)
        /// </summary>
        /// <param name="e"></param>
        /// <remarks></remarks>
        private static void ShowLoginAndInitMainForm(ShowLoginAndInitFormEventArgs e)
        {
            //-- ToDo: add any code to show a login form and authenticate the user
            //   e.LoginSuccessful = ?
        }

        /// <summary>
        /// Provides a centralized location to add any initialization parameters that need to be set before
        /// the application is loaded and defines the form types used as main forms by the application
        /// </summary>
        /// <param name="e"></param>
        /// <remarks></remarks>
        private static void InitApplication(InitializingApplicationEventArgs e)
        {
            //-- Add the main form type
            //-- If more than one form is added to the collection, they can be chosen by showing a "Gateway" form
            //   and supplying the index of the form to show (At least 1 form type must be added to the collection
            e.Forms.Add(typeof(ComplexBOSample.Form1));

            //-- ToDo:  Add any extra application initialization
            MicroFour.StrataFrame.UI.Localization.MessageKeyType = MicroFour.StrataFrame.Messaging.MessageKeyDataType.XML;
            MicroFour.StrataFrame.UI.Localization.MessageLocaleID = MicroFour.StrataFrame.UI.Localization.GetActiveLanguage(APP_CONNECTION_KEY, "", false); ;
        }

        /// <summary>
        /// Catches any unhandled exception within the application and provides a place to log the information
        /// </summary>
        /// <param name="e"></param>
        /// <remarks></remarks>
        private static void UnhandledExceptionFound(UnhandledExceptionFoundEventArgs e)
        {
            //-- ToDo: add any error logging required.  To prevent the StrataFrame ApplicationErrorForm from showing,
            //   set:
            //   e.Handled = true
        }
    }
}