using MicroFour.StrataFrame.Business;
using MicroFour.StrataFrame.UI.Windows.Forms;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.IO;

namespace ComplexBOSample
{
    public partial class StateBO : MicroFour.StrataFrame.Business.BusinessLayer
    {

        #region Component Implementation

        /// <summary>
        /// Required designer variable.
        /// </summary>
        private System.ComponentModel.IContainer components = null;

        public StateBO()
        {
            InitializeComponent();
        }

        public StateBO(IContainer container)
        {
            container.Add(this);

            InitializeComponent();
        }

        /// <summary> 
        /// Clean up any resources being used.
        /// </summary>
        /// <param name="disposing">true if managed resources should be disposed; otherwise, false.</param>
        protected override void Dispose(bool disposing)
        {
            if (disposing && (components != null))
            {
                components.Dispose();
            }
            base.Dispose(disposing);
        }

        /// <summary>
        /// Required method for Designer support - do not modify
        /// the contents of this method with the code editor.
        /// </summary>
        private void InitializeComponent()
        {
            // 
            // StateBO
            // 
            this.CheckRulesOnCurrentRow += new MicroFour.StrataFrame.Business.BusinessLayer.CheckRulesOnCurrentRowEventHandler(this.StateBO_CheckRulesOnCurrentRow);
            this.SetDefaultValues += new MicroFour.StrataFrame.Business.BusinessLayer.SetDefaultValuesEventHandler(this.StateBO_SetDefaultValues);

        }

        #endregion


        #region BusinessLayer Overriden Methods & Properties

        /// <summary>
        /// The collection of required fields for the business object.
        /// </summary>
        /// <remarks></remarks>
        [Browsable(false), DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public override RequiredFieldsCollection RequiredFields
        {
            get
            {
                return base.RequiredFields;
            }
            set
            {
                base.RequiredFields = value;
            }
        }

        /// <summary>
        /// Defines the constraint that defines the parent-child relationship between this business object type and another business object type.
        /// </summary>
        /// <remarks></remarks>
        [Browsable(false), DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public override IBusinessParentRelationship ParentRelationship
        {
            get
            {
                return base.ParentRelationship;
            }
            set
            {
                base.ParentRelationship = value;
            }
        }

        /// <summary>
        /// Returns all of the field names in a single string in the form of [field1],[field2],...  This must be used in the place of '*' in select statements if Query Notifications are to be registered.
        /// </summary>
        /// <remarks></remarks>
        protected override String AllFieldNames
        {
            get
            {
                return "[StateMasterID],[State],[StateName],[ZipCodeLowest],[ZipCodeHighest],[TrailerLength]";
            }
        }

        /// <summary>
        /// The name of the database that contains the table to which this business object is mapped.
        /// </summary>
        /// <remarks></remarks>
        public override String Database
        {
            get
            {
                return "Sample";
            }
        }

        /// <summary>
        /// The name of the column that is the primary key of the table to which this business object is mapped.
        /// </summary>
        /// <remarks></remarks>
        public override String PrimaryKeyField
        {
            get
            {
                return "StateMasterID";
            }
        }

        /// <summary>
        /// The name of the table in the database to which this business object is mapped.
        /// </summary>
        /// <remarks></remarks>
        public override String TableName
        {
            get
            {
                return "State";
            }
        }

        /// <summary>
        /// The schema of the table in the database to which this business object is mapped.
        /// </summary>
        /// <remarks></remarks>
        public override String TableSchema
        {
            get
            {
                return "dbo";
            }
        }

        /// <summary>
        /// Creates and returns an array of DataColumns that contains the schema for the table.  This is used to prevent a round trip to the server to aquire the initial schema for the internal DataTable.
        /// </summary>
        /// <remarks></remarks>
        protected override DataColumn[] CreateTableSchema()
        {
            return new DataColumn[] {
new DataColumn("StateMasterID", typeof(System.Int32)),
new DataColumn("State", typeof(System.String)),
new DataColumn("StateName", typeof(System.String)),
new DataColumn("ZipCodeLowest", typeof(System.String)),
new DataColumn("ZipCodeHighest", typeof(System.String)),
new DataColumn("TrailerLength", typeof(System.String))};
        }

        protected override void InitFieldTypesAndLengths()
        {
            this.FieldDbTypes = new Dictionary<string, DbType>(6);
            this.FieldDbTypes.Add("StateMasterID", DbType.Int32);
            this.FieldDbTypes.Add("State", DbType.String);
            this.FieldDbTypes.Add("StateName", DbType.String);
            this.FieldDbTypes.Add("ZipCodeLowest", DbType.String);
            this.FieldDbTypes.Add("ZipCodeHighest", DbType.String);
            this.FieldDbTypes.Add("TrailerLength", DbType.String);

            this.FieldLengths = new Dictionary<string, int>(6);
            this.FieldLengths.Add("StateMasterID", 4);
            this.FieldLengths.Add("State", 50);
            this.FieldLengths.Add("StateName", 50);
            this.FieldLengths.Add("ZipCodeLowest", 50);
            this.FieldLengths.Add("ZipCodeHighest", 50);
            this.FieldLengths.Add("TrailerLength", 50);
        }

        /// <summary>
        /// Adds a broken rule to the business object's collection
        /// </summary>
        /// <remarks></remarks>
        protected void AddBrokenRule(StateBOFieldNames Field, string ErrorMessage)
        {
            base.AddBrokenRule(Field, ErrorMessage);
        }

        /// <summary>
        /// Adds a broken rule to the business object's collection
        /// </summary>
        /// <remarks></remarks>
        protected new void AddBrokenRule(string FieldName, string ErrorMessage)
        {
            base.AddBrokenRule(FieldName, ErrorMessage);
        }

        /// <summary>
        /// Adds a broken rules to the business object's collection using the given message key to pull the error message from the localization database
        /// </summary>
        /// <remarks></remarks>
        protected void AddBrokenRuleByKey(StateBOFieldNames Field, string ErrorMessageKey)
        {
            base.AddBrokenRuleByKey(Field, ErrorMessageKey);
        }

        /// <summary>
        /// Adds a broken rules to the business object's collection using the given message key to pull the error message from the localization database
        /// </summary>
        /// <remarks></remarks>
        protected new void AddBrokenRuleByKey(string FieldName, string ErrorMessageKey)
        {
            base.AddBrokenRuleByKey(FieldName, ErrorMessageKey);
        }

        #endregion

        #region Field Properties

        /// <summary>
        /// 
        /// </summary>
        /// <remarks></remarks>
        [Description(""),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden),
         Browsable(false), BusinessFieldDisplayInEditor()]
        public System.Int32 StateMasterID
        {
            get
            {
                if (CurrentRow.RowState == DataRowState.Deleted)
                {
                    return (System.Int32)CurrentRow["StateMasterID", DataRowVersion.Original];
                }
                else
                {
                    return (System.Int32)CurrentRow["StateMasterID"];
                }
            }
            set
            {
                CurrentRow["StateMasterID"] = value;
            }
        }

        /// <summary>
        /// 
        /// </summary>
        /// <remarks></remarks>
        [Description(""),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden),
         Browsable(false), BusinessFieldDisplayInEditor()]
        public System.String State
        {
            get
            {
                if (CurrentRow.RowState == DataRowState.Deleted)
                {
                    return (System.String)CurrentRow["State", DataRowVersion.Original];
                }
                else
                {
                    return (System.String)CurrentRow["State"];
                }
            }
            set
            {
                CurrentRow["State"] = value;
            }
        }

        /// <summary>
        /// 
        /// </summary>
        /// <remarks></remarks>
        [Description(""),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden),
         Browsable(false), BusinessFieldDisplayInEditor()]
        public System.String StateName
        {
            get
            {
                if (CurrentRow.RowState == DataRowState.Deleted)
                {
                    return (System.String)CurrentRow["StateName", DataRowVersion.Original];
                }
                else
                {
                    return (System.String)CurrentRow["StateName"];
                }
            }
            set
            {
                CurrentRow["StateName"] = value;
            }
        }

        /// <summary>
        /// 
        /// </summary>
        /// <remarks></remarks>
        [Description(""),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden),
         Browsable(false), BusinessFieldDisplayInEditor()]
        public System.String ZipCodeLowest
        {
            get
            {
                if (CurrentRow.RowState == DataRowState.Deleted)
                {
                    return (System.String)CurrentRow["ZipCodeLowest", DataRowVersion.Original];
                }
                else
                {
                    return (System.String)CurrentRow["ZipCodeLowest"];
                }
            }
            set
            {
                CurrentRow["ZipCodeLowest"] = value;
            }
        }

        /// <summary>
        /// 
        /// </summary>
        /// <remarks></remarks>
        [Description(""),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden),
         Browsable(false), BusinessFieldDisplayInEditor()]
        public System.String ZipCodeHighest
        {
            get
            {
                if (CurrentRow.RowState == DataRowState.Deleted)
                {
                    return (System.String)CurrentRow["ZipCodeHighest", DataRowVersion.Original];
                }
                else
                {
                    return (System.String)CurrentRow["ZipCodeHighest"];
                }
            }
            set
            {
                CurrentRow["ZipCodeHighest"] = value;
            }
        }

        /// <summary>
        /// 
        /// </summary>
        /// <remarks></remarks>
        [Description(""),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden),
         Browsable(false), BusinessFieldDisplayInEditor()]
        public System.String TrailerLength
        {
            get
            {
                if (CurrentRow.RowState == DataRowState.Deleted)
                {
                    return (System.String)CurrentRow["TrailerLength", DataRowVersion.Original];
                }
                else
                {
                    return (System.String)CurrentRow["TrailerLength"];
                }
            }
            set
            {
                CurrentRow["TrailerLength"] = value;
            }
        }

        #endregion

        #region Nested Types & Field Security

        /// <summary>
        /// Contains all of the field names that belong to the business object.
        /// </summary>
        /// <remarks></remarks>
        public enum StateBOFieldNames
        {
            StateMasterID,
            State,
            StateName,
            ZipCodeLowest,
            ZipCodeHighest,
            TrailerLength,
            CUSTOM_FIELD
        }

        /// <summary>
        /// Gets the System.Type of the enumeration that contains the field names for the business object.
        /// </summary>
        /// <remarks></remarks>
        public override System.Type GetFieldEnumType()
        {
            return typeof(StateBOFieldNames);
        }

        /// <summary>
        /// Gets the System.Type of the enumeration that contains the field names for the business object.
        /// </summary>
        /// <remarks></remarks>
        public override System.Type GetFieldSecurityEventArgsType()
        {
            return typeof(CheckStateBOFieldSecurityEventArgs);
        }

        /// <summary>
        /// A subclass of MicroFour.StrataFrame.Business.CheckFieldSecurityEventArgs that returns the field to check as a custom enumeration for this business object.
        /// </summary>
        /// <remarks></remarks>
        public class CheckStateBOFieldSecurityEventArgs : CheckFieldSecurityEventArgs
        {

            public StateBOFieldNames FieldToCheck
            {
                get
                {
                    return (StateBOFieldNames)base.Field;
                }
            }
        }

        public delegate void CheckFieldSecurityEventHandler(CheckStateBOFieldSecurityEventArgs e);

        /// <summary>
        /// Checks the security on an individual field level if CheckSecurityOnFields is set to true.
        /// </summary>
        /// <remarks></remarks>
        public event CheckFieldSecurityEventHandler CheckFieldSecurity;

        /// <summary>
        /// Called from within the framework to raise the actual event to check individual field security.
        /// </summary>
        /// <remarks></remarks>
        protected override void RaiseCheckFieldSecurityEvent(CheckFieldSecurityEventArgs e)
        {
            this.CheckFieldSecurity((CheckStateBOFieldSecurityEventArgs)e);
        }

        #endregion

        #region Item Property Implementation

        /// <summary>
        /// Initializes the static members of the StateBO class.
        /// </summary>
        /// <remarks></remarks>
        static StateBO()
        {
            //-- Create the new shared dictionary and populate it with an 
            //   instance of each property descriptor
            _PropertyDescriptors = new PropertyDescriptorDictionary(11);
            _PropertyDescriptors.Add("StateMasterID", new Field_StateMasterID_Descriptor());
            _PropertyDescriptors.Add("State", new Field_State_Descriptor());
            _PropertyDescriptors.Add("StateName", new Field_StateName_Descriptor());
            _PropertyDescriptors.Add("ZipCodeLowest", new Field_ZipCodeLowest_Descriptor());
            _PropertyDescriptors.Add("ZipCodeHighest", new Field_ZipCodeHighest_Descriptor());
            _PropertyDescriptors.Add("TrailerLength", new Field_TrailerLength_Descriptor());
        }

        private static bool _AreCustomDescriptorsEvaluated = false;
        protected override bool AreCustomDescriptorsEvaluated
        {
            get
            {
                bool llReturn = _AreCustomDescriptorsEvaluated;
                _AreCustomDescriptorsEvaluated = true;
                return llReturn;
            }
        }

        private static PropertyDescriptorDictionary _PropertyDescriptors;
        protected override PropertyDescriptorDictionary PropertyDescriptors
        {
            get
            {
                return _PropertyDescriptors;
            }
        }

        /// <summary>
        /// A private field used to store the System.Type of this business object for use by the FieldPropertyDescriptor classes.
        /// </summary>
        /// <remarks></remarks>

        private static System.Type _ComponentType = typeof(StateBO);

        /// <summary>
        /// A PropertyDescriptor class used to Get and Set the value of the StateMasterID property.
        /// </summary>
        /// <remarks></remarks>
        private class Field_StateMasterID_Descriptor : MicroFour.StrataFrame.Business.FieldPropertyDescriptor
        {
            public Field_StateMasterID_Descriptor() : base("StateMasterID") { }
            private System.Type _PropertyType = typeof(System.Int32);
            public override object GetValue(Object component)
            {
                return ((StateBO)component).StateMasterID;
            }
            public override void SetValue(Object component, object Value)
            {
                ((StateBO)component).StateMasterID = (System.Int32)Value;
            }
            public override System.Type PropertyType
            {
                get
                {
                    return this._PropertyType;
                }
            }
            public override System.Type ComponentType
            {
                get
                {
                    return _ComponentType;
                }
            }
        }

        /// <summary>
        /// A PropertyDescriptor class used to Get and Set the value of the State property.
        /// </summary>
        /// <remarks></remarks>
        private class Field_State_Descriptor : MicroFour.StrataFrame.Business.FieldPropertyDescriptor
        {
            public Field_State_Descriptor() : base("State") { }
            private System.Type _PropertyType = typeof(System.String);
            public override object GetValue(Object component)
            {
                return ((StateBO)component).State;
            }
            public override void SetValue(Object component, object Value)
            {
                ((StateBO)component).State = (System.String)Value;
            }
            public override System.Type PropertyType
            {
                get
                {
                    return this._PropertyType;
                }
            }
            public override System.Type ComponentType
            {
                get
                {
                    return _ComponentType;
                }
            }
        }

        /// <summary>
        /// A PropertyDescriptor class used to Get and Set the value of the StateName property.
        /// </summary>
        /// <remarks></remarks>
        private class Field_StateName_Descriptor : MicroFour.StrataFrame.Business.FieldPropertyDescriptor
        {
            public Field_StateName_Descriptor() : base("StateName") { }
            private System.Type _PropertyType = typeof(System.String);
            public override object GetValue(Object component)
            {
                return ((StateBO)component).StateName;
            }
            public override void SetValue(Object component, object Value)
            {
                ((StateBO)component).StateName = (System.String)Value;
            }
            public override System.Type PropertyType
            {
                get
                {
                    return this._PropertyType;
                }
            }
            public override System.Type ComponentType
            {
                get
                {
                    return _ComponentType;
                }
            }
        }

        /// <summary>
        /// A PropertyDescriptor class used to Get and Set the value of the ZipCodeLowest property.
        /// </summary>
        /// <remarks></remarks>
        private class Field_ZipCodeLowest_Descriptor : MicroFour.StrataFrame.Business.FieldPropertyDescriptor
        {
            public Field_ZipCodeLowest_Descriptor() : base("ZipCodeLowest") { }
            private System.Type _PropertyType = typeof(System.String);
            public override object GetValue(Object component)
            {
                return ((StateBO)component).ZipCodeLowest;
            }
            public override void SetValue(Object component, object Value)
            {
                ((StateBO)component).ZipCodeLowest = (System.String)Value;
            }
            public override System.Type PropertyType
            {
                get
                {
                    return this._PropertyType;
                }
            }
            public override System.Type ComponentType
            {
                get
                {
                    return _ComponentType;
                }
            }
        }

        /// <summary>
        /// A PropertyDescriptor class used to Get and Set the value of the ZipCodeHighest property.
        /// </summary>
        /// <remarks></remarks>
        private class Field_ZipCodeHighest_Descriptor : MicroFour.StrataFrame.Business.FieldPropertyDescriptor
        {
            public Field_ZipCodeHighest_Descriptor() : base("ZipCodeHighest") { }
            private System.Type _PropertyType = typeof(System.String);
            public override object GetValue(Object component)
            {
                return ((StateBO)component).ZipCodeHighest;
            }
            public override void SetValue(Object component, object Value)
            {
                ((StateBO)component).ZipCodeHighest = (System.String)Value;
            }
            public override System.Type PropertyType
            {
                get
                {
                    return this._PropertyType;
                }
            }
            public override System.Type ComponentType
            {
                get
                {
                    return _ComponentType;
                }
            }
        }

        /// <summary>
        /// A PropertyDescriptor class used to Get and Set the value of the TrailerLength property.
        /// </summary>
        /// <remarks></remarks>
        private class Field_TrailerLength_Descriptor : MicroFour.StrataFrame.Business.FieldPropertyDescriptor
        {
            public Field_TrailerLength_Descriptor() : base("TrailerLength") { }
            private System.Type _PropertyType = typeof(System.String);
            public override object GetValue(Object component)
            {
                return ((StateBO)component).TrailerLength;
            }
            public override void SetValue(Object component, object Value)
            {
                ((StateBO)component).TrailerLength = (System.String)Value;
            }
            public override System.Type PropertyType
            {
                get
                {
                    return this._PropertyType;
                }
            }
            public override System.Type ComponentType
            {
                get
                {
                    return _ComponentType;
                }
            }
        }

        #endregion

    }

}
