using MicroFour.StrataFrame.Tools;
using System.Web.Configuration;
using SFRadGridTestBizLib;

public class ApplicationBasePage : MicroFour.StrataFrame.UI.Web.BasePage, ITypeResolver
{

    #region [ Business Object Declarations ]

    //-- Business Objects defined within this class will be available to 
    //   inherited pages as binding sources to bindable controls.  These 
    //   business objects will also be persisted within session variables 
    //   and retrieved each time the page loads.
    private ProductsBO _productsBO = new ProductsBO();

    public ProductsBO Products
    {
        get
        {
            return _productsBO;
        }
        set
        {
            _productsBO = value;
        }
    }
    #endregion

    #region [ ITypeResolver Implementation ]

    /// <summary>
    /// Must be used by the StrataFrame Application Framework to resolve a 
    /// type within this ASP.NET project due to the fact that the Entry Assembly 
    /// cannot be evaluated in an ASP.NET application.
    /// </summary>
    /// <param name="TypeName"></param>
    /// <returns></returns>
    /// <remarks></remarks>
    public System.Type ResolveType(string TypeName)
    {
        //-- Return the gettype for the given TypeName
        return System.Type.GetType(TypeName, false, true);
    }

    /// <summary>
    /// Required by the base class to allow the StrataFrame Application Framework 
    /// to access the assemblies referenced by this project.
    /// </summary>
    /// <returns></returns>
    /// <remarks></remarks>
    public CompilationSection GetCompilationSection()
    {
        return (CompilationSection)WebConfigurationManager.GetSection("system.web/compilation");
    }

    #endregion

}