using MicroFour.StrataFrame.Business;
using MicroFour.StrataFrame.Security;
using MicroFour.StrataFrame.UI.Windows.Forms;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.IO;

namespace SFRadGridTestBizLib
{
    public partial class ProductsBO
    {

        #region Component Implementation

        /// <summary>
        /// Required designer variable.
        /// </summary>
        private System.ComponentModel.IContainer components = null;

        /// <summary> 
        /// Clean up any resources being used.
        /// </summary>
        /// <param name="disposing">true if managed resources should be disposed; otherwise, false.</param>
        protected override void Dispose(bool disposing)
        {
            if (disposing && (components != null))
            {
                components.Dispose();
            }
            base.Dispose(disposing);
        }

        /// <summary>
        /// Required method for Designer support - do not modify
        /// the contents of this method with the code editor.
        /// </summary>
        private void InitializeComponent()
        {
            components = new System.ComponentModel.Container();

            this.CheckRulesOnCurrentRow += new CheckRulesOnCurrentRowEventHandler(ProductsBO_CheckRulesOnCurrentRow);
            this.SetDefaultValues += new SetDefaultValuesEventHandler(ProductsBO_SetDefaultValues);
        }

        #endregion


        #region BusinessLayer Overriden Methods & Properties

        /// <summary>
        /// The collection of required fields for the business object.
        /// </summary>
        /// <remarks></remarks>
        [Browsable(false), DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public override RequiredFieldsCollection RequiredFields
        {
            get
            {
                return base.RequiredFields;
            }
            set
            {
                base.RequiredFields = value;
            }
        }

        /// <summary>
        /// Defines the constraint that defines the parent-child relationship between this business object type and another business object type.
        /// </summary>
        /// <remarks></remarks>
        [Browsable(false), DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public override IBusinessParentRelationship ParentRelationship
        {
            get
            {
                return base.ParentRelationship;
            }
            set
            {
                base.ParentRelationship = value;
            }
        }

        /// <summary>
        /// Returns all of the field names in a single string in the form of [field1],[field2],...  This must be used in the place of '*' in select statements if Query Notifications are to be registered.
        /// </summary>
        /// <remarks></remarks>
        protected override String AllFieldNames
        {
            get
            {
                return "[prod_pk],[prod_SKU],[prod_Name],[prod_Desc],[prod_Price],[prod_Image],[prod_IsActive],[prod_Created],[prod_Version]";
            }
        }

        /// <summary>
        /// The name of the database that contains the table to which this business object is mapped.
        /// </summary>
        /// <remarks></remarks>
        public override String Database
        {
            get
            {
                return "StrataFrameSample";
            }
        }

        private static string[] _PrimaryKeyFields = new string[] { "prod_pk" };
        /// <summary>
        /// Gets the field or fields that comprise the primary key for the business object.
        /// </summary>
        /// <remarks></remarks>
        public override string[] PrimaryKeyFields
        {
            get
            {
                return _PrimaryKeyFields;
            }
        }

        /// <summary>
        /// The name of the table in the database to which this business object is mapped.
        /// </summary>
        /// <remarks></remarks>
        public override String TableName
        {
            get
            {
                return "Products";
            }
        }

        /// <summary>
        /// The schema of the table in the database to which this business object is mapped.
        /// </summary>
        /// <remarks></remarks>
        public override String TableSchema
        {
            get
            {
                return "dbo";
            }
        }

        /// <summary>
        /// Creates and returns an array of DataColumns that contains the schema for the table.  This is used to prevent a round trip to the server to aquire the initial schema for the internal DataTable.
        /// </summary>
        /// <remarks></remarks>
        protected override DataColumn[] CreateTableSchema()
        {
            return new DataColumn[] {
new DataColumn("prod_pk", typeof(System.Int32)),
new DataColumn("prod_SKU", typeof(System.String)),
new DataColumn("prod_Name", typeof(System.String)),
new DataColumn("prod_Desc", typeof(System.String)),
new DataColumn("prod_Price", typeof(System.Decimal)),
new DataColumn("prod_Image", typeof(System.Byte[])),
new DataColumn("prod_IsActive", typeof(System.Boolean)),
new DataColumn("prod_Created", typeof(System.DateTime)),
new DataColumn("prod_Version", typeof(System.Int32))};
        }

        /// <summary>
        /// Adds a broken rule to the business object's collection
        /// </summary>
        /// <remarks></remarks>
        protected void AddBrokenRule(ProductsBOFieldNames Field, string ErrorMessage)
        {
            base.AddBrokenRule(Field, ErrorMessage);
        }

        /// <summary>
        /// Adds a broken rule to the business object's collection
        /// </summary>
        /// <remarks></remarks>
        protected new void AddBrokenRule(string FieldName, string ErrorMessage)
        {
            base.AddBrokenRule(FieldName, ErrorMessage);
        }

        /// <summary>
        /// Adds a broken rules to the business object's collection using the given message key to pull the error message from the localization database
        /// </summary>
        /// <remarks></remarks>
        protected void AddBrokenRuleByKey(ProductsBOFieldNames Field, string ErrorMessageKey)
        {
            base.AddBrokenRuleByKey(Field, ErrorMessageKey);
        }

        /// <summary>
        /// Adds a broken rules to the business object's collection using the given message key to pull the error message from the localization database
        /// </summary>
        /// <remarks></remarks>
        protected new void AddBrokenRuleByKey(string FieldName, string ErrorMessageKey)
        {
            base.AddBrokenRuleByKey(FieldName, ErrorMessageKey);
        }

        /// <summary>
        /// Gets a collection of the names for all fields that belong to this business object and map to the database.
        /// </summary>
        /// <remarks></remarks>
        public override List<string> AllFieldsList
        {
            get
            {
                return _AllFieldsList;
            }
        }

        /// <summary>
        /// Gets a dictionary of the DbTypes for all fields that belong to this business object and map to the database.
        /// </summary>
        /// <remarks></remarks>
        public override Dictionary<string, DbType> FieldDbTypes
        {
            get
            {
                return _FieldDbTypes;
            }
        }

        /// <summary>
        /// Gets a dictionary of all fields within this business object that map to the FieldNames enumeration for this business object.
        /// </summary>
        /// <remarks></remarks>
        public override BusinessLayerFieldEnumDictionary FieldEnums
        {
            get
            {
                return _FieldEnums;
            }
        }

        /// <summary>
        /// Gets a dictionary of all of the lengths for all fields within this business object that map to a field in the database.
        /// </summary>
        /// <remarks></remarks>
        public override Dictionary<string, int> FieldLengths
        {
            get
            {
                return _FieldLengths;
            }
        }

        /// <summary>
        /// Gets a dictionary of the native DbType (SqlDbType, OracleType, OleDbType, etc.) for all fields within this buisness object that map to a field in the database.
        /// </summary>
        /// <remarks></remarks>
        public override Dictionary<string, int> FieldNativeDbTypes
        {
            get
            {
                return _FieldNativeDbTypes;
            }
        }

        /// <summary>
        /// Gets a dictionary of the security permission keys for each field in the business object.
        /// </summary>
        /// <remarks></remarks>
        public override Dictionary<string, string> FieldPermissionKeys
        {
            get
            {
                return _FieldPermissionKeys;
            }
        }

        #endregion

        #region Field Properties

        /// <summary>
        /// prod_pk
        /// </summary>
        /// <remarks></remarks>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("prod_pk"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.Int32 prod_pk
        {
            get
            {
                return (System.Int32)this.CurrentRow["prod_pk"];
            }
            set
            {
                this.CurrentRow["prod_pk"] = value;
            }
        }

        /// <summary>
        /// prod_SKU
        /// </summary>
        /// <remarks></remarks>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("prod_SKU"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.String prod_SKU
        {
            get
            {
                return (System.String)this.CurrentRow["prod_SKU"];
            }
            set
            {
                this.CurrentRow["prod_SKU"] = value;
            }
        }

        /// <summary>
        /// prod_Name
        /// </summary>
        /// <remarks></remarks>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("prod_Name"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.String prod_Name
        {
            get
            {
                return (System.String)this.CurrentRow["prod_Name"];
            }
            set
            {
                this.CurrentRow["prod_Name"] = value;
            }
        }

        /// <summary>
        /// prod_Desc
        /// </summary>
        /// <remarks></remarks>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("prod_Desc"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.String prod_Desc
        {
            get
            {
                return (System.String)this.CurrentRow["prod_Desc"];
            }
            set
            {
                this.CurrentRow["prod_Desc"] = value;
            }
        }

        /// <summary>
        /// prod_Price
        /// </summary>
        /// <remarks></remarks>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("prod_Price"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.Decimal prod_Price
        {
            get
            {
                return (System.Decimal)this.CurrentRow["prod_Price"];
            }
            set
            {
                this.CurrentRow["prod_Price"] = value;
            }
        }

        /// <summary>
        /// prod_Image
        /// </summary>
        /// <remarks></remarks>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("prod_Image"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.Byte[] prod_Image
        {
            get
            {
                return (System.Byte[])this.CurrentRow["prod_Image"];
            }
            set
            {
                this.CurrentRow["prod_Image"] = value;
            }
        }

        /// <summary>
        /// prod_IsActive
        /// </summary>
        /// <remarks></remarks>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("prod_IsActive"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.Boolean prod_IsActive
        {
            get
            {
                return (System.Boolean)this.CurrentRow["prod_IsActive"];
            }
            set
            {
                this.CurrentRow["prod_IsActive"] = value;
            }
        }

        /// <summary>
        /// prod_Created
        /// </summary>
        /// <remarks></remarks>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("prod_Created"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.DateTime prod_Created
        {
            get
            {
                return (System.DateTime)this.CurrentRow["prod_Created"];
            }
            set
            {
                this.CurrentRow["prod_Created"] = value;
            }
        }

        /// <summary>
        /// prod_Version
        /// </summary>
        /// <remarks></remarks>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("prod_Version"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.Int32 prod_Version
        {
            get
            {
                return (System.Int32)this.CurrentRow["prod_Version"];
            }
            set
            {
                this.CurrentRow["prod_Version"] = value;
            }
        }

        #endregion

        #region Field Property Events

        #endregion

        #region Nested Types & Field Security

        /// <summary>
        /// Contains all of the field names that belong to the business object.
        /// </summary>
        /// <remarks></remarks>
        public enum ProductsBOFieldNames
        {
            prod_pk,
            prod_SKU,
            prod_Name,
            prod_Desc,
            prod_Price,
            prod_Image,
            prod_IsActive,
            prod_Created,
            prod_Version,
            CUSTOM_FIELD
        }

        /// <summary>
        /// Gets the System.Type of the enumeration that contains the field names for the business object.
        /// </summary>
        /// <remarks></remarks>
        public override System.Type GetFieldEnumType()
        {
            return typeof(ProductsBOFieldNames);
        }

        /// <summary>
        /// Creates a new CheckFieldSecurityEventArgs object that can be used with this business object type.
        /// </summary>
        /// <remarks></remarks>
        protected override CheckFieldSecurityEventArgsBase CreateNewFieldSecurityEventArgs(System.Enum Field, string CustomField, string PermissionKey, PermissionInfo Perm)
        {
            return new CheckFieldSecurityEventArgs<ProductsBOFieldNames>(Field, CustomField, PermissionKey, Perm);
        }

        /// <summary>
        /// Describes a method that will handle the CheckFieldScurity event.
        /// </summary>
        /// <remarks></remarks>
        public delegate void CheckFieldSecurityEventHandler(object sender, CheckFieldSecurityEventArgs<ProductsBOFieldNames> e);

        /// <summary>
        /// Occurs when the business objects needs to check the security on a field.
        /// </summary>
        /// <remarks></remarks>
        public event CheckFieldSecurityEventHandler CheckFieldSecurity;

        /// <summary>
        /// Raises the CheckFieldSecurity event.
        /// </summary>
        /// <remarks></remarks>
        protected override void OnCheckFieldSecurity(CheckFieldSecurityEventArgsBase e)
        {
            if (this.CheckFieldSecurity != null)
            {
                this.CheckFieldSecurity(this, (CheckFieldSecurityEventArgs<ProductsBOFieldNames>)e);
            }
        }

        #endregion

        #region Item Property Implementation


        private static List<string> _AllFieldsList;
        private static Dictionary<string, DbType> _FieldDbTypes;
        private static BusinessLayerFieldEnumDictionary _FieldEnums;
        private static Dictionary<string, int> _FieldLengths;
        private static Dictionary<string, int> _FieldNativeDbTypes;
        private static Dictionary<string, string> _FieldPermissionKeys;

        /// <summary>
        /// Initializes the static members of the ProductsBO class.
        /// </summary>
        /// <remarks></remarks>
        static ProductsBO()
        {
            //-- Create the new shared dictionary and populate it with an 
            //   instance of each property descriptor
            _PropertyDescriptors = new PropertyDescriptorDictionary(14);
            _PropertyDescriptors.Add("prod_pk", new Field_prod_pk_Descriptor());
            _PropertyDescriptors.Add("prod_SKU", new Field_prod_SKU_Descriptor());
            _PropertyDescriptors.Add("prod_Name", new Field_prod_Name_Descriptor());
            _PropertyDescriptors.Add("prod_Desc", new Field_prod_Desc_Descriptor());
            _PropertyDescriptors.Add("prod_Price", new Field_prod_Price_Descriptor());
            _PropertyDescriptors.Add("prod_Image", new Field_prod_Image_Descriptor());
            _PropertyDescriptors.Add("prod_IsActive", new Field_prod_IsActive_Descriptor());
            _PropertyDescriptors.Add("prod_Created", new Field_prod_Created_Descriptor());
            _PropertyDescriptors.Add("prod_Version", new Field_prod_Version_Descriptor());

            _AllFieldsList = new List<string>(9);
            _AllFieldsList.Add("prod_pk");
            _AllFieldsList.Add("prod_SKU");
            _AllFieldsList.Add("prod_Name");
            _AllFieldsList.Add("prod_Desc");
            _AllFieldsList.Add("prod_Price");
            _AllFieldsList.Add("prod_Image");
            _AllFieldsList.Add("prod_IsActive");
            _AllFieldsList.Add("prod_Created");
            _AllFieldsList.Add("prod_Version");

            _FieldDbTypes = new Dictionary<string, DbType>(9);
            _FieldDbTypes.Add("prod_pk", DbType.Int32);
            _FieldDbTypes.Add("prod_SKU", DbType.AnsiString);
            _FieldDbTypes.Add("prod_Name", DbType.String);
            _FieldDbTypes.Add("prod_Desc", DbType.String);
            _FieldDbTypes.Add("prod_Price", DbType.Currency);
            _FieldDbTypes.Add("prod_Image", DbType.Binary);
            _FieldDbTypes.Add("prod_IsActive", DbType.Boolean);
            _FieldDbTypes.Add("prod_Created", DbType.DateTime);
            _FieldDbTypes.Add("prod_Version", DbType.Int32);

            _FieldEnums = new BusinessLayerFieldEnumDictionary(10);
            _FieldEnums.Add("prod_pk", ProductsBOFieldNames.prod_pk);
            _FieldEnums.Add("prod_SKU", ProductsBOFieldNames.prod_SKU);
            _FieldEnums.Add("prod_Name", ProductsBOFieldNames.prod_Name);
            _FieldEnums.Add("prod_Desc", ProductsBOFieldNames.prod_Desc);
            _FieldEnums.Add("prod_Price", ProductsBOFieldNames.prod_Price);
            _FieldEnums.Add("prod_Image", ProductsBOFieldNames.prod_Image);
            _FieldEnums.Add("prod_IsActive", ProductsBOFieldNames.prod_IsActive);
            _FieldEnums.Add("prod_Created", ProductsBOFieldNames.prod_Created);
            _FieldEnums.Add("prod_Version", ProductsBOFieldNames.prod_Version);
            _FieldEnums.Add("CUSTOM_FIELD", ProductsBOFieldNames.CUSTOM_FIELD);

            _FieldLengths = new Dictionary<string, int>(9);
            _FieldLengths.Add("prod_pk", 0);
            _FieldLengths.Add("prod_SKU", 20);
            _FieldLengths.Add("prod_Name", 100);
            _FieldLengths.Add("prod_Desc", 1000);
            _FieldLengths.Add("prod_Price", 0);
            _FieldLengths.Add("prod_Image", -1);
            _FieldLengths.Add("prod_IsActive", 0);
            _FieldLengths.Add("prod_Created", 0);
            _FieldLengths.Add("prod_Version", 0);

            _FieldNativeDbTypes = new Dictionary<string, int>(9);
            _FieldNativeDbTypes.Add("prod_pk", (int)System.Data.SqlDbType.Int);
            _FieldNativeDbTypes.Add("prod_SKU", (int)System.Data.SqlDbType.VarChar);
            _FieldNativeDbTypes.Add("prod_Name", (int)System.Data.SqlDbType.NVarChar);
            _FieldNativeDbTypes.Add("prod_Desc", (int)System.Data.SqlDbType.NVarChar);
            _FieldNativeDbTypes.Add("prod_Price", (int)System.Data.SqlDbType.Money);
            _FieldNativeDbTypes.Add("prod_Image", (int)System.Data.SqlDbType.VarBinary);
            _FieldNativeDbTypes.Add("prod_IsActive", (int)System.Data.SqlDbType.Bit);
            _FieldNativeDbTypes.Add("prod_Created", (int)System.Data.SqlDbType.DateTime);
            _FieldNativeDbTypes.Add("prod_Version", (int)System.Data.SqlDbType.Int);

            _FieldPermissionKeys = new Dictionary<string, string>(9);

        }

        private static bool _AreCustomDescriptorsEvaluated = false;
        protected override bool AreCustomDescriptorsEvaluated
        {
            get
            {
                bool llReturn = _AreCustomDescriptorsEvaluated;
                _AreCustomDescriptorsEvaluated = true;
                return llReturn;
            }
        }

        private static PropertyDescriptorDictionary _PropertyDescriptors;
        protected override PropertyDescriptorDictionary PropertyDescriptors
        {
            get
            {
                return _PropertyDescriptors;
            }
        }

        /// <summary>
        /// A private field used to store the System.Type of this business object for use by the FieldPropertyDescriptor classes.
        /// </summary>
        /// <remarks></remarks>

        private static System.Type _ComponentType = typeof(ProductsBO);

        /// <summary>
        /// A PropertyDescriptor class used to Get and Set the value of the prod_pk property.
        /// </summary>
        /// <remarks></remarks>
        private class Field_prod_pk_Descriptor : MicroFour.StrataFrame.Business.FieldPropertyDescriptor
        {
            public Field_prod_pk_Descriptor() : base("prod_pk") { }
            private System.Type _PropertyType = typeof(System.Int32);
            public override object GetValue(Object component)
            {
                return ((ProductsBO)component).prod_pk;
            }
            public override void SetValue(Object component, object Value)
            {
                ((ProductsBO)component).prod_pk = (System.Int32)Value;
            }
            public override System.Type PropertyType
            {
                get
                {
                    return this._PropertyType;
                }
            }
            public override System.Type ComponentType
            {
                get
                {
                    return _ComponentType;
                }
            }
        }

        /// <summary>
        /// A PropertyDescriptor class used to Get and Set the value of the prod_SKU property.
        /// </summary>
        /// <remarks></remarks>
        private class Field_prod_SKU_Descriptor : MicroFour.StrataFrame.Business.FieldPropertyDescriptor
        {
            public Field_prod_SKU_Descriptor() : base("prod_SKU") { }
            private System.Type _PropertyType = typeof(System.String);
            public override object GetValue(Object component)
            {
                return ((ProductsBO)component).prod_SKU;
            }
            public override void SetValue(Object component, object Value)
            {
                ((ProductsBO)component).prod_SKU = (System.String)Value;
            }
            public override System.Type PropertyType
            {
                get
                {
                    return this._PropertyType;
                }
            }
            public override System.Type ComponentType
            {
                get
                {
                    return _ComponentType;
                }
            }
        }

        /// <summary>
        /// A PropertyDescriptor class used to Get and Set the value of the prod_Name property.
        /// </summary>
        /// <remarks></remarks>
        private class Field_prod_Name_Descriptor : MicroFour.StrataFrame.Business.FieldPropertyDescriptor
        {
            public Field_prod_Name_Descriptor() : base("prod_Name") { }
            private System.Type _PropertyType = typeof(System.String);
            public override object GetValue(Object component)
            {
                return ((ProductsBO)component).prod_Name;
            }
            public override void SetValue(Object component, object Value)
            {
                ((ProductsBO)component).prod_Name = (System.String)Value;
            }
            public override System.Type PropertyType
            {
                get
                {
                    return this._PropertyType;
                }
            }
            public override System.Type ComponentType
            {
                get
                {
                    return _ComponentType;
                }
            }
        }

        /// <summary>
        /// A PropertyDescriptor class used to Get and Set the value of the prod_Desc property.
        /// </summary>
        /// <remarks></remarks>
        private class Field_prod_Desc_Descriptor : MicroFour.StrataFrame.Business.FieldPropertyDescriptor
        {
            public Field_prod_Desc_Descriptor() : base("prod_Desc") { }
            private System.Type _PropertyType = typeof(System.String);
            public override object GetValue(Object component)
            {
                return ((ProductsBO)component).prod_Desc;
            }
            public override void SetValue(Object component, object Value)
            {
                ((ProductsBO)component).prod_Desc = (System.String)Value;
            }
            public override System.Type PropertyType
            {
                get
                {
                    return this._PropertyType;
                }
            }
            public override System.Type ComponentType
            {
                get
                {
                    return _ComponentType;
                }
            }
        }

        /// <summary>
        /// A PropertyDescriptor class used to Get and Set the value of the prod_Price property.
        /// </summary>
        /// <remarks></remarks>
        private class Field_prod_Price_Descriptor : MicroFour.StrataFrame.Business.FieldPropertyDescriptor
        {
            public Field_prod_Price_Descriptor() : base("prod_Price") { }
            private System.Type _PropertyType = typeof(System.Decimal);
            public override object GetValue(Object component)
            {
                return ((ProductsBO)component).prod_Price;
            }
            public override void SetValue(Object component, object Value)
            {
                ((ProductsBO)component).prod_Price = (System.Decimal)Value;
            }
            public override System.Type PropertyType
            {
                get
                {
                    return this._PropertyType;
                }
            }
            public override System.Type ComponentType
            {
                get
                {
                    return _ComponentType;
                }
            }
        }

        /// <summary>
        /// A PropertyDescriptor class used to Get and Set the value of the prod_Image property.
        /// </summary>
        /// <remarks></remarks>
        private class Field_prod_Image_Descriptor : MicroFour.StrataFrame.Business.FieldPropertyDescriptor
        {
            public Field_prod_Image_Descriptor() : base("prod_Image") { }
            private System.Type _PropertyType = typeof(System.Byte[]);
            public override object GetValue(Object component)
            {
                return ((ProductsBO)component).prod_Image;
            }
            public override void SetValue(Object component, object Value)
            {
                ((ProductsBO)component).prod_Image = (System.Byte[])Value;
            }
            public override System.Type PropertyType
            {
                get
                {
                    return this._PropertyType;
                }
            }
            public override System.Type ComponentType
            {
                get
                {
                    return _ComponentType;
                }
            }
        }

        /// <summary>
        /// A PropertyDescriptor class used to Get and Set the value of the prod_IsActive property.
        /// </summary>
        /// <remarks></remarks>
        private class Field_prod_IsActive_Descriptor : MicroFour.StrataFrame.Business.FieldPropertyDescriptor
        {
            public Field_prod_IsActive_Descriptor() : base("prod_IsActive") { }
            private System.Type _PropertyType = typeof(System.Boolean);
            public override object GetValue(Object component)
            {
                return ((ProductsBO)component).prod_IsActive;
            }
            public override void SetValue(Object component, object Value)
            {
                ((ProductsBO)component).prod_IsActive = (System.Boolean)Value;
            }
            public override System.Type PropertyType
            {
                get
                {
                    return this._PropertyType;
                }
            }
            public override System.Type ComponentType
            {
                get
                {
                    return _ComponentType;
                }
            }
        }

        /// <summary>
        /// A PropertyDescriptor class used to Get and Set the value of the prod_Created property.
        /// </summary>
        /// <remarks></remarks>
        private class Field_prod_Created_Descriptor : MicroFour.StrataFrame.Business.FieldPropertyDescriptor
        {
            public Field_prod_Created_Descriptor() : base("prod_Created") { }
            private System.Type _PropertyType = typeof(System.DateTime);
            public override object GetValue(Object component)
            {
                return ((ProductsBO)component).prod_Created;
            }
            public override void SetValue(Object component, object Value)
            {
                ((ProductsBO)component).prod_Created = (System.DateTime)Value;
            }
            public override System.Type PropertyType
            {
                get
                {
                    return this._PropertyType;
                }
            }
            public override System.Type ComponentType
            {
                get
                {
                    return _ComponentType;
                }
            }
        }

        /// <summary>
        /// A PropertyDescriptor class used to Get and Set the value of the prod_Version property.
        /// </summary>
        /// <remarks></remarks>
        private class Field_prod_Version_Descriptor : MicroFour.StrataFrame.Business.FieldPropertyDescriptor
        {
            public Field_prod_Version_Descriptor() : base("prod_Version") { }
            private System.Type _PropertyType = typeof(System.Int32);
            public override object GetValue(Object component)
            {
                return ((ProductsBO)component).prod_Version;
            }
            public override void SetValue(Object component, object Value)
            {
                ((ProductsBO)component).prod_Version = (System.Int32)Value;
            }
            public override System.Type PropertyType
            {
                get
                {
                    return this._PropertyType;
                }
            }
            public override System.Type ComponentType
            {
                get
                {
                    return _ComponentType;
                }
            }
        }

        #endregion

    }

}
