﻿Option Strict On
Option Explicit On

Imports MicroFour.StrataFrame.Business
Imports MicroFour.StrataFrame.UI.Windows.Forms
Imports System.Collections.Generic
Imports System.ComponentModel
Imports System.Data
Imports System.IO

Namespace ComplexBOSample

    Partial Public Class StateBO
        Inherits MicroFour.StrataFrame.Business.BusinessLayer

#Region " Component Implementation "

        <System.Diagnostics.DebuggerNonUserCodeAttribute()> _
        Public Sub New()
            MyBase.New()
            'This call is required by the Component Designer.
            Me.InitializeComponent()
        End Sub

        <System.Diagnostics.DebuggerNonUserCodeAttribute()> _
        Public Sub New(ByVal Container As System.ComponentModel.IContainer)
            MyBase.New()
            'This call adds the component to the given container.
            Container.Add(Me)
            'This call is required by the Component Designer.
            Me.InitializeComponent()
        End Sub

        <System.Diagnostics.DebuggerNonUserCodeAttribute()> _
        Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
            If (disposing _
               AndAlso (Not (Me.components) Is Nothing)) Then
                Me.components.Dispose()
            End If
            MyBase.Dispose(disposing)
        End Sub

        Private components As System.ComponentModel.IContainer

        'NOTE: The following procedure is required by the Component Designer
        'It can be modified using the Component Designer.
        'Do not modify it using the code editor.
        <System.Diagnostics.DebuggerNonUserCodeAttribute()> _
        Private Sub InitializeComponent()
            '
            'StateBO
            '
        End Sub

#End Region

#Region " BusinessLayer Overriden Methods & Properties "

        ''' <summary>
        ''' The collection of required fields for the business object.
        ''' </summary>
        ''' <remarks></remarks>
        <Browsable(False), DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)> _
        Public Overrides Property RequiredFields() As RequiredFieldsCollection
            Get
                Return MyBase.RequiredFields
            End Get
            Set(ByVal value As RequiredFieldsCollection)
                MyBase.RequiredFields = value
            End Set
        End Property

        ''' <summary>
        ''' Defines the constraint that defines the parent-child relationship between this business object type and another business object type.
        ''' </summary>
        ''' <remarks></remarks>
        <Browsable(False), DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)> _
        Public Overrides Property ParentRelationship() As IBusinessParentRelationship
            Get
                Return MyBase.ParentRelationship
            End Get
            Set(ByVal value As IBusinessParentRelationship)
                MyBase.ParentRelationship = value
            End Set
        End Property

        ''' <summary>
        ''' Returns all of the field names in a single string in the form of [field1],[field2],...  This must be used in the place of '*' in select statements if Query Notifications are to be registered.
        ''' </summary>
        ''' <remarks></remarks>
        Protected Overrides ReadOnly Property AllFieldNames() As String
            Get
                Return "[StateMasterID],[State],[StateName],[ZipCodeLowest],[ZipCodeHighest],[TrailerLength]"
            End Get
        End Property

        ''' <summary>
        ''' The name of the database that contains the table to which this business object is mapped.
        ''' </summary>
        ''' <remarks></remarks>
        Public Overrides ReadOnly Property Database() As String
            Get
                Return "Sample"
            End Get
        End Property

        ''' <summary>
        ''' The name of the column that is the primary key of the table to which this business object is mapped.
        ''' </summary>
        ''' <remarks></remarks>
        Public Overrides ReadOnly Property PrimaryKeyField() As String
            Get
                Return "StateMasterID"
            End Get
        End Property

        ''' <summary>
        ''' The name of the table in the database to which this business object is mapped.
        ''' </summary>
        ''' <remarks></remarks>
        Public Overrides ReadOnly Property TableName() As String
            Get
                Return "State"
            End Get
        End Property

        ''' <summary>
        ''' The schema of the table in the database to which this business object is mapped.
        ''' </summary>
        ''' <remarks></remarks>
        Public Overrides ReadOnly Property TableSchema() As String
            Get
                Return "dbo"
            End Get
        End Property

        ''' <summary>
        ''' Creates and returns an array of DataColumns that contains the schema for the table.  This is used to prevent a round trip to the server to aquire the initial schema for the internal DataTable.
        ''' </summary>
        ''' <remarks></remarks>
        Protected Overrides Function CreateTableSchema() As DataColumn()
            Return New DataColumn() { _
            New DataColumn("StateMasterID", GetType(System.Int32)), _
            New DataColumn("State", GetType(System.String)), _
            New DataColumn("StateName", GetType(System.String)), _
            New DataColumn("ZipCodeLowest", GetType(System.String)), _
            New DataColumn("ZipCodeHighest", GetType(System.String)), _
            New DataColumn("TrailerLength", GetType(System.String))}
        End Function

        Protected Overrides Sub InitFieldTypesAndLengths()
            Me.FieldDbTypes = New Dictionary(Of String, DbType)(6)
            Me.FieldDbTypes.Add("StateMasterID", DbType.Int32)
            Me.FieldDbTypes.Add("State", DbType.String)
            Me.FieldDbTypes.Add("StateName", DbType.String)
            Me.FieldDbTypes.Add("ZipCodeLowest", DbType.String)
            Me.FieldDbTypes.Add("ZipCodeHighest", DbType.String)
            Me.FieldDbTypes.Add("TrailerLength", DbType.String)

            Me.FieldLengths = New Dictionary(Of String, Integer)(6)
            Me.FieldLengths.Add("StateMasterID", 4)
            Me.FieldLengths.Add("State", 50)
            Me.FieldLengths.Add("StateName", 50)
            Me.FieldLengths.Add("ZipCodeLowest", 50)
            Me.FieldLengths.Add("ZipCodeHighest", 50)
            Me.FieldLengths.Add("TrailerLength", 50)
        End Sub

        ''' <summary>
        ''' Adds a broken rule to the business object's collection
        ''' </summary>
        ''' <remarks></remarks>
        Protected Shadows Sub AddBrokenRule(ByVal Field As StateBOFieldNames, ByVal ErrorMessage As String)
            MyBase.AddBrokenRule(Field, ErrorMessage)
        End Sub

        ''' <summary>
        ''' Adds a broken rule to the business object's collection
        ''' </summary>
        ''' <remarks></remarks>
        Protected Shadows Sub AddBrokenRule(ByVal FieldName As String, ByVal ErrorMessage As String)
            MyBase.AddBrokenRule(FieldName, ErrorMessage)
        End Sub

        ''' <summary>
        ''' Adds a broken rules to the business object's collection using the given message key to pull the error message from the localization database
        ''' </summary>
        ''' <remarks></remarks>
        Protected Shadows Sub AddBrokenRuleByKey(ByVal Field As StateBOFieldNames, ByVal ErrorMessageKey As String)
            MyBase.AddBrokenRuleByKey(Field, ErrorMessageKey)
        End Sub

        ''' <summary>
        ''' Adds a broken rules to the business object's collection using the given message key to pull the error message from the localization database
        ''' </summary>
        ''' <remarks></remarks>
        Protected Shadows Sub AddBrokenRuleByKey(ByVal FieldName As String, ByVal ErrorMessageKey As String)
            MyBase.AddBrokenRuleByKey(FieldName, ErrorMessageKey)
        End Sub

#End Region

#Region " Field Properties "

        ''' <summary>
        ''' 
        ''' </summary>
        ''' <remarks></remarks>
        <Description(""), _
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden), _
         Browsable(False), BusinessFieldDisplayInEditor()> _
        Public Property [StateMasterID]() As System.Int32
            Get
                If (CurrentRow.RowState = DataRowState.Deleted) Then
                    Return CType(CurrentRow.Item("StateMasterID", DataRowVersion.Original), System.Int32)
                Else
                    Return CType(CurrentRow.Item("StateMasterID"), System.Int32)
                End If
            End Get
            Set(ByVal value As System.Int32)
                CurrentRow.Item("StateMasterID") = value
            End Set
        End Property

        ''' <summary>
        ''' 
        ''' </summary>
        ''' <remarks></remarks>
        <Description(""), _
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden), _
         Browsable(False), BusinessFieldDisplayInEditor()> _
        Public Property [State]() As System.String
            Get
                If (CurrentRow.RowState = DataRowState.Deleted) Then
                    Return CType(CurrentRow.Item("State", DataRowVersion.Original), System.String)
                Else
                    Return CType(CurrentRow.Item("State"), System.String)
                End If
            End Get
            Set(ByVal value As System.String)
                CurrentRow.Item("State") = value
            End Set
        End Property

        ''' <summary>
        ''' 
        ''' </summary>
        ''' <remarks></remarks>
        <Description(""), _
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden), _
         Browsable(False), BusinessFieldDisplayInEditor()> _
        Public Property [StateName]() As System.String
            Get
                If (CurrentRow.RowState = DataRowState.Deleted) Then
                    Return CType(CurrentRow.Item("StateName", DataRowVersion.Original), System.String)
                Else
                    Return CType(CurrentRow.Item("StateName"), System.String)
                End If
            End Get
            Set(ByVal value As System.String)
                CurrentRow.Item("StateName") = value
            End Set
        End Property

        ''' <summary>
        ''' 
        ''' </summary>
        ''' <remarks></remarks>
        <Description(""), _
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden), _
         Browsable(False), BusinessFieldDisplayInEditor()> _
        Public Property [ZipCodeLowest]() As System.String
            Get
                If (CurrentRow.RowState = DataRowState.Deleted) Then
                    Return CType(CurrentRow.Item("ZipCodeLowest", DataRowVersion.Original), System.String)
                Else
                    Return CType(CurrentRow.Item("ZipCodeLowest"), System.String)
                End If
            End Get
            Set(ByVal value As System.String)
                CurrentRow.Item("ZipCodeLowest") = value
            End Set
        End Property

        ''' <summary>
        ''' 
        ''' </summary>
        ''' <remarks></remarks>
        <Description(""), _
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden), _
         Browsable(False), BusinessFieldDisplayInEditor()> _
        Public Property [ZipCodeHighest]() As System.String
            Get
                If (CurrentRow.RowState = DataRowState.Deleted) Then
                    Return CType(CurrentRow.Item("ZipCodeHighest", DataRowVersion.Original), System.String)
                Else
                    Return CType(CurrentRow.Item("ZipCodeHighest"), System.String)
                End If
            End Get
            Set(ByVal value As System.String)
                CurrentRow.Item("ZipCodeHighest") = value
            End Set
        End Property

        ''' <summary>
        ''' 
        ''' </summary>
        ''' <remarks></remarks>
        <Description(""), _
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden), _
         Browsable(False), BusinessFieldDisplayInEditor()> _
        Public Property [TrailerLength]() As System.String
            Get
                If (CurrentRow.RowState = DataRowState.Deleted) Then
                    Return CType(CurrentRow.Item("TrailerLength", DataRowVersion.Original), System.String)
                Else
                    Return CType(CurrentRow.Item("TrailerLength"), System.String)
                End If
            End Get
            Set(ByVal value As System.String)
                CurrentRow.Item("TrailerLength") = value
            End Set
        End Property

#End Region

#Region " Nested Types & Field Security "

        ''' <summary>
        ''' Contains all of the field names that belong to the business object.
        ''' </summary>
        ''' <remarks></remarks>
        Public Enum StateBOFieldNames As Integer
            [StateMasterID]
            [State]
            [StateName]
            [ZipCodeLowest]
            [ZipCodeHighest]
            [TrailerLength]
            CUSTOM_FIELD
        End Enum

        ''' <summary>
        ''' Gets the System.Type of the enumeration that contains the field names for the business object.
        ''' </summary>
        ''' <remarks></remarks>
        Public Overrides Function GetFieldEnumType() As System.Type
            Return GetType(StateBOFieldNames)
        End Function

        ''' <summary>
        ''' Gets the System.Type of the enumeration that contains the field names for the business object.
        ''' </summary>
        ''' <remarks></remarks>
        Public Overrides Function GetFieldSecurityEventArgsType() As System.Type
            Return GetType(CheckStateBOFieldSecurityEventArgs)
        End Function

        ''' <summary>
        ''' A subclass of MicroFour.StrataFrame.Business.CheckFieldSecurityEventArgs that returns the field to check as a custom enumeration for this business object.
        ''' </summary>
        ''' <remarks></remarks>
        Public Class CheckStateBOFieldSecurityEventArgs
            Inherits CheckFieldSecurityEventArgs

            Public ReadOnly Property FieldToCheck() As StateBOFieldNames
                Get
                    Return CType(MyBase.Field, StateBOFieldNames)
                End Get
            End Property

        End Class

        ''' <summary>
        ''' Checks the security on an individual field level if CheckSecurityOnFields is set to true.
        ''' </summary>
        ''' <remarks></remarks>
        Public Event CheckFieldSecurity(ByVal e As CheckStateBOFieldSecurityEventArgs)

        ''' <summary>
        ''' Called from within the framework to raise the actual event to check individual field security.
        ''' </summary>
        ''' <remarks></remarks>
        Protected Overrides Sub RaiseCheckFieldSecurityEvent(ByVal e As CheckFieldSecurityEventArgs)
            RaiseEvent CheckFieldSecurity(CType(e, CheckStateBOFieldSecurityEventArgs))
        End Sub

#End Region

#Region " Item Property Implementation "

        ''' <summary>
        ''' Initializes the shared members of the StateBO class.
        ''' </summary>
        ''' <remarks></remarks>
        Shared Sub New()
            '-- Create the new shared dictionary and populate it with an 
            '   instance of each property descriptor
            _PropertyDescriptors = New PropertyDescriptorDictionary(11)
            _PropertyDescriptors.Add("StateMasterID", New Field_StateMasterID_Descriptor())
            _PropertyDescriptors.Add("State", New Field_State_Descriptor())
            _PropertyDescriptors.Add("StateName", New Field_StateName_Descriptor())
            _PropertyDescriptors.Add("ZipCodeLowest", New Field_ZipCodeLowest_Descriptor())
            _PropertyDescriptors.Add("ZipCodeHighest", New Field_ZipCodeHighest_Descriptor())
            _PropertyDescriptors.Add("TrailerLength", New Field_TrailerLength_Descriptor())
        End Sub

        Private Shared _AreCustomDescriptorsEvaluated As Boolean = False
        Protected Overrides ReadOnly Property AreCustomDescriptorsEvaluated() As Boolean
            Get
                Dim llReturn As Boolean = _AreCustomDescriptorsEvaluated
                _AreCustomDescriptorsEvaluated = True
                Return llReturn
            End Get
        End Property

        Private Shared _PropertyDescriptors As PropertyDescriptorDictionary
        Protected Overrides ReadOnly Property PropertyDescriptors() As PropertyDescriptorDictionary
            Get
                Return _PropertyDescriptors
            End Get
        End Property

        ''' <summary>
        ''' A private field used to store the System.Type of this business object for use by the FieldPropertyDescriptor classes.
        ''' </summary>
        ''' <remarks></remarks>

        Private Shared _ComponentType As System.Type = GetType(StateBO)

        ''' <summary>
        ''' A PropertyDescriptor class used to Get and Set the value of the StateMasterID property.
        ''' </summary>
        ''' <remarks></remarks>
        Private Class Field_StateMasterID_Descriptor
            Inherits MicroFour.StrataFrame.Business.FieldPropertyDescriptor
            Public Sub New()
                MyBase.New("StateMasterID")
            End Sub
            Private _PropertyType As System.Type = GetType(System.Int32)
            Public Overrides Function GetValue(ByVal component As Object) As Object
                Return CType(component, StateBO).StateMasterID
            End Function
            Public Overrides Sub SetValue(ByVal component As Object, ByVal Value As Object)
                CType(component, StateBO).StateMasterID = CType(Value, System.Int32)
            End Sub
            Public Overrides ReadOnly Property PropertyType() As System.Type
                Get
                    Return Me._PropertyType
                End Get
            End Property
            Public Overrides ReadOnly Property ComponentType() As System.Type
                Get
                    Return _ComponentType
                End Get
            End Property
        End Class

        ''' <summary>
        ''' A PropertyDescriptor class used to Get and Set the value of the State property.
        ''' </summary>
        ''' <remarks></remarks>
        Private Class Field_State_Descriptor
            Inherits MicroFour.StrataFrame.Business.FieldPropertyDescriptor
            Public Sub New()
                MyBase.New("State")
            End Sub
            Private _PropertyType As System.Type = GetType(System.String)
            Public Overrides Function GetValue(ByVal component As Object) As Object
                Return CType(component, StateBO).State
            End Function
            Public Overrides Sub SetValue(ByVal component As Object, ByVal Value As Object)
                CType(component, StateBO).State = CType(Value, System.String)
            End Sub
            Public Overrides ReadOnly Property PropertyType() As System.Type
                Get
                    Return Me._PropertyType
                End Get
            End Property
            Public Overrides ReadOnly Property ComponentType() As System.Type
                Get
                    Return _ComponentType
                End Get
            End Property
        End Class

        ''' <summary>
        ''' A PropertyDescriptor class used to Get and Set the value of the StateName property.
        ''' </summary>
        ''' <remarks></remarks>
        Private Class Field_StateName_Descriptor
            Inherits MicroFour.StrataFrame.Business.FieldPropertyDescriptor
            Public Sub New()
                MyBase.New("StateName")
            End Sub
            Private _PropertyType As System.Type = GetType(System.String)
            Public Overrides Function GetValue(ByVal component As Object) As Object
                Return CType(component, StateBO).StateName
            End Function
            Public Overrides Sub SetValue(ByVal component As Object, ByVal Value As Object)
                CType(component, StateBO).StateName = CType(Value, System.String)
            End Sub
            Public Overrides ReadOnly Property PropertyType() As System.Type
                Get
                    Return Me._PropertyType
                End Get
            End Property
            Public Overrides ReadOnly Property ComponentType() As System.Type
                Get
                    Return _ComponentType
                End Get
            End Property
        End Class

        ''' <summary>
        ''' A PropertyDescriptor class used to Get and Set the value of the ZipCodeLowest property.
        ''' </summary>
        ''' <remarks></remarks>
        Private Class Field_ZipCodeLowest_Descriptor
            Inherits MicroFour.StrataFrame.Business.FieldPropertyDescriptor
            Public Sub New()
                MyBase.New("ZipCodeLowest")
            End Sub
            Private _PropertyType As System.Type = GetType(System.String)
            Public Overrides Function GetValue(ByVal component As Object) As Object
                Return CType(component, StateBO).ZipCodeLowest
            End Function
            Public Overrides Sub SetValue(ByVal component As Object, ByVal Value As Object)
                CType(component, StateBO).ZipCodeLowest = CType(Value, System.String)
            End Sub
            Public Overrides ReadOnly Property PropertyType() As System.Type
                Get
                    Return Me._PropertyType
                End Get
            End Property
            Public Overrides ReadOnly Property ComponentType() As System.Type
                Get
                    Return _ComponentType
                End Get
            End Property
        End Class

        ''' <summary>
        ''' A PropertyDescriptor class used to Get and Set the value of the ZipCodeHighest property.
        ''' </summary>
        ''' <remarks></remarks>
        Private Class Field_ZipCodeHighest_Descriptor
            Inherits MicroFour.StrataFrame.Business.FieldPropertyDescriptor
            Public Sub New()
                MyBase.New("ZipCodeHighest")
            End Sub
            Private _PropertyType As System.Type = GetType(System.String)
            Public Overrides Function GetValue(ByVal component As Object) As Object
                Return CType(component, StateBO).ZipCodeHighest
            End Function
            Public Overrides Sub SetValue(ByVal component As Object, ByVal Value As Object)
                CType(component, StateBO).ZipCodeHighest = CType(Value, System.String)
            End Sub
            Public Overrides ReadOnly Property PropertyType() As System.Type
                Get
                    Return Me._PropertyType
                End Get
            End Property
            Public Overrides ReadOnly Property ComponentType() As System.Type
                Get
                    Return _ComponentType
                End Get
            End Property
        End Class

        ''' <summary>
        ''' A PropertyDescriptor class used to Get and Set the value of the TrailerLength property.
        ''' </summary>
        ''' <remarks></remarks>
        Private Class Field_TrailerLength_Descriptor
            Inherits MicroFour.StrataFrame.Business.FieldPropertyDescriptor
            Public Sub New()
                MyBase.New("TrailerLength")
            End Sub
            Private _PropertyType As System.Type = GetType(System.String)
            Public Overrides Function GetValue(ByVal component As Object) As Object
                Return CType(component, StateBO).TrailerLength
            End Function
            Public Overrides Sub SetValue(ByVal component As Object, ByVal Value As Object)
                CType(component, StateBO).TrailerLength = CType(Value, System.String)
            End Sub
            Public Overrides ReadOnly Property PropertyType() As System.Type
                Get
                    Return Me._PropertyType
                End Get
            End Property
            Public Overrides ReadOnly Property ComponentType() As System.Type
                Get
                    Return _ComponentType
                End Get
            End Property
        End Class

#End Region

    End Class

End Namespace
