﻿Option Strict On
Option Explicit On

Imports MicroFour.StrataFrame.Business
Imports MicroFour.StrataFrame.UI.Windows.Forms
Imports System.Collections.Generic
Imports System.ComponentModel
Imports System.Data
Imports System.IO

Partial Public Class CompanyBO
    Inherits MicroFour.StrataFrame.Business.BusinessLayer

#Region " Component Implementation "

    <System.Diagnostics.DebuggerNonUserCodeAttribute()> _
    Public Sub New()
        MyBase.New()
        'This call is required by the Component Designer.
        Me.InitializeComponent()
    End Sub

    <System.Diagnostics.DebuggerNonUserCodeAttribute()> _
    Public Sub New(ByVal Container As System.ComponentModel.IContainer)
        MyBase.New()
        'This call adds the component to the given container.
        Container.Add(Me)
        'This call is required by the Component Designer.
        Me.InitializeComponent()
    End Sub

    <System.Diagnostics.DebuggerNonUserCodeAttribute()> _
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If (disposing _
           AndAlso (Not (Me.components) Is Nothing)) Then
            Me.components.Dispose()
        End If
        MyBase.Dispose(disposing)
    End Sub

    Private components As System.ComponentModel.IContainer

    'NOTE: The following procedure is required by the Component Designer
    'It can be modified using the Component Designer.
    'Do not modify it using the code editor.
    <System.Diagnostics.DebuggerNonUserCodeAttribute()> _
    Private Sub InitializeComponent()
        '
        'CompanyBO
        '
    End Sub

#End Region

#Region " BusinessLayer Overriden Methods & Properties "

    ''' <summary>
    ''' The collection of required fields for the business object.
    ''' </summary>
    ''' <remarks></remarks>
    <Browsable(False), DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)> _
    Public Overrides Property RequiredFields() As RequiredFieldsCollection
        Get
            Return MyBase.RequiredFields
        End Get
        Set(ByVal value As RequiredFieldsCollection)
            MyBase.RequiredFields = value
        End Set
    End Property

    ''' <summary>
    ''' Defines the constraint that defines the parent-child relationship between this business object type and another business object type.
    ''' </summary>
    ''' <remarks></remarks>
    <Browsable(False), DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)> _
    Public Overrides Property ParentRelationship() As IBusinessParentRelationship
        Get
            Return MyBase.ParentRelationship
        End Get
        Set(ByVal value As IBusinessParentRelationship)
            MyBase.ParentRelationship = value
        End Set
    End Property

    ''' <summary>
    ''' Returns all of the field names in a single string in the form of [field1],[field2],...  This must be used in the place of '*' in select statements if Query Notifications are to be registered.
    ''' </summary>
    ''' <remarks></remarks>
    Protected Overrides ReadOnly Property AllFieldNames() As String
        Get
            Return "[CompanyMasterID],[CompanyID],[CompanyName],[AddressLine1],[AddressLine2],[City],[State],[ZipCode]"
        End Get
    End Property

    ''' <summary>
    ''' The name of the database that contains the table to which this business object is mapped.
    ''' </summary>
    ''' <remarks></remarks>
    Public Overrides ReadOnly Property Database() As String
        Get
            Return "Sample"
        End Get
    End Property

    ''' <summary>
    ''' The name of the column that is the primary key of the table to which this business object is mapped.
    ''' </summary>
    ''' <remarks></remarks>
    Public Overrides ReadOnly Property PrimaryKeyField() As String
        Get
            Return "CompanyMasterID"
        End Get
    End Property

    ''' <summary>
    ''' The name of the table in the database to which this business object is mapped.
    ''' </summary>
    ''' <remarks></remarks>
    Public Overrides ReadOnly Property TableName() As String
        Get
            Return "Company"
        End Get
    End Property

    ''' <summary>
    ''' The schema of the table in the database to which this business object is mapped.
    ''' </summary>
    ''' <remarks></remarks>
    Public Overrides ReadOnly Property TableSchema() As String
        Get
            Return "dbo"
        End Get
    End Property

    ''' <summary>
    ''' Creates and returns an array of DataColumns that contains the schema for the table.  This is used to prevent a round trip to the server to aquire the initial schema for the internal DataTable.
    ''' </summary>
    ''' <remarks></remarks>
    Protected Overrides Function CreateTableSchema() As DataColumn()
        Return New DataColumn() { _
        New DataColumn("CompanyMasterID", GetType(System.Int32)), _
        New DataColumn("CompanyID", GetType(System.String)), _
        New DataColumn("CompanyName", GetType(System.String)), _
        New DataColumn("AddressLine1", GetType(System.String)), _
        New DataColumn("AddressLine2", GetType(System.String)), _
        New DataColumn("City", GetType(System.String)), _
        New DataColumn("State", GetType(System.String)), _
        New DataColumn("ZipCode", GetType(System.String))}
    End Function

    Protected Overrides Sub InitFieldTypesAndLengths()
        Me.FieldDbTypes = New Dictionary(Of String, DbType)(8)
        Me.FieldDbTypes.Add("CompanyMasterID", DbType.Int32)
        Me.FieldDbTypes.Add("CompanyID", DbType.String)
        Me.FieldDbTypes.Add("CompanyName", DbType.String)
        Me.FieldDbTypes.Add("AddressLine1", DbType.AnsiString)
        Me.FieldDbTypes.Add("AddressLine2", DbType.String)
        Me.FieldDbTypes.Add("City", DbType.String)
        Me.FieldDbTypes.Add("State", DbType.String)
        Me.FieldDbTypes.Add("ZipCode", DbType.String)

        Me.FieldLengths = New Dictionary(Of String, Integer)(8)
        Me.FieldLengths.Add("CompanyMasterID", 4)
        Me.FieldLengths.Add("CompanyID", 50)
        Me.FieldLengths.Add("CompanyName", 50)
        Me.FieldLengths.Add("AddressLine1", 10)
        Me.FieldLengths.Add("AddressLine2", 50)
        Me.FieldLengths.Add("City", 16)
        Me.FieldLengths.Add("State", 50)
        Me.FieldLengths.Add("ZipCode", 50)
    End Sub

    ''' <summary>
    ''' Adds a broken rule to the business object's collection
    ''' </summary>
    ''' <remarks></remarks>
    Protected Shadows Sub AddBrokenRule(ByVal Field As CompanyBOFieldNames, ByVal ErrorMessage As String)
        MyBase.AddBrokenRule(Field, ErrorMessage)
    End Sub

    ''' <summary>
    ''' Adds a broken rule to the business object's collection
    ''' </summary>
    ''' <remarks></remarks>
    Protected Shadows Sub AddBrokenRule(ByVal FieldName As String, ByVal ErrorMessage As String)
        MyBase.AddBrokenRule(FieldName, ErrorMessage)
    End Sub

    ''' <summary>
    ''' Adds a broken rules to the business object's collection using the given message key to pull the error message from the localization database
    ''' </summary>
    ''' <remarks></remarks>
    Protected Shadows Sub AddBrokenRuleByKey(ByVal Field As CompanyBOFieldNames, ByVal ErrorMessageKey As String)
        MyBase.AddBrokenRuleByKey(Field, ErrorMessageKey)
    End Sub

    ''' <summary>
    ''' Adds a broken rules to the business object's collection using the given message key to pull the error message from the localization database
    ''' </summary>
    ''' <remarks></remarks>
    Protected Shadows Sub AddBrokenRuleByKey(ByVal FieldName As String, ByVal ErrorMessageKey As String)
        MyBase.AddBrokenRuleByKey(FieldName, ErrorMessageKey)
    End Sub

#End Region

#Region " Field Properties "

    ''' <summary>
    ''' 
    ''' </summary>
    ''' <remarks></remarks>
    <Description(""), _
     DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden), _
     Browsable(False), BusinessFieldDisplayInEditor()> _
    Public Property [CompanyMasterID]() As System.Int32
        Get
            If (CurrentRow.RowState = DataRowState.Deleted) Then
                Return CType(CurrentRow.Item("CompanyMasterID", DataRowVersion.Original), System.Int32)
            Else
                Return CType(CurrentRow.Item("CompanyMasterID"), System.Int32)
            End If
        End Get
        Set(ByVal value As System.Int32)
            CurrentRow.Item("CompanyMasterID") = value
        End Set
    End Property

    ''' <summary>
    ''' 
    ''' </summary>
    ''' <remarks></remarks>
    <Description(""), _
     DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden), _
     Browsable(False), BusinessFieldDisplayInEditor()> _
    Public Property [CompanyID]() As System.String
        Get
            If (CurrentRow.RowState = DataRowState.Deleted) Then
                Return CType(CurrentRow.Item("CompanyID", DataRowVersion.Original), System.String)
            Else
                Return CType(CurrentRow.Item("CompanyID"), System.String)
            End If
        End Get
        Set(ByVal value As System.String)
            CurrentRow.Item("CompanyID") = value
        End Set
    End Property

    ''' <summary>
    ''' 
    ''' </summary>
    ''' <remarks></remarks>
    <Description(""), _
     DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden), _
     Browsable(False), BusinessFieldDisplayInEditor()> _
    Public Property [CompanyName]() As System.String
        Get
            If (CurrentRow.RowState = DataRowState.Deleted) Then
                Return CType(CurrentRow.Item("CompanyName", DataRowVersion.Original), System.String)
            Else
                Return CType(CurrentRow.Item("CompanyName"), System.String)
            End If
        End Get
        Set(ByVal value As System.String)
            CurrentRow.Item("CompanyName") = value
        End Set
    End Property

    ''' <summary>
    ''' 
    ''' </summary>
    ''' <remarks></remarks>
    <Description(""), _
     DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden), _
     Browsable(False), BusinessFieldDisplayInEditor()> _
    Public Property [AddressLine1]() As System.String
        Get
            If (CurrentRow.RowState = DataRowState.Deleted) Then
                Return CType(CurrentRow.Item("AddressLine1", DataRowVersion.Original), System.String)
            Else
                Return CType(CurrentRow.Item("AddressLine1"), System.String)
            End If
        End Get
        Set(ByVal value As System.String)
            CurrentRow.Item("AddressLine1") = value
        End Set
    End Property

    ''' <summary>
    ''' 
    ''' </summary>
    ''' <remarks></remarks>
    <Description(""), _
     DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden), _
     Browsable(False), BusinessFieldDisplayInEditor()> _
    Public Property [AddressLine2]() As System.String
        Get
            If (CurrentRow.RowState = DataRowState.Deleted) Then
                Return CType(CurrentRow.Item("AddressLine2", DataRowVersion.Original), System.String)
            Else
                Return CType(CurrentRow.Item("AddressLine2"), System.String)
            End If
        End Get
        Set(ByVal value As System.String)
            CurrentRow.Item("AddressLine2") = value
        End Set
    End Property

    ''' <summary>
    ''' 
    ''' </summary>
    ''' <remarks></remarks>
    <Description(""), _
     DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden), _
     Browsable(False), BusinessFieldDisplayInEditor()> _
    Public Property [City]() As System.String
        Get
            If (CurrentRow.RowState = DataRowState.Deleted) Then
                Return CType(CurrentRow.Item("City", DataRowVersion.Original), System.String)
            Else
                Return CType(CurrentRow.Item("City"), System.String)
            End If
        End Get
        Set(ByVal value As System.String)
            CurrentRow.Item("City") = value
        End Set
    End Property

    Public ReadOnly Property State() As StateBO
        Get
            Return Me._State
        End Get
    End Property

    ''' <summary>
    ''' 
    ''' </summary>
    ''' <remarks></remarks>
    <Description(""), _
     DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden), _
     Browsable(False), BusinessFieldDisplayInEditor()> _
    Public Property [ZipCode]() As System.String
        Get
            If (CurrentRow.RowState = DataRowState.Deleted) Then
                Return CType(CurrentRow.Item("ZipCode", DataRowVersion.Original), System.String)
            Else
                Return CType(CurrentRow.Item("ZipCode"), System.String)
            End If
        End Get
        Set(ByVal value As System.String)
            CurrentRow.Item("ZipCode") = value
        End Set
    End Property

#End Region

#Region " Nested Types & Field Security "

    ''' <summary>
    ''' Contains all of the field names that belong to the business object.
    ''' </summary>
    ''' <remarks></remarks>
    Public Enum CompanyBOFieldNames As Integer
        [CompanyMasterID]
        [CompanyID]
        [CompanyName]
        [AddressLine1]
        [AddressLine2]
        [City]
        [State]
        [ZipCode]
        CUSTOM_FIELD
    End Enum

    ''' <summary>
    ''' Gets the System.Type of the enumeration that contains the field names for the business object.
    ''' </summary>
    ''' <remarks></remarks>
    Public Overrides Function GetFieldEnumType() As System.Type
        Return GetType(CompanyBOFieldNames)
    End Function

    ''' <summary>
    ''' Gets the System.Type of the enumeration that contains the field names for the business object.
    ''' </summary>
    ''' <remarks></remarks>
    Public Overrides Function GetFieldSecurityEventArgsType() As System.Type
        Return GetType(CheckCompanyBOFieldSecurityEventArgs)
    End Function

    ''' <summary>
    ''' A subclass of MicroFour.StrataFrame.Business.CheckFieldSecurityEventArgs that returns the field to check as a custom enumeration for this business object.
    ''' </summary>
    ''' <remarks></remarks>
    Public Class CheckCompanyBOFieldSecurityEventArgs
        Inherits CheckFieldSecurityEventArgs

        Public ReadOnly Property FieldToCheck() As CompanyBOFieldNames
            Get
                Return CType(MyBase.Field, CompanyBOFieldNames)
            End Get
        End Property

    End Class

    ''' <summary>
    ''' Checks the security on an individual field level if CheckSecurityOnFields is set to true.
    ''' </summary>
    ''' <remarks></remarks>
    Public Event CheckFieldSecurity(ByVal e As CheckCompanyBOFieldSecurityEventArgs)

    ''' <summary>
    ''' Called from within the framework to raise the actual event to check individual field security.
    ''' </summary>
    ''' <remarks></remarks>
    Protected Overrides Sub RaiseCheckFieldSecurityEvent(ByVal e As CheckFieldSecurityEventArgs)
        RaiseEvent CheckFieldSecurity(CType(e, CheckCompanyBOFieldSecurityEventArgs))
    End Sub

#End Region

#Region " Item Property Implementation "

    ''' <summary>
    ''' Initializes the shared members of the CompanyBO class.
    ''' </summary>
    ''' <remarks></remarks>
    Shared Sub New()
        '-- Create the new shared dictionary and populate it with an 
        '   instance of each property descriptor
        _PropertyDescriptors = New PropertyDescriptorDictionary(13)
        _PropertyDescriptors.Add("CompanyMasterID", New Field_CompanyMasterID_Descriptor())
        _PropertyDescriptors.Add("CompanyID", New Field_CompanyID_Descriptor())
        _PropertyDescriptors.Add("CompanyName", New Field_CompanyName_Descriptor())
        _PropertyDescriptors.Add("AddressLine1", New Field_AddressLine1_Descriptor())
        _PropertyDescriptors.Add("AddressLine2", New Field_AddressLine2_Descriptor())
        _PropertyDescriptors.Add("City", New Field_City_Descriptor())
        _PropertyDescriptors.Add("ZipCode", New Field_ZipCode_Descriptor())
    End Sub

    Private Shared _AreCustomDescriptorsEvaluated As Boolean = False
    Protected Overrides ReadOnly Property AreCustomDescriptorsEvaluated() As Boolean
        Get
            Dim llReturn As Boolean = _AreCustomDescriptorsEvaluated
            _AreCustomDescriptorsEvaluated = True
            Return llReturn
        End Get
    End Property

    Private Shared _PropertyDescriptors As PropertyDescriptorDictionary
    Protected Overrides ReadOnly Property PropertyDescriptors() As PropertyDescriptorDictionary
        Get
            Return _PropertyDescriptors
        End Get
    End Property

    ''' <summary>
    ''' A private field used to store the System.Type of this business object for use by the FieldPropertyDescriptor classes.
    ''' </summary>
    ''' <remarks></remarks>

    Private Shared _ComponentType As System.Type = GetType(CompanyBO)

    ''' <summary>
    ''' A PropertyDescriptor class used to Get and Set the value of the CompanyMasterID property.
    ''' </summary>
    ''' <remarks></remarks>
    Private Class Field_CompanyMasterID_Descriptor
        Inherits MicroFour.StrataFrame.Business.FieldPropertyDescriptor
        Public Sub New()
            MyBase.New("CompanyMasterID")
        End Sub
        Private _PropertyType As System.Type = GetType(System.Int32)
        Public Overrides Function GetValue(ByVal component As Object) As Object
            Return CType(component, CompanyBO).CompanyMasterID
        End Function
        Public Overrides Sub SetValue(ByVal component As Object, ByVal Value As Object)
            CType(component, CompanyBO).CompanyMasterID = CType(Value, System.Int32)
        End Sub
        Public Overrides ReadOnly Property PropertyType() As System.Type
            Get
                Return Me._PropertyType
            End Get
        End Property
        Public Overrides ReadOnly Property ComponentType() As System.Type
            Get
                Return _ComponentType
            End Get
        End Property
    End Class

    ''' <summary>
    ''' A PropertyDescriptor class used to Get and Set the value of the CompanyID property.
    ''' </summary>
    ''' <remarks></remarks>
    Private Class Field_CompanyID_Descriptor
        Inherits MicroFour.StrataFrame.Business.FieldPropertyDescriptor
        Public Sub New()
            MyBase.New("CompanyID")
        End Sub
        Private _PropertyType As System.Type = GetType(System.String)
        Public Overrides Function GetValue(ByVal component As Object) As Object
            Return CType(component, CompanyBO).CompanyID
        End Function
        Public Overrides Sub SetValue(ByVal component As Object, ByVal Value As Object)
            CType(component, CompanyBO).CompanyID = CType(Value, System.String)
        End Sub
        Public Overrides ReadOnly Property PropertyType() As System.Type
            Get
                Return Me._PropertyType
            End Get
        End Property
        Public Overrides ReadOnly Property ComponentType() As System.Type
            Get
                Return _ComponentType
            End Get
        End Property
    End Class

    ''' <summary>
    ''' A PropertyDescriptor class used to Get and Set the value of the CompanyName property.
    ''' </summary>
    ''' <remarks></remarks>
    Private Class Field_CompanyName_Descriptor
        Inherits MicroFour.StrataFrame.Business.FieldPropertyDescriptor
        Public Sub New()
            MyBase.New("CompanyName")
        End Sub
        Private _PropertyType As System.Type = GetType(System.String)
        Public Overrides Function GetValue(ByVal component As Object) As Object
            Return CType(component, CompanyBO).CompanyName
        End Function
        Public Overrides Sub SetValue(ByVal component As Object, ByVal Value As Object)
            CType(component, CompanyBO).CompanyName = CType(Value, System.String)
        End Sub
        Public Overrides ReadOnly Property PropertyType() As System.Type
            Get
                Return Me._PropertyType
            End Get
        End Property
        Public Overrides ReadOnly Property ComponentType() As System.Type
            Get
                Return _ComponentType
            End Get
        End Property
    End Class

    ''' <summary>
    ''' A PropertyDescriptor class used to Get and Set the value of the AddressLine1 property.
    ''' </summary>
    ''' <remarks></remarks>
    Private Class Field_AddressLine1_Descriptor
        Inherits MicroFour.StrataFrame.Business.FieldPropertyDescriptor
        Public Sub New()
            MyBase.New("AddressLine1")
        End Sub
        Private _PropertyType As System.Type = GetType(System.String)
        Public Overrides Function GetValue(ByVal component As Object) As Object
            Return CType(component, CompanyBO).AddressLine1
        End Function
        Public Overrides Sub SetValue(ByVal component As Object, ByVal Value As Object)
            CType(component, CompanyBO).AddressLine1 = CType(Value, System.String)
        End Sub
        Public Overrides ReadOnly Property PropertyType() As System.Type
            Get
                Return Me._PropertyType
            End Get
        End Property
        Public Overrides ReadOnly Property ComponentType() As System.Type
            Get
                Return _ComponentType
            End Get
        End Property
    End Class

    ''' <summary>
    ''' A PropertyDescriptor class used to Get and Set the value of the AddressLine2 property.
    ''' </summary>
    ''' <remarks></remarks>
    Private Class Field_AddressLine2_Descriptor
        Inherits MicroFour.StrataFrame.Business.FieldPropertyDescriptor
        Public Sub New()
            MyBase.New("AddressLine2")
        End Sub
        Private _PropertyType As System.Type = GetType(System.String)
        Public Overrides Function GetValue(ByVal component As Object) As Object
            Return CType(component, CompanyBO).AddressLine2
        End Function
        Public Overrides Sub SetValue(ByVal component As Object, ByVal Value As Object)
            CType(component, CompanyBO).AddressLine2 = CType(Value, System.String)
        End Sub
        Public Overrides ReadOnly Property PropertyType() As System.Type
            Get
                Return Me._PropertyType
            End Get
        End Property
        Public Overrides ReadOnly Property ComponentType() As System.Type
            Get
                Return _ComponentType
            End Get
        End Property
    End Class

    ''' <summary>
    ''' A PropertyDescriptor class used to Get and Set the value of the City property.
    ''' </summary>
    ''' <remarks></remarks>
    Private Class Field_City_Descriptor
        Inherits MicroFour.StrataFrame.Business.FieldPropertyDescriptor
        Public Sub New()
            MyBase.New("City")
        End Sub
        Private _PropertyType As System.Type = GetType(System.String)
        Public Overrides Function GetValue(ByVal component As Object) As Object
            Return CType(component, CompanyBO).City
        End Function
        Public Overrides Sub SetValue(ByVal component As Object, ByVal Value As Object)
            CType(component, CompanyBO).City = CType(Value, System.String)
        End Sub
        Public Overrides ReadOnly Property PropertyType() As System.Type
            Get
                Return Me._PropertyType
            End Get
        End Property
        Public Overrides ReadOnly Property ComponentType() As System.Type
            Get
                Return _ComponentType
            End Get
        End Property
    End Class

    ''' <summary>
    ''' A PropertyDescriptor class used to Get and Set the value of the ZipCode property.
    ''' </summary>
    ''' <remarks></remarks>
    Private Class Field_ZipCode_Descriptor
        Inherits MicroFour.StrataFrame.Business.FieldPropertyDescriptor
        Public Sub New()
            MyBase.New("ZipCode")
        End Sub
        Private _PropertyType As System.Type = GetType(System.String)
        Public Overrides Function GetValue(ByVal component As Object) As Object
            Return CType(component, CompanyBO).ZipCode
        End Function
        Public Overrides Sub SetValue(ByVal component As Object, ByVal Value As Object)
            CType(component, CompanyBO).ZipCode = CType(Value, System.String)
        End Sub
        Public Overrides ReadOnly Property PropertyType() As System.Type
            Get
                Return Me._PropertyType
            End Get
        End Property
        Public Overrides ReadOnly Property ComponentType() As System.Type
            Get
                Return _ComponentType
            End Get
        End Property
    End Class

#End Region

End Class