﻿Public Class CustomerOrdersForm

#Region "   Constructors "

  ''' <summary>
  ''' A customer ID is required to open this form.
  ''' </summary>
  ''' <param name="customerID"></param>
  ''' <remarks></remarks>
  Public Sub New(ByVal customerID As Integer)
    '-- Validate arguments
    If customerID = 0 Then
      Throw New ArgumentException("A customer ID is required.")
    End If

    '-- Set the customer ID
    Me.CustomerID = customerID

    '-- Init form
    Me.InitializeComponent()

    '-- Load the customer name
    Me.SetCustomerName()
  End Sub

#End Region

#Region "   Properties "

  Private _customerID As Integer

  ''' <summary>
  ''' Define the customer whose orders are being viewed.
  ''' </summary>
  ''' <value></value>
  ''' <returns></returns>
  ''' <remarks></remarks>     
  Public Property CustomerID() As Integer
    Get
      Return _customerID
    End Get
    Set(ByVal value As Integer)
      _customerID = value
    End Set
  End Property

#End Region

#Region "   Event Handlers "

  ''' <summary>
  ''' Load the BO with the orders for the indicated customer.
  ''' </summary>
  ''' <remarks></remarks>
  Private Sub OrdersBO1_ParentFormLoading() Handles OrdersBO1.ParentFormLoading
    Me.OrdersBO1.FillByParentPrimaryKey(Me.CustomerID)
  End Sub

  ''' <summary>
  ''' Manage FK to the customer.
  ''' </summary>
  ''' <remarks></remarks>
  Private Sub OrdersBO1_SetDefaultValues() Handles OrdersBO1.SetDefaultValues
    Me.OrdersBO1.or_cust_pk = Me.CustomerID
  End Sub

#End Region

#Region "   Private (helper) Methods "

  ''' <summary>
  ''' Load the customer's name into the form UI.
  ''' </summary>
  ''' <remarks></remarks>
  Private Sub SetCustomerName()
    Dim name As String = String.Empty
    Using bo As New CustomersBO()
      name = bo.GetCustomerName(Me.CustomerID)
    End Using
    Me.lblCustomerName.Text = name
  End Sub

#End Region

End Class
