﻿Imports System.Data
Imports System.Data.SqlClient
Imports System.Runtime.Serialization
Imports MicroFour.StrataFrame.Data

<Serializable()> _
Public Class CustomersBO
    Inherits MicroFour.StrataFrame.Business.BusinessLayer

#Region " Constructors "

	''' <summary>
    ''' Initializes a new instance of the CustomersBO class.
    ''' </summary>
    ''' <remarks></remarks>
    <System.Diagnostics.DebuggerNonUserCodeAttribute()> _
    Public Sub New()
        MyBase.New()
        'This call is required by the Component Designer.
        Me.InitializeComponent()
        '-- Add the necessary handlers
        Me.AddHandlers()
    End Sub

    ''' <summary>
    ''' Initializes a new instance of the CustomersBO class.
    ''' </summary>
    ''' <param name="Container">The IContainer to which this object will be added.</param>
    ''' <remarks></remarks>
    <System.Diagnostics.DebuggerNonUserCodeAttribute()> _
    Public Sub New(ByVal Container As System.ComponentModel.IContainer)
        MyBase.New()
        'This call adds the component to the given container.
        Container.Add(Me)
        'This call is required by the Component Designer.
        Me.InitializeComponent()
        '-- Add the necessary handlers
        Me.AddHandlers()
    End Sub

    ''' <summary>
    ''' Initializes a new instance of the CustomersBO class.
    ''' </summary>
    ''' <param name="info">The SerializationInfo for the object.</param>
    ''' <param name="context">The StreamingContext for the source stream.</param>
    ''' <remarks></remarks>
    Protected Sub New(ByVal info As SerializationInfo, ByVal context As StreamingContext)
        MyBase.New(info, context)
        'This call is required by the Component Designer.
        Me.InitializeComponent()
        '-- Add the necessary handlers
        Me.AddHandlers()
    End Sub
    
    ''' <summary>
    ''' Adds the necessary handlers for the CustomersBO class.
    ''' </summary>
    ''' <remarks></remarks>
    Private Sub AddHandlers()
		AddHandler Me.CheckRulesOnCurrentRow, AddressOf CustomersBO_CheckRulesOnCurrentRow
		AddHandler Me.SetDefaultValues, AddressOf CustomersBO_SetDefaultValues
    End Sub
    
#End Region 

#Region " Data Retrieval Methods "

  ''' <summary>
  ''' Return the name of the indicated customer.
  ''' </summary>
  ''' <param name="id"></param>
  ''' <returns></returns>
  ''' <remarks></remarks>
  Public Function GetCustomerName(ByVal id As Integer) As String
    '-- Establish a return var
    Dim name As String = String.Empty
    Using cmd As New SqlCommand()
      cmd.CommandText = " Select IsNull(cust_LastName,'') + ', ' + IsNull(cust_FirstName,'')" _
                      & " From Customers" _
                      & " Where cust_pk = @id"
      cmd.Parameters.Add("@id", SqlDbType.Int)
      cmd.Parameters("@id").Value = id
      Dim res As Object = Me.ExecuteScalar(cmd)
      If res IsNot Nothing AndAlso res IsNot DBNull.Value Then
        name = CType(res, String)
      End If
    End Using

    '-- return the name
    Return name
  End Function

  ''' <summary>
  ''' Fill the BO with the customers whose last names start
  ''' with the indicated letter.
  ''' </summary>
  ''' <param name="lastNameLetter"></param>
  ''' <remarks></remarks>
  Public Sub FillByStartOfLast(ByVal lastNameLetter As String)
    Using cmd As New SqlCommand()
      cmd.CommandText = " Select *" _
                      & " From Customers" _
                      & " Where cust_LastName Like(@lastNameLetter + '%')"
      cmd.Parameters.Add("@lastNameLetter", SqlDbType.Char, 1)
      cmd.Parameters("@lastNameLetter").Value = lastNameLetter
      Me.FillDataTable(cmd)
    End Using
  End Sub

#End Region

#Region " Event Handlers "

    ''' <summary>
    ''' Checks the business rules on the current row
    ''' </summary>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub CustomersBO_CheckRulesOnCurrentRow(ByVal e As MicroFour.StrataFrame.Business.CheckRulesEventArgs)

    End Sub

    ''' <summary>
    ''' Sets the default values for a new row
    ''' </summary>
    ''' <remarks></remarks>
    Private Sub CustomersBO_SetDefaultValues()

    End Sub

#End Region

End Class
