﻿Public Class CustomersForm

  ''' <summary>
  ''' View this customer's orders.
  ''' </summary>
  ''' <param name="sender"></param>
  ''' <param name="e"></param>
  ''' <remarks></remarks>
  Private Sub btnViewOrders_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnViewOrders.Click
    '-- exit if not current customer
    If Me.CustomersBO1.Count = 0 OrElse Me.CustomersBO1.CurrentRowIndex < 0 Then Return

    '-- Get the customer ID
    Dim id As Integer = Me.CustomersBO1.cust_pk

    '-- See if an order was selected
    Dim orderId As Integer
    If Me.cboCustomerOrders.SelectedItem IsNot Nothing Then
      orderId = CType(Me.cboCustomerOrders.SelectedValue, Integer)
    End If

    '-- Open the order form. Here we create the form ourselves, then 
    '   configure it to navigate to the selected order (if any was selected)
    Dim frm As New CustomerOrdersForm(id)
    If orderId > 0 Then
      CustomerOrdersForm.ConfigNavToRecordForm(Of CustomerOrdersForm)(frm, orderId)
    End If
    frm.MdiParent = Me.MdiParent
    frm.Show()
  End Sub

  ''' <summary>
  ''' Set the current customer pk to load the appropriate orders.
  ''' </summary>
  ''' <param name="e"></param>
  ''' <remarks></remarks>
  Private Sub cboCustomerOrders_ListPopulating(ByVal e As MicroFour.StrataFrame.UI.ListPopulatingEventArgs) Handles cboCustomerOrders.ListPopulating
    e.Parameters(0).Value = Me.CustomersBO1.cust_pk
  End Sub

End Class
