﻿Public Class MainForm

#Region "   Constructors "

  ''' <summary>
  ''' Construct a default instance.
  ''' </summary>
  ''' <remarks></remarks>
  Public Sub New()
    '-- This call is required by the Windows Form Designer.
    InitializeComponent()

    '-- Load the letter combo
    Me.LoadLetters()
  End Sub

#End Region

#Region "   MDI Window Event Handlers "

  ''' <summary>
  ''' This arranges all child MDI window icons
  ''' </summary>
  ''' <param name="sender"></param>
  ''' <param name="e"></param>
  ''' <remarks></remarks>
  Private Sub tsmiArrangeIcons_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles tsmiArrangeIcons.Click
    Me.LayoutMdi(MdiLayout.ArrangeIcons)
  End Sub

  ''' <summary>
  ''' This cascades all MDI child windows.
  ''' </summary>
  ''' <param name="sender"></param>
  ''' <param name="e"></param>
  ''' <remarks></remarks>
  Private Sub tsmiCascade_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles tsmiCascade.Click
    Me.LayoutMdi(MdiLayout.Cascade)
  End Sub

  ''' <summary>
  ''' This tiles the MDI child windows vertically.
  ''' </summary>
  ''' <param name="sender"></param>
  ''' <param name="e"></param>
  ''' <remarks></remarks>
  Private Sub tsmiTileVertically_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles tsmiTileVertically.Click
    Me.LayoutMdi(MdiLayout.TileVertical)
  End Sub

  ''' <summary>
  ''' This tiles the MDI child windows horizontially.
  ''' </summary>
  ''' <param name="sender"></param>
  ''' <param name="e"></param>
  ''' <remarks></remarks>
  Private Sub tsmiTileHorizontally_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles tsmiTileHorizontally.Click
    Me.LayoutMdi(MdiLayout.TileHorizontal)
  End Sub

  ''' <summary>
  ''' Closes all child forms.
  ''' </summary>
  ''' <param name="sender"></param>
  ''' <param name="e"></param>
  ''' <remarks></remarks>
  Private Sub tsmiCloseAll_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles tsmiCloseAll.Click
    For Each mdiChild As Form In Me.MdiChildren
      mdiChild.Close()
    Next
  End Sub

#End Region

#Region "   Event Handlers "

  ''' <summary>
  ''' Exit the appliction.
  ''' </summary>
  ''' <param name="sender"></param>
  ''' <param name="e"></param>
  ''' <remarks></remarks>
  Private Sub tsmiExit_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles tsmiExit.Click
    Application.Exit()
  End Sub

  ''' <summary>
  ''' Open the customer form for data entry.
  ''' </summary>
  ''' <param name="sender"></param>
  ''' <param name="e"></param>
  ''' <remarks></remarks>
  Private Sub tsbAddCustomer_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles tsbAddCustomer.Click
    Dim frm As CustomersForm = CustomersForm.CreateDataEntryForm(Of CustomersForm)()
    frm.MdiParent = Me
    frm.Show()
  End Sub

  ''' <summary>
  ''' View the customer with the indicated ID.
  ''' </summary>
  ''' <param name="sender"></param>
  ''' <param name="e"></param>
  ''' <remarks></remarks>
  Private Sub tsbViewCustomerByID_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles tsbViewCustomerByID.Click
    '-- throw exception of no ID...not very friendly, but this is just an example!
    If String.IsNullOrEmpty(Me.tstbCustomerID.Text) Then
      Throw New InvalidOperationException("You cannot view a customer unless you first enter an ID.")
    End If

    '-- Get the ID...better enter a number here.
    Dim id As Integer = CType(Me.tstbCustomerID.Text, Integer)

    '-- Open the form to this customer
    Dim frm As CustomersForm = CustomersForm.CreateSingleRecordForm(Of CustomersForm)(id)
    frm.MdiParent = Me
    frm.Show()
  End Sub

  ''' <summary>
  ''' View the customer form with all the customers with the chosen
  ''' first letter of the last name.
  ''' </summary>
  ''' <param name="sender"></param>
  ''' <param name="e"></param>
  ''' <remarks>
  ''' In this case if nothing is selected all customers are shown!
  ''' </remarks>
  Private Sub tsbViewCustomerByLetter_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles tsbViewCustomerByLetter.Click
    '-- Get the letter
    Dim letter As String = String.Empty
    If Not String.IsNullOrEmpty(Me.tscbLastNameLeter.Text) Then
      letter = Me.tscbLastNameLeter.Text
    End If

    '-- If entered, get an ID to navigate to
    Dim navID As Integer
    If Not String.IsNullOrEmpty(Me.tstbNavID.Text) Then
      navID = CType(Me.tstbNavID.Text, Integer)
    End If

    '-- Create a BO with the appropriate data, then use the BO's 
    '   data table to load the customers form.
    Using bo As New CustomersBO()
      bo.FillByStartOfLast(letter)

      '-- If only the leter was provided, create form setup to
      '   auto-load the data from our customers BO
      Dim frm As CustomersForm
      If navID = 0 Then
        '-- Use the data table to load the form
        frm = CustomersForm.CreateDataLoadedForm(Of CustomersForm)(bo.CurrentDataTable)
      Else
        frm = CustomersForm.CreateAutoLoadAndNavForm(Of CustomersForm)(bo.CurrentDataTable, navID)
      End If

      '-- Setup MDI and show the form
      frm.MdiParent = Me
      frm.Show()
    End Using
  End Sub

  ''' <summary>
  ''' Show the form that explains how to use the demo app.
  ''' </summary>
  ''' <param name="sender"></param>
  ''' <param name="e"></param>
  ''' <remarks></remarks>
  Private Sub MainForm_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
    Dim frm As New ExampleInfoForm()
    frm.MdiParent = Me
    frm.Show()
  End Sub

#End Region


#Region "   Private (helper) Methods "


  ''' <summary>
  ''' Load the letters A-Z into the last name letter combo.
  ''' </summary>
  ''' <remarks></remarks>
  Private Sub LoadLetters()
    '-- For the letters A-Z add to combo
    For letter As Integer = 65 To 90
      Me.tscbLastNameLeter.Items.Add(ChrW(letter))
    Next
  End Sub

#End Region

End Class
