﻿Option Strict On
Option Explicit On

Imports MicroFour.StrataFrame.Business
Imports MicroFour.StrataFrame.Security
Imports MicroFour.StrataFrame.UI.Windows.Forms
Imports System.Collections.Generic
Imports System.ComponentModel
Imports System.Data
Imports System.IO

Partial Public Class CustomersBO

#Region " Component Implementation "

  <System.Diagnostics.DebuggerNonUserCodeAttribute()> _
  Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
    If (disposing _
       AndAlso (Not (Me.components) Is Nothing)) Then
      Me.components.Dispose()
    End If
    MyBase.Dispose(disposing)
  End Sub

  Private components As System.ComponentModel.IContainer

  'NOTE: The following procedure is required by the Component Designer
  'It can be modified using the Component Designer.
  'Do not modify it using the code editor.
  <System.Diagnostics.DebuggerNonUserCodeAttribute()> _
  Private Sub InitializeComponent()
    '
    'CustomersBO
    '
  End Sub

#End Region

#Region " BusinessLayer Overriden Methods & Properties "

  ''' <summary>
  ''' The collection of required fields for the business object.
  ''' </summary>
  ''' <remarks></remarks>
  <Browsable(False), DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)> _
  Public Overrides Property RequiredFields() As RequiredFieldsCollection
    Get
      Return MyBase.RequiredFields
    End Get
    Set(ByVal value As RequiredFieldsCollection)
      MyBase.RequiredFields = value
    End Set
  End Property

  ''' <summary>
  ''' Defines the constraint that defines the parent-child relationship between this business object type and another business object type.
  ''' </summary>
  ''' <remarks></remarks>
  <Browsable(False), DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)> _
  Public Overrides Property ParentRelationship() As IBusinessParentRelationship
    Get
      Return MyBase.ParentRelationship
    End Get
    Set(ByVal value As IBusinessParentRelationship)
      MyBase.ParentRelationship = value
    End Set
  End Property

  ''' <summary>
  ''' Returns all of the field names in a single string in the form of [field1],[field2],...  This must be used in the place of '*' in select statements if Query Notifications are to be registered.
  ''' </summary>
  ''' <remarks></remarks>
  Protected Overrides ReadOnly Property AllFieldNames() As String
    Get
      Return "[cust_pk],[cust_Company],[cust_Prefix],[cust_FirstName],[cust_MiddleName],[cust_LastName],[cust_Suffix],[cust_Address1],[cust_Address2],[cust_City],[cust_State],[cust_Postal],[cust_Country],[cust_Email],[cust_PhoneDay],[cust_PhoneDayType],[cust_PhoneNight],[cust_PhoneNightType],[cust_Created],[cust_Version]"
    End Get
  End Property

  ''' <summary>
  ''' The name of the database that contains the table to which this business object is mapped.
  ''' </summary>
  ''' <remarks></remarks>
  Public Overrides ReadOnly Property Database() As String
    Get
      Return "StrataFrameSample"
    End Get
  End Property

  Private Shared _PrimaryKeyFields As String() = New String() {"cust_pk"}
  ''' <summary>
  ''' Gets the field or fields that comprise the primary key for the business object.
  ''' </summary>
  ''' <remarks></remarks>
  Public Overrides ReadOnly Property PrimaryKeyFields() As String()
    Get
      Return _PrimaryKeyFields
    End Get
  End Property

  ''' <summary>
  ''' The name of the table in the database to which this business object is mapped.
  ''' </summary>
  ''' <remarks></remarks>
  Public Overrides ReadOnly Property TableName() As String
    Get
      Return "Customers"
    End Get
  End Property

  ''' <summary>
  ''' The schema of the table in the database to which this business object is mapped.
  ''' </summary>
  ''' <remarks></remarks>
  Public Overrides ReadOnly Property TableSchema() As String
    Get
      Return "dbo"
    End Get
  End Property

  ''' <summary>
  ''' Creates and returns an array of DataColumns that contains the schema for the table.  This is used to prevent a round trip to the server to aquire the initial schema for the internal DataTable.
  ''' </summary>
  ''' <remarks></remarks>
  Protected Overrides Function CreateTableSchema() As DataColumn()
    Return New DataColumn() { _
    New DataColumn("cust_pk", GetType(System.Int32)), _
    New DataColumn("cust_Company", GetType(System.String)), _
    New DataColumn("cust_Prefix", GetType(System.String)), _
    New DataColumn("cust_FirstName", GetType(System.String)), _
    New DataColumn("cust_MiddleName", GetType(System.String)), _
    New DataColumn("cust_LastName", GetType(System.String)), _
    New DataColumn("cust_Suffix", GetType(System.String)), _
    New DataColumn("cust_Address1", GetType(System.String)), _
    New DataColumn("cust_Address2", GetType(System.String)), _
    New DataColumn("cust_City", GetType(System.String)), _
    New DataColumn("cust_State", GetType(System.String)), _
    New DataColumn("cust_Postal", GetType(System.String)), _
    New DataColumn("cust_Country", GetType(System.String)), _
    New DataColumn("cust_Email", GetType(System.String)), _
    New DataColumn("cust_PhoneDay", GetType(System.String)), _
    New DataColumn("cust_PhoneDayType", GetType(System.Int32)), _
    New DataColumn("cust_PhoneNight", GetType(System.String)), _
    New DataColumn("cust_PhoneNightType", GetType(System.Int32)), _
    New DataColumn("cust_Created", GetType(System.DateTime)), _
    New DataColumn("cust_Version", GetType(System.Int32))}
  End Function

  ''' <summary>
  ''' Adds a broken rule to the business object's collection
  ''' </summary>
  ''' <remarks></remarks>
  Protected Shadows Sub AddBrokenRule(ByVal Field As CustomersBOFieldNames, ByVal ErrorMessage As String)
    MyBase.AddBrokenRule(Field, ErrorMessage)
  End Sub

  ''' <summary>
  ''' Adds a broken rule to the business object's collection
  ''' </summary>
  ''' <remarks></remarks>
  Protected Shadows Sub AddBrokenRule(ByVal FieldName As String, ByVal ErrorMessage As String)
    MyBase.AddBrokenRule(FieldName, ErrorMessage)
  End Sub

  ''' <summary>
  ''' Adds a broken rules to the business object's collection using the given message key to pull the error message from the localization database
  ''' </summary>
  ''' <remarks></remarks>
  Protected Shadows Sub AddBrokenRuleByKey(ByVal Field As CustomersBOFieldNames, ByVal ErrorMessageKey As String)
    MyBase.AddBrokenRuleByKey(Field, ErrorMessageKey)
  End Sub

  ''' <summary>
  ''' Adds a broken rules to the business object's collection using the given message key to pull the error message from the localization database
  ''' </summary>
  ''' <remarks></remarks>
  Protected Shadows Sub AddBrokenRuleByKey(ByVal FieldName As String, ByVal ErrorMessageKey As String)
    MyBase.AddBrokenRuleByKey(FieldName, ErrorMessageKey)
  End Sub

  ''' <summary>
  ''' Gets a collection of the names for all fields that belong to this business object and map to the database.
  ''' </summary>
  ''' <remarks></remarks>
  Public Overrides ReadOnly Property AllFieldsList() As List(Of String)
    Get
      Return _AllFieldsList
    End Get
  End Property

  ''' <summary>
  ''' Gets a dictionary of the DbTypes for all fields that belong to this business object and map to the database.
  ''' </summary>
  ''' <remarks></remarks>
  Public Overrides ReadOnly Property FieldDbTypes() As Dictionary(Of String, DbType)
    Get
      Return _FieldDbTypes
    End Get
  End Property

  ''' <summary>
  ''' Gets a dictionary of all fields within this business object that map to the FieldNames enumeration for this business object.
  ''' </summary>
  ''' <remarks></remarks>
  Public Overrides ReadOnly Property FieldEnums() As BusinessLayerFieldEnumDictionary
    Get
      Return _FieldEnums
    End Get
  End Property

  ''' <summary>
  ''' Gets a dictionary of all of the lengths for all fields within this business object that map to a field in the database.
  ''' </summary>
  ''' <remarks></remarks>
  Public Overrides ReadOnly Property FieldLengths() As Dictionary(Of String, Integer)
    Get
      Return _FieldLengths
    End Get
  End Property

  ''' <summary>
  ''' Gets a dictionary of the native DbType (SqlDbType, OracleType, OleDbType, etc.) for all fields within this buisness object that map to a field in the database.
  ''' </summary>
  ''' <remarks></remarks>
  Public Overrides ReadOnly Property FieldNativeDbTypes() As Dictionary(Of String, Integer)
    Get
      Return _FieldNativeDbTypes
    End Get
  End Property

  ''' <summary>
  ''' Gets a dictionary of the security permission keys for each field in the business object.
  ''' </summary>
  ''' <remarks></remarks>
  Public Overrides ReadOnly Property FieldPermissionKeys() As Dictionary(Of String, String)
    Get
      Return _FieldPermissionKeys
    End Get
  End Property

#End Region

#Region " Field Properties "

  ''' <summary>
  ''' cust_pk
  ''' </summary>
  ''' <remarks></remarks>
  <Browsable(False), _
   BusinessFieldDisplayInEditor(), _
   Description("cust_pk"), _
   DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)> _
  Public Property [cust_pk]() As System.Int32
    Get
      Return CType(Me.CurrentRow.Item("cust_pk"), System.Int32)
    End Get
    Set(ByVal value As System.Int32)
      Me.CurrentRow.Item("cust_pk") = value
    End Set
  End Property

  ''' <summary>
  ''' cust_Company
  ''' </summary>
  ''' <remarks></remarks>
  <Browsable(False), _
   BusinessFieldDisplayInEditor(), _
   Description("cust_Company"), _
   DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)> _
  Public Property [cust_Company]() As System.String
    Get
      Return CType(Me.CurrentRow.Item("cust_Company"), System.String)
    End Get
    Set(ByVal value As System.String)
      Me.CurrentRow.Item("cust_Company") = value
    End Set
  End Property

  ''' <summary>
  ''' cust_Prefix
  ''' </summary>
  ''' <remarks></remarks>
  <Browsable(False), _
   BusinessFieldDisplayInEditor(), _
   Description("cust_Prefix"), _
   DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)> _
  Public Property [cust_Prefix]() As System.String
    Get
      Return CType(Me.CurrentRow.Item("cust_Prefix"), System.String)
    End Get
    Set(ByVal value As System.String)
      Me.CurrentRow.Item("cust_Prefix") = value
    End Set
  End Property

  ''' <summary>
  ''' cust_FirstName
  ''' </summary>
  ''' <remarks></remarks>
  <Browsable(False), _
   BusinessFieldDisplayInEditor(), _
   Description("cust_FirstName"), _
   DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)> _
  Public Property [cust_FirstName]() As System.String
    Get
      Return CType(Me.CurrentRow.Item("cust_FirstName"), System.String)
    End Get
    Set(ByVal value As System.String)
      Me.CurrentRow.Item("cust_FirstName") = value
    End Set
  End Property

  ''' <summary>
  ''' cust_MiddleName
  ''' </summary>
  ''' <remarks></remarks>
  <Browsable(False), _
   BusinessFieldDisplayInEditor(), _
   Description("cust_MiddleName"), _
   DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)> _
  Public Property [cust_MiddleName]() As System.String
    Get
      Return CType(Me.CurrentRow.Item("cust_MiddleName"), System.String)
    End Get
    Set(ByVal value As System.String)
      Me.CurrentRow.Item("cust_MiddleName") = value
    End Set
  End Property

  ''' <summary>
  ''' cust_LastName
  ''' </summary>
  ''' <remarks></remarks>
  <Browsable(False), _
   BusinessFieldDisplayInEditor(), _
   Description("cust_LastName"), _
   DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)> _
  Public Property [cust_LastName]() As System.String
    Get
      Return CType(Me.CurrentRow.Item("cust_LastName"), System.String)
    End Get
    Set(ByVal value As System.String)
      Me.CurrentRow.Item("cust_LastName") = value
    End Set
  End Property

  ''' <summary>
  ''' cust_Suffix
  ''' </summary>
  ''' <remarks></remarks>
  <Browsable(False), _
   BusinessFieldDisplayInEditor(), _
   Description("cust_Suffix"), _
   DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)> _
  Public Property [cust_Suffix]() As System.String
    Get
      Return CType(Me.CurrentRow.Item("cust_Suffix"), System.String)
    End Get
    Set(ByVal value As System.String)
      Me.CurrentRow.Item("cust_Suffix") = value
    End Set
  End Property

  ''' <summary>
  ''' cust_Address1
  ''' </summary>
  ''' <remarks></remarks>
  <Browsable(False), _
   BusinessFieldDisplayInEditor(), _
   Description("cust_Address1"), _
   DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)> _
  Public Property [cust_Address1]() As System.String
    Get
      Return CType(Me.CurrentRow.Item("cust_Address1"), System.String)
    End Get
    Set(ByVal value As System.String)
      Me.CurrentRow.Item("cust_Address1") = value
    End Set
  End Property

  ''' <summary>
  ''' cust_Address2
  ''' </summary>
  ''' <remarks></remarks>
  <Browsable(False), _
   BusinessFieldDisplayInEditor(), _
   Description("cust_Address2"), _
   DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)> _
  Public Property [cust_Address2]() As System.String
    Get
      Return CType(Me.CurrentRow.Item("cust_Address2"), System.String)
    End Get
    Set(ByVal value As System.String)
      Me.CurrentRow.Item("cust_Address2") = value
    End Set
  End Property

  ''' <summary>
  ''' cust_City
  ''' </summary>
  ''' <remarks></remarks>
  <Browsable(False), _
   BusinessFieldDisplayInEditor(), _
   Description("cust_City"), _
   DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)> _
  Public Property [cust_City]() As System.String
    Get
      Return CType(Me.CurrentRow.Item("cust_City"), System.String)
    End Get
    Set(ByVal value As System.String)
      Me.CurrentRow.Item("cust_City") = value
    End Set
  End Property

  ''' <summary>
  ''' cust_State
  ''' </summary>
  ''' <remarks></remarks>
  <Browsable(False), _
   BusinessFieldDisplayInEditor(), _
   Description("cust_State"), _
   DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)> _
  Public Property [cust_State]() As System.String
    Get
      Return CType(Me.CurrentRow.Item("cust_State"), System.String)
    End Get
    Set(ByVal value As System.String)
      Me.CurrentRow.Item("cust_State") = value
    End Set
  End Property

  ''' <summary>
  ''' cust_Postal
  ''' </summary>
  ''' <remarks></remarks>
  <Browsable(False), _
   BusinessFieldDisplayInEditor(), _
   Description("cust_Postal"), _
   DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)> _
  Public Property [cust_Postal]() As System.String
    Get
      Return CType(Me.CurrentRow.Item("cust_Postal"), System.String)
    End Get
    Set(ByVal value As System.String)
      Me.CurrentRow.Item("cust_Postal") = value
    End Set
  End Property

  ''' <summary>
  ''' cust_Country
  ''' </summary>
  ''' <remarks></remarks>
  <Browsable(False), _
   BusinessFieldDisplayInEditor(), _
   Description("cust_Country"), _
   DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)> _
  Public Property [cust_Country]() As System.String
    Get
      Return CType(Me.CurrentRow.Item("cust_Country"), System.String)
    End Get
    Set(ByVal value As System.String)
      Me.CurrentRow.Item("cust_Country") = value
    End Set
  End Property

  ''' <summary>
  ''' cust_Email
  ''' </summary>
  ''' <remarks></remarks>
  <Browsable(False), _
   BusinessFieldDisplayInEditor(), _
   Description("cust_Email"), _
   DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)> _
  Public Property [cust_Email]() As System.String
    Get
      Return CType(Me.CurrentRow.Item("cust_Email"), System.String)
    End Get
    Set(ByVal value As System.String)
      Me.CurrentRow.Item("cust_Email") = value
    End Set
  End Property

  ''' <summary>
  ''' cust_PhoneDay
  ''' </summary>
  ''' <remarks></remarks>
  <Browsable(False), _
   BusinessFieldDisplayInEditor(), _
   Description("cust_PhoneDay"), _
   DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)> _
  Public Property [cust_PhoneDay]() As System.String
    Get
      Return CType(Me.CurrentRow.Item("cust_PhoneDay"), System.String)
    End Get
    Set(ByVal value As System.String)
      Me.CurrentRow.Item("cust_PhoneDay") = value
    End Set
  End Property

  ''' <summary>
  ''' cust_PhoneDayType
  ''' </summary>
  ''' <remarks></remarks>
  <Browsable(False), _
   BusinessFieldDisplayInEditor(), _
   Description("cust_PhoneDayType"), _
   DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)> _
  Public Property [cust_PhoneDayType]() As System.Int32
    Get
      Return CType(Me.CurrentRow.Item("cust_PhoneDayType"), System.Int32)
    End Get
    Set(ByVal value As System.Int32)
      Me.CurrentRow.Item("cust_PhoneDayType") = value
    End Set
  End Property

  ''' <summary>
  ''' cust_PhoneNight
  ''' </summary>
  ''' <remarks></remarks>
  <Browsable(False), _
   BusinessFieldDisplayInEditor(), _
   Description("cust_PhoneNight"), _
   DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)> _
  Public Property [cust_PhoneNight]() As System.String
    Get
      Return CType(Me.CurrentRow.Item("cust_PhoneNight"), System.String)
    End Get
    Set(ByVal value As System.String)
      Me.CurrentRow.Item("cust_PhoneNight") = value
    End Set
  End Property

  ''' <summary>
  ''' cust_PhoneNightType
  ''' </summary>
  ''' <remarks></remarks>
  <Browsable(False), _
   BusinessFieldDisplayInEditor(), _
   Description("cust_PhoneNightType"), _
   DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)> _
  Public Property [cust_PhoneNightType]() As System.Int32
    Get
      Return CType(Me.CurrentRow.Item("cust_PhoneNightType"), System.Int32)
    End Get
    Set(ByVal value As System.Int32)
      Me.CurrentRow.Item("cust_PhoneNightType") = value
    End Set
  End Property

  ''' <summary>
  ''' cust_Created
  ''' </summary>
  ''' <remarks></remarks>
  <Browsable(False), _
   BusinessFieldDisplayInEditor(), _
   Description("cust_Created"), _
   DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)> _
  Public Property [cust_Created]() As System.DateTime
    Get
      Return CType(Me.CurrentRow.Item("cust_Created"), System.DateTime)
    End Get
    Set(ByVal value As System.DateTime)
      Me.CurrentRow.Item("cust_Created") = value
    End Set
  End Property

  ''' <summary>
  ''' cust_Version
  ''' </summary>
  ''' <remarks></remarks>
  <Browsable(False), _
   BusinessFieldDisplayInEditor(), _
   Description("cust_Version"), _
   DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)> _
  Public Property [cust_Version]() As System.Int32
    Get
      Return CType(Me.CurrentRow.Item("cust_Version"), System.Int32)
    End Get
    Set(ByVal value As System.Int32)
      Me.CurrentRow.Item("cust_Version") = value
    End Set
  End Property

#End Region

#Region " Field Property Events  "

#End Region

#Region " Nested Types & Field Security "

  ''' <summary>
  ''' Contains all of the field names that belong to the business object.
  ''' </summary>
  ''' <remarks></remarks>
  Public Enum CustomersBOFieldNames As Integer
    [cust_pk]
    [cust_Company]
    [cust_Prefix]
    [cust_FirstName]
    [cust_MiddleName]
    [cust_LastName]
    [cust_Suffix]
    [cust_Address1]
    [cust_Address2]
    [cust_City]
    [cust_State]
    [cust_Postal]
    [cust_Country]
    [cust_Email]
    [cust_PhoneDay]
    [cust_PhoneDayType]
    [cust_PhoneNight]
    [cust_PhoneNightType]
    [cust_Created]
    [cust_Version]
    CUSTOM_FIELD
  End Enum

  ''' <summary>
  ''' Gets the System.Type of the enumeration that contains the field names for the business object.
  ''' </summary>
  ''' <remarks></remarks>
  Public Overrides Function GetFieldEnumType() As System.Type
    Return GetType(CustomersBOFieldNames)
  End Function

  ''' <summary>
  ''' Creates a new CheckFieldSecurityEventArgs object that can be used with this business object type.
  ''' </summary>
  ''' <remarks></remarks>
  Protected Overrides Function CreateNewFieldSecurityEventArgs(ByVal Field As System.Enum, ByVal CustomField As String, ByVal PermissionKey As String, ByVal Perm As PermissionInfo) As CheckFieldSecurityEventArgsBase
    Return New CheckFieldSecurityEventArgs(Of CustomersBOFieldNames)(Field, CustomField, PermissionKey, Perm)
  End Function

  ''' <summary>
  ''' Describes a method that will handle the CheckFieldScurity event.
  ''' </summary>
  ''' <remarks></remarks>
  Public Delegate Sub CheckFieldSecurityEventHandler(ByVal sender As Object, ByVal e As CheckFieldSecurityEventArgs(Of CustomersBOFieldNames))

  ''' <summary>
  ''' Occurs when the business objects needs to check the security on a field.
  ''' </summary>
  ''' <remarks></remarks>
  Public Event CheckFieldSecurity As CheckFieldSecurityEventHandler

  ''' <summary>
  ''' Raises the CheckFieldSecurity event.
  ''' </summary>
  ''' <remarks></remarks>
  Protected Overrides Sub OnCheckFieldSecurity(ByVal e As CheckFieldSecurityEventArgsBase)
    RaiseEvent CheckFieldSecurity(Me, CType(e, CheckFieldSecurityEventArgs(Of CustomersBOFieldNames)))
  End Sub

#End Region

#Region " Item Property Implementation "


  Private Shared _AllFieldsList As List(Of String)
  Private Shared _FieldDbTypes As Dictionary(Of String, DbType)
  Private Shared _FieldEnums As BusinessLayerFieldEnumDictionary
  Private Shared _FieldLengths As Dictionary(Of String, Integer)
  Private Shared _FieldNativeDbTypes As Dictionary(Of String, Integer)
  Private Shared _FieldPermissionKeys As Dictionary(Of String, String)

  ''' <summary>
  ''' Initializes the shared members of the CustomersBO class.
  ''' </summary>
  ''' <remarks></remarks>
  Shared Sub New()
    '-- Create the new shared dictionary and populate it with an 
    '   instance of each property descriptor
    _PropertyDescriptors = New PropertyDescriptorDictionary(25)
    _PropertyDescriptors.Add("cust_pk", New Field_cust_pk_Descriptor())
    _PropertyDescriptors.Add("cust_Company", New Field_cust_Company_Descriptor())
    _PropertyDescriptors.Add("cust_Prefix", New Field_cust_Prefix_Descriptor())
    _PropertyDescriptors.Add("cust_FirstName", New Field_cust_FirstName_Descriptor())
    _PropertyDescriptors.Add("cust_MiddleName", New Field_cust_MiddleName_Descriptor())
    _PropertyDescriptors.Add("cust_LastName", New Field_cust_LastName_Descriptor())
    _PropertyDescriptors.Add("cust_Suffix", New Field_cust_Suffix_Descriptor())
    _PropertyDescriptors.Add("cust_Address1", New Field_cust_Address1_Descriptor())
    _PropertyDescriptors.Add("cust_Address2", New Field_cust_Address2_Descriptor())
    _PropertyDescriptors.Add("cust_City", New Field_cust_City_Descriptor())
    _PropertyDescriptors.Add("cust_State", New Field_cust_State_Descriptor())
    _PropertyDescriptors.Add("cust_Postal", New Field_cust_Postal_Descriptor())
    _PropertyDescriptors.Add("cust_Country", New Field_cust_Country_Descriptor())
    _PropertyDescriptors.Add("cust_Email", New Field_cust_Email_Descriptor())
    _PropertyDescriptors.Add("cust_PhoneDay", New Field_cust_PhoneDay_Descriptor())
    _PropertyDescriptors.Add("cust_PhoneDayType", New Field_cust_PhoneDayType_Descriptor())
    _PropertyDescriptors.Add("cust_PhoneNight", New Field_cust_PhoneNight_Descriptor())
    _PropertyDescriptors.Add("cust_PhoneNightType", New Field_cust_PhoneNightType_Descriptor())
    _PropertyDescriptors.Add("cust_Created", New Field_cust_Created_Descriptor())
    _PropertyDescriptors.Add("cust_Version", New Field_cust_Version_Descriptor())

    _AllFieldsList = New List(Of String)(20)
    _AllFieldsList.Add("cust_pk")
    _AllFieldsList.Add("cust_Company")
    _AllFieldsList.Add("cust_Prefix")
    _AllFieldsList.Add("cust_FirstName")
    _AllFieldsList.Add("cust_MiddleName")
    _AllFieldsList.Add("cust_LastName")
    _AllFieldsList.Add("cust_Suffix")
    _AllFieldsList.Add("cust_Address1")
    _AllFieldsList.Add("cust_Address2")
    _AllFieldsList.Add("cust_City")
    _AllFieldsList.Add("cust_State")
    _AllFieldsList.Add("cust_Postal")
    _AllFieldsList.Add("cust_Country")
    _AllFieldsList.Add("cust_Email")
    _AllFieldsList.Add("cust_PhoneDay")
    _AllFieldsList.Add("cust_PhoneDayType")
    _AllFieldsList.Add("cust_PhoneNight")
    _AllFieldsList.Add("cust_PhoneNightType")
    _AllFieldsList.Add("cust_Created")
    _AllFieldsList.Add("cust_Version")

    _FieldDbTypes = New Dictionary(Of String, DbType)(20)
    _FieldDbTypes.Add("cust_pk", DbType.Int32)
    _FieldDbTypes.Add("cust_Company", DbType.String)
    _FieldDbTypes.Add("cust_Prefix", DbType.String)
    _FieldDbTypes.Add("cust_FirstName", DbType.String)
    _FieldDbTypes.Add("cust_MiddleName", DbType.String)
    _FieldDbTypes.Add("cust_LastName", DbType.String)
    _FieldDbTypes.Add("cust_Suffix", DbType.String)
    _FieldDbTypes.Add("cust_Address1", DbType.String)
    _FieldDbTypes.Add("cust_Address2", DbType.String)
    _FieldDbTypes.Add("cust_City", DbType.String)
    _FieldDbTypes.Add("cust_State", DbType.String)
    _FieldDbTypes.Add("cust_Postal", DbType.AnsiString)
    _FieldDbTypes.Add("cust_Country", DbType.String)
    _FieldDbTypes.Add("cust_Email", DbType.AnsiString)
    _FieldDbTypes.Add("cust_PhoneDay", DbType.AnsiString)
    _FieldDbTypes.Add("cust_PhoneDayType", DbType.Int32)
    _FieldDbTypes.Add("cust_PhoneNight", DbType.AnsiString)
    _FieldDbTypes.Add("cust_PhoneNightType", DbType.Int32)
    _FieldDbTypes.Add("cust_Created", DbType.DateTime)
    _FieldDbTypes.Add("cust_Version", DbType.Int32)

    _FieldEnums = New BusinessLayerFieldEnumDictionary(21)
    _FieldEnums.Add("cust_pk", CustomersBOFieldNames.cust_pk)
    _FieldEnums.Add("cust_Company", CustomersBOFieldNames.cust_Company)
    _FieldEnums.Add("cust_Prefix", CustomersBOFieldNames.cust_Prefix)
    _FieldEnums.Add("cust_FirstName", CustomersBOFieldNames.cust_FirstName)
    _FieldEnums.Add("cust_MiddleName", CustomersBOFieldNames.cust_MiddleName)
    _FieldEnums.Add("cust_LastName", CustomersBOFieldNames.cust_LastName)
    _FieldEnums.Add("cust_Suffix", CustomersBOFieldNames.cust_Suffix)
    _FieldEnums.Add("cust_Address1", CustomersBOFieldNames.cust_Address1)
    _FieldEnums.Add("cust_Address2", CustomersBOFieldNames.cust_Address2)
    _FieldEnums.Add("cust_City", CustomersBOFieldNames.cust_City)
    _FieldEnums.Add("cust_State", CustomersBOFieldNames.cust_State)
    _FieldEnums.Add("cust_Postal", CustomersBOFieldNames.cust_Postal)
    _FieldEnums.Add("cust_Country", CustomersBOFieldNames.cust_Country)
    _FieldEnums.Add("cust_Email", CustomersBOFieldNames.cust_Email)
    _FieldEnums.Add("cust_PhoneDay", CustomersBOFieldNames.cust_PhoneDay)
    _FieldEnums.Add("cust_PhoneDayType", CustomersBOFieldNames.cust_PhoneDayType)
    _FieldEnums.Add("cust_PhoneNight", CustomersBOFieldNames.cust_PhoneNight)
    _FieldEnums.Add("cust_PhoneNightType", CustomersBOFieldNames.cust_PhoneNightType)
    _FieldEnums.Add("cust_Created", CustomersBOFieldNames.cust_Created)
    _FieldEnums.Add("cust_Version", CustomersBOFieldNames.cust_Version)
    _FieldEnums.Add("CUSTOM_FIELD", CustomersBOFieldNames.CUSTOM_FIELD)

    _FieldLengths = New Dictionary(Of String, Integer)(20)
    _FieldLengths.Add("cust_pk", 0)
    _FieldLengths.Add("cust_Company", 150)
    _FieldLengths.Add("cust_Prefix", 20)
    _FieldLengths.Add("cust_FirstName", 60)
    _FieldLengths.Add("cust_MiddleName", 60)
    _FieldLengths.Add("cust_LastName", 60)
    _FieldLengths.Add("cust_Suffix", 20)
    _FieldLengths.Add("cust_Address1", 150)
    _FieldLengths.Add("cust_Address2", 150)
    _FieldLengths.Add("cust_City", 60)
    _FieldLengths.Add("cust_State", 128)
    _FieldLengths.Add("cust_Postal", 20)
    _FieldLengths.Add("cust_Country", 120)
    _FieldLengths.Add("cust_Email", 100)
    _FieldLengths.Add("cust_PhoneDay", 20)
    _FieldLengths.Add("cust_PhoneDayType", 0)
    _FieldLengths.Add("cust_PhoneNight", 20)
    _FieldLengths.Add("cust_PhoneNightType", 0)
    _FieldLengths.Add("cust_Created", 0)
    _FieldLengths.Add("cust_Version", 0)

    _FieldNativeDbTypes = New Dictionary(Of String, Integer)(20)
    _FieldNativeDbTypes.Add("cust_pk", System.Data.SqlDbType.Int)
    _FieldNativeDbTypes.Add("cust_Company", System.Data.SqlDbType.NVarChar)
    _FieldNativeDbTypes.Add("cust_Prefix", System.Data.SqlDbType.NVarChar)
    _FieldNativeDbTypes.Add("cust_FirstName", System.Data.SqlDbType.NVarChar)
    _FieldNativeDbTypes.Add("cust_MiddleName", System.Data.SqlDbType.NVarChar)
    _FieldNativeDbTypes.Add("cust_LastName", System.Data.SqlDbType.NVarChar)
    _FieldNativeDbTypes.Add("cust_Suffix", System.Data.SqlDbType.NVarChar)
    _FieldNativeDbTypes.Add("cust_Address1", System.Data.SqlDbType.NVarChar)
    _FieldNativeDbTypes.Add("cust_Address2", System.Data.SqlDbType.NVarChar)
    _FieldNativeDbTypes.Add("cust_City", System.Data.SqlDbType.NVarChar)
    _FieldNativeDbTypes.Add("cust_State", System.Data.SqlDbType.NVarChar)
    _FieldNativeDbTypes.Add("cust_Postal", System.Data.SqlDbType.VarChar)
    _FieldNativeDbTypes.Add("cust_Country", System.Data.SqlDbType.NVarChar)
    _FieldNativeDbTypes.Add("cust_Email", System.Data.SqlDbType.VarChar)
    _FieldNativeDbTypes.Add("cust_PhoneDay", System.Data.SqlDbType.VarChar)
    _FieldNativeDbTypes.Add("cust_PhoneDayType", System.Data.SqlDbType.Int)
    _FieldNativeDbTypes.Add("cust_PhoneNight", System.Data.SqlDbType.VarChar)
    _FieldNativeDbTypes.Add("cust_PhoneNightType", System.Data.SqlDbType.Int)
    _FieldNativeDbTypes.Add("cust_Created", System.Data.SqlDbType.DateTime)
    _FieldNativeDbTypes.Add("cust_Version", System.Data.SqlDbType.Int)

    _FieldPermissionKeys = New Dictionary(Of String, String)(20)

  End Sub

  Private Shared _AreCustomDescriptorsEvaluated As Boolean = False
  Protected Overrides ReadOnly Property AreCustomDescriptorsEvaluated() As Boolean
    Get
      Dim llReturn As Boolean = _AreCustomDescriptorsEvaluated
      _AreCustomDescriptorsEvaluated = True
      Return llReturn
    End Get
  End Property

  Private Shared _PropertyDescriptors As PropertyDescriptorDictionary
  Protected Overrides ReadOnly Property PropertyDescriptors() As PropertyDescriptorDictionary
    Get
      Return _PropertyDescriptors
    End Get
  End Property

  ''' <summary>
  ''' A private field used to store the System.Type of this business object for use by the FieldPropertyDescriptor classes.
  ''' </summary>
  ''' <remarks></remarks>

  Private Shared _ComponentType As System.Type = GetType(CustomersBO)

  ''' <summary>
  ''' A PropertyDescriptor class used to Get and Set the value of the cust_pk property.
  ''' </summary>
  ''' <remarks></remarks>
  Private Class Field_cust_pk_Descriptor
    Inherits MicroFour.StrataFrame.Business.FieldPropertyDescriptor
    Public Sub New()
      MyBase.New("cust_pk")
    End Sub
    Private _PropertyType As System.Type = GetType(System.Int32)
    Public Overrides Function GetValue(ByVal component As Object) As Object
      Return CType(component, CustomersBO).cust_pk
    End Function
    Public Overrides Sub SetValue(ByVal component As Object, ByVal Value As Object)
      CType(component, CustomersBO).cust_pk = CType(Value, System.Int32)
    End Sub
    Public Overrides ReadOnly Property PropertyType() As System.Type
      Get
        Return Me._PropertyType
      End Get
    End Property
    Public Overrides ReadOnly Property ComponentType() As System.Type
      Get
        Return _ComponentType
      End Get
    End Property
  End Class

  ''' <summary>
  ''' A PropertyDescriptor class used to Get and Set the value of the cust_Company property.
  ''' </summary>
  ''' <remarks></remarks>
  Private Class Field_cust_Company_Descriptor
    Inherits MicroFour.StrataFrame.Business.FieldPropertyDescriptor
    Public Sub New()
      MyBase.New("cust_Company")
    End Sub
    Private _PropertyType As System.Type = GetType(System.String)
    Public Overrides Function GetValue(ByVal component As Object) As Object
      Return CType(component, CustomersBO).cust_Company
    End Function
    Public Overrides Sub SetValue(ByVal component As Object, ByVal Value As Object)
      CType(component, CustomersBO).cust_Company = CType(Value, System.String)
    End Sub
    Public Overrides ReadOnly Property PropertyType() As System.Type
      Get
        Return Me._PropertyType
      End Get
    End Property
    Public Overrides ReadOnly Property ComponentType() As System.Type
      Get
        Return _ComponentType
      End Get
    End Property
  End Class

  ''' <summary>
  ''' A PropertyDescriptor class used to Get and Set the value of the cust_Prefix property.
  ''' </summary>
  ''' <remarks></remarks>
  Private Class Field_cust_Prefix_Descriptor
    Inherits MicroFour.StrataFrame.Business.FieldPropertyDescriptor
    Public Sub New()
      MyBase.New("cust_Prefix")
    End Sub
    Private _PropertyType As System.Type = GetType(System.String)
    Public Overrides Function GetValue(ByVal component As Object) As Object
      Return CType(component, CustomersBO).cust_Prefix
    End Function
    Public Overrides Sub SetValue(ByVal component As Object, ByVal Value As Object)
      CType(component, CustomersBO).cust_Prefix = CType(Value, System.String)
    End Sub
    Public Overrides ReadOnly Property PropertyType() As System.Type
      Get
        Return Me._PropertyType
      End Get
    End Property
    Public Overrides ReadOnly Property ComponentType() As System.Type
      Get
        Return _ComponentType
      End Get
    End Property
  End Class

  ''' <summary>
  ''' A PropertyDescriptor class used to Get and Set the value of the cust_FirstName property.
  ''' </summary>
  ''' <remarks></remarks>
  Private Class Field_cust_FirstName_Descriptor
    Inherits MicroFour.StrataFrame.Business.FieldPropertyDescriptor
    Public Sub New()
      MyBase.New("cust_FirstName")
    End Sub
    Private _PropertyType As System.Type = GetType(System.String)
    Public Overrides Function GetValue(ByVal component As Object) As Object
      Return CType(component, CustomersBO).cust_FirstName
    End Function
    Public Overrides Sub SetValue(ByVal component As Object, ByVal Value As Object)
      CType(component, CustomersBO).cust_FirstName = CType(Value, System.String)
    End Sub
    Public Overrides ReadOnly Property PropertyType() As System.Type
      Get
        Return Me._PropertyType
      End Get
    End Property
    Public Overrides ReadOnly Property ComponentType() As System.Type
      Get
        Return _ComponentType
      End Get
    End Property
  End Class

  ''' <summary>
  ''' A PropertyDescriptor class used to Get and Set the value of the cust_MiddleName property.
  ''' </summary>
  ''' <remarks></remarks>
  Private Class Field_cust_MiddleName_Descriptor
    Inherits MicroFour.StrataFrame.Business.FieldPropertyDescriptor
    Public Sub New()
      MyBase.New("cust_MiddleName")
    End Sub
    Private _PropertyType As System.Type = GetType(System.String)
    Public Overrides Function GetValue(ByVal component As Object) As Object
      Return CType(component, CustomersBO).cust_MiddleName
    End Function
    Public Overrides Sub SetValue(ByVal component As Object, ByVal Value As Object)
      CType(component, CustomersBO).cust_MiddleName = CType(Value, System.String)
    End Sub
    Public Overrides ReadOnly Property PropertyType() As System.Type
      Get
        Return Me._PropertyType
      End Get
    End Property
    Public Overrides ReadOnly Property ComponentType() As System.Type
      Get
        Return _ComponentType
      End Get
    End Property
  End Class

  ''' <summary>
  ''' A PropertyDescriptor class used to Get and Set the value of the cust_LastName property.
  ''' </summary>
  ''' <remarks></remarks>
  Private Class Field_cust_LastName_Descriptor
    Inherits MicroFour.StrataFrame.Business.FieldPropertyDescriptor
    Public Sub New()
      MyBase.New("cust_LastName")
    End Sub
    Private _PropertyType As System.Type = GetType(System.String)
    Public Overrides Function GetValue(ByVal component As Object) As Object
      Return CType(component, CustomersBO).cust_LastName
    End Function
    Public Overrides Sub SetValue(ByVal component As Object, ByVal Value As Object)
      CType(component, CustomersBO).cust_LastName = CType(Value, System.String)
    End Sub
    Public Overrides ReadOnly Property PropertyType() As System.Type
      Get
        Return Me._PropertyType
      End Get
    End Property
    Public Overrides ReadOnly Property ComponentType() As System.Type
      Get
        Return _ComponentType
      End Get
    End Property
  End Class

  ''' <summary>
  ''' A PropertyDescriptor class used to Get and Set the value of the cust_Suffix property.
  ''' </summary>
  ''' <remarks></remarks>
  Private Class Field_cust_Suffix_Descriptor
    Inherits MicroFour.StrataFrame.Business.FieldPropertyDescriptor
    Public Sub New()
      MyBase.New("cust_Suffix")
    End Sub
    Private _PropertyType As System.Type = GetType(System.String)
    Public Overrides Function GetValue(ByVal component As Object) As Object
      Return CType(component, CustomersBO).cust_Suffix
    End Function
    Public Overrides Sub SetValue(ByVal component As Object, ByVal Value As Object)
      CType(component, CustomersBO).cust_Suffix = CType(Value, System.String)
    End Sub
    Public Overrides ReadOnly Property PropertyType() As System.Type
      Get
        Return Me._PropertyType
      End Get
    End Property
    Public Overrides ReadOnly Property ComponentType() As System.Type
      Get
        Return _ComponentType
      End Get
    End Property
  End Class

  ''' <summary>
  ''' A PropertyDescriptor class used to Get and Set the value of the cust_Address1 property.
  ''' </summary>
  ''' <remarks></remarks>
  Private Class Field_cust_Address1_Descriptor
    Inherits MicroFour.StrataFrame.Business.FieldPropertyDescriptor
    Public Sub New()
      MyBase.New("cust_Address1")
    End Sub
    Private _PropertyType As System.Type = GetType(System.String)
    Public Overrides Function GetValue(ByVal component As Object) As Object
      Return CType(component, CustomersBO).cust_Address1
    End Function
    Public Overrides Sub SetValue(ByVal component As Object, ByVal Value As Object)
      CType(component, CustomersBO).cust_Address1 = CType(Value, System.String)
    End Sub
    Public Overrides ReadOnly Property PropertyType() As System.Type
      Get
        Return Me._PropertyType
      End Get
    End Property
    Public Overrides ReadOnly Property ComponentType() As System.Type
      Get
        Return _ComponentType
      End Get
    End Property
  End Class

  ''' <summary>
  ''' A PropertyDescriptor class used to Get and Set the value of the cust_Address2 property.
  ''' </summary>
  ''' <remarks></remarks>
  Private Class Field_cust_Address2_Descriptor
    Inherits MicroFour.StrataFrame.Business.FieldPropertyDescriptor
    Public Sub New()
      MyBase.New("cust_Address2")
    End Sub
    Private _PropertyType As System.Type = GetType(System.String)
    Public Overrides Function GetValue(ByVal component As Object) As Object
      Return CType(component, CustomersBO).cust_Address2
    End Function
    Public Overrides Sub SetValue(ByVal component As Object, ByVal Value As Object)
      CType(component, CustomersBO).cust_Address2 = CType(Value, System.String)
    End Sub
    Public Overrides ReadOnly Property PropertyType() As System.Type
      Get
        Return Me._PropertyType
      End Get
    End Property
    Public Overrides ReadOnly Property ComponentType() As System.Type
      Get
        Return _ComponentType
      End Get
    End Property
  End Class

  ''' <summary>
  ''' A PropertyDescriptor class used to Get and Set the value of the cust_City property.
  ''' </summary>
  ''' <remarks></remarks>
  Private Class Field_cust_City_Descriptor
    Inherits MicroFour.StrataFrame.Business.FieldPropertyDescriptor
    Public Sub New()
      MyBase.New("cust_City")
    End Sub
    Private _PropertyType As System.Type = GetType(System.String)
    Public Overrides Function GetValue(ByVal component As Object) As Object
      Return CType(component, CustomersBO).cust_City
    End Function
    Public Overrides Sub SetValue(ByVal component As Object, ByVal Value As Object)
      CType(component, CustomersBO).cust_City = CType(Value, System.String)
    End Sub
    Public Overrides ReadOnly Property PropertyType() As System.Type
      Get
        Return Me._PropertyType
      End Get
    End Property
    Public Overrides ReadOnly Property ComponentType() As System.Type
      Get
        Return _ComponentType
      End Get
    End Property
  End Class

  ''' <summary>
  ''' A PropertyDescriptor class used to Get and Set the value of the cust_State property.
  ''' </summary>
  ''' <remarks></remarks>
  Private Class Field_cust_State_Descriptor
    Inherits MicroFour.StrataFrame.Business.FieldPropertyDescriptor
    Public Sub New()
      MyBase.New("cust_State")
    End Sub
    Private _PropertyType As System.Type = GetType(System.String)
    Public Overrides Function GetValue(ByVal component As Object) As Object
      Return CType(component, CustomersBO).cust_State
    End Function
    Public Overrides Sub SetValue(ByVal component As Object, ByVal Value As Object)
      CType(component, CustomersBO).cust_State = CType(Value, System.String)
    End Sub
    Public Overrides ReadOnly Property PropertyType() As System.Type
      Get
        Return Me._PropertyType
      End Get
    End Property
    Public Overrides ReadOnly Property ComponentType() As System.Type
      Get
        Return _ComponentType
      End Get
    End Property
  End Class

  ''' <summary>
  ''' A PropertyDescriptor class used to Get and Set the value of the cust_Postal property.
  ''' </summary>
  ''' <remarks></remarks>
  Private Class Field_cust_Postal_Descriptor
    Inherits MicroFour.StrataFrame.Business.FieldPropertyDescriptor
    Public Sub New()
      MyBase.New("cust_Postal")
    End Sub
    Private _PropertyType As System.Type = GetType(System.String)
    Public Overrides Function GetValue(ByVal component As Object) As Object
      Return CType(component, CustomersBO).cust_Postal
    End Function
    Public Overrides Sub SetValue(ByVal component As Object, ByVal Value As Object)
      CType(component, CustomersBO).cust_Postal = CType(Value, System.String)
    End Sub
    Public Overrides ReadOnly Property PropertyType() As System.Type
      Get
        Return Me._PropertyType
      End Get
    End Property
    Public Overrides ReadOnly Property ComponentType() As System.Type
      Get
        Return _ComponentType
      End Get
    End Property
  End Class

  ''' <summary>
  ''' A PropertyDescriptor class used to Get and Set the value of the cust_Country property.
  ''' </summary>
  ''' <remarks></remarks>
  Private Class Field_cust_Country_Descriptor
    Inherits MicroFour.StrataFrame.Business.FieldPropertyDescriptor
    Public Sub New()
      MyBase.New("cust_Country")
    End Sub
    Private _PropertyType As System.Type = GetType(System.String)
    Public Overrides Function GetValue(ByVal component As Object) As Object
      Return CType(component, CustomersBO).cust_Country
    End Function
    Public Overrides Sub SetValue(ByVal component As Object, ByVal Value As Object)
      CType(component, CustomersBO).cust_Country = CType(Value, System.String)
    End Sub
    Public Overrides ReadOnly Property PropertyType() As System.Type
      Get
        Return Me._PropertyType
      End Get
    End Property
    Public Overrides ReadOnly Property ComponentType() As System.Type
      Get
        Return _ComponentType
      End Get
    End Property
  End Class

  ''' <summary>
  ''' A PropertyDescriptor class used to Get and Set the value of the cust_Email property.
  ''' </summary>
  ''' <remarks></remarks>
  Private Class Field_cust_Email_Descriptor
    Inherits MicroFour.StrataFrame.Business.FieldPropertyDescriptor
    Public Sub New()
      MyBase.New("cust_Email")
    End Sub
    Private _PropertyType As System.Type = GetType(System.String)
    Public Overrides Function GetValue(ByVal component As Object) As Object
      Return CType(component, CustomersBO).cust_Email
    End Function
    Public Overrides Sub SetValue(ByVal component As Object, ByVal Value As Object)
      CType(component, CustomersBO).cust_Email = CType(Value, System.String)
    End Sub
    Public Overrides ReadOnly Property PropertyType() As System.Type
      Get
        Return Me._PropertyType
      End Get
    End Property
    Public Overrides ReadOnly Property ComponentType() As System.Type
      Get
        Return _ComponentType
      End Get
    End Property
  End Class

  ''' <summary>
  ''' A PropertyDescriptor class used to Get and Set the value of the cust_PhoneDay property.
  ''' </summary>
  ''' <remarks></remarks>
  Private Class Field_cust_PhoneDay_Descriptor
    Inherits MicroFour.StrataFrame.Business.FieldPropertyDescriptor
    Public Sub New()
      MyBase.New("cust_PhoneDay")
    End Sub
    Private _PropertyType As System.Type = GetType(System.String)
    Public Overrides Function GetValue(ByVal component As Object) As Object
      Return CType(component, CustomersBO).cust_PhoneDay
    End Function
    Public Overrides Sub SetValue(ByVal component As Object, ByVal Value As Object)
      CType(component, CustomersBO).cust_PhoneDay = CType(Value, System.String)
    End Sub
    Public Overrides ReadOnly Property PropertyType() As System.Type
      Get
        Return Me._PropertyType
      End Get
    End Property
    Public Overrides ReadOnly Property ComponentType() As System.Type
      Get
        Return _ComponentType
      End Get
    End Property
  End Class

  ''' <summary>
  ''' A PropertyDescriptor class used to Get and Set the value of the cust_PhoneDayType property.
  ''' </summary>
  ''' <remarks></remarks>
  Private Class Field_cust_PhoneDayType_Descriptor
    Inherits MicroFour.StrataFrame.Business.FieldPropertyDescriptor
    Public Sub New()
      MyBase.New("cust_PhoneDayType")
    End Sub
    Private _PropertyType As System.Type = GetType(System.Int32)
    Public Overrides Function GetValue(ByVal component As Object) As Object
      Return CType(component, CustomersBO).cust_PhoneDayType
    End Function
    Public Overrides Sub SetValue(ByVal component As Object, ByVal Value As Object)
      CType(component, CustomersBO).cust_PhoneDayType = CType(Value, System.Int32)
    End Sub
    Public Overrides ReadOnly Property PropertyType() As System.Type
      Get
        Return Me._PropertyType
      End Get
    End Property
    Public Overrides ReadOnly Property ComponentType() As System.Type
      Get
        Return _ComponentType
      End Get
    End Property
  End Class

  ''' <summary>
  ''' A PropertyDescriptor class used to Get and Set the value of the cust_PhoneNight property.
  ''' </summary>
  ''' <remarks></remarks>
  Private Class Field_cust_PhoneNight_Descriptor
    Inherits MicroFour.StrataFrame.Business.FieldPropertyDescriptor
    Public Sub New()
      MyBase.New("cust_PhoneNight")
    End Sub
    Private _PropertyType As System.Type = GetType(System.String)
    Public Overrides Function GetValue(ByVal component As Object) As Object
      Return CType(component, CustomersBO).cust_PhoneNight
    End Function
    Public Overrides Sub SetValue(ByVal component As Object, ByVal Value As Object)
      CType(component, CustomersBO).cust_PhoneNight = CType(Value, System.String)
    End Sub
    Public Overrides ReadOnly Property PropertyType() As System.Type
      Get
        Return Me._PropertyType
      End Get
    End Property
    Public Overrides ReadOnly Property ComponentType() As System.Type
      Get
        Return _ComponentType
      End Get
    End Property
  End Class

  ''' <summary>
  ''' A PropertyDescriptor class used to Get and Set the value of the cust_PhoneNightType property.
  ''' </summary>
  ''' <remarks></remarks>
  Private Class Field_cust_PhoneNightType_Descriptor
    Inherits MicroFour.StrataFrame.Business.FieldPropertyDescriptor
    Public Sub New()
      MyBase.New("cust_PhoneNightType")
    End Sub
    Private _PropertyType As System.Type = GetType(System.Int32)
    Public Overrides Function GetValue(ByVal component As Object) As Object
      Return CType(component, CustomersBO).cust_PhoneNightType
    End Function
    Public Overrides Sub SetValue(ByVal component As Object, ByVal Value As Object)
      CType(component, CustomersBO).cust_PhoneNightType = CType(Value, System.Int32)
    End Sub
    Public Overrides ReadOnly Property PropertyType() As System.Type
      Get
        Return Me._PropertyType
      End Get
    End Property
    Public Overrides ReadOnly Property ComponentType() As System.Type
      Get
        Return _ComponentType
      End Get
    End Property
  End Class

  ''' <summary>
  ''' A PropertyDescriptor class used to Get and Set the value of the cust_Created property.
  ''' </summary>
  ''' <remarks></remarks>
  Private Class Field_cust_Created_Descriptor
    Inherits MicroFour.StrataFrame.Business.FieldPropertyDescriptor
    Public Sub New()
      MyBase.New("cust_Created")
    End Sub
    Private _PropertyType As System.Type = GetType(System.DateTime)
    Public Overrides Function GetValue(ByVal component As Object) As Object
      Return CType(component, CustomersBO).cust_Created
    End Function
    Public Overrides Sub SetValue(ByVal component As Object, ByVal Value As Object)
      CType(component, CustomersBO).cust_Created = CType(Value, System.DateTime)
    End Sub
    Public Overrides ReadOnly Property PropertyType() As System.Type
      Get
        Return Me._PropertyType
      End Get
    End Property
    Public Overrides ReadOnly Property ComponentType() As System.Type
      Get
        Return _ComponentType
      End Get
    End Property
  End Class

  ''' <summary>
  ''' A PropertyDescriptor class used to Get and Set the value of the cust_Version property.
  ''' </summary>
  ''' <remarks></remarks>
  Private Class Field_cust_Version_Descriptor
    Inherits MicroFour.StrataFrame.Business.FieldPropertyDescriptor
    Public Sub New()
      MyBase.New("cust_Version")
    End Sub
    Private _PropertyType As System.Type = GetType(System.Int32)
    Public Overrides Function GetValue(ByVal component As Object) As Object
      Return CType(component, CustomersBO).cust_Version
    End Function
    Public Overrides Sub SetValue(ByVal component As Object, ByVal Value As Object)
      CType(component, CustomersBO).cust_Version = CType(Value, System.Int32)
    End Sub
    Public Overrides ReadOnly Property PropertyType() As System.Type
      Get
        Return Me._PropertyType
      End Get
    End Property
    Public Overrides ReadOnly Property ComponentType() As System.Type
      Get
        Return _ComponentType
      End Get
    End Property
  End Class

#End Region

End Class

