
''' <summary>
''' Define the column type of a SearchEngine.Column.
''' </summary>
''' <remarks></remarks>
<Flags()> _
Public Enum SearchColumnTypes

  ''' <summary>
  ''' The column is not defined.
  ''' </summary>
  ''' <remarks></remarks>
  Unknown = 0

  ''' <summary>
  ''' The column is used in the select clause of
  ''' the SQL statement.
  ''' </summary>
  ''' <remarks></remarks>
  SelectColumn = 1

  ''' <summary>
  ''' The column is used in the order by clause of 
  ''' the SQL statement.
  ''' </summary>
  ''' <remarks></remarks>
  SortColumn = 2

  ''' <summary>
  ''' The column is included in the list.
  ''' </summary>
  ''' <remarks>
  ''' </remarks>
  ListColumn = 4

  ''' <summary>
  ''' The column is used in the select and order by
  ''' clauses of the SQL statement and can be displayed
  ''' in the results list.
  ''' </summary>
  ''' <remarks></remarks>
  StandardColumn = 7

End Enum

''' <summary>
''' Define how the select statement of the SearchEngine 
''' builds the select clause.  
''' </summary>
''' <remarks></remarks>
Public Enum SearchSelectType
  ''' <summary>
  ''' Include all columns from the Columns collection that are
  ''' marked as select columns.
  ''' </summary>
  ''' <remarks></remarks>
  SelectColumns

  ''' <summary>
  ''' Include all columns from the Columns collection that are
  ''' marked as PK columns.
  ''' </summary>
  ''' <remarks></remarks>
  PKColumns

  ''' <summary>
  ''' Use the BoAllFieldList to build the select clause.
  ''' </summary>
  ''' <remarks>
  ''' These are the columns in the BO that are mapped to the 
  ''' database.
  ''' </remarks>
  BOColumns
End Enum

''' <summary>
''' Define the value type of a value used in a search. 
''' The value can be any part of a search template that
''' is to be replaced at runtime including field names
''' operators, values etc.
''' </summary>
''' <remarks></remarks>
Public Enum SearchValueType

  ''' <summary>
  ''' Value type is text (string).
  ''' </summary>
  ''' <remarks>
  ''' Default (0).
  ''' </remarks>
  Text

  ''' <summary>
  ''' Valud type is a long text field (string). This 
  ''' is a TEXT field in SQL or a Memo field in Access.
  ''' Certain queries aren't allowed with long text 
  ''' fields.
  ''' </summary>
  ''' <remarks></remarks>
  LongText

  ''' <summary>
  ''' Value type is a number (integer, float, etc).
  ''' </summary>
  ''' <remarks></remarks>
  Number

  ''' <summary>
  ''' Value type is a date (no time).
  ''' </summary>
  ''' <remarks>
  ''' 'Date' is a reserved word, so it couldn't be used.
  ''' </remarks>
  Calendar

  ''' <summary>
  ''' Value type is time (no date).
  ''' </summary>
  ''' <remarks></remarks>
  Time

  ''' <summary>
  ''' Value type is both date and time.
  ''' </summary>
  ''' <remarks></remarks>
  DateTime

  ''' <summary>
  ''' Value type is a field name.
  ''' </summary>
  ''' <remarks></remarks>
  Field

  ''' <summary>
  ''' Value type is an operator.
  ''' </summary>
  ''' <remarks></remarks>
  SearchOperator

  ''' <summary>
  ''' The template is using a mixed set of data types.
  ''' </summary>
  ''' <remarks>
  ''' This should only be used at the template level.
  ''' </remarks>
  Mixed = -1

  ''' <summary>
  ''' Data type is unknown.
  ''' </summary>
  ''' <remarks></remarks>
  Unknown = -2

End Enum

''' <summary>
''' Define common search template types.
''' </summary>
''' <remarks>
''' This enumaration is used to simplify the creation of 
''' SearchTemplate objects for common template types.
''' 
''' These all pertain to templates that will prompt the 
''' user for a value(s).
''' </remarks>
Public Enum StandardSearchTemplate
  ''' <summary>
  ''' Search text field with criterion starting with the value.
  ''' </summary>
  ''' <remarks></remarks>
  TextStartsWith

  ''' <summary>
  ''' Search text field with criterion ending with the value.
  ''' </summary>
  ''' <remarks></remarks>
  TextEndsWith

  ''' <summary>
  ''' Search text field with criterion containing the value.
  ''' </summary>
  ''' <remarks></remarks>
  TextContains

  ''' <summary>
  ''' Search text field with criterion the pattern indicated by the value.
  ''' </summary>
  ''' <remarks></remarks>
  TextPattern

  ''' <summary>
  ''' Search text field with criterion that equals the value.
  ''' </summary>
  ''' <remarks>
  ''' This template will NOT work with SQL Text columns. 
  ''' Text columns must use LIKE.
  ''' </remarks>
  TextEquals

  ''' <summary>
  ''' Search text field with criterion that is within a list (as defined by the value).
  ''' </summary>
  ''' <remarks></remarks>
  TextInList

  ''' <summary>
  ''' Search text field with criterion that equals the value.
  ''' </summary>
  ''' <remarks></remarks>
  NumberEquals

  ''' <summary>
  ''' Search text field with criterion that is NOT equal to the value.
  ''' </summary>
  ''' <remarks></remarks>
  NumberNotEquals

  ''' <summary>
  ''' Search text field with criterion that is within a list (as defined by the value).
  ''' </summary>
  ''' <remarks></remarks>
  NumberInList

  ''' <summary>
  ''' Search text field with criterion that is between two values.
  ''' </summary>
  ''' <remarks></remarks>
  NumberBetween

  ''' <summary>
  ''' Search text field with criterion that matches the comparison with a value.
  ''' </summary>
  ''' <remarks></remarks>
  NumberComparison

  ''' <summary>
  ''' Search text field with criterion that equals the value.
  ''' </summary>
  ''' <remarks></remarks>
  DateEquals

  ''' <summary>
  ''' Search text field with criterion that is NOT equal to the value.
  ''' </summary>
  ''' <remarks></remarks>
  DateNotEquals

  ''' <summary>
  ''' Search text field with criterion that is within a list (as defined by the value).
  ''' </summary>
  ''' <remarks></remarks>
  DateInList

  ''' <summary>
  ''' Search text field with criterion that is between two values.
  ''' </summary>
  ''' <remarks></remarks>
  DateBetween

  ''' <summary>
  ''' Search text field with criterion that matches the comparison with a value.
  ''' </summary>
  ''' <remarks></remarks>
  DateComparison
End Enum

''' <summary>
''' Define sources of search criterion values.
''' </summary>
''' <remarks>
''' This is used to indicate how the user will provide the
''' value of a search criterion.
''' </remarks>
Public Enum SearchValueSource
  ''' <summary>
  ''' User provides value.
  ''' </summary>
  ''' <remarks>
  ''' Default (0).
  ''' </remarks>
  User

  ''' <summary>
  ''' The value is selected form a list.
  ''' </summary>
  ''' <remarks></remarks>
  List
End Enum

''' <summary>
''' Define source of data for search list.
''' </summary>
''' <remarks>
''' If the value source of a search field is list, this
''' defines the sources of data to fill those lists.
''' </remarks>
Public Enum SearchListSource
  ''' <summary>
  ''' Fill the list using an enumeration.
  ''' </summary>
  ''' <remarks>
  ''' Default value (0).
  ''' </remarks>
  Enumeration

  ''' <summary>
  ''' Fill the list using a named application list.
  ''' </summary>
  ''' <remarks>
  ''' These are lists defined in the database in the tblLookupListRef table.
  ''' </remarks>
  AppList

  ''' <summary>
  ''' Fill the list using a BO.
  ''' </summary>
  ''' <remarks>
  ''' A ListPopulationSettings object is needed to define how the list
  ''' is filled.
  ''' </remarks>
  BusinessObject

  ''' <summary>
  ''' Fill the list using code.
  ''' </summary>
  ''' <remarks>
  ''' The code should create a data table and bind it to the list.
  ''' </remarks>
  Custom
End Enum

''' <summary>
''' Define how SearchFields are presented to the user.
''' </summary>
''' <remarks></remarks>
Public Enum SearchFieldPresentationMode
  ''' <summary>
  ''' Each field is presented individually. The DisplayText is
  ''' presented as a label (or some UI equivalent).
  ''' </summary>
  ''' <remarks></remarks>
  SingleField

  ''' <summary>
  ''' A combo (or other list selection UI element)
  ''' is used to allow the user to select the field.
  ''' </summary>
  ''' <remarks></remarks>
  SelectField
End Enum

''' <summary>
''' Define the types of controls needed by a search form.
''' </summary>
''' <remarks>
''' This indicates functionality, not the implementation.
''' I.e. this doesn't indicate the control type, but rather
''' the function of the control. Thus this can be used by
''' both winform and webform apps that use the SearchEngine/
''' SearchForm classes.
''' </remarks>
Public Enum SearchControlType
  ''' <summary>
  ''' A control that displays the field display name to the user.
  ''' </summary>
  ''' <remarks></remarks>
  FieldLabel

  ''' <summary>
  ''' A control that allows the user to select a field from a list.
  ''' </summary>
  ''' <remarks></remarks>
  FieldSelector

  ''' <summary>
  ''' A control that allows the user to select a template from a list.
  ''' </summary>
  ''' <remarks></remarks>
  TemplateSelector

  ''' <summary>
  ''' A control that allows the user to enter a value.
  ''' </summary>
  ''' <remarks></remarks>
  ValueEntry

  ''' <summary>
  ''' A control that allows the user to select a value from a list.
  ''' </summary>
  ''' <remarks></remarks>
  ValueList

  ''' <summary>
  ''' A control that adds a new field to the form.
  ''' </summary>
  ''' <remarks></remarks>
  AddField

  ''' <summary>
  ''' A control that provides the user information, usually shown
  ''' when a FieldSelector is used, since the TemplateSelector and
  ''' ValueEntry or ValueList controls won't exist yet (or won't be
  ''' shown yet).
  ''' </summary>
  ''' <remarks></remarks>
  UserInfo

  ''' <summary>
  ''' A control that removes the set of controls for a criterion field.
  ''' </summary>
  ''' <remarks></remarks>
  RemoveButton
End Enum

''' <summary>
''' Define the source of the value that will replace
''' a token within a SearchTemplate.
''' </summary>
''' <remarks></remarks>
Public Enum SearchTokenSource
  ''' <summary>
  ''' The value will be supplied by the user.
  ''' </summary>
  ''' <remarks>
  ''' A value will either be from a list or parsed
  ''' from a regex.
  ''' </remarks>
  User

  ''' <summary>
  ''' The value will be provided by code.
  ''' </summary>
  ''' <remarks></remarks>
  Code
End Enum

''' <summary>
''' Define the flags that can be used to indicate which
''' standard buttons to include on a search form.
''' </summary>
''' <remarks></remarks>
<Flags()> _
Public Enum StandardSearchButtons
  ''' <summary>
  ''' Use no standard buttons.
  ''' </summary>
  ''' <remarks></remarks>
  None = 0

  ''' <summary>
  ''' Use a standard button that will close the form.
  ''' </summary>
  ''' <remarks></remarks>
  Close = 1

  ''' <summary>
  ''' Use a standard button that will close a dialog 
  ''' and return a result of OK.
  ''' </summary>
  ''' <remarks></remarks>
  ReturnOK = 2

  ''' <summary>
  ''' Use a standard button that will close the dialog
  ''' and return a result of Cancel.
  ''' </summary>
  ''' <remarks></remarks>
  ReturnCancel = 4

  ''' <summary>
  ''' Use both the standard ReturnOK and ReturnCancel buttons.
  ''' </summary>
  ''' <remarks></remarks>
  BothOKCancel = 6
End Enum

''' <summary>
''' Define reselection types for the CurrentNodeKeeper class.
''' This indicates the logic that will be used to reselect a
''' node when the end using statement is called.
''' </summary>
''' <remarks>
''' The general logic followed with these types is to try each
''' of these in succession until something is selected:
''' 
''' <list>
''' <item>current item</item>
''' <item>item below</item>
''' <item>item above</item>
''' <item>parent</item>
''' <item>first item in tree</item>
''' </list>
''' 
''' If there are no items in the tree, nothing is reselected.
''' 
''' If the specific selection modes are indicated, it is expected
''' that they will work. If not an exception is thrown.
''' </remarks>
Public Enum ReselectNodeType

  ''' <summary>
  ''' The first node that can be selected is selected. This is
  ''' the default item.
  ''' </summary>
  ''' <remarks>
  ''' This will attempt to find the current node first, then
  ''' the node below it, then the node above it, then the parent
  ''' and finally the first node in the tree.
  ''' 
  ''' This will be slower typically than defining the type
  ''' explicitly. However, it will also not throw any exceptions.
  ''' </remarks>
  Related = 0

  ''' <summary>
  ''' The first node related to the current node is selected.
  ''' </summary>
  ''' <remarks>
  ''' This will not attempt to select the current node, but then
  ''' follows the logic of the Related type.
  ''' 
  ''' This is best used for deletes.
  ''' </remarks>
  RelatedNotCurrent

  ''' <summary>
  ''' The current node should be reselected.
  ''' </summary>
  ''' <remarks>
  ''' This is used with move/rearrangements.
  ''' </remarks>
  Current

  ''' <summary>
  ''' The parent of the current node will be reselected.
  ''' </summary>
  ''' <remarks>
  ''' This usually isn't used, but sometimes the action on
  ''' a tree may be so confusing that this is the best option. 
  ''' </remarks>
  Parent

  ''' <summary>
  ''' The first item in the tree will be selected.
  ''' </summary>
  ''' <remarks>
  ''' This is best used when the tree is being completely
  ''' refreshed.
  ''' </remarks>
  FirstInTree

End Enum

''' <summary>
''' Define the view options for a splitter that has a list 
''' on side and details on the other.
''' </summary>
''' <remarks></remarks>
Public Enum ViewOption
  ''' <summary>
  ''' View both the list and the details.
  ''' </summary>
  ''' <remarks>
  ''' This is the default
  ''' </remarks>
  Both = 0

  ''' <summary>
  ''' View only the list.
  ''' </summary>
  ''' <remarks></remarks>
  List

  ''' <summary>
  ''' View only the details.
  ''' </summary>
  ''' <remarks></remarks>
  Details
End Enum

''' <summary>
''' Define the actions that are taken on a controls state(s)
''' based on rules defined for it and managed by the 
''' ControlStateManager.
''' </summary>
''' <remarks>
''' This is used to indicate what action should be taken based
''' on the users permissions. Thus it can be used to hide/disable
''' a control based the state of any permission a user has. I.e.
''' it can be used to hide a control if the user has GRANT on a 
''' permission as well as disable a control if the has READONLY
''' on a permission.
''' </remarks>
Public Enum ControlStateAction
  ''' <summary>
  ''' The control is visible and enabled.
  ''' </summary>
  ''' <remarks>
  ''' Typical action when the user has GRANT access.
  ''' </remarks>
  Normal

  ''' <summary>
  ''' Disable the control
  ''' </summary>
  ''' <remarks>
  ''' This typically will affect the Enabled property.
  ''' </remarks>
  Disable

  ''' <summary>
  ''' Hide the control.
  ''' </summary>
  ''' <remarks>
  ''' This typically will affect the Visible property.
  ''' </remarks>
  Hide

End Enum

''' <summary>
''' Define the states that the ControlStateManager can affect.
''' </summary>
''' <remarks></remarks>
Public Enum ControlState
  ''' <summary>
  ''' Neither the visibility or enabled state of the control.
  ''' </summary>
  ''' <remarks></remarks>
  None

  ''' <summary>
  ''' Visibility of the control.
  ''' </summary>
  ''' <remarks></remarks>
  Visibility

  ''' <summary>
  ''' Enabled state of the control.
  ''' </summary>
  ''' <remarks></remarks>
  ''' 
  Enabled

  ''' <summary>
  ''' Visibility and enabled state of the control.
  ''' </summary>
  ''' <remarks></remarks>
  Both
End Enum

''' <summary>
''' Define when UI clues are shown for required fields.
''' </summary>
''' <remarks></remarks>
Public Enum RequiredFieldsShown
  ''' <summary>
  ''' Never show UI clues about required fields.
  ''' </summary>
  ''' <remarks></remarks>
  Never = 0

  ''' <summary>
  ''' Show UI clues about required fields only when
  ''' adding a record.
  ''' </summary>
  ''' <remarks></remarks>
  OnAdd

  ''' <summary>
  ''' Show UI clues about required fields only when
  ''' editing a record.
  ''' </summary>
  ''' <remarks></remarks>
  OnEdit

  ''' <summary>
  ''' Show UI clues about required fields when both
  ''' adding and editing a record.
  ''' </summary>
  ''' <remarks></remarks>
  Always
End Enum
