﻿
''' <summary>
''' Provide UI to show the remediation for a requirement/vendor.
''' </summary>
''' <remarks>
''' Remediations are controlled changes to a requirement after it
''' has been published. Remediation is always on a requirement 
''' relative to a vendor. Remedation is only avialable if the project
''' has locked requirements.
''' </remarks>
Public Class ReqRemediationForm

#Region "   Constructors "

  ''' <summary>
  ''' Construct an instance with the default project and the
  ''' indicated requirement key.
  ''' </summary>
  ''' <param name="requirementKey"></param>
  ''' <remarks></remarks>
  Public Sub New(ByVal requirementKey As Integer)
    Me.New(0, requirementKey)
  End Sub

  ''' <summary>
  ''' Construct an instance for the indicated project and requirement.
  ''' </summary>
  ''' <param name="projectID"></param>
  ''' <param name="requirementKey"></param>
  ''' <remarks></remarks>
  Public Sub New(ByVal projectID As Integer, ByVal requirementKey As Integer)
    '-- Set the project
    Me.SetProjectID(projectID)

    '-- This call is required by the Windows Form Designer.
    InitializeComponent()

    '-- Make sure the z-order is correct
    Me.tcVendorSelection.SendToBack()
    Me.ramsHeader.SendToBack()

    '-- Setup the remediation panel
    Me.RemediationSummaryPanel1.RequirementKey = requirementKey

    '-- Load the requirement area
    Dim reqTitleTemplate As String = Me.tcRequirementInfo.Title
    Dim reqName As String = "Some Requirement"
    Me.tcRequirementInfo.Title = String.Format(reqTitleTemplate, reqName)
    Me.lblRequirementKey.Text = requirementKey.ToString()
    Me.lblRequirementName.Text = reqName
  End Sub

#End Region

#Region "   Event Handlers "

  ''' <summary>
  ''' Show the current requirement in the requirement editor
  ''' form.
  ''' </summary>
  ''' <remarks></remarks>
  Private Sub tcRequirementInfo_CloseButtonClicked() Handles tcRequirementInfo.CloseButtonClicked
    '-- Get the key of the current requirment
    Dim key As Integer = Me.RemediationSummaryPanel1.RequirementKey

    '-- Validate there is a requirement key
    If key = 0 Then Return

    '-- Show the requirement form. If this form is opened 
    '   modally, then open the requirement modally (otherwise
    '   it will be behind this form).
    If Me.Modal Then
      MessageBox.Show("Requirement details...")
    Else
      MessageBox.Show("Requirement details...")
    End If
  End Sub

  Private Sub ReqRemediationForm_Resize(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Resize
    Me.tcRequirementInfo.Update()
  End Sub

  ''' <summary>
  ''' Invalidate the requirement info container so it is redrawn.
  ''' </summary>
  ''' <param name="sender"></param>
  ''' <param name="e"></param>
  ''' <remarks></remarks>
  Private Sub ReqRemediationForm_ResizeEnd(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.ResizeEnd
    ' Me.tcRequirementInfo.Update()
  End Sub

  ''' <summary>
  ''' Load the remediation related to this vendor.
  ''' </summary>
  ''' <param name="sender"></param>
  ''' <param name="e"></param>
  ''' <remarks></remarks>
  Private Sub ReqRemediationForm_VendorChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.VendorChanged
    Me.RemediationSummaryPanel1.LoadRemediation(Me.ProjectID, Me.VendorID, Me.RemediationSummaryPanel1.RequirementKey)
  End Sub

#End Region

End Class
