

''' <summary>
''' Delegate used by the ControlStateManager class when setting
''' the states of controls to allow callbacks to provide 
''' additional logic on determining if a control is visible/enabled.
''' </summary>
''' <param name="item">control being checked</param>
''' <param name="stateToCheck">what state is being checked</param>
''' <returns>True if control should have the indicated state</returns>
''' <remarks>
''' The ControlStateManager only intrinsically handles the state of 
''' a control based on security permissions. In order to allow for 
''' all the other logic (very form specific) this callback should
''' be implemented in each form.  The results of this callback are
''' anded to the permission results to determine the final state.
''' </remarks>
Public Delegate Function ControlStateCallback(ByVal item As Object, ByVal stateToCheck As ControlState) As Boolean


''' <summary>
''' Delegate used by the BaseForm when raising the 
''' FormItemSaved event. The handler provides information 
''' about the item being saved and the number of rows saved.
''' </summary>
''' <param name="sender"></param>
''' <param name="e"></param>
''' <remarks></remarks>
Public Delegate Sub FormItemSavedEventHandler(ByVal sender As Object, ByVal e As FormItemSavedEventArgs)