
''' <summary>
''' Event arguments used with the FormItemSaved event used 
''' by the BaseForm. This extends the SF AfterSavedEventArgs
''' by adding some information about the item saved.
''' </summary>
''' <remarks></remarks>
Public Class FormItemSavedEventArgs
  Inherits System.EventArgs

#Region "   Constructors "

  ''' <summary>
  ''' Construct a default, blank instance.
  ''' </summary>
  ''' <remarks></remarks>
  Public Sub New()
  End Sub

  ''' <summary>
  ''' Construct an instance with its data set.
  ''' </summary>
  ''' <param name="id"></param>
  ''' <param name="rowsAffected"></param>
  ''' <remarks></remarks>
  Public Sub New(ByVal id As Integer, ByVal rowsAffected As Integer)
    Me.ItemID = id
    Me.RowsAffected = rowsAffected
  End Sub

#End Region

#Region "   Properties "

  Private _itemID As Integer

  ''' <summary>
  ''' Define the ID of the items saved.
  ''' </summary>
  ''' <value></value>
  ''' <returns></returns>
  ''' <remarks>
  ''' If more than one row is affected it is not clear which 
  ''' ID this will return.
  ''' </remarks>
  Public Property ItemID() As Integer
    Get
      Return _itemID
    End Get
    Set(ByVal value As Integer)
      _itemID = value
    End Set
  End Property

  Private _rowsAffected As Integer

  ''' <summary>
  ''' Define the number of rows affected.
  ''' </summary>
  ''' <value></value>
  ''' <returns></returns>
  ''' <remarks></remarks>     
  Public Property RowsAffected() As Integer
    Get
      Return _rowsAffected
    End Get
    Set(ByVal value As Integer)
      _rowsAffected = value
    End Set
  End Property

#End Region

End Class
