﻿Public Class MainForm

  ''' <summary>
  ''' Test formatting of a boolean using the values entered
  ''' on the form.
  ''' </summary>
  ''' <param name="sender"></param>
  ''' <param name="e"></param>
  ''' <remarks></remarks>
  Private Sub btnFormat_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnFormat.Click
    '-- If not format provider was set, use a default
    If String.IsNullOrEmpty(Me.txtFormatString.Text) Then
      Me.txtFormatString.Text = "yes|no"
    End If

    '-- If the delimiter wasn't provided, use default
    If String.IsNullOrEmpty(Me.txtDelimiter.Text) Then
      Me.txtDelimiter.Text = New BooleanFormatProvider().Delimiter
    End If

    '-- Get the boolean format string and delimiter
    Dim boolFormat As String = Me.txtFormatString.Text
    Dim delimiter As Char = CType(Me.txtDelimiter.Text, Char)

    '-- The easiest way would have been to use ToString(), but it is
    '   noted in MSDN that the IFormatProvider is not used for booleans.
    '   I also thought about subclassing the Boolean type, but since it is
    '   a structure and I'd want a structure to subclass it, that won't work
    '   (structures can't inherit or be inherited).
    '   Therefore, this doesn't work, it just returns True or False.
    'Me.lblFormattedBooleanString.Text = Me.chkTextValue.Checked.ToString(New BooleanFormatProvider(boolFormat))

    '-- Two ways to use String.Format with this provider:
    '     - Use a format string with the parameters, e.g. {0:y|n}
    '     - Use the overloaded constructor to provide the format string
    '
    '-- METHOD 1:
    '   Build the formatting string
    Dim formatString As String = "{0:" & boolFormat & "}"
    Me.lblFormattedBooleanString1.Text = String.Format(New BooleanFormatProvider(delimiter), formatString, Me.chkTextValue.Checked)

    '-- METHOD 2:
    Me.lblFormattedBooleanString2.Text = String.Format(New BooleanFormatProvider(boolFormat, delimiter), "{0}", Me.chkTextValue.Checked)
  End Sub

  ''' <summary>
  ''' Set the default delimiter
  ''' </summary>
  ''' <param name="sender"></param>
  ''' <param name="e"></param>
  ''' <remarks></remarks>
  Private Sub MainForm_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
    Me.txtDelimiter.Text = New BooleanFormatProvider().Delimiter
  End Sub

End Class
